/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.bc.asn1;

import com.lowagie.bc.asn1.ASN1OctetString;
import com.lowagie.bc.asn1.ASN1TaggedObject;
import com.lowagie.bc.asn1.DERObject;
import com.lowagie.bc.asn1.DEROutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.SimpleTimeZone;

public class DERUTCTime
extends DERObject {
    String time;

    public static DERUTCTime getInstance(Object obj) {
        if (obj == null || obj instanceof DERUTCTime) {
            return (DERUTCTime)obj;
        }
        if (obj instanceof ASN1OctetString) {
            return new DERUTCTime(((ASN1OctetString)obj).getOctets());
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static DERUTCTime getInstance(ASN1TaggedObject obj, boolean explicit) {
        return DERUTCTime.getInstance(obj.getObject());
    }

    public DERUTCTime(String time) {
        this.time = time;
    }

    public DERUTCTime(Date time) {
        SimpleDateFormat dateF = new SimpleDateFormat("yyMMddHHmmss'Z'");
        dateF.setTimeZone(new SimpleTimeZone(0, "Z"));
        this.time = dateF.format(time);
    }

    DERUTCTime(byte[] bytes) {
        char[] dateC = new char[bytes.length];
        int i2 = 0;
        while (i2 != dateC.length) {
            dateC[i2] = (char)(bytes[i2] & 0xFF);
            ++i2;
        }
        this.time = new String(dateC);
    }

    public String getTime() {
        if (this.time.length() == 11) {
            return String.valueOf(this.time.substring(0, 10)) + "00GMT+00:00";
        }
        if (this.time.length() == 13) {
            return String.valueOf(this.time.substring(0, 12)) + "GMT+00:00";
        }
        if (this.time.length() == 17) {
            return String.valueOf(this.time.substring(0, 12)) + "GMT" + this.time.substring(12, 15) + ":" + this.time.substring(15, 17);
        }
        return this.time;
    }

    public String getAdjustedTime() {
        String d2 = this.getTime();
        if (d2.charAt(0) < '5') {
            return "20" + d2;
        }
        return "19" + d2;
    }

    private byte[] getOctets() {
        char[] cs = this.time.toCharArray();
        byte[] bs = new byte[cs.length];
        int i2 = 0;
        while (i2 != cs.length) {
            bs[i2] = (byte)cs[i2];
            ++i2;
        }
        return bs;
    }

    void encode(DEROutputStream out) throws IOException {
        out.writeEncoded(23, this.getOctets());
    }

    public boolean equals(Object o2) {
        if (o2 == null || !(o2 instanceof DERUTCTime)) {
            return false;
        }
        return this.time.equals(((DERUTCTime)o2).time);
    }
}

