/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.bc.asn1;

import com.lowagie.bc.asn1.ASN1OctetString;
import com.lowagie.bc.asn1.ASN1TaggedObject;
import com.lowagie.bc.asn1.DERObject;
import com.lowagie.bc.asn1.DEROutputStream;
import com.lowagie.bc.asn1.DERString;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class DERUTF8String
extends DERObject
implements DERString {
    String string;

    public static DERUTF8String getInstance(Object obj) {
        if (obj == null || obj instanceof DERUTF8String) {
            return (DERUTF8String)obj;
        }
        if (obj instanceof ASN1OctetString) {
            return new DERUTF8String(((ASN1OctetString)obj).getOctets());
        }
        if (obj instanceof ASN1TaggedObject) {
            return DERUTF8String.getInstance(((ASN1TaggedObject)obj).getObject());
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static DERUTF8String getInstance(ASN1TaggedObject obj, boolean explicit) {
        return DERUTF8String.getInstance(obj.getObject());
    }

    DERUTF8String(byte[] string) {
        int i2 = 0;
        int length = 0;
        while (i2 < string.length) {
            ++length;
            if ((string[i2] & 0xE0) == 224) {
                i2 += 3;
                continue;
            }
            if ((string[i2] & 0xC0) == 192) {
                i2 += 2;
                continue;
            }
            ++i2;
        }
        char[] cs = new char[length];
        i2 = 0;
        length = 0;
        while (i2 < string.length) {
            char ch;
            if ((string[i2] & 0xE0) == 224) {
                ch = (char)((string[i2] & 0x1F) << 12 | (string[i2 + 1] & 0x3F) << 6 | string[i2 + 2] & 0x3F);
                i2 += 3;
            } else if ((string[i2] & 0xC0) == 192) {
                ch = (char)((string[i2] & 0x3F) << 6 | string[i2 + 1] & 0x3F);
                i2 += 2;
            } else {
                ch = (char)(string[i2] & 0xFF);
                ++i2;
            }
            cs[length++] = ch;
        }
        this.string = new String(cs);
    }

    public DERUTF8String(String string) {
        this.string = string;
    }

    public String getString() {
        return this.string;
    }

    public int hashCode() {
        return this.getString().hashCode();
    }

    public boolean equals(Object o2) {
        if (!(o2 instanceof DERUTF8String)) {
            return false;
        }
        DERUTF8String s = (DERUTF8String)o2;
        return this.getString().equals(s.getString());
    }

    void encode(DEROutputStream out) throws IOException {
        char[] c2 = this.string.toCharArray();
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        int i2 = 0;
        while (i2 != c2.length) {
            char ch = c2[i2];
            if (ch < '\u0080') {
                bOut.write(ch);
            } else if (ch < '\u0800') {
                bOut.write(0xC0 | ch >> 6);
                bOut.write(0x80 | ch & 0x3F);
            } else {
                bOut.write(0xE0 | ch >> 12);
                bOut.write(0x80 | ch >> 6 & 0x3F);
                bOut.write(0x80 | ch & 0x3F);
            }
            ++i2;
        }
        out.writeEncoded(12, bOut.toByteArray());
    }
}

