/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.markup;

import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.TextElementArray;
import com.lowagie.text.html.HtmlWriter;
import com.lowagie.text.markup.MarkupParser;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDestination;
import com.lowagie.text.pdf.PdfOutline;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.rtf.RtfWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.EmptyStackException;
import java.util.Properties;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class Parser
extends DefaultHandler {
    protected Stack filestack;
    protected Stack outline;
    protected Stack tagstack = new Stack();
    protected Stack objectstack = new Stack();
    protected Chunk currentChunk = null;
    protected Document document;
    protected PdfWriter writer;
    protected String title;
    protected String[] structures;
    protected String[] titles;
    protected int[] counterParents;
    protected int[] counters;
    protected MarkupParser markup;

    public Parser(String srcfile) {
        this(srcfile, "title", null, null, null);
    }

    public Parser(String srcfile, String title, String[] structures, String[] titles, int[] counterParents) {
        this.filestack = new Stack();
        this.filestack.push(srcfile);
        this.title = title;
        if (structures == null || titles == null || counterParents == null) {
            this.counters = new int[0];
        } else {
            this.structures = structures;
            this.titles = titles;
            this.counterParents = counterParents;
            this.counters = new int[counterParents.length];
        }
        this.document = new Document();
        try {
            this.parse();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        while (this.flushObject()) {
        }
        this.document.close();
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        Properties attrs = new Properties();
        attrs.put("tag", qName);
        int i2 = 0;
        while (i2 < attributes.getLength()) {
            attrs.put(attributes.getQName(i2), attributes.getValue(i2));
            ++i2;
        }
        this.tagstack.push(attrs);
        if (this.document.isOpen()) {
            this.flushCurrentChunk();
            Element element = this.markup.getObject(attrs);
            if (element != null) {
                switch (element.type()) {
                    case 11: {
                        this.addObject((Phrase)element);
                        break;
                    }
                    case 12: {
                        this.addObject((Paragraph)element);
                    }
                }
            }
        } else if ("body".equals(qName)) {
            Rectangle rect = this.markup.getRectangle(attrs);
            if (rect != null) {
                this.document.setPageSize(rect);
            }
            this.document.open();
            if (this.writer != null) {
                this.outline = new Stack();
                PdfContentByte cb = this.writer.getDirectContent();
                this.outline.push(cb.getRootOutline());
            }
        } else if ("link".equals(qName) && "stylesheet".equals(attrs.getProperty("rel"))) {
            String parent = new File((String)this.filestack.peek()).getParent();
            String markupfile = attrs.getProperty("href");
            markupfile = markupfile.startsWith("/") ? String.valueOf(parent) + markupfile : String.valueOf(parent) + "/" + markupfile;
            this.markup = new MarkupParser(markupfile);
        }
    }

    public void characters(char[] ch, int start, int length) {
        String content = new String(ch, start, length);
        if (content.trim().length() == 0) {
            return;
        }
        StringBuffer buf = new StringBuffer();
        int len = content.length();
        boolean newline = false;
        int i2 = 0;
        while (i2 < len) {
            char character = content.charAt(i2);
            switch (character) {
                case ' ': {
                    if (newline) break;
                    buf.append(character);
                    break;
                }
                case '\n': {
                    if (i2 <= 0) break;
                    newline = true;
                    buf.append(' ');
                    break;
                }
                case '\r': {
                    break;
                }
                case '\t': {
                    break;
                }
                default: {
                    newline = false;
                    buf.append(character);
                }
            }
            ++i2;
        }
        this.addToCurrentChunk(buf.toString());
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        Properties attrs = (Properties)this.tagstack.peek();
        PdfOutline bookmark = null;
        this.flushCurrentChunk();
        if (attrs != null && this.title.equals(attrs.getProperty("id")) && this.outline != null) {
            PdfOutline parent = (PdfOutline)this.outline.peek();
            PdfDestination dest = new PdfDestination(2, this.writer.getVerticalPosition(false));
            Paragraph p = (Paragraph)this.objectstack.peek();
            bookmark = new PdfOutline(parent, dest, p);
        }
        this.tagstack.pop();
        this.flushObject();
        if (this.markup.getPageBreakAfter(attrs)) {
            while (this.flushObject()) {
            }
            try {
                this.document.newPage();
            }
            catch (DocumentException documentException) {
                // empty catch block
            }
        }
        if (bookmark != null) {
            this.outline.push(bookmark);
        }
    }

    public void processingInstruction(String instruction, String parameter) throws SAXException {
        try {
            if ("parse".equals(instruction)) {
                StringTokenizer sublevels = new StringTokenizer(parameter, ",");
                while (sublevels.hasMoreTokens()) {
                    String file = sublevels.nextToken();
                    if (this.filestack.size() > 0) {
                        file = String.valueOf(new File((String)this.filestack.peek()).getParent()) + "/" + file.trim();
                    }
                    this.filestack.push(file);
                    this.parse();
                    if (this.outline == null) continue;
                    this.outline.pop();
                }
            }
            if (this.document.isOpen()) {
                return;
            }
            if ("pdfwriter".equals(instruction)) {
                this.writer = PdfWriter.getInstance(this.document, new FileOutputStream(parameter));
            } else if ("htmlwriter".equals(instruction)) {
                HtmlWriter.getInstance(this.document, new FileOutputStream(parameter));
            } else if ("rtfwriter".equals(instruction)) {
                RtfWriter.getInstance(this.document, new FileOutputStream(parameter));
            }
        }
        catch (Exception e2) {
            throw new SAXException(e2);
        }
    }

    private void flushCurrentChunk() {
        TextElementArray current;
        if (this.currentChunk == null || !this.document.isOpen()) {
            return;
        }
        try {
            current = (TextElementArray)this.objectstack.pop();
        }
        catch (EmptyStackException ese) {
            current = new Paragraph();
        }
        current.add(this.currentChunk);
        this.objectstack.push(current);
        this.currentChunk = null;
    }

    private void addToCurrentChunk(String s) {
        if (this.currentChunk != null) {
            this.currentChunk.append(s);
        } else {
            try {
                this.currentChunk = new Chunk(s, ((Phrase)this.objectstack.peek()).font());
            }
            catch (EmptyStackException ese) {
                this.currentChunk = new Chunk(s);
            }
        }
    }

    private void addObject(Phrase phrase) {
        this.objectstack.push(phrase);
    }

    private void addObject(Paragraph paragraph) {
        Properties attrs = (Properties)this.tagstack.peek();
        if (attrs == null) {
            return;
        }
        if (this.title.equals(attrs.getProperty("id"))) {
            int i2 = 0;
            while (i2 < this.counters.length) {
                if (this.structures[i2].equals(attrs.getProperty("class"))) {
                    int n2 = i2;
                    this.counters[n2] = this.counters[n2] + 1;
                    int j2 = i2 + 1;
                    while (j2 < this.counters.length) {
                        if (this.counterParents[j2] == i2) {
                            this.counters[j2] = 0;
                            break;
                        }
                        ++j2;
                    }
                    String s = this.titles[i2];
                    if (s == null) {
                        s = "";
                        int j3 = this.counterParents[i2];
                        while (j3 > 1) {
                            s = String.valueOf(String.valueOf(this.counters[j3])) + "." + s;
                            j3 = this.counterParents[j3];
                        }
                        if (i2 > 0) {
                            s = String.valueOf(s) + String.valueOf(this.counters[i2]) + " ";
                        }
                    } else {
                        s = String.valueOf(s) + " " + this.counters[i2] + ": ";
                    }
                    paragraph.add(new Chunk(s));
                }
                ++i2;
            }
        }
        if (this.markup.getPageBreakBefore(attrs)) {
            while (this.flushObject()) {
            }
            try {
                this.document.newPage();
            }
            catch (DocumentException documentException) {
                // empty catch block
            }
        }
        this.objectstack.push(paragraph);
    }

    private boolean flushObject() {
        if (this.objectstack.size() == 0) {
            return false;
        }
        Element current = (Element)this.objectstack.pop();
        try {
            TextElementArray previous = (TextElementArray)this.objectstack.pop();
            previous.add(current);
            this.objectstack.push(previous);
            return true;
        }
        catch (EmptyStackException ese) {
            try {
                this.document.add(current);
                return true;
            }
            catch (DocumentException e2) {
                return false;
            }
        }
    }

    private void parse() throws ParserConfigurationException, IOException, SAXException {
        String file = (String)this.filestack.peek();
        SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
        SAXParser saxParser = saxParserFactory.newSAXParser();
        XMLReader parser = saxParser.getXMLReader();
        parser.setContentHandler(this);
        parser.parse(new InputSource(file));
        this.filestack.pop();
    }
}

