/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocWriter;
import com.lowagie.text.pdf.PdfEncodings;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class ByteBuffer
extends OutputStream {
    protected int count;
    protected byte[] buf;
    private static int byteCacheSize = 0;
    private static byte[][] byteCache = new byte[byteCacheSize][];
    public static byte ZERO = (byte)48;
    private static final char[] chars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private static final byte[] bytes = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};

    public ByteBuffer() {
        this(128);
    }

    public ByteBuffer(int size) {
        if (size < 1) {
            size = 128;
        }
        this.buf = new byte[size];
    }

    public static void setCacheSize(int size) {
        if (size > 3276700) {
            size = 3276700;
        }
        if (size <= byteCacheSize) {
            return;
        }
        byte[][] tmpCache = new byte[size][];
        int i2 = 0;
        while (i2 < byteCacheSize) {
            tmpCache[i2] = byteCache[i2];
            ++i2;
        }
        byteCache = tmpCache;
        byteCacheSize = size;
    }

    public static void fillCache(int decimals) {
        int step = 1;
        switch (decimals) {
            case 0: {
                step = 100;
                break;
            }
            case 1: {
                step = 10;
            }
        }
        int i2 = 1;
        while (i2 < byteCacheSize) {
            if (byteCache[i2] == null) {
                ByteBuffer.byteCache[i2] = ByteBuffer.convertToBytes(i2);
            }
            i2 += step;
        }
    }

    private static byte[] convertToBytes(int i2) {
        int size = (int)Math.floor(Math.log(i2) / Math.log(10.0));
        if (i2 % 100 != 0) {
            size += 2;
        }
        if (i2 % 10 != 0) {
            ++size;
        }
        if (i2 < 100) {
            ++size;
            if (i2 < 10) {
                ++size;
            }
        }
        byte[] cache = new byte[--size];
        --size;
        if (i2 < 100) {
            cache[0] = 48;
        }
        if (i2 % 10 != 0) {
            cache[size--] = bytes[i2 % 10];
        }
        if (i2 % 100 != 0) {
            cache[size--] = bytes[i2 / 10 % 10];
            cache[size--] = 46;
        }
        size = (int)Math.floor(Math.log(i2) / Math.log(10.0)) - 1;
        int add = 0;
        while (add < size) {
            cache[add] = bytes[i2 / (int)Math.pow(10.0, size - add + 1) % 10];
            ++add;
        }
        return cache;
    }

    public ByteBuffer append_i(int b2) {
        int newcount = this.count + 1;
        if (newcount > this.buf.length) {
            byte[] newbuf = new byte[Math.max(this.buf.length << 1, newcount)];
            System.arraycopy(this.buf, 0, newbuf, 0, this.count);
            this.buf = newbuf;
        }
        this.buf[this.count] = (byte)b2;
        this.count = newcount;
        return this;
    }

    public ByteBuffer append(byte[] b2, int off, int len) {
        if (off < 0 || off > b2.length || len < 0 || off + len > b2.length || off + len < 0 || len == 0) {
            return this;
        }
        int newcount = this.count + len;
        if (newcount > this.buf.length) {
            byte[] newbuf = new byte[Math.max(this.buf.length << 1, newcount)];
            System.arraycopy(this.buf, 0, newbuf, 0, this.count);
            this.buf = newbuf;
        }
        System.arraycopy(b2, off, this.buf, this.count, len);
        this.count = newcount;
        return this;
    }

    public ByteBuffer append(byte[] b2) {
        return this.append(b2, 0, b2.length);
    }

    public ByteBuffer append(String str) {
        if (str != null) {
            return this.append(DocWriter.getISOBytes(str));
        }
        return this;
    }

    public ByteBuffer append(char c2) {
        return this.append_i(c2);
    }

    public ByteBuffer append(ByteBuffer buf) {
        return this.append(buf.buf, 0, buf.count);
    }

    public ByteBuffer append(int i2) {
        return this.append((double)i2);
    }

    public ByteBuffer append(byte b2) {
        return this.append_i(b2);
    }

    public ByteBuffer appendHex(byte b2) {
        this.append(bytes[b2 >> 4 & 0xF]);
        return this.append(bytes[b2 & 0xF]);
    }

    public ByteBuffer append(float i2) {
        return this.append((double)i2);
    }

    public ByteBuffer append(double d2) {
        this.append(ByteBuffer.formatDouble(d2, this));
        return this;
    }

    public static String formatDouble(double d2) {
        return ByteBuffer.formatDouble(d2, null);
    }

    public static String formatDouble(double d2, ByteBuffer buf) {
        boolean negative = false;
        if (Math.abs(d2) < 1.5E-5) {
            if (buf != null) {
                buf.append(ZERO);
                return null;
            }
            return "0";
        }
        if (d2 < 0.0) {
            negative = true;
            d2 = -d2;
        }
        if (d2 < 1.0) {
            if ((d2 += 5.0E-6) >= 1.0) {
                if (negative) {
                    if (buf != null) {
                        buf.append((byte)45);
                        buf.append((byte)49);
                        return null;
                    }
                    return "-1";
                }
                if (buf != null) {
                    buf.append((byte)49);
                    return null;
                }
                return "1";
            }
            if (buf != null) {
                int v = (int)(d2 * 100000.0);
                if (negative) {
                    buf.append((byte)45);
                }
                buf.append((byte)48);
                buf.append((byte)46);
                buf.append((byte)(v / 10000 + ZERO));
                if (v % 10000 != 0) {
                    buf.append((byte)(v / 1000 % 10 + ZERO));
                    if (v % 1000 != 0) {
                        buf.append((byte)(v / 100 % 10 + ZERO));
                        if (v % 100 != 0) {
                            buf.append((byte)(v / 10 % 10 + ZERO));
                            if (v % 10 != 0) {
                                buf.append((byte)(v % 10 + ZERO));
                            }
                        }
                    }
                }
                return null;
            }
            int x = 100000;
            int v = (int)(d2 * (double)x);
            StringBuffer res = new StringBuffer();
            if (negative) {
                res.append('-');
            }
            res.append("0.");
            while (v < x / 10) {
                res.append('0');
                x /= 10;
            }
            res.append(v);
            int cut = res.length() - 1;
            while (res.charAt(cut) == '0') {
                --cut;
            }
            res.setLength(cut + 1);
            return res.toString();
        }
        if (d2 <= 32767.0) {
            int v = (int)((d2 += 0.005) * 100.0);
            if (v < byteCacheSize && byteCache[v] != null) {
                if (buf != null) {
                    if (negative) {
                        buf.append((byte)45);
                    }
                    buf.append(byteCache[v]);
                    return null;
                }
                String tmp = PdfEncodings.convertToString(byteCache[v], null);
                if (negative) {
                    tmp = "-" + tmp;
                }
                return tmp;
            }
            if (buf != null) {
                if (v < byteCacheSize) {
                    int size = 0;
                    if (v >= 1000000) {
                        size += 5;
                    } else if (v >= 100000) {
                        size += 4;
                    } else if (v >= 10000) {
                        size += 3;
                    } else if (v >= 1000) {
                        size += 2;
                    } else if (v >= 100) {
                        ++size;
                    }
                    if (v % 100 != 0) {
                        size += 2;
                    }
                    if (v % 10 != 0) {
                        ++size;
                    }
                    byte[] cache = new byte[size];
                    int add = 0;
                    if (v >= 1000000) {
                        cache[add++] = bytes[v / 1000000];
                    }
                    if (v >= 100000) {
                        cache[add++] = bytes[v / 100000 % 10];
                    }
                    if (v >= 10000) {
                        cache[add++] = bytes[v / 10000 % 10];
                    }
                    if (v >= 1000) {
                        cache[add++] = bytes[v / 1000 % 10];
                    }
                    if (v >= 100) {
                        cache[add++] = bytes[v / 100 % 10];
                    }
                    if (v % 100 != 0) {
                        cache[add++] = 46;
                        cache[add++] = bytes[v / 10 % 10];
                        if (v % 10 != 0) {
                            cache[add++] = bytes[v % 10];
                        }
                    }
                    ByteBuffer.byteCache[v] = cache;
                }
                if (negative) {
                    buf.append((byte)45);
                }
                if (v >= 1000000) {
                    buf.append(bytes[v / 1000000]);
                }
                if (v >= 100000) {
                    buf.append(bytes[v / 100000 % 10]);
                }
                if (v >= 10000) {
                    buf.append(bytes[v / 10000 % 10]);
                }
                if (v >= 1000) {
                    buf.append(bytes[v / 1000 % 10]);
                }
                if (v >= 100) {
                    buf.append(bytes[v / 100 % 10]);
                }
                if (v % 100 != 0) {
                    buf.append((byte)46);
                    buf.append(bytes[v / 10 % 10]);
                    if (v % 10 != 0) {
                        buf.append(bytes[v % 10]);
                    }
                }
                return null;
            }
            StringBuffer res = new StringBuffer();
            if (negative) {
                res.append('-');
            }
            if (v >= 1000000) {
                res.append(chars[v / 1000000]);
            }
            if (v >= 100000) {
                res.append(chars[v / 100000 % 10]);
            }
            if (v >= 10000) {
                res.append(chars[v / 10000 % 10]);
            }
            if (v >= 1000) {
                res.append(chars[v / 1000 % 10]);
            }
            if (v >= 100) {
                res.append(chars[v / 100 % 10]);
            }
            if (v % 100 != 0) {
                res.append('.');
                res.append(chars[v / 10 % 10]);
                if (v % 10 != 0) {
                    res.append(chars[v % 10]);
                }
            }
            return res.toString();
        }
        StringBuffer res = new StringBuffer();
        if (negative) {
            res.append('-');
        }
        long v = (long)(d2 += 0.5);
        return res.append(v).toString();
    }

    public void reset() {
        this.count = 0;
    }

    public byte[] toByteArray() {
        byte[] newbuf = new byte[this.count];
        System.arraycopy(this.buf, 0, newbuf, 0, this.count);
        return newbuf;
    }

    public int size() {
        return this.count;
    }

    public String toString() {
        return new String(this.buf, 0, this.count);
    }

    public String toString(String enc) throws UnsupportedEncodingException {
        return new String(this.buf, 0, this.count, enc);
    }

    public void writeTo(OutputStream out) throws IOException {
        out.write(this.buf, 0, this.count);
    }

    public void write(int b2) throws IOException {
        this.append((byte)b2);
    }

    public void write(byte[] b2, int off, int len) {
        this.append(b2, off, len);
    }

    public byte[] getBuffer() {
        return this.buf;
    }
}

