/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.CJKFont;
import com.lowagie.text.pdf.IntHashtable;
import com.lowagie.text.pdf.PdfEncodings;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.TrueTypeFontUnicode;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;

class FontDetails {
    PdfIndirectReference indirectReference;
    PdfName fontName;
    BaseFont baseFont;
    TrueTypeFontUnicode ttu;
    CJKFont cjkFont;
    byte[] shortTag;
    HashMap longTag;
    IntHashtable cjkTag;
    int fontType;
    boolean symbolic;
    protected boolean subset = true;

    FontDetails(PdfName fontName, PdfIndirectReference indirectReference, BaseFont baseFont) {
        this.fontName = fontName;
        this.indirectReference = indirectReference;
        this.baseFont = baseFont;
        this.fontType = baseFont.getFontType();
        switch (this.fontType) {
            case 0: 
            case 1: {
                this.shortTag = new byte[256];
                break;
            }
            case 2: {
                this.cjkTag = new IntHashtable();
                this.cjkFont = (CJKFont)baseFont;
                break;
            }
            case 3: {
                this.longTag = new HashMap();
                this.ttu = (TrueTypeFontUnicode)baseFont;
                this.symbolic = baseFont.isFontSpecific();
            }
        }
    }

    PdfIndirectReference getIndirectReference() {
        return this.indirectReference;
    }

    PdfName getFontName() {
        return this.fontName;
    }

    BaseFont getBaseFont() {
        return this.baseFont;
    }

    byte[] convertToBytes(String text) {
        byte[] b2 = null;
        switch (this.fontType) {
            case 0: 
            case 1: {
                b2 = this.baseFont.convertToBytes(text);
                int len = b2.length;
                int k2 = 0;
                while (k2 < len) {
                    this.shortTag[b2[k2] & 0xFF] = 1;
                    ++k2;
                }
                break;
            }
            case 2: {
                int len = text.length();
                int k3 = 0;
                while (k3 < len) {
                    this.cjkTag.put(this.cjkFont.getCidCode(text.charAt(k3)), 0);
                    ++k3;
                }
                b2 = this.baseFont.convertToBytes(text);
                break;
            }
            case 4: {
                b2 = this.baseFont.convertToBytes(text);
                break;
            }
            case 3: {
                try {
                    int k4;
                    int len = text.length();
                    int[] metrics = null;
                    char[] glyph = new char[len];
                    int i2 = 0;
                    if (this.symbolic) {
                        b2 = PdfEncodings.convertToBytes(text, "symboltt");
                        len = b2.length;
                        k4 = 0;
                        while (k4 < len) {
                            metrics = this.ttu.getMetricsTT(b2[k4] & 0xFF);
                            if (metrics != null) {
                                this.longTag.put(new Integer(metrics[0]), new int[]{metrics[0], metrics[1], this.ttu.getUnicodeDifferences(b2[k4] & 0xFF)});
                                glyph[i2++] = (char)metrics[0];
                            }
                            ++k4;
                        }
                    } else {
                        k4 = 0;
                        while (k4 < len) {
                            char c2 = text.charAt(k4);
                            metrics = this.ttu.getMetricsTT(c2);
                            if (metrics != null) {
                                int m0 = metrics[0];
                                Integer gl = new Integer(m0);
                                if (!this.longTag.containsKey(gl)) {
                                    this.longTag.put(gl, new int[]{m0, metrics[1], c2});
                                }
                                glyph[i2++] = (char)m0;
                            }
                            ++k4;
                        }
                    }
                    String s = new String(glyph, 0, i2);
                    b2 = s.getBytes("UnicodeBigUnmarked");
                    break;
                }
                catch (UnsupportedEncodingException e2) {
                    throw new ExceptionConverter(e2);
                }
            }
        }
        return b2;
    }

    void writeFont(PdfWriter writer) {
        try {
            switch (this.fontType) {
                case 0: 
                case 1: {
                    int lastChar;
                    int firstChar;
                    if (this.subset) {
                        firstChar = 0;
                        while (firstChar < 256) {
                            if (this.shortTag[firstChar] != 0) break;
                            ++firstChar;
                        }
                        lastChar = 255;
                        while (lastChar >= firstChar) {
                            if (this.shortTag[lastChar] != 0) break;
                            --lastChar;
                        }
                        if (firstChar > 255) {
                            firstChar = 255;
                            lastChar = 255;
                        }
                    } else {
                        int k2 = 0;
                        while (k2 < this.shortTag.length) {
                            this.shortTag[k2] = 1;
                            ++k2;
                        }
                        firstChar = 0;
                        lastChar = this.shortTag.length - 1;
                    }
                    this.baseFont.writeFont(writer, this.indirectReference, new Object[]{new Integer(firstChar), new Integer(lastChar), this.shortTag});
                    break;
                }
                case 2: {
                    this.baseFont.writeFont(writer, this.indirectReference, new Object[]{this.cjkTag});
                    break;
                }
                case 3: {
                    this.baseFont.writeFont(writer, this.indirectReference, new Object[]{this.longTag});
                }
            }
        }
        catch (Exception e2) {
            throw new ExceptionConverter(e2);
        }
    }

    public boolean isSubset() {
        return this.subset;
    }

    public void setSubset(boolean subset) {
        this.subset = subset;
    }
}

