/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocWriter;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.PageSize;
import com.lowagie.text.Rectangle;
import com.lowagie.text.StringCompare;
import com.lowagie.text.pdf.AcroFields;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.IntHashtable;
import com.lowagie.text.pdf.LZWDecoder;
import com.lowagie.text.pdf.PRAcroForm;
import com.lowagie.text.pdf.PRIndirectReference;
import com.lowagie.text.pdf.PRStream;
import com.lowagie.text.pdf.PRTokeniser;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfBoolean;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfEncodings;
import com.lowagie.text.pdf.PdfEncryption;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfLiteral;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNameTree;
import com.lowagie.text.pdf.PdfNull;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReaderInstance;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import com.lowagie.text.pdf.SequenceList;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.zip.InflaterInputStream;

public class PdfReader {
    static final PdfName[] pageInhCandidates = new PdfName[]{PdfName.MEDIABOX, PdfName.ROTATE, PdfName.RESOURCES, PdfName.CROPBOX};
    static final PdfName[] vpnames = new PdfName[]{PdfName.HIDETOOLBAR, PdfName.HIDEMENUBAR, PdfName.HIDEWINDOWUI, PdfName.FITWINDOW, PdfName.CENTERWINDOW, PdfName.DISPLAYDOCTITLE};
    static final int[] vpints = new int[]{256, 512, 1024, 2048, 4096, 262144};
    static final byte[] endstream = PdfEncodings.convertToBytes("endstream", null);
    static final byte[] endobj = PdfEncodings.convertToBytes("endobj", null);
    protected PRTokeniser tokens;
    protected int[] xref;
    protected HashMap objStmMark;
    protected IntHashtable objStmToOffset;
    protected boolean newXrefType;
    private ArrayList xrefObj;
    PdfDictionary rootPages;
    protected PdfDictionary trailer;
    protected PdfDictionary catalog;
    protected PageRefs pageRefs;
    protected PRAcroForm acroForm = null;
    protected boolean acroFormParsed = false;
    protected ArrayList pageInh;
    protected boolean encrypted = false;
    protected boolean rebuilt = false;
    protected int freeXref;
    protected boolean tampered = false;
    protected int lastXref;
    protected int eofPos;
    protected char pdfVersion;
    protected PdfEncryption decrypt;
    protected byte[] password = null;
    protected ArrayList strings = new ArrayList();
    protected boolean sharedStreams = true;
    protected boolean consolidateNamedDestinations = false;
    protected int rValue;
    protected int pValue;
    private int objNum;
    private int objGen;
    private boolean[] visited;
    private IntHashtable newHits;
    private int fileLength;
    private boolean hybridXref;
    private int lastXrefPartial = -1;
    private boolean partial;
    private boolean appendable;

    protected PdfReader() {
    }

    public PdfReader(String filename) throws IOException {
        this(filename, null);
    }

    public PdfReader(String filename, byte[] ownerPassword) throws IOException {
        this.password = ownerPassword;
        this.tokens = new PRTokeniser(filename);
        this.readPdf();
    }

    public PdfReader(byte[] pdfIn) throws IOException {
        this(pdfIn, null);
    }

    public PdfReader(byte[] pdfIn, byte[] ownerPassword) throws IOException {
        this.password = ownerPassword;
        this.tokens = new PRTokeniser(pdfIn);
        this.readPdf();
    }

    public PdfReader(URL url) throws IOException {
        this(url, null);
    }

    public PdfReader(URL url, byte[] ownerPassword) throws IOException {
        this.password = ownerPassword;
        this.tokens = new PRTokeniser(new RandomAccessFileOrArray(url));
        this.readPdf();
    }

    public PdfReader(InputStream is, byte[] ownerPassword) throws IOException {
        this.password = ownerPassword;
        this.tokens = new PRTokeniser(new RandomAccessFileOrArray(is));
        this.readPdf();
    }

    public PdfReader(InputStream is) throws IOException {
        this(is, null);
    }

    public PdfReader(RandomAccessFileOrArray raf, byte[] ownerPassword) throws IOException {
        this.password = ownerPassword;
        this.partial = true;
        this.tokens = new PRTokeniser(raf);
        this.readPdfPartial();
    }

    public PdfReader(PdfReader reader) {
        this.appendable = reader.appendable;
        this.consolidateNamedDestinations = reader.consolidateNamedDestinations;
        this.encrypted = reader.encrypted;
        this.rebuilt = reader.rebuilt;
        this.sharedStreams = reader.sharedStreams;
        this.tampered = reader.tampered;
        this.password = reader.password;
        this.pdfVersion = reader.pdfVersion;
        this.eofPos = reader.eofPos;
        this.freeXref = reader.freeXref;
        this.lastXref = reader.lastXref;
        this.tokens = new PRTokeniser(reader.tokens.getSafeFile());
        if (reader.decrypt != null) {
            this.decrypt = new PdfEncryption(reader.decrypt);
        }
        this.pValue = reader.pValue;
        this.rValue = reader.rValue;
        this.xrefObj = new ArrayList(reader.xrefObj);
        int k2 = 0;
        while (k2 < reader.xrefObj.size()) {
            this.xrefObj.set(k2, PdfReader.duplicatePdfObject((PdfObject)reader.xrefObj.get(k2), this));
            ++k2;
        }
        this.pageRefs = new PageRefs(reader.pageRefs, this);
        this.trailer = (PdfDictionary)PdfReader.duplicatePdfObject(reader.trailer, this);
        this.catalog = (PdfDictionary)PdfReader.getPdfObject(this.trailer.get(PdfName.ROOT));
        this.rootPages = (PdfDictionary)PdfReader.getPdfObject(this.catalog.get(PdfName.PAGES));
        this.fileLength = reader.fileLength;
        this.partial = reader.partial;
        this.hybridXref = reader.hybridXref;
        this.objStmToOffset = reader.objStmToOffset;
        this.xref = reader.xref;
    }

    public RandomAccessFileOrArray getSafeFile() {
        return this.tokens.getSafeFile();
    }

    protected PdfReaderInstance getPdfReaderInstance(PdfWriter writer) {
        return new PdfReaderInstance(this, writer);
    }

    public int getNumberOfPages() {
        return this.pageRefs.size();
    }

    public PdfDictionary getCatalog() {
        return this.catalog;
    }

    public PRAcroForm getAcroForm() {
        if (!this.acroFormParsed) {
            this.acroFormParsed = true;
            PdfObject form = this.catalog.get(PdfName.ACROFORM);
            if (form != null) {
                try {
                    this.acroForm = new PRAcroForm(this);
                    this.acroForm.readAcroForm((PdfDictionary)PdfReader.getPdfObject(form));
                }
                catch (Exception e2) {
                    this.acroForm = null;
                }
            }
        }
        return this.acroForm;
    }

    public int getPageRotation(int index) {
        return this.getPageRotation(this.pageRefs.getPageNRelease(index));
    }

    int getPageRotation(PdfDictionary page) {
        PdfNumber rotate = (PdfNumber)PdfReader.getPdfObject(page.get(PdfName.ROTATE));
        if (rotate == null) {
            return 0;
        }
        int n2 = rotate.intValue();
        return (n2 %= 360) < 0 ? n2 + 360 : n2;
    }

    public Rectangle getPageSizeWithRotation(int index) {
        return this.getPageSizeWithRotation(this.pageRefs.getPageNRelease(index));
    }

    public Rectangle getPageSizeWithRotation(PdfDictionary page) {
        Rectangle rect = this.getPageSize(page);
        int rotation = this.getPageRotation(page);
        while (rotation > 0) {
            rect = rect.rotate();
            rotation -= 90;
        }
        return rect;
    }

    public Rectangle getPageSize(int index) {
        return this.getPageSize(this.pageRefs.getPageNRelease(index));
    }

    public Rectangle getPageSize(PdfDictionary page) {
        PdfArray mediaBox = (PdfArray)PdfReader.getPdfObject(page.get(PdfName.MEDIABOX));
        return PdfReader.getNormalizedRectangle(mediaBox);
    }

    public Rectangle getCropBox(int index) {
        PdfDictionary page = this.pageRefs.getPageNRelease(index);
        PdfArray cropBox = (PdfArray)PdfReader.getPdfObjectRelease(page.get(PdfName.CROPBOX));
        if (cropBox == null) {
            return this.getPageSize(page);
        }
        return PdfReader.getNormalizedRectangle(cropBox);
    }

    public Rectangle getBoxSize(int index, String boxName) {
        PdfDictionary page = this.pageRefs.getPageNRelease(index);
        PdfArray box = null;
        if (boxName.equals("trim")) {
            box = (PdfArray)PdfReader.getPdfObjectRelease(page.get(PdfName.TRIMBOX));
        } else if (boxName.equals("art")) {
            box = (PdfArray)PdfReader.getPdfObjectRelease(page.get(PdfName.ARTBOX));
        } else if (boxName.equals("bleed")) {
            box = (PdfArray)PdfReader.getPdfObjectRelease(page.get(PdfName.BLEEDBOX));
        } else if (boxName.equals("crop")) {
            box = (PdfArray)PdfReader.getPdfObjectRelease(page.get(PdfName.CROPBOX));
        } else if (boxName.equals("media")) {
            box = (PdfArray)PdfReader.getPdfObjectRelease(page.get(PdfName.MEDIABOX));
        }
        if (box == null) {
            return null;
        }
        return PdfReader.getNormalizedRectangle(box);
    }

    public HashMap getInfo() {
        HashMap<String, String> map = new HashMap<String, String>();
        PdfDictionary info = (PdfDictionary)PdfReader.getPdfObject(this.trailer.get(PdfName.INFO));
        if (info == null) {
            return map;
        }
        Iterator it = info.getKeys().iterator();
        while (it.hasNext()) {
            PdfName key = (PdfName)it.next();
            PdfObject obj = PdfReader.getPdfObject(info.get(key));
            if (obj == null) continue;
            String value = obj.toString();
            switch (obj.type()) {
                case 3: {
                    value = ((PdfString)obj).toUnicodeString();
                    break;
                }
                case 4: {
                    value = PdfName.decodeName(value);
                }
            }
            map.put(PdfName.decodeName(key.toString()), value);
        }
        return map;
    }

    public static Rectangle getNormalizedRectangle(PdfArray box) {
        ArrayList rect = box.getArrayList();
        float llx = ((PdfNumber)rect.get(0)).floatValue();
        float lly = ((PdfNumber)rect.get(1)).floatValue();
        float urx = ((PdfNumber)rect.get(2)).floatValue();
        float ury = ((PdfNumber)rect.get(3)).floatValue();
        return new Rectangle(Math.min(llx, urx), Math.min(lly, ury), Math.max(llx, urx), Math.max(lly, ury));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void readPdf() throws IOException {
        try {
            this.fileLength = this.tokens.getFile().length();
            this.pdfVersion = this.tokens.checkPdfHeader();
            try {
                this.readXref();
            }
            catch (Exception e2) {
                try {
                    this.rebuilt = true;
                    this.rebuildXref();
                    this.lastXref = -1;
                }
                catch (Exception ne) {
                    throw new IOException("Rebuild failed: " + ne.getMessage() + "; Original message: " + e2.getMessage());
                }
            }
            try {
                this.readDocObj();
            }
            catch (IOException ne) {
                if (this.rebuilt) {
                    throw ne;
                }
                this.rebuilt = true;
                this.encrypted = false;
                this.rebuildXref();
                this.lastXref = -1;
                this.readDocObj();
            }
            this.strings.clear();
            this.readPages();
            this.eliminateSharedStreams();
            this.removeUnusedObjects();
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            try {
                this.tokens.close();
                throw throwable;
            }
            catch (Exception e3) {
                // empty catch block
            }
            throw throwable;
        }
        {
            Object var3_6 = null;
        }
        try {}
        catch (Exception e3) {
            return;
        }
        this.tokens.close();
    }

    protected void readPdfPartial() throws IOException {
        try {
            this.fileLength = this.tokens.getFile().length();
            this.pdfVersion = this.tokens.checkPdfHeader();
            try {
                this.readXref();
            }
            catch (Exception e2) {
                try {
                    this.rebuilt = true;
                    this.rebuildXref();
                    this.lastXref = -1;
                }
                catch (Exception ne) {
                    throw new IOException("Rebuild failed: " + ne.getMessage() + "; Original message: " + e2.getMessage());
                }
            }
            this.readDocObjPartial();
            this.readPages();
        }
        catch (IOException e3) {
            try {
                this.tokens.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e3;
        }
    }

    private boolean equalsArray(byte[] ar1, byte[] ar2, int size) {
        int k2 = 0;
        while (k2 < size) {
            if (ar1[k2] != ar2[k2]) {
                return false;
            }
            ++k2;
        }
        return true;
    }

    private void readDecryptedDocObj() throws IOException {
        String s;
        PdfObject o2;
        if (this.encrypted) {
            return;
        }
        PdfObject encDic = this.trailer.get(PdfName.ENCRYPT);
        if (encDic == null || encDic.toString().equals("null")) {
            return;
        }
        this.encrypted = true;
        PdfDictionary enc = (PdfDictionary)PdfReader.getPdfObject(encDic);
        PdfArray documentIDs = (PdfArray)PdfReader.getPdfObject(this.trailer.get(PdfName.ID));
        byte[] documentID = null;
        if (documentIDs != null) {
            o2 = (PdfObject)documentIDs.getArrayList().get(0);
            s = o2.toString();
            documentID = DocWriter.getISOBytes(s);
        }
        s = enc.get(PdfName.U).toString();
        byte[] uValue = DocWriter.getISOBytes(s);
        s = enc.get(PdfName.O).toString();
        byte[] oValue = DocWriter.getISOBytes(s);
        o2 = enc.get(PdfName.R);
        if (!o2.isNumber()) {
            throw new IOException("Illegal R value.");
        }
        this.rValue = ((PdfNumber)o2).intValue();
        if (this.rValue != 2 && this.rValue != 3) {
            throw new IOException("Unknown encryption type (" + this.rValue + ")");
        }
        o2 = enc.get(PdfName.P);
        if (!o2.isNumber()) {
            throw new IOException("Illegal P value.");
        }
        this.pValue = ((PdfNumber)o2).intValue();
        this.decrypt = new PdfEncryption();
        this.decrypt.setupByUserPassword(documentID, this.password, oValue, this.pValue, this.rValue == 3);
        if (!this.equalsArray(uValue, this.decrypt.userKey, this.rValue == 3 ? 16 : 32)) {
            this.decrypt.setupByOwnerPassword(documentID, this.password, uValue, oValue, this.pValue, this.rValue == 3);
            if (!this.equalsArray(uValue, this.decrypt.userKey, this.rValue == 3 ? 16 : 32)) {
                throw new IOException("Bad user password");
            }
        }
        int k2 = 0;
        while (k2 < this.strings.size()) {
            PdfString str = (PdfString)this.strings.get(k2);
            str.decrypt(this);
            ++k2;
        }
        if (encDic.isIndirect()) {
            this.xrefObj.set(((PRIndirectReference)encDic).getNumber(), null);
        }
    }

    public static PdfObject getPdfObjectRelease(PdfObject obj) {
        PdfObject obj2 = PdfReader.getPdfObject(obj);
        PdfReader.releaseLastXrefPartial(obj);
        return obj2;
    }

    public static PdfObject getPdfObject(PdfObject obj) {
        if (obj == null) {
            return null;
        }
        if (!obj.isIndirect()) {
            return obj;
        }
        try {
            PRIndirectReference ref = (PRIndirectReference)obj;
            int idx = ref.getNumber();
            boolean appendable = ref.getReader().appendable;
            obj = ref.getReader().getPdfObject(idx);
            if (obj == null) {
                if (appendable) {
                    obj = new PdfNull();
                    obj.setIndRef(ref);
                    return obj;
                }
                return PdfNull.PDFNULL;
            }
            if (appendable) {
                switch (obj.type()) {
                    case 8: {
                        obj = new PdfNull();
                        break;
                    }
                    case 1: {
                        obj = new PdfBoolean(((PdfBoolean)obj).booleanValue());
                        break;
                    }
                    case 4: {
                        obj = new PdfName(obj.getBytes());
                    }
                }
                obj.setIndRef(ref);
            }
            return obj;
        }
        catch (Exception e2) {
            throw new ExceptionConverter(e2);
        }
    }

    public static PdfObject getPdfObjectRelease(PdfObject obj, PdfObject parent) {
        PdfObject obj2 = PdfReader.getPdfObject(obj, parent);
        PdfReader.releaseLastXrefPartial(obj);
        return obj2;
    }

    public static PdfObject getPdfObject(PdfObject obj, PdfObject parent) {
        if (obj == null) {
            return null;
        }
        if (!obj.isIndirect()) {
            PRIndirectReference ref = null;
            if (parent != null && (ref = parent.getIndRef()) != null && ref.getReader().isAppendable()) {
                switch (obj.type()) {
                    case 8: {
                        obj = new PdfNull();
                        break;
                    }
                    case 1: {
                        obj = new PdfBoolean(((PdfBoolean)obj).booleanValue());
                        break;
                    }
                    case 4: {
                        obj = new PdfName(obj.getBytes());
                    }
                }
                obj.setIndRef(ref);
            }
            return obj;
        }
        return PdfReader.getPdfObject(obj);
    }

    public PdfObject getPdfObjectRelease(int idx) {
        PdfObject obj = this.getPdfObject(idx);
        this.releaseLastXrefPartial();
        return obj;
    }

    public PdfObject getPdfObject(int idx) {
        try {
            this.lastXrefPartial = -1;
            if (idx < 0 || idx >= this.xrefObj.size()) {
                return null;
            }
            PdfObject obj = (PdfObject)this.xrefObj.get(idx);
            if (!this.partial || obj != null) {
                return obj;
            }
            if (idx * 2 >= this.xref.length) {
                return null;
            }
            obj = this.readSingleObject(idx);
            this.lastXrefPartial = -1;
            if (obj != null) {
                this.lastXrefPartial = idx;
            }
            return obj;
        }
        catch (Exception e2) {
            throw new ExceptionConverter(e2);
        }
    }

    public void resetLastXrefPartial() {
        this.lastXrefPartial = -1;
    }

    public void releaseLastXrefPartial() {
        if (this.partial && this.lastXrefPartial != -1) {
            this.xrefObj.set(this.lastXrefPartial, null);
            this.lastXrefPartial = -1;
        }
    }

    public static void releaseLastXrefPartial(PdfObject obj) {
        if (obj == null) {
            return;
        }
        if (!obj.isIndirect()) {
            return;
        }
        PRIndirectReference ref = (PRIndirectReference)obj;
        PdfReader reader = ref.getReader();
        if (reader.partial && reader.lastXrefPartial != -1 && reader.lastXrefPartial == ref.getNumber()) {
            reader.xrefObj.set(reader.lastXrefPartial, null);
        }
        reader.lastXrefPartial = -1;
    }

    private void setXrefPartialObject(int idx, PdfObject obj) {
        if (!this.partial || idx < 0) {
            return;
        }
        this.xrefObj.set(idx, obj);
    }

    public PRIndirectReference addPdfObject(PdfObject obj) {
        this.xrefObj.add(obj);
        return new PRIndirectReference(this, this.xrefObj.size() - 1);
    }

    protected void readPages() throws IOException {
        this.pageInh = new ArrayList();
        this.catalog = (PdfDictionary)PdfReader.getPdfObject(this.trailer.get(PdfName.ROOT));
        this.rootPages = (PdfDictionary)PdfReader.getPdfObject(this.catalog.get(PdfName.PAGES));
        this.pageRefs = new PageRefs(this);
    }

    protected PRIndirectReference getSinglePage(int n2) throws IOException {
        PdfDictionary acc = new PdfDictionary();
        PdfDictionary top = this.rootPages;
        boolean base = false;
        return null;
    }

    protected void PRSimpleRecursive(PdfObject obj) throws IOException {
        switch (obj.type()) {
            case 6: 
            case 7: {
                PdfDictionary dic = (PdfDictionary)obj;
                Iterator it = dic.getKeys().iterator();
                while (it.hasNext()) {
                    PdfName key = (PdfName)it.next();
                    this.PRSimpleRecursive(dic.get(key));
                }
                break;
            }
            case 5: {
                ArrayList list = ((PdfArray)obj).getArrayList();
                int k2 = 0;
                while (k2 < list.size()) {
                    this.PRSimpleRecursive((PdfObject)list.get(k2));
                    ++k2;
                }
                break;
            }
            case 10: {
                PRIndirectReference ref = (PRIndirectReference)obj;
                int num = ref.getNumber();
                if (this.visited[num]) break;
                this.visited[num] = true;
                this.newHits.put(num, 1);
            }
        }
    }

    protected void readDocObjPartial() throws IOException {
        this.xrefObj = new ArrayList(this.xref.length / 2);
        this.xrefObj.addAll(Collections.nCopies(this.xref.length / 2, null));
        this.readDecryptedDocObj();
        if (this.objStmToOffset != null) {
            int[] keys = this.objStmToOffset.getKeys();
            int k2 = 0;
            while (k2 < keys.length) {
                int n2 = keys[k2];
                this.objStmToOffset.put(n2, this.xref[n2 * 2]);
                this.xref[n2 * 2] = -1;
                ++k2;
            }
        }
    }

    protected PdfObject readSingleObject(int k2) throws IOException {
        PdfObject obj;
        this.strings.clear();
        int k22 = k2 * 2;
        int pos = this.xref[k22];
        if (pos < 0) {
            return null;
        }
        if (this.xref[k22 + 1] > 0) {
            pos = this.objStmToOffset.get(this.xref[k22 + 1]);
        }
        this.tokens.seek(pos);
        this.tokens.nextValidToken();
        if (this.tokens.getTokenType() != 1) {
            this.tokens.throwError("Invalid object number.");
        }
        this.objNum = this.tokens.intValue();
        this.tokens.nextValidToken();
        if (this.tokens.getTokenType() != 1) {
            this.tokens.throwError("Invalid generation number.");
        }
        this.objGen = this.tokens.intValue();
        this.tokens.nextValidToken();
        if (!this.tokens.getStringValue().equals("obj")) {
            this.tokens.throwError("Token 'obj' expected.");
        }
        try {
            obj = this.readPRObject();
            int j2 = 0;
            while (j2 < this.strings.size()) {
                PdfString str = (PdfString)this.strings.get(j2);
                str.decrypt(this);
                ++j2;
            }
            if (obj.isStream()) {
                this.checkPRStreamLength((PRStream)obj);
            }
        }
        catch (Exception e2) {
            obj = null;
        }
        if (this.xref[k22 + 1] > 0) {
            obj = this.readOneObjStm((PRStream)obj, this.xref[k22]);
        }
        this.xrefObj.set(k2, obj);
        return obj;
    }

    protected PdfObject readOneObjStm(PRStream stream, int idx) throws IOException {
        int first = ((PdfNumber)PdfReader.getPdfObject(stream.get(PdfName.FIRST))).intValue();
        int n2 = ((PdfNumber)PdfReader.getPdfObject(stream.get(PdfName.N))).intValue();
        byte[] b2 = PdfReader.getStreamBytes(stream, this.tokens.getFile());
        PRTokeniser saveTokens = this.tokens;
        this.tokens = new PRTokeniser(b2);
        try {
            int address = 0;
            int objNumber = 0;
            boolean ok = true;
            ++idx;
            int k2 = 0;
            while (k2 < idx) {
                ok = this.tokens.nextToken();
                if (!ok) break;
                if (this.tokens.getTokenType() != 1) {
                    ok = false;
                    break;
                }
                objNumber = this.tokens.intValue();
                ok = this.tokens.nextToken();
                if (!ok) break;
                if (this.tokens.getTokenType() != 1) {
                    ok = false;
                    break;
                }
                address = this.tokens.intValue() + first;
                ++k2;
            }
            if (!ok) {
                throw new IOException("Error reading ObjStm");
            }
            this.tokens.seek(address);
            PdfObject pdfObject = this.readPRObject();
            Object var11_12 = null;
            this.tokens = saveTokens;
            return pdfObject;
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            this.tokens = saveTokens;
            throw throwable;
        }
    }

    public double dumpPerc() {
        int total = 0;
        int k2 = 0;
        while (k2 < this.xrefObj.size()) {
            if (this.xrefObj.get(k2) != null) {
                ++total;
            }
            ++k2;
        }
        return (double)total * 100.0 / (double)this.xrefObj.size();
    }

    protected void readDocObj() throws IOException {
        ArrayList<PdfObject> streams = new ArrayList<PdfObject>();
        this.xrefObj = new ArrayList(this.xref.length / 2);
        this.xrefObj.addAll(Collections.nCopies(this.xref.length / 2, null));
        int k2 = 2;
        while (k2 < this.xref.length) {
            int pos = this.xref[k2];
            if (pos > 0 && this.xref[k2 + 1] <= 0) {
                PdfObject obj;
                this.tokens.seek(pos);
                this.tokens.nextValidToken();
                if (this.tokens.getTokenType() != 1) {
                    this.tokens.throwError("Invalid object number.");
                }
                this.objNum = this.tokens.intValue();
                this.tokens.nextValidToken();
                if (this.tokens.getTokenType() != 1) {
                    this.tokens.throwError("Invalid generation number.");
                }
                this.objGen = this.tokens.intValue();
                this.tokens.nextValidToken();
                if (!this.tokens.getStringValue().equals("obj")) {
                    this.tokens.throwError("Token 'obj' expected.");
                }
                try {
                    obj = this.readPRObject();
                    if (obj.isStream()) {
                        streams.add(obj);
                    }
                }
                catch (Exception e2) {
                    obj = null;
                }
                this.xrefObj.set(k2 / 2, obj);
            }
            k2 += 2;
        }
        int fileLength = this.tokens.length();
        byte[] tline = new byte[16];
        int k3 = 0;
        while (k3 < streams.size()) {
            this.checkPRStreamLength((PRStream)streams.get(k3));
            ++k3;
        }
        this.readDecryptedDocObj();
        if (this.objStmMark != null) {
            Iterator i2 = this.objStmMark.entrySet().iterator();
            while (i2.hasNext()) {
                Map.Entry entry = i2.next();
                int n2 = (Integer)entry.getKey();
                IntHashtable h2 = (IntHashtable)entry.getValue();
                this.readObjStm((PRStream)this.xrefObj.get(n2), h2);
                this.xrefObj.set(n2, null);
            }
            this.objStmMark = null;
        }
        this.xref = null;
    }

    private void checkPRStreamLength(PRStream stream) throws IOException {
        int streamLength;
        block8: {
            int fileLength = this.tokens.length();
            int start = stream.getOffset();
            boolean calc = false;
            streamLength = 0;
            PdfObject obj = PdfReader.getPdfObjectRelease(stream.get(PdfName.LENGTH));
            if (obj != null && obj.type() == 2) {
                streamLength = ((PdfNumber)obj).intValue();
                if (streamLength + start > fileLength - 20) {
                    calc = true;
                } else {
                    this.tokens.seek(start + streamLength);
                    String line = this.tokens.readString(20);
                    if (!(line.startsWith("\nendstream") || line.startsWith("\r\nendstream") || line.startsWith("\rendstream") || line.startsWith("endstream"))) {
                        calc = true;
                    }
                }
            } else {
                calc = true;
            }
            if (calc) {
                int pos;
                byte[] tline = new byte[16];
                this.tokens.seek(start);
                do {
                    pos = this.tokens.getFilePointer();
                    if (!this.tokens.readLineSegment(tline)) break block8;
                    if (!PdfReader.equalsn(tline, endstream)) continue;
                    streamLength = pos - start;
                    break block8;
                } while (!PdfReader.equalsn(tline, endobj));
                this.tokens.seek(pos - 16);
                String s = this.tokens.readString(16);
                int index = s.indexOf("endstream");
                if (index >= 0) {
                    pos = pos - 16 + index;
                }
                streamLength = pos - start;
            }
        }
        stream.setLength(streamLength);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void readObjStm(PRStream stream, IntHashtable map) throws IOException {
        int first = ((PdfNumber)PdfReader.getPdfObject(stream.get(PdfName.FIRST))).intValue();
        int n2 = ((PdfNumber)PdfReader.getPdfObject(stream.get(PdfName.N))).intValue();
        byte[] b2 = PdfReader.getStreamBytes(stream, this.tokens.getFile());
        PRTokeniser saveTokens = this.tokens;
        this.tokens = new PRTokeniser(b2);
        try {
            int[] address = new int[n2];
            int[] objNumber = new int[n2];
            boolean ok = true;
            int k2 = 0;
            while (k2 < n2 && (ok = this.tokens.nextToken())) {
                if (this.tokens.getTokenType() != 1) {
                    ok = false;
                    break;
                }
                objNumber[k2] = this.tokens.intValue();
                ok = this.tokens.nextToken();
                if (!ok) break;
                if (this.tokens.getTokenType() != 1) {
                    ok = false;
                    break;
                }
                address[k2] = this.tokens.intValue() + first;
                ++k2;
            }
            if (!ok) {
                throw new IOException("Error reading ObjStm");
            }
            k2 = 0;
            while (k2 < n2) {
                if (map.containsKey(k2)) {
                    this.tokens.seek(address[k2]);
                    PdfObject obj = this.readPRObject();
                    this.xrefObj.set(objNumber[k2], obj);
                }
                ++k2;
            }
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            this.tokens = saveTokens;
            throw throwable;
        }
        {
            Object var12_14 = null;
            this.tokens = saveTokens;
            return;
        }
    }

    static PdfObject killIndirect(PdfObject obj) {
        if (obj == null || obj.isNull()) {
            return null;
        }
        PdfObject ret = PdfReader.getPdfObjectRelease(obj);
        if (obj.isIndirect()) {
            PRIndirectReference ref = (PRIndirectReference)obj;
            PdfReader reader = ref.getReader();
            int n2 = ref.getNumber();
            reader.xrefObj.set(n2, null);
            if (reader.partial) {
                reader.xref[n2 * 2] = -1;
            }
        }
        return ret;
    }

    private void ensureXrefSize(int size) {
        if (size == 0) {
            return;
        }
        if (this.xref == null) {
            this.xref = new int[size];
        } else if (this.xref.length < size) {
            int[] xref2 = new int[size];
            System.arraycopy(this.xref, 0, xref2, 0, this.xref.length);
            this.xref = xref2;
        }
    }

    protected void readXref() throws IOException {
        PdfNumber prev;
        int startxref;
        this.hybridXref = false;
        this.newXrefType = false;
        this.tokens.seek(this.tokens.getStartxref());
        this.tokens.nextToken();
        if (!this.tokens.getStringValue().equals("startxref")) {
            throw new IOException("startxref not found.");
        }
        this.tokens.nextToken();
        if (this.tokens.getTokenType() != 1) {
            throw new IOException("startxref is not followed by a number.");
        }
        this.lastXref = startxref = this.tokens.intValue();
        this.eofPos = this.tokens.getFilePointer();
        try {
            if (this.readXRefStream(startxref)) {
                this.newXrefType = true;
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.xref = null;
        this.tokens.seek(startxref);
        PdfDictionary trailer2 = this.trailer = this.readXrefSection();
        while ((prev = (PdfNumber)trailer2.get(PdfName.PREV)) != null) {
            this.tokens.seek(prev.intValue());
            trailer2 = this.readXrefSection();
        }
    }

    protected PdfDictionary readXrefSection() throws IOException {
        this.tokens.nextValidToken();
        if (!this.tokens.getStringValue().equals("xref")) {
            this.tokens.throwError("xref subsection not found");
        }
        int start = 0;
        int end = 0;
        int pos = 0;
        int gen = 0;
        block2: while (true) {
            this.tokens.nextValidToken();
            if (this.tokens.getStringValue().equals("trailer")) break;
            if (this.tokens.getTokenType() != 1) {
                this.tokens.throwError("Object number of the first object in this xref subsection not found");
            }
            start = this.tokens.intValue();
            this.tokens.nextValidToken();
            if (this.tokens.getTokenType() != 1) {
                this.tokens.throwError("Number of entries in this xref subsection not found");
            }
            end = this.tokens.intValue() + start;
            if (start == 1) {
                int back = this.tokens.getFilePointer();
                this.tokens.nextValidToken();
                pos = this.tokens.intValue();
                this.tokens.nextValidToken();
                gen = this.tokens.intValue();
                if (pos == 0 && gen == 65535) {
                    --end;
                }
                this.tokens.seek(back);
            }
            this.ensureXrefSize(end * 2);
            int k2 = --start;
            while (true) {
                if (k2 >= end) continue block2;
                this.tokens.nextValidToken();
                pos = this.tokens.intValue();
                this.tokens.nextValidToken();
                gen = this.tokens.intValue();
                this.tokens.nextValidToken();
                int p = k2 * 2;
                if (this.tokens.getStringValue().equals("n")) {
                    if (this.xref[p] == 0 && this.xref[p + 1] == 0) {
                        this.xref[p] = pos;
                    }
                } else if (this.tokens.getStringValue().equals("f")) {
                    if (this.xref[p] == 0 && this.xref[p + 1] == 0) {
                        this.xref[p] = -1;
                    }
                } else {
                    this.tokens.throwError("Invalid cross-reference entry in this xref subsection");
                }
                ++k2;
            }
            break;
        }
        PdfDictionary trailer = (PdfDictionary)this.readPRObject();
        PdfNumber xrefSize = (PdfNumber)trailer.get(PdfName.SIZE);
        this.ensureXrefSize(xrefSize.intValue() * 2);
        PdfObject xrs = trailer.get(PdfName.XREFSTM);
        if (xrs != null && xrs.isNumber()) {
            int loc = ((PdfNumber)xrs).intValue();
            try {
                this.readXRefStream(loc);
                this.newXrefType = true;
                this.hybridXref = true;
            }
            catch (IOException e2) {
                this.xref = null;
                throw e2;
            }
        }
        return trailer;
    }

    protected boolean readXRefStream(int ptr) throws IOException {
        PdfArray index;
        this.tokens.seek(ptr);
        int thisStream = 0;
        if (!this.tokens.nextToken()) {
            return false;
        }
        if (this.tokens.getTokenType() != 1) {
            return false;
        }
        thisStream = this.tokens.intValue();
        if (!this.tokens.nextToken() || this.tokens.getTokenType() != 1) {
            return false;
        }
        if (!this.tokens.nextToken() || !this.tokens.getStringValue().equals("obj")) {
            return false;
        }
        PdfObject object = this.readPRObject();
        PRStream stm = null;
        if (object.isStream() && !PdfName.XREF.equals((stm = (PRStream)object).get(PdfName.TYPE))) {
            return false;
        }
        if (this.trailer == null) {
            this.trailer = new PdfDictionary();
            this.trailer.putAll(stm);
        }
        stm.setLength(((PdfNumber)stm.get(PdfName.LENGTH)).intValue());
        int size = ((PdfNumber)stm.get(PdfName.SIZE)).intValue();
        PdfObject obj = stm.get(PdfName.INDEX);
        if (obj == null) {
            index = new PdfArray();
            int[] nArray = new int[2];
            nArray[1] = size;
            index.add(nArray);
        } else {
            index = (PdfArray)obj;
        }
        PdfArray w = (PdfArray)stm.get(PdfName.W);
        int prev = -1;
        obj = stm.get(PdfName.PREV);
        if (obj != null) {
            prev = ((PdfNumber)obj).intValue();
        }
        this.ensureXrefSize(size * 2);
        if (this.objStmMark == null && !this.partial) {
            this.objStmMark = new HashMap();
        }
        if (this.objStmToOffset == null && this.partial) {
            this.objStmToOffset = new IntHashtable();
        }
        byte[] b2 = PdfReader.getStreamBytes(stm, this.tokens.getFile());
        int bptr = 0;
        ArrayList wa = w.getArrayList();
        int[] wc = new int[3];
        int k2 = 0;
        while (k2 < 3) {
            wc[k2] = ((PdfNumber)wa.get(k2)).intValue();
            ++k2;
        }
        ArrayList sections = index.getArrayList();
        int idx = 0;
        while (idx < sections.size()) {
            int start = ((PdfNumber)sections.get(idx)).intValue();
            int length = ((PdfNumber)sections.get(idx + 1)).intValue();
            this.ensureXrefSize((start + length) * 2);
            while (length-- > 0) {
                boolean total = false;
                int type = 1;
                if (wc[0] > 0) {
                    type = 0;
                    int k3 = 0;
                    while (k3 < wc[0]) {
                        type = (type << 8) + (b2[bptr++] & 0xFF);
                        ++k3;
                    }
                }
                int field2 = 0;
                int k4 = 0;
                while (k4 < wc[1]) {
                    field2 = (field2 << 8) + (b2[bptr++] & 0xFF);
                    ++k4;
                }
                int field3 = 0;
                int k5 = 0;
                while (k5 < wc[2]) {
                    field3 = (field3 << 8) + (b2[bptr++] & 0xFF);
                    ++k5;
                }
                int base = start * 2;
                if (this.xref[base] == 0 && this.xref[base + 1] == 0) {
                    switch (type) {
                        case 0: {
                            this.xref[base] = -1;
                            break;
                        }
                        case 1: {
                            this.xref[base] = field2;
                            break;
                        }
                        case 2: {
                            this.xref[base] = field3;
                            this.xref[base + 1] = field2;
                            if (this.partial) {
                                this.objStmToOffset.put(field2, 0);
                                break;
                            }
                            Integer on = new Integer(field2);
                            IntHashtable seq = (IntHashtable)this.objStmMark.get(on);
                            if (seq == null) {
                                seq = new IntHashtable();
                                seq.put(field3, 1);
                                this.objStmMark.put(on, seq);
                                break;
                            }
                            seq.put(field3, 1);
                        }
                    }
                }
                ++start;
            }
            idx += 2;
        }
        if ((thisStream *= 2) < this.xref.length) {
            this.xref[thisStream] = -1;
        }
        if (prev == -1) {
            return true;
        }
        return this.readXRefStream(prev);
    }

    protected void rebuildXref() throws IOException {
        int[] obj;
        this.hybridXref = false;
        this.newXrefType = false;
        this.tokens.seek(0);
        int[][] xr = new int[1024][];
        int top = 0;
        this.trailer = null;
        byte[] line = new byte[64];
        while (true) {
            int pos = this.tokens.getFilePointer();
            if (!this.tokens.readLineSegment(line)) break;
            if (line[0] == 116) {
                if (!PdfEncodings.convertToString(line, null).startsWith("trailer")) continue;
                pos = this.tokens.getFilePointer();
                try {
                    PdfDictionary dic = (PdfDictionary)this.readPRObject();
                    if (dic.get(PdfName.ROOT) != null) {
                        this.trailer = dic;
                        continue;
                    }
                    this.tokens.seek(pos);
                }
                catch (Exception e2) {
                    this.tokens.seek(pos);
                }
                continue;
            }
            if (line[0] < 48 || line[0] > 57 || (obj = PRTokeniser.checkObjectStart(line)) == null) continue;
            int num = obj[0];
            int gen = obj[1];
            if (num >= xr.length) {
                int newLength = num * 2;
                int[][] xr2 = new int[newLength][];
                System.arraycopy(xr, 0, xr2, 0, top);
                xr = xr2;
            }
            if (num >= top) {
                top = num + 1;
            }
            if (xr[num] != null && gen < xr[num][1]) continue;
            obj[0] = pos;
            xr[num] = obj;
        }
        if (this.trailer == null) {
            throw new IOException("trailer not found.");
        }
        this.xref = new int[top * 2];
        int k2 = 0;
        while (k2 < top) {
            obj = xr[k2];
            if (obj != null) {
                this.xref[k2 * 2] = obj[0];
            }
            ++k2;
        }
    }

    protected PdfDictionary readDictionary() throws IOException {
        PdfDictionary dic = new PdfDictionary();
        while (true) {
            this.tokens.nextValidToken();
            if (this.tokens.getTokenType() == 8) break;
            if (this.tokens.getTokenType() != 3) {
                this.tokens.throwError("Dictionary key is not a name.");
            }
            PdfName name = new PdfName(this.tokens.getStringValue());
            PdfObject obj = this.readPRObject();
            int type = obj.type();
            if (-type == 8) {
                this.tokens.throwError("Unexpected '>>'");
            }
            if (-type == 6) {
                this.tokens.throwError("Unexpected ']'");
            }
            dic.put(name, obj);
        }
        return dic;
    }

    protected PdfArray readArray() throws IOException {
        PdfObject obj;
        int type;
        PdfArray array = new PdfArray();
        while (-(type = (obj = this.readPRObject()).type()) != 6) {
            if (-type == 8) {
                this.tokens.throwError("Unexpected '>>'");
            }
            array.add(obj);
        }
        return array;
    }

    protected PdfObject readPRObject() throws IOException {
        this.tokens.nextValidToken();
        int type = this.tokens.getTokenType();
        switch (type) {
            case 7: {
                PdfDictionary dic = this.readDictionary();
                int pos = this.tokens.getFilePointer();
                if (this.tokens.nextToken() && this.tokens.getStringValue().equals("stream")) {
                    int ch = this.tokens.read();
                    if (ch != 10) {
                        ch = this.tokens.read();
                    }
                    if (ch != 10) {
                        this.tokens.backOnePosition(ch);
                    }
                    PRStream stream = new PRStream(this, this.tokens.getFilePointer());
                    stream.putAll(dic);
                    stream.setObjNum(this.objNum, this.objGen);
                    return stream;
                }
                this.tokens.seek(pos);
                return dic;
            }
            case 5: {
                return this.readArray();
            }
            case 1: {
                return new PdfNumber(this.tokens.getStringValue());
            }
            case 2: {
                PdfString str = new PdfString(this.tokens.getStringValue(), null).setHexWriting(this.tokens.isHexString());
                str.setObjNum(this.objNum, this.objGen);
                if (this.strings != null) {
                    this.strings.add(str);
                }
                return str;
            }
            case 3: {
                return new PdfName(this.tokens.getStringValue());
            }
            case 9: {
                int num = this.tokens.getReference();
                PRIndirectReference ref = new PRIndirectReference(this, num, this.tokens.getGeneration());
                if (this.visited != null && !this.visited[num]) {
                    this.visited[num] = true;
                    this.newHits.put(num, 1);
                }
                return ref;
            }
        }
        return new PdfLiteral(-type, this.tokens.getStringValue());
    }

    public static byte[] FlateDecode(byte[] in) {
        byte[] b2 = PdfReader.FlateDecode(in, true);
        if (b2 == null) {
            return PdfReader.FlateDecode(in, false);
        }
        return b2;
    }

    public static byte[] decodePredictor(byte[] in, PdfObject dicPar) {
        if (dicPar == null || !dicPar.isDictionary()) {
            return in;
        }
        PdfDictionary dic = (PdfDictionary)dicPar;
        PdfObject obj = PdfReader.getPdfObject(dic.get(PdfName.PREDICTOR));
        if (obj == null || !obj.isNumber()) {
            return in;
        }
        int predictor = ((PdfNumber)obj).intValue();
        if (predictor < 10) {
            return in;
        }
        int width = 1;
        obj = PdfReader.getPdfObject(dic.get(PdfName.COLUMNS));
        if (obj != null && obj.isNumber()) {
            width = ((PdfNumber)obj).intValue();
        }
        int colors = 1;
        obj = PdfReader.getPdfObject(dic.get(PdfName.COLORS));
        if (obj != null && obj.isNumber()) {
            colors = ((PdfNumber)obj).intValue();
        }
        int bpc = 8;
        obj = PdfReader.getPdfObject(dic.get(PdfName.BITSPERCOMPONENT));
        if (obj != null && obj.isNumber()) {
            bpc = ((PdfNumber)obj).intValue();
        }
        DataInputStream dataStream = new DataInputStream(new ByteArrayInputStream(in));
        ByteArrayOutputStream fout = new ByteArrayOutputStream(in.length);
        int bytesPerPixel = colors * bpc / 8;
        int bytesPerRow = (colors * width * bpc + 7) / 8;
        byte[] curr = new byte[bytesPerRow];
        byte[] prior = new byte[bytesPerRow];
        while (true) {
            int filter = 0;
            try {
                filter = dataStream.read();
                if (filter < 0) {
                    return fout.toByteArray();
                }
                dataStream.readFully(curr, 0, bytesPerRow);
            }
            catch (Exception e2) {
                return fout.toByteArray();
            }
            switch (filter) {
                case 0: {
                    break;
                }
                case 1: {
                    int i2 = bytesPerPixel;
                    while (i2 < bytesPerRow) {
                        int n2 = i2;
                        curr[n2] = (byte)(curr[n2] + curr[i2 - bytesPerPixel]);
                        ++i2;
                    }
                    break;
                }
                case 2: {
                    int i3 = 0;
                    while (i3 < bytesPerRow) {
                        int n3 = i3;
                        curr[n3] = (byte)(curr[n3] + prior[i3]);
                        ++i3;
                    }
                    break;
                }
                case 3: {
                    int i4 = 0;
                    while (i4 < bytesPerPixel) {
                        int n4 = i4;
                        curr[n4] = (byte)(curr[n4] + prior[i4] / 2);
                        ++i4;
                    }
                    i4 = bytesPerPixel;
                    while (i4 < bytesPerRow) {
                        int n5 = i4;
                        curr[n5] = (byte)(curr[n5] + ((curr[i4 - bytesPerPixel] & 0xFF) + (prior[i4] & 0xFF)) / 2);
                        ++i4;
                    }
                    break;
                }
                case 4: {
                    int i5 = 0;
                    while (i5 < bytesPerPixel) {
                        int n6 = i5;
                        curr[n6] = (byte)(curr[n6] + prior[i5]);
                        ++i5;
                    }
                    i5 = bytesPerPixel;
                    while (i5 < bytesPerRow) {
                        int a2 = curr[i5 - bytesPerPixel] & 0xFF;
                        int b2 = prior[i5] & 0xFF;
                        int c2 = prior[i5 - bytesPerPixel] & 0xFF;
                        int p = a2 + b2 - c2;
                        int pa = Math.abs(p - a2);
                        int pb = Math.abs(p - b2);
                        int pc = Math.abs(p - c2);
                        int ret = pa <= pb && pa <= pc ? a2 : (pb <= pc ? b2 : c2);
                        int n7 = i5++;
                        curr[n7] = (byte)(curr[n7] + (byte)ret);
                    }
                    break;
                }
                default: {
                    throw new RuntimeException("PNG filter unknown.");
                }
            }
            try {
                fout.write(curr);
            }
            catch (IOException i6) {
                // empty catch block
            }
            byte[] tmp = prior;
            prior = curr;
            curr = tmp;
        }
    }

    public static byte[] FlateDecode(byte[] in, boolean strict) {
        ByteArrayInputStream stream = new ByteArrayInputStream(in);
        InflaterInputStream zip = new InflaterInputStream(stream);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] b2 = new byte[strict ? 4092 : 1];
        try {
            int n2;
            while ((n2 = zip.read(b2)) >= 0) {
                out.write(b2, 0, n2);
            }
            zip.close();
            out.close();
            return out.toByteArray();
        }
        catch (Exception e2) {
            if (strict) {
                return null;
            }
            return out.toByteArray();
        }
    }

    public static byte[] ASCIIHexDecode(byte[] in) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        boolean first = true;
        int n1 = 0;
        int k2 = 0;
        while (k2 < in.length) {
            int ch = in[k2] & 0xFF;
            if (ch == 62) break;
            if (!PRTokeniser.isWhitespace(ch)) {
                int n2 = PRTokeniser.getHex(ch);
                if (n2 == -1) {
                    throw new RuntimeException("Illegal character in ASCIIHexDecode.");
                }
                if (first) {
                    n1 = n2;
                } else {
                    out.write((byte)((n1 << 4) + n2));
                }
                first = !first;
            }
            ++k2;
        }
        if (!first) {
            out.write((byte)(n1 << 4));
        }
        return out.toByteArray();
    }

    public static byte[] ASCII85Decode(byte[] in) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int state = 0;
        int[] chn = new int[5];
        int k2 = 0;
        while (k2 < in.length) {
            int ch = in[k2] & 0xFF;
            if (ch == 126) break;
            if (!PRTokeniser.isWhitespace(ch)) {
                if (ch == 122 && state == 0) {
                    out.write(0);
                    out.write(0);
                    out.write(0);
                    out.write(0);
                } else {
                    if (ch < 33 || ch > 117) {
                        throw new RuntimeException("Illegal character in ASCII85Decode.");
                    }
                    chn[state] = ch - 33;
                    if (++state == 5) {
                        state = 0;
                        int r = 0;
                        int j2 = 0;
                        while (j2 < 5) {
                            r = r * 85 + chn[j2];
                            ++j2;
                        }
                        out.write((byte)(r >> 24));
                        out.write((byte)(r >> 16));
                        out.write((byte)(r >> 8));
                        out.write((byte)r);
                    }
                }
            }
            ++k2;
        }
        int r = 0;
        if (state == 1) {
            throw new RuntimeException("Illegal length in ASCII85Decode.");
        }
        if (state == 2) {
            r = chn[0] * 85 * 85 * 85 * 85 + chn[1] * 85 * 85 * 85;
            out.write((byte)(r >> 24));
        } else if (state == 3) {
            r = chn[0] * 85 * 85 * 85 * 85 + chn[1] * 85 * 85 * 85 + chn[2] * 85 * 85;
            out.write((byte)(r >> 24));
            out.write((byte)(r >> 16));
        } else if (state == 4) {
            r = chn[0] * 85 * 85 * 85 * 85 + chn[1] * 85 * 85 * 85 + chn[2] * 85 * 85 + chn[3] * 85;
            out.write((byte)(r >> 24));
            out.write((byte)(r >> 16));
            out.write((byte)(r >> 8));
        }
        return out.toByteArray();
    }

    public static byte[] LZWDecode(byte[] in) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        LZWDecoder lzw = new LZWDecoder();
        lzw.decode(in, out);
        return out.toByteArray();
    }

    public boolean isRebuilt() {
        return this.rebuilt;
    }

    public PdfDictionary getPageN(int pageNum) {
        PdfDictionary dic = this.pageRefs.getPageN(pageNum);
        if (dic == null) {
            return null;
        }
        if (this.appendable) {
            dic.setIndRef(this.pageRefs.getPageOrigRef(pageNum));
        }
        return dic;
    }

    public PdfDictionary getPageNRelease(int pageNum) {
        PdfDictionary dic = this.getPageN(pageNum);
        this.pageRefs.releasePage(pageNum);
        return dic;
    }

    public void releasePage(int pageNum) {
        this.pageRefs.releasePage(pageNum);
    }

    public void resetReleasePage() {
        this.pageRefs.resetReleasePage();
    }

    public PRIndirectReference getPageOrigRef(int pageNum) {
        return this.pageRefs.getPageOrigRef(pageNum);
    }

    public byte[] getPageContent(int pageNum, RandomAccessFileOrArray file) throws IOException {
        PdfDictionary page = this.getPageNRelease(pageNum);
        if (page == null) {
            return null;
        }
        PdfObject contents = PdfReader.getPdfObjectRelease(page.get(PdfName.CONTENTS));
        if (contents == null) {
            return new byte[0];
        }
        ByteArrayOutputStream bout = null;
        if (contents.isStream()) {
            return PdfReader.getStreamBytes((PRStream)contents, file);
        }
        if (contents.isArray()) {
            PdfArray array = (PdfArray)contents;
            ArrayList list = array.getArrayList();
            bout = new ByteArrayOutputStream();
            int k2 = 0;
            while (k2 < list.size()) {
                PdfObject item = PdfReader.getPdfObjectRelease((PdfObject)list.get(k2));
                if (item != null && item.isStream()) {
                    byte[] b2 = PdfReader.getStreamBytes((PRStream)item, file);
                    bout.write(b2);
                    if (k2 != list.size() - 1) {
                        bout.write(10);
                    }
                }
                ++k2;
            }
            return bout.toByteArray();
        }
        return new byte[0];
    }

    public byte[] getPageContent(int pageNum) throws IOException {
        byte[] byArray;
        RandomAccessFileOrArray rf = this.getSafeFile();
        try {
            rf.reOpen();
            byArray = this.getPageContent(pageNum, rf);
            Object var3_4 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            try {
                rf.close();
            }
            catch (Exception e2) {}
            throw throwable;
        }
        try {
            rf.close();
        }
        catch (Exception e2) {
            // empty catch block
        }
        return byArray;
    }

    protected void killXref(PdfObject obj) {
        if (obj == null) {
            return;
        }
        if (obj instanceof PdfIndirectReference && !obj.isIndirect()) {
            return;
        }
        switch (obj.type()) {
            case 10: {
                int xr = ((PRIndirectReference)obj).getNumber();
                obj = (PdfObject)this.xrefObj.get(xr);
                this.xrefObj.set(xr, null);
                this.freeXref = xr;
                this.killXref(obj);
                break;
            }
            case 5: {
                ArrayList t = ((PdfArray)obj).getArrayList();
                int i2 = 0;
                while (i2 < t.size()) {
                    this.killXref((PdfObject)t.get(i2));
                    ++i2;
                }
                break;
            }
            case 6: 
            case 7: {
                PdfDictionary dic = (PdfDictionary)obj;
                Iterator i3 = dic.getKeys().iterator();
                while (i3.hasNext()) {
                    this.killXref(dic.get((PdfName)i3.next()));
                }
                break;
            }
        }
    }

    public void setPageContent(int pageNum, byte[] content) throws IOException {
        PdfDictionary page = this.getPageN(pageNum);
        if (page == null) {
            return;
        }
        PdfObject contents = page.get(PdfName.CONTENTS);
        this.freeXref = -1;
        this.killXref(contents);
        if (this.freeXref == -1) {
            this.xrefObj.add(null);
            this.freeXref = this.xrefObj.size() - 1;
        }
        page.put(PdfName.CONTENTS, new PRIndirectReference(this, this.freeXref));
        this.xrefObj.set(this.freeXref, new PRStream(this, content));
    }

    public static byte[] getStreamBytes(PRStream stream, RandomAccessFileOrArray file) throws IOException {
        byte[] b2;
        PdfReader reader = stream.getReader();
        PdfObject filter = PdfReader.getPdfObjectRelease(stream.get(PdfName.FILTER));
        if (stream.getOffset() < 0) {
            b2 = stream.getBytes();
        } else {
            b2 = new byte[stream.getLength()];
            file.seek(stream.getOffset());
            file.readFully(b2);
            PdfEncryption decrypt = reader.getDecrypt();
            if (decrypt != null) {
                decrypt.setHashKey(stream.getObjNum(), stream.getObjGen());
                decrypt.prepareKey();
                decrypt.encryptRC4(b2);
            }
        }
        ArrayList filters = new ArrayList();
        if (filter != null) {
            if (filter.isName()) {
                filters.add(filter);
            } else if (filter.isArray()) {
                filters = ((PdfArray)filter).getArrayList();
            }
        }
        ArrayList dp = new ArrayList();
        PdfObject dpo = PdfReader.getPdfObjectRelease(stream.get(PdfName.DECODEPARMS));
        if (dpo == null || !dpo.isDictionary() && !dpo.isArray()) {
            dpo = PdfReader.getPdfObjectRelease(stream.get(PdfName.DP));
        }
        if (dpo != null) {
            if (dpo.isDictionary()) {
                dp.add(dpo);
            } else if (dpo.isArray()) {
                dp = ((PdfArray)dpo).getArrayList();
            }
        }
        int j2 = 0;
        while (j2 < filters.size()) {
            PdfObject dicParam;
            String name = ((PdfName)PdfReader.getPdfObjectRelease((PdfObject)filters.get(j2))).toString();
            if (name.equals("/FlateDecode") || name.equals("/Fl")) {
                b2 = PdfReader.FlateDecode(b2);
                dicParam = null;
                if (j2 < dp.size()) {
                    dicParam = (PdfObject)dp.get(j2);
                    b2 = PdfReader.decodePredictor(b2, dicParam);
                }
            } else if (name.equals("/ASCIIHexDecode") || name.equals("/AHx")) {
                b2 = PdfReader.ASCIIHexDecode(b2);
            } else if (name.equals("/ASCII85Decode") || name.equals("/A85")) {
                b2 = PdfReader.ASCII85Decode(b2);
            } else if (name.equals("/LZWDecode")) {
                b2 = PdfReader.LZWDecode(b2);
                dicParam = null;
                if (j2 < dp.size()) {
                    dicParam = (PdfObject)dp.get(j2);
                    b2 = PdfReader.decodePredictor(b2, dicParam);
                }
            } else {
                throw new IOException("The filter " + name + " is not supported.");
            }
            ++j2;
        }
        return b2;
    }

    public static byte[] getStreamBytes(PRStream stream) throws IOException {
        byte[] byArray;
        RandomAccessFileOrArray rf = stream.getReader().getSafeFile();
        try {
            rf.reOpen();
            byArray = PdfReader.getStreamBytes(stream, rf);
            Object var2_3 = null;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            try {
                rf.close();
            }
            catch (Exception e2) {}
            throw throwable;
        }
        try {
            rf.close();
        }
        catch (Exception e2) {
            // empty catch block
        }
        return byArray;
    }

    public void eliminateSharedStreams() {
        if (!this.sharedStreams) {
            return;
        }
        this.sharedStreams = false;
        if (this.pageRefs.size() == 1) {
            return;
        }
        ArrayList<PRIndirectReference> newRefs = new ArrayList<PRIndirectReference>();
        ArrayList<PRStream> newStreams = new ArrayList<PRStream>();
        IntHashtable visited = new IntHashtable();
        int k2 = 1;
        while (k2 <= this.pageRefs.size()) {
            PdfObject contents;
            PdfDictionary page = this.pageRefs.getPageN(k2);
            if (page != null && (contents = PdfReader.getPdfObject(page.get(PdfName.CONTENTS))) != null) {
                if (contents.isStream()) {
                    PRIndirectReference ref = (PRIndirectReference)page.get(PdfName.CONTENTS);
                    if (visited.containsKey(ref.getNumber())) {
                        newRefs.add(ref);
                        newStreams.add(new PRStream((PRStream)contents, null));
                    } else {
                        visited.put(ref.getNumber(), 1);
                    }
                } else {
                    PdfArray array = (PdfArray)contents;
                    ArrayList list = array.getArrayList();
                    int j2 = 0;
                    while (j2 < list.size()) {
                        PRIndirectReference ref = (PRIndirectReference)list.get(j2);
                        if (visited.containsKey(ref.getNumber())) {
                            newRefs.add(ref);
                            newStreams.add(new PRStream((PRStream)PdfReader.getPdfObject(ref), null));
                        } else {
                            visited.put(ref.getNumber(), 1);
                        }
                        ++j2;
                    }
                }
            }
            ++k2;
        }
        if (newStreams.size() == 0) {
            return;
        }
        k2 = 0;
        while (k2 < newStreams.size()) {
            this.xrefObj.add(newStreams.get(k2));
            PRIndirectReference ref = (PRIndirectReference)newRefs.get(k2);
            ref.setNumber(this.xrefObj.size() - 1, 0);
            ++k2;
        }
    }

    public boolean isTampered() {
        return this.tampered;
    }

    public void setTampered(boolean tampered) {
        this.tampered = tampered;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] getMetadata() throws IOException {
        PdfObject obj = PdfReader.getPdfObject(this.catalog.get(PdfName.METADATA));
        if (!(obj instanceof PRStream)) {
            return null;
        }
        RandomAccessFileOrArray rf = this.getSafeFile();
        byte[] b2 = null;
        try {
            rf.reOpen();
            b2 = PdfReader.getStreamBytes((PRStream)obj, rf);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            try {
                rf.close();
                throw throwable;
            }
            catch (Exception e2) {
                // empty catch block
            }
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        try {}
        catch (Exception e2) {
            return b2;
        }
        rf.close();
        return b2;
    }

    public int getLastXref() {
        return this.lastXref;
    }

    public int getXrefSize() {
        return this.xrefObj.size();
    }

    public int getEofPos() {
        return this.eofPos;
    }

    public char getPdfVersion() {
        return this.pdfVersion;
    }

    public boolean isEncrypted() {
        return this.encrypted;
    }

    public int getPermissions() {
        return this.pValue;
    }

    public boolean is128Key() {
        return this.rValue == 3;
    }

    public PdfDictionary getTrailer() {
        return this.trailer;
    }

    PdfEncryption getDecrypt() {
        return this.decrypt;
    }

    static boolean equalsn(byte[] a1, byte[] a2) {
        int length = a2.length;
        int k2 = 0;
        while (k2 < length) {
            if (a1[k2] != a2[k2]) {
                return false;
            }
            ++k2;
        }
        return true;
    }

    static boolean existsName(PdfDictionary dic, PdfName key, PdfName value) {
        PdfObject type = PdfReader.getPdfObjectRelease(dic.get(key));
        if (type == null || !type.isName()) {
            return false;
        }
        PdfName name = (PdfName)type;
        return name.equals(value);
    }

    static String getFontName(PdfDictionary dic) {
        PdfObject type = PdfReader.getPdfObjectRelease(dic.get(PdfName.BASEFONT));
        if (type == null || !type.isName()) {
            return null;
        }
        return PdfName.decodeName(type.toString());
    }

    static String getSubsetPrefix(PdfDictionary dic) {
        String s = PdfReader.getFontName(dic);
        if (s == null) {
            return null;
        }
        if (s.length() < 8 || s.charAt(6) != '+') {
            return null;
        }
        int k2 = 0;
        while (k2 < 6) {
            char c2 = s.charAt(k2);
            if (c2 < 'A' || c2 > 'Z') {
                return null;
            }
            ++k2;
        }
        return s;
    }

    public int shuffleSubsetNames() {
        int total = 0;
        int k2 = 1;
        while (k2 < this.xrefObj.size()) {
            PdfDictionary dic;
            PdfObject obj = this.getPdfObjectRelease(k2);
            if (obj != null && obj.isDictionary() && PdfReader.existsName(dic = (PdfDictionary)obj, PdfName.TYPE, PdfName.FONT)) {
                String s;
                if (PdfReader.existsName(dic, PdfName.SUBTYPE, PdfName.TYPE1) || PdfReader.existsName(dic, PdfName.SUBTYPE, PdfName.MMTYPE1) || PdfReader.existsName(dic, PdfName.SUBTYPE, PdfName.TRUETYPE)) {
                    s = PdfReader.getSubsetPrefix(dic);
                    if (s != null) {
                        String ns = String.valueOf(BaseFont.createSubsetPrefix()) + s.substring(7);
                        PdfName newName = new PdfName(ns);
                        dic.put(PdfName.BASEFONT, newName);
                        this.setXrefPartialObject(k2, dic);
                        ++total;
                        PdfDictionary fd = (PdfDictionary)PdfReader.getPdfObject(dic.get(PdfName.FONTDESCRIPTOR));
                        if (fd != null) {
                            fd.put(PdfName.FONTNAME, newName);
                        }
                    }
                } else if (PdfReader.existsName(dic, PdfName.SUBTYPE, PdfName.TYPE0)) {
                    PdfDictionary desc;
                    String sde;
                    ArrayList list;
                    s = PdfReader.getSubsetPrefix(dic);
                    PdfArray arr = (PdfArray)PdfReader.getPdfObject(dic.get(PdfName.DESCENDANTFONTS));
                    if (arr != null && (list = arr.getArrayList()).size() != 0 && (sde = PdfReader.getSubsetPrefix(desc = (PdfDictionary)PdfReader.getPdfObject((PdfObject)list.get(0)))) != null) {
                        String ns = BaseFont.createSubsetPrefix();
                        if (s != null) {
                            dic.put(PdfName.BASEFONT, new PdfName(String.valueOf(ns) + s.substring(7)));
                        }
                        this.setXrefPartialObject(k2, dic);
                        PdfName newName = new PdfName(String.valueOf(ns) + sde.substring(7));
                        desc.put(PdfName.BASEFONT, newName);
                        ++total;
                        PdfDictionary fd = (PdfDictionary)PdfReader.getPdfObject(desc.get(PdfName.FONTDESCRIPTOR));
                        if (fd != null) {
                            fd.put(PdfName.FONTNAME, newName);
                        }
                    }
                }
            }
            ++k2;
        }
        return total;
    }

    public int createFakeFontSubsets() {
        int total = 0;
        int k2 = 1;
        while (k2 < this.xrefObj.size()) {
            String s;
            PdfDictionary dic;
            PdfObject obj = this.getPdfObjectRelease(k2);
            if (obj != null && obj.isDictionary() && PdfReader.existsName(dic = (PdfDictionary)obj, PdfName.TYPE, PdfName.FONT) && (PdfReader.existsName(dic, PdfName.SUBTYPE, PdfName.TYPE1) || PdfReader.existsName(dic, PdfName.SUBTYPE, PdfName.MMTYPE1) || PdfReader.existsName(dic, PdfName.SUBTYPE, PdfName.TRUETYPE)) && (s = PdfReader.getSubsetPrefix(dic)) == null && (s = PdfReader.getFontName(dic)) != null) {
                String ns = String.valueOf(BaseFont.createSubsetPrefix()) + s;
                PdfDictionary fd = (PdfDictionary)PdfReader.getPdfObjectRelease(dic.get(PdfName.FONTDESCRIPTOR));
                if (fd != null && (fd.get(PdfName.FONTFILE) != null || fd.get(PdfName.FONTFILE2) != null || fd.get(PdfName.FONTFILE3) != null)) {
                    fd = (PdfDictionary)PdfReader.getPdfObject(dic.get(PdfName.FONTDESCRIPTOR));
                    PdfName newName = new PdfName(ns);
                    dic.put(PdfName.BASEFONT, newName);
                    fd.put(PdfName.FONTNAME, newName);
                    this.setXrefPartialObject(k2, dic);
                    ++total;
                }
            }
            ++k2;
        }
        return total;
    }

    private static PdfArray getNameArray(PdfObject obj) {
        PdfObject arr2;
        if (obj == null) {
            return null;
        }
        if ((obj = PdfReader.getPdfObjectRelease(obj)).isArray()) {
            return (PdfArray)obj;
        }
        if (obj.isDictionary() && (arr2 = PdfReader.getPdfObjectRelease(((PdfDictionary)obj).get(PdfName.D))) != null && arr2.isArray()) {
            return (PdfArray)arr2;
        }
        return null;
    }

    public HashMap getNamedDestination() {
        HashMap names = this.getNamedDestinationFromNames();
        names.putAll(this.getNamedDestinationFromStrings());
        return names;
    }

    public HashMap getNamedDestinationFromNames() {
        HashMap<String, PdfArray> names = new HashMap<String, PdfArray>();
        if (this.catalog.get(PdfName.DESTS) != null) {
            PdfDictionary dic = (PdfDictionary)PdfReader.getPdfObjectRelease(this.catalog.get(PdfName.DESTS));
            Set keys = dic.getKeys();
            Iterator it = keys.iterator();
            while (it.hasNext()) {
                PdfName key = (PdfName)it.next();
                String name = PdfName.decodeName(key.toString());
                PdfArray arr = PdfReader.getNameArray(dic.get(key));
                if (arr == null) continue;
                names.put(name, arr);
            }
        }
        return names;
    }

    public HashMap getNamedDestinationFromStrings() {
        if (this.catalog.get(PdfName.NAMES) != null) {
            PdfDictionary dic = (PdfDictionary)PdfReader.getPdfObjectRelease(this.catalog.get(PdfName.NAMES));
            if ((dic = (PdfDictionary)PdfReader.getPdfObjectRelease(dic.get(PdfName.DESTS))) != null) {
                HashMap names = PdfNameTree.readTree(dic);
                Iterator it = names.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    PdfArray arr = PdfReader.getNameArray((PdfObject)entry.getValue());
                    if (arr != null) {
                        entry.setValue(arr);
                        continue;
                    }
                    it.remove();
                }
                return names;
            }
        }
        return new HashMap();
    }

    private boolean replaceNamedDestination(PdfObject obj, HashMap names) {
        obj = PdfReader.getPdfObject(obj);
        int objIdx = this.lastXrefPartial;
        this.releaseLastXrefPartial();
        if (obj != null && obj.isDictionary()) {
            PdfObject ob2 = PdfReader.getPdfObjectRelease(((PdfDictionary)obj).get(PdfName.DEST));
            String name = null;
            if (ob2 != null) {
                if (ob2.isName()) {
                    name = PdfName.decodeName(ob2.toString());
                } else if (ob2.isString()) {
                    name = ob2.toString();
                }
                PdfArray dest = (PdfArray)names.get(name);
                if (dest != null) {
                    ((PdfDictionary)obj).put(PdfName.DEST, dest);
                    this.setXrefPartialObject(objIdx, obj);
                    return true;
                }
            } else {
                ob2 = PdfReader.getPdfObject(((PdfDictionary)obj).get(PdfName.A));
                if (ob2 != null) {
                    int obj2Idx = this.lastXrefPartial;
                    this.releaseLastXrefPartial();
                    PdfDictionary dic = (PdfDictionary)ob2;
                    PdfName type = (PdfName)PdfReader.getPdfObjectRelease(dic.get(PdfName.S));
                    if (PdfName.GOTO.equals(type)) {
                        PdfObject ob3 = PdfReader.getPdfObjectRelease(dic.get(PdfName.D));
                        if (ob3.isName()) {
                            name = PdfName.decodeName(ob3.toString());
                        } else if (ob3.isString()) {
                            name = ob3.toString();
                        }
                        PdfArray dest = (PdfArray)names.get(name);
                        if (dest != null) {
                            dic.put(PdfName.D, dest);
                            this.setXrefPartialObject(obj2Idx, ob2);
                            this.setXrefPartialObject(objIdx, obj);
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    public void removeFields() {
        this.pageRefs.resetReleasePage();
        int k2 = 1;
        while (k2 <= this.pageRefs.size()) {
            PdfDictionary page = this.pageRefs.getPageN(k2);
            PdfArray annots = (PdfArray)PdfReader.getPdfObject(page.get(PdfName.ANNOTS));
            if (annots == null) {
                this.pageRefs.releasePage(k2);
            } else {
                ArrayList arr = annots.getArrayList();
                int startSize = arr.size();
                int j2 = 0;
                while (j2 < arr.size()) {
                    PdfDictionary annot = (PdfDictionary)PdfReader.getPdfObjectRelease((PdfObject)arr.get(j2));
                    if (PdfName.WIDGET.equals(annot.get(PdfName.SUBTYPE))) {
                        arr.remove(j2--);
                    }
                    ++j2;
                }
                if (arr.isEmpty()) {
                    page.remove(PdfName.ANNOTS);
                } else {
                    this.pageRefs.releasePage(k2);
                }
            }
            ++k2;
        }
        this.catalog.remove(PdfName.ACROFORM);
        this.pageRefs.resetReleasePage();
    }

    public void removeAnnotations() {
        this.pageRefs.resetReleasePage();
        int k2 = 1;
        while (k2 <= this.pageRefs.size()) {
            PdfDictionary page = this.pageRefs.getPageN(k2);
            if (page.get(PdfName.ANNOTS) == null) {
                this.pageRefs.releasePage(k2);
            } else {
                page.remove(PdfName.ANNOTS);
            }
            ++k2;
        }
        this.catalog.remove(PdfName.ACROFORM);
        this.pageRefs.resetReleasePage();
    }

    private void iterateBookmarks(PdfObject outlineRef, HashMap names) {
        while (outlineRef != null) {
            this.replaceNamedDestination(outlineRef, names);
            PdfDictionary outline = (PdfDictionary)PdfReader.getPdfObjectRelease(outlineRef);
            PdfObject first = outline.get(PdfName.FIRST);
            if (first != null) {
                this.iterateBookmarks(first, names);
            }
            outlineRef = outline.get(PdfName.NEXT);
        }
    }

    public void consolidateNamedDestinations() {
        if (this.consolidateNamedDestinations) {
            return;
        }
        this.consolidateNamedDestinations = true;
        HashMap names = this.getNamedDestination();
        if (names.size() == 0) {
            return;
        }
        int k2 = 1;
        while (k2 <= this.pageRefs.size()) {
            PdfDictionary page = this.pageRefs.getPageN(k2);
            PdfObject annotsRef = page.get(PdfName.ANNOTS);
            PdfArray annots = (PdfArray)PdfReader.getPdfObject(annotsRef);
            int annotIdx = this.lastXrefPartial;
            this.releaseLastXrefPartial();
            if (annots == null) {
                this.pageRefs.releasePage(k2);
            } else {
                ArrayList list = annots.getArrayList();
                boolean commitAnnots = false;
                int an = 0;
                while (an < list.size()) {
                    PdfObject objRef = (PdfObject)list.get(an);
                    if (this.replaceNamedDestination(objRef, names) && !objRef.isIndirect()) {
                        commitAnnots = true;
                    }
                    ++an;
                }
                if (commitAnnots) {
                    this.setXrefPartialObject(annotIdx, annots);
                }
                if (!commitAnnots || annotsRef.isIndirect()) {
                    this.pageRefs.releasePage(k2);
                }
            }
            ++k2;
        }
        PdfDictionary outlines = (PdfDictionary)PdfReader.getPdfObjectRelease(this.catalog.get(PdfName.OUTLINES));
        if (outlines == null) {
            return;
        }
        this.iterateBookmarks(outlines.get(PdfName.FIRST), names);
    }

    protected static PdfDictionary duplicatePdfDictionary(PdfDictionary original, PdfDictionary copy, PdfReader newReader) {
        if (copy == null) {
            copy = new PdfDictionary();
        }
        Iterator it = original.getKeys().iterator();
        while (it.hasNext()) {
            PdfName key = (PdfName)it.next();
            copy.put(key, PdfReader.duplicatePdfObject(original.get(key), newReader));
        }
        return copy;
    }

    protected static PdfObject duplicatePdfObject(PdfObject original, PdfReader newReader) {
        if (original == null) {
            return null;
        }
        switch (original.type()) {
            case 6: {
                return PdfReader.duplicatePdfDictionary((PdfDictionary)original, null, newReader);
            }
            case 7: {
                PRStream org = (PRStream)original;
                PRStream stream = new PRStream(org, null, newReader);
                PdfReader.duplicatePdfDictionary(org, stream, newReader);
                return stream;
            }
            case 5: {
                ArrayList list = ((PdfArray)original).getArrayList();
                PdfArray arr = new PdfArray();
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    arr.add(PdfReader.duplicatePdfObject((PdfObject)it.next(), newReader));
                }
                return arr;
            }
            case 10: {
                PRIndirectReference org = (PRIndirectReference)original;
                return new PRIndirectReference(newReader, org.getNumber(), org.getGeneration());
            }
        }
        return original;
    }

    public void close() {
        if (!this.partial) {
            return;
        }
        try {
            this.tokens.close();
        }
        catch (IOException e2) {
            throw new ExceptionConverter(e2);
        }
    }

    protected void removeUnusedNode(PdfObject obj, boolean[] hits) {
        if (obj == null) {
            return;
        }
        switch (obj.type()) {
            case 6: 
            case 7: {
                PdfDictionary dic = (PdfDictionary)obj;
                Iterator it = dic.getKeys().iterator();
                while (it.hasNext()) {
                    int num;
                    PdfName key = (PdfName)it.next();
                    PdfObject v = dic.get(key);
                    if (v.isIndirect() && ((num = ((PRIndirectReference)v).getNumber()) >= this.xrefObj.size() || this.xrefObj.get(num) == null)) {
                        dic.put(key, PdfNull.PDFNULL);
                        continue;
                    }
                    this.removeUnusedNode(v, hits);
                }
                break;
            }
            case 5: {
                ArrayList list = ((PdfArray)obj).getArrayList();
                int k2 = 0;
                while (k2 < list.size()) {
                    int num;
                    PdfObject v = (PdfObject)list.get(k2);
                    if (v.isIndirect() && this.xrefObj.get(num = ((PRIndirectReference)v).getNumber()) == null) {
                        list.set(k2, PdfNull.PDFNULL);
                    } else {
                        this.removeUnusedNode(v, hits);
                    }
                    ++k2;
                }
                break;
            }
            case 10: {
                PRIndirectReference ref = (PRIndirectReference)obj;
                int num = ref.getNumber();
                if (hits[num]) break;
                hits[num] = true;
                this.removeUnusedNode(PdfReader.getPdfObjectRelease(ref), hits);
            }
        }
    }

    public int removeUnusedObjects() {
        boolean[] hits = new boolean[this.xrefObj.size()];
        this.removeUnusedNode(this.trailer, hits);
        int total = 0;
        if (this.partial) {
            int k2 = 1;
            while (k2 < hits.length) {
                if (!hits[k2]) {
                    this.xref[k2 * 2] = -1;
                    this.xref[k2 * 2 + 1] = 0;
                    this.xrefObj.set(k2, null);
                    ++total;
                }
                ++k2;
            }
        } else {
            int k3 = 1;
            while (k3 < hits.length) {
                if (!hits[k3]) {
                    this.xrefObj.set(k3, null);
                    ++total;
                }
                ++k3;
            }
        }
        return total;
    }

    public AcroFields getAcroFields() {
        return new AcroFields(this, null);
    }

    public String getJavaScript(RandomAccessFileOrArray file) throws IOException {
        PdfDictionary names = (PdfDictionary)PdfReader.getPdfObjectRelease(this.catalog.get(PdfName.NAMES));
        if (names == null) {
            return null;
        }
        PdfDictionary js = (PdfDictionary)PdfReader.getPdfObjectRelease(names.get(PdfName.JAVASCRIPT));
        if (js == null) {
            return null;
        }
        HashMap jscript = PdfNameTree.readTree(js);
        String[] sortedNames = new String[jscript.size()];
        sortedNames = jscript.keySet().toArray(sortedNames);
        Arrays.sort(sortedNames, new StringCompare());
        StringBuffer buf = new StringBuffer();
        int k2 = 0;
        while (k2 < sortedNames.length) {
            PdfDictionary j2 = (PdfDictionary)PdfReader.getPdfObjectRelease((PdfIndirectReference)jscript.get(sortedNames[k2]));
            if (j2 != null) {
                PdfObject obj = PdfReader.getPdfObjectRelease(j2.get(PdfName.JS));
                if (obj.isString()) {
                    buf.append(((PdfString)obj).toUnicodeString()).append('\n');
                } else if (obj.isStream()) {
                    byte[] bytes = PdfReader.getStreamBytes((PRStream)obj, file);
                    if (bytes.length >= 2 && bytes[0] == -2 && bytes[1] == -1) {
                        buf.append(PdfEncodings.convertToString(bytes, "UnicodeBig"));
                    } else {
                        buf.append(PdfEncodings.convertToString(bytes, "PDF"));
                    }
                    buf.append('\n');
                }
            }
            ++k2;
        }
        return buf.toString();
    }

    public String getJavaScript() throws IOException {
        String string;
        RandomAccessFileOrArray rf = this.getSafeFile();
        try {
            rf.reOpen();
            string = this.getJavaScript(rf);
            Object var2_3 = null;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            try {
                rf.close();
            }
            catch (Exception e2) {}
            throw throwable;
        }
        try {
            rf.close();
        }
        catch (Exception e2) {
            // empty catch block
        }
        return string;
    }

    public void selectPages(String ranges) {
        this.selectPages(SequenceList.expand(ranges, this.getNumberOfPages()));
    }

    public void selectPages(List pagesToKeep) {
        throw new UnsupportedOperationException("Later.");
    }

    public static void setViewerPreferences(int preferences, PdfDictionary catalog) {
        catalog.remove(PdfName.PAGELAYOUT);
        catalog.remove(PdfName.PAGEMODE);
        catalog.remove(PdfName.VIEWERPREFERENCES);
        if ((preferences & 1) != 0) {
            catalog.put(PdfName.PAGELAYOUT, PdfName.SINGLEPAGE);
        } else if ((preferences & 2) != 0) {
            catalog.put(PdfName.PAGELAYOUT, PdfName.ONECOLUMN);
        } else if ((preferences & 4) != 0) {
            catalog.put(PdfName.PAGELAYOUT, PdfName.TWOCOLUMNLEFT);
        } else if ((preferences & 8) != 0) {
            catalog.put(PdfName.PAGELAYOUT, PdfName.TWOCOLUMNRIGHT);
        }
        if ((preferences & 0x10) != 0) {
            catalog.put(PdfName.PAGEMODE, PdfName.USENONE);
        } else if ((preferences & 0x20) != 0) {
            catalog.put(PdfName.PAGEMODE, PdfName.USEOUTLINES);
        } else if ((preferences & 0x40) != 0) {
            catalog.put(PdfName.PAGEMODE, PdfName.USETHUMBS);
        } else if ((preferences & 0x80) != 0) {
            catalog.put(PdfName.PAGEMODE, PdfName.FULLSCREEN);
        } else if ((preferences & 0x100000) != 0) {
            catalog.put(PdfName.PAGEMODE, PdfName.USEOC);
        }
        if ((preferences & 0xFFFF00) == 0) {
            return;
        }
        PdfDictionary vp = new PdfDictionary();
        if ((preferences & 0x100) != 0) {
            vp.put(PdfName.HIDETOOLBAR, PdfBoolean.PDFTRUE);
        }
        if ((preferences & 0x200) != 0) {
            vp.put(PdfName.HIDEMENUBAR, PdfBoolean.PDFTRUE);
        }
        if ((preferences & 0x400) != 0) {
            vp.put(PdfName.HIDEWINDOWUI, PdfBoolean.PDFTRUE);
        }
        if ((preferences & 0x800) != 0) {
            vp.put(PdfName.FITWINDOW, PdfBoolean.PDFTRUE);
        }
        if ((preferences & 0x1000) != 0) {
            vp.put(PdfName.CENTERWINDOW, PdfBoolean.PDFTRUE);
        }
        if ((preferences & 0x40000) != 0) {
            vp.put(PdfName.DISPLAYDOCTITLE, PdfBoolean.PDFTRUE);
        }
        if ((preferences & 0x2000) != 0) {
            vp.put(PdfName.NONFULLSCREENPAGEMODE, PdfName.USENONE);
        } else if ((preferences & 0x4000) != 0) {
            vp.put(PdfName.NONFULLSCREENPAGEMODE, PdfName.USEOUTLINES);
        } else if ((preferences & 0x8000) != 0) {
            vp.put(PdfName.NONFULLSCREENPAGEMODE, PdfName.USETHUMBS);
        } else if ((preferences & 0x80000) != 0) {
            vp.put(PdfName.NONFULLSCREENPAGEMODE, PdfName.USEOC);
        }
        if ((preferences & 0x10000) != 0) {
            vp.put(PdfName.DIRECTION, PdfName.L2R);
        } else if ((preferences & 0x20000) != 0) {
            vp.put(PdfName.DIRECTION, PdfName.R2L);
        }
        if ((preferences & 0x100000) != 0) {
            vp.put(PdfName.PRINTSCALING, PdfName.NONE);
        }
        catalog.put(PdfName.VIEWERPREFERENCES, vp);
    }

    public void setViewerPreferences(int preferences) {
        PdfReader.setViewerPreferences(preferences, this.catalog);
    }

    public int getViewerPreferences() {
        int prefs = 0;
        PdfName name = null;
        PdfObject obj = PdfReader.getPdfObjectRelease(this.catalog.get(PdfName.PAGELAYOUT));
        if (obj != null && obj.isName()) {
            name = (PdfName)obj;
            if (name.equals(PdfName.SINGLEPAGE)) {
                prefs |= 1;
            } else if (name.equals(PdfName.ONECOLUMN)) {
                prefs |= 2;
            } else if (name.equals(PdfName.TWOCOLUMNLEFT)) {
                prefs |= 4;
            } else if (name.equals(PdfName.TWOCOLUMNRIGHT)) {
                prefs |= 8;
            }
        }
        if ((obj = PdfReader.getPdfObjectRelease(this.catalog.get(PdfName.PAGEMODE))) != null && obj.isName()) {
            name = (PdfName)obj;
            if (name.equals(PdfName.USENONE)) {
                prefs |= 0x10;
            } else if (name.equals(PdfName.USEOUTLINES)) {
                prefs |= 0x20;
            } else if (name.equals(PdfName.USETHUMBS)) {
                prefs |= 0x40;
            } else if (name.equals(PdfName.USEOC)) {
                prefs |= 0x100000;
            }
        }
        if ((obj = PdfReader.getPdfObjectRelease(this.catalog.get(PdfName.VIEWERPREFERENCES))) == null || !obj.isDictionary()) {
            return prefs;
        }
        PdfDictionary vp = (PdfDictionary)obj;
        int k2 = 0;
        while (k2 < vpnames.length) {
            obj = PdfReader.getPdfObject(vp.get(vpnames[k2]));
            if (obj != null && "true".equals(obj.toString())) {
                prefs |= vpints[k2];
            }
            ++k2;
        }
        obj = PdfReader.getPdfObjectRelease(vp.get(PdfName.PRINTSCALING));
        if (PdfName.NONE.equals(obj)) {
            prefs |= 0x100000;
        }
        if ((obj = PdfReader.getPdfObjectRelease(vp.get(PdfName.NONFULLSCREENPAGEMODE))) != null && obj.isName()) {
            name = (PdfName)obj;
            if (name.equals(PdfName.USENONE)) {
                prefs |= 0x2000;
            } else if (name.equals(PdfName.USEOUTLINES)) {
                prefs |= 0x4000;
            } else if (name.equals(PdfName.USETHUMBS)) {
                prefs |= 0x8000;
            } else if (name.equals(PdfName.USEOC)) {
                prefs |= 0x80000;
            }
        }
        if ((obj = PdfReader.getPdfObjectRelease(vp.get(PdfName.DIRECTION))) != null && obj.isName()) {
            name = (PdfName)obj;
            if (name.equals(PdfName.L2R)) {
                prefs |= 0x10000;
            } else if (name.equals(PdfName.R2L)) {
                prefs |= 0x20000;
            }
        }
        return prefs;
    }

    public boolean isAppendable() {
        return this.appendable;
    }

    public void setAppendable(boolean appendable) {
        this.appendable = appendable;
        if (appendable) {
            PdfReader.getPdfObject(this.trailer.get(PdfName.ROOT));
        }
    }

    public boolean isNewXrefType() {
        return this.newXrefType;
    }

    public int getFileLength() {
        return this.fileLength;
    }

    public boolean isHybridXref() {
        return this.hybridXref;
    }

    static class PageRefs {
        private PdfReader reader;
        private IntHashtable refsp;
        private ArrayList refsn;
        private ArrayList pageInh;
        private int lastPageRead = -1;
        private int sizep;

        private PageRefs(PdfReader reader) throws IOException {
            this.reader = reader;
            if (reader.partial) {
                this.refsp = new IntHashtable();
                PdfNumber npages = (PdfNumber)PdfReader.getPdfObjectRelease(reader.rootPages.get(PdfName.COUNT));
                this.sizep = npages.intValue();
            } else {
                this.readPages();
            }
        }

        PageRefs(PageRefs other, PdfReader reader) {
            this.reader = reader;
            this.sizep = other.sizep;
            if (this.refsn != null) {
                this.refsn = new ArrayList(other.refsn);
                int k2 = 0;
                while (k2 < this.refsn.size()) {
                    this.refsn.set(k2, PdfReader.duplicatePdfObject((PdfObject)this.refsn.get(k2), reader));
                    ++k2;
                }
            } else {
                this.refsp = (IntHashtable)other.refsp.clone();
            }
        }

        int size() {
            if (this.refsn != null) {
                return this.refsn.size();
            }
            return this.sizep;
        }

        void readPages() throws IOException {
            if (this.refsn != null) {
                return;
            }
            this.refsp = null;
            this.refsn = new ArrayList();
            this.pageInh = new ArrayList();
            this.iteratePages((PRIndirectReference)this.reader.catalog.get(PdfName.PAGES));
            this.pageInh = null;
            this.reader.rootPages.put(PdfName.COUNT, new PdfNumber(this.refsn.size()));
        }

        void reReadPages() throws IOException {
            this.refsn = null;
            this.readPages();
        }

        public PdfDictionary getPageN(int pageNum) {
            PRIndirectReference ref = this.getPageOrigRef(pageNum);
            return (PdfDictionary)PdfReader.getPdfObject(ref);
        }

        public PdfDictionary getPageNRelease(int pageNum) {
            PdfDictionary page = this.getPageN(pageNum);
            this.releasePage(pageNum);
            return page;
        }

        public PRIndirectReference getPageOrigRefRelease(int pageNum) {
            PRIndirectReference ref = this.getPageOrigRef(pageNum);
            this.releasePage(pageNum);
            return ref;
        }

        public PRIndirectReference getPageOrigRef(int pageNum) {
            try {
                if (--pageNum < 0 || pageNum >= this.size()) {
                    return null;
                }
                if (this.refsn != null) {
                    return (PRIndirectReference)this.refsn.get(pageNum);
                }
                int n2 = this.refsp.get(pageNum);
                if (n2 == 0) {
                    PRIndirectReference ref = this.getSinglePage(pageNum);
                    this.lastPageRead = this.reader.lastXrefPartial == -1 ? -1 : pageNum;
                    this.reader.lastXrefPartial = -1;
                    this.refsp.put(pageNum, ref.getNumber());
                    return ref;
                }
                if (this.lastPageRead != pageNum) {
                    this.lastPageRead = -1;
                }
                return new PRIndirectReference(this.reader, n2);
            }
            catch (Exception e2) {
                throw new ExceptionConverter(e2);
            }
        }

        public void releasePage(int pageNum) {
            if (this.refsp == null) {
                return;
            }
            if (--pageNum < 0 || pageNum >= this.size()) {
                return;
            }
            if (pageNum != this.lastPageRead) {
                return;
            }
            this.lastPageRead = -1;
            this.reader.lastXrefPartial = this.refsp.get(pageNum);
            this.reader.releaseLastXrefPartial();
            this.refsp.remove(pageNum);
        }

        public void resetReleasePage() {
            if (this.refsp == null) {
                return;
            }
            this.lastPageRead = -1;
        }

        void insertPage(int pageNum, PRIndirectReference ref) {
            --pageNum;
            if (this.refsn != null) {
                if (pageNum >= this.refsn.size()) {
                    this.refsn.add(ref);
                } else {
                    this.refsn.add(pageNum, ref);
                }
            } else {
                ++this.sizep;
                this.lastPageRead = -1;
                if (pageNum >= this.size()) {
                    this.refsp.put(this.size(), ref.getNumber());
                } else {
                    IntHashtable refs2 = new IntHashtable((this.refsp.size() + 1) * 2);
                    Iterator it = this.refsp.getEntryIterator();
                    while (it.hasNext()) {
                        IntHashtable.IntHashtableEntry entry = (IntHashtable.IntHashtableEntry)it.next();
                        int p = entry.getKey();
                        refs2.put(p >= pageNum ? p + 1 : p, entry.getValue());
                    }
                    refs2.put(pageNum, ref.getNumber());
                    this.refsp = refs2;
                }
            }
        }

        private void pushPageAttributes(PdfDictionary nodePages) {
            PdfDictionary dic = new PdfDictionary();
            if (this.pageInh.size() != 0) {
                dic.putAll((PdfDictionary)this.pageInh.get(this.pageInh.size() - 1));
            }
            int k2 = 0;
            while (k2 < pageInhCandidates.length) {
                PdfObject obj = nodePages.get(pageInhCandidates[k2]);
                if (obj != null) {
                    dic.put(pageInhCandidates[k2], obj);
                }
                ++k2;
            }
            this.pageInh.add(dic);
        }

        private void popPageAttributes() {
            this.pageInh.remove(this.pageInh.size() - 1);
        }

        private void iteratePages(PRIndirectReference rpage) throws IOException {
            PdfDictionary page = (PdfDictionary)PdfReader.getPdfObject(rpage);
            PdfArray kidsPR = (PdfArray)PdfReader.getPdfObject(page.get(PdfName.KIDS));
            if (kidsPR == null) {
                page.put(PdfName.TYPE, PdfName.PAGE);
                PdfDictionary dic = (PdfDictionary)this.pageInh.get(this.pageInh.size() - 1);
                Iterator i2 = dic.getKeys().iterator();
                while (i2.hasNext()) {
                    PdfName key = (PdfName)i2.next();
                    if (page.get(key) != null) continue;
                    page.put(key, dic.get(key));
                }
                if (page.get(PdfName.MEDIABOX) == null) {
                    PdfArray arr = new PdfArray(new float[]{0.0f, 0.0f, PageSize.LETTER.right(), PageSize.LETTER.top()});
                    page.put(PdfName.MEDIABOX, arr);
                }
                this.refsn.add(rpage);
            } else {
                page.put(PdfName.TYPE, PdfName.PAGES);
                this.pushPageAttributes(page);
                ArrayList kids = kidsPR.getArrayList();
                int k2 = 0;
                while (k2 < kids.size()) {
                    this.iteratePages((PRIndirectReference)kids.get(k2));
                    ++k2;
                }
                this.popPageAttributes();
            }
        }

        protected PRIndirectReference getSinglePage(int n2) throws IOException {
            PdfDictionary acc = new PdfDictionary();
            PdfDictionary top = this.reader.rootPages;
            int base = 0;
            block0: while (true) {
                int k2 = 0;
                while (k2 < pageInhCandidates.length) {
                    PdfObject obj = top.get(pageInhCandidates[k2]);
                    if (obj != null) {
                        acc.put(pageInhCandidates[k2], obj);
                    }
                    ++k2;
                }
                PdfArray kids = (PdfArray)PdfReader.getPdfObjectRelease(top.get(PdfName.KIDS));
                ListIterator it = kids.listIterator();
                while (true) {
                    if (!it.hasNext()) continue block0;
                    PRIndirectReference ref = (PRIndirectReference)it.next();
                    PdfDictionary dic = (PdfDictionary)PdfReader.getPdfObject(ref);
                    int last = this.reader.lastXrefPartial;
                    PdfObject count = PdfReader.getPdfObjectRelease(dic.get(PdfName.COUNT));
                    this.reader.lastXrefPartial = last;
                    int acn = 1;
                    if (count != null && count.type() == 2) {
                        acn = ((PdfNumber)count).intValue();
                    }
                    if (n2 < base + acn) {
                        if (count == null) {
                            dic.mergeDifferent(acc);
                            return ref;
                        }
                        this.reader.releaseLastXrefPartial();
                        top = dic;
                        continue block0;
                    }
                    this.reader.releaseLastXrefPartial();
                    base += acn;
                }
                break;
            }
        }
    }
}

