/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf;

import com.lowagie.text.Anchor;
import com.lowagie.text.Annotation;
import com.lowagie.text.Chapter;
import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Image;
import com.lowagie.text.List;
import com.lowagie.text.ListItem;
import com.lowagie.text.Meta;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Section;
import com.lowagie.text.SimpleTable;
import com.lowagie.text.Table;
import com.lowagie.text.rtf.RtfBasicElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.document.RtfInfoElement;
import com.lowagie.text.rtf.field.RtfAnchor;
import com.lowagie.text.rtf.graphic.RtfImage;
import com.lowagie.text.rtf.list.RtfList;
import com.lowagie.text.rtf.list.RtfListItem;
import com.lowagie.text.rtf.table.RtfTable;
import com.lowagie.text.rtf.text.RtfAnnotation;
import com.lowagie.text.rtf.text.RtfChapter;
import com.lowagie.text.rtf.text.RtfChunk;
import com.lowagie.text.rtf.text.RtfNewPage;
import com.lowagie.text.rtf.text.RtfParagraph;
import com.lowagie.text.rtf.text.RtfPhrase;
import com.lowagie.text.rtf.text.RtfSection;

public class RtfMapper {
    RtfDocument rtfDoc;

    public RtfMapper(RtfDocument doc) {
        this.rtfDoc = doc;
    }

    public RtfBasicElement mapElement(Element element) throws DocumentException {
        RtfBasicElement rtfElement = null;
        if (element instanceof RtfBasicElement) {
            rtfElement = (RtfBasicElement)((Object)element);
            rtfElement.setRtfDocument(this.rtfDoc);
            return rtfElement;
        }
        switch (element.type()) {
            case 10: {
                if (((Chunk)element).getImage() != null) {
                    rtfElement = new RtfImage(this.rtfDoc, ((Chunk)element).getImage());
                    break;
                }
                if (((Chunk)element).hasAttributes() && ((Chunk)element).getAttributes().containsKey("NEWPAGE")) {
                    rtfElement = new RtfNewPage(this.rtfDoc);
                    break;
                }
                rtfElement = new RtfChunk(this.rtfDoc, (Chunk)element);
                break;
            }
            case 11: {
                rtfElement = new RtfPhrase(this.rtfDoc, (Phrase)element);
                break;
            }
            case 12: {
                rtfElement = new RtfParagraph(this.rtfDoc, (Paragraph)element);
                break;
            }
            case 17: {
                rtfElement = new RtfAnchor(this.rtfDoc, (Anchor)element);
                break;
            }
            case 29: {
                rtfElement = new RtfAnnotation(this.rtfDoc, (Annotation)element);
                break;
            }
            case 32: 
            case 34: 
            case 35: {
                rtfElement = new RtfImage(this.rtfDoc, (Image)element);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                rtfElement = new RtfInfoElement(this.rtfDoc, (Meta)element);
                break;
            }
            case 14: {
                rtfElement = new RtfList(this.rtfDoc, (List)element);
                break;
            }
            case 15: {
                rtfElement = new RtfListItem(this.rtfDoc, (ListItem)element);
                break;
            }
            case 13: {
                rtfElement = new RtfSection(this.rtfDoc, (Section)element);
                break;
            }
            case 16: {
                rtfElement = new RtfChapter(this.rtfDoc, (Chapter)element);
                break;
            }
            case 22: {
                try {
                    rtfElement = new RtfTable(this.rtfDoc, (Table)element);
                    break;
                }
                catch (ClassCastException e2) {
                    rtfElement = new RtfTable(this.rtfDoc, ((SimpleTable)element).createTable());
                }
            }
        }
        return rtfElement;
    }
}

