/*
 * Decompiled with CFR 0.152.
 */
package grandchef.server;

import grandchef.server.GrandChefServer;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import org.json.JSONObject;

public class UpdateChecker {
    private static final String JSON_URL = "https://files.procomm.ro/gcmobile/server.json";

    public UpdateChecker(String version) throws Exception {
        String json = UpdateChecker.fetchJSON();
        String latestVersion = UpdateChecker.getLatestVersion(json);
        String jarUrl = UpdateChecker.getJarUrl(json);
        if (UpdateChecker.isNewVersion(latestVersion, version)) {
            System.out.println("New Version : " + latestVersion);
            UpdateChecker.downloadNewJar(jarUrl);
            UpdateChecker.executeNewJar("server.jar");
        }
    }

    public static String fetchJSON() throws Exception {
        String inputLine;
        URL url = new URL(JSON_URL);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        StringBuilder content = new StringBuilder();
        while ((inputLine = in.readLine()) != null) {
            content.append(inputLine);
        }
        in.close();
        conn.disconnect();
        return content.toString();
    }

    public static String getLatestVersion(String json) {
        JSONObject jsonObject = new JSONObject(json);
        return jsonObject.getString("version");
    }

    public static String getJarUrl(String json) {
        JSONObject jsonObject = new JSONObject(json);
        return jsonObject.getString("jar_url");
    }

    public static boolean isNewVersion(String latestVersion, String currentVersion) {
        return latestVersion.compareTo(currentVersion) > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadNewJar(String jarUrl) throws Exception {
        BufferedInputStream in = null;
        FileOutputStream fout = null;
        try {
            int count;
            in = new BufferedInputStream(new URL(jarUrl).openStream());
            fout = new FileOutputStream("updated.jar");
            byte[] data = new byte[1024];
            System.out.print("Downloading ... : ");
            while ((count = in.read(data, 0, 1024)) != -1) {
                fout.write(data, 0, count);
                System.out.print("#");
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (fout != null) {
                fout.close();
            }
        }
        System.out.println("\nDownloaded Complete!");
    }

    public static void executeNewJar(String jarFilePath) throws IOException, URISyntaxException {
        System.out.println("Preparing to execute new version!");
        File jarDir = new File(GrandChefServer.class.getProtectionDomain().getCodeSource().getLocation().toURI()).getParentFile();
        ProcessBuilder processBuilder = new ProcessBuilder("cmd.exe", "/c", "start", "update.bat");
        processBuilder.directory(jarDir);
        processBuilder.inheritIO();
        Process process = processBuilder.start();
        try {
            process.waitFor();
        }
        catch (InterruptedException e2) {
            e2.printStackTrace();
        }
        System.exit(0);
    }
}

