/*
 * Decompiled with CFR 0.152.
 */
package groovy.lang;

import groovy.lang.GroovyObjectSupport;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.MetaClass;
import groovy.lang.MissingPropertyException;
import groovy.lang.Writable;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.codehaus.groovy.reflection.CachedMethod;
import org.codehaus.groovy.reflection.ReflectionCache;
import org.codehaus.groovy.runtime.CurriedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;

public abstract class Closure
extends GroovyObjectSupport
implements Cloneable,
Runnable {
    public static final int OWNER_FIRST = 0;
    public static final int DELEGATE_FIRST = 1;
    public static final int OWNER_ONLY = 2;
    public static final int DELEGATE_ONLY = 3;
    public static final int TO_SELF = 4;
    private Object delegate;
    private final Object owner;
    protected Class[] parameterTypes;
    protected int maximumNumberOfParameters;
    private final Object thisObject;
    private int resolveStrategy = 0;
    private int directive;
    public static final int DONE = 1;
    public static final int SKIP = 2;
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];

    public Closure(Object owner, Object thisObject) {
        this.owner = owner;
        this.delegate = owner;
        this.thisObject = thisObject;
        Class<?> clazz = this.getClass();
        CachedMethod[] methods = ReflectionCache.getCachedClass(clazz).getMethods();
        this.maximumNumberOfParameters = -1;
        for (int j2 = 0; j2 < methods.length; ++j2) {
            Class[] pt;
            if (!"doCall".equals(methods[j2].getName()) || (pt = methods[j2].getNativeParameterTypes()).length <= this.maximumNumberOfParameters) continue;
            this.parameterTypes = pt;
            this.maximumNumberOfParameters = this.parameterTypes.length;
        }
        this.maximumNumberOfParameters = Math.max(this.maximumNumberOfParameters, 0);
    }

    public Closure(Object owner) {
        this(owner, null);
    }

    public void setResolveStrategy(int resolveStrategy) {
        this.resolveStrategy = resolveStrategy;
    }

    public int getResolveStrategy() {
        return this.resolveStrategy;
    }

    public Object getThisObject() {
        return this.thisObject;
    }

    public Object getProperty(String property) {
        if ("delegate".equals(property)) {
            return this.getDelegate();
        }
        if ("owner".equals(property)) {
            return this.getOwner();
        }
        if ("maximumNumberOfParameters".equals(property)) {
            return new Integer(this.getMaximumNumberOfParameters());
        }
        if ("parameterTypes".equals(property)) {
            return this.getParameterTypes();
        }
        if ("metaClass".equals(property)) {
            return this.getMetaClass();
        }
        if ("class".equals(property)) {
            return this.getClass();
        }
        if ("directive".equals(property)) {
            return new Integer(this.getDirective());
        }
        switch (this.resolveStrategy) {
            case 1: {
                return this.getPropertyDelegateFirst(property);
            }
            case 3: {
                return InvokerHelper.getProperty(this.delegate, property);
            }
            case 2: {
                return InvokerHelper.getProperty(this.owner, property);
            }
            case 4: {
                return super.getProperty(property);
            }
        }
        return this.getPropertyOwnerFirst(property);
    }

    private Object getPropertyDelegateFirst(String property) {
        if (this.delegate == null) {
            return this.getPropertyOwnerFirst(property);
        }
        return this.getPropertyTryThese(property, this.delegate, this.owner);
    }

    private Object getPropertyTryThese(String property, Object firstTry, Object secondTry) {
        try {
            return InvokerHelper.getProperty(firstTry, property);
        }
        catch (MissingPropertyException e1) {
            if (secondTry != null && firstTry != this && firstTry != secondTry) {
                try {
                    return InvokerHelper.getProperty(secondTry, property);
                }
                catch (GroovyRuntimeException e2) {
                    // empty catch block
                }
            }
            throw e1;
        }
    }

    private Object getPropertyOwnerFirst(String property) {
        return this.getPropertyTryThese(property, this.owner, this.delegate);
    }

    public void setProperty(String property, Object newValue) {
        if ("delegate".equals(property)) {
            this.setDelegate(newValue);
        } else if ("metaClass".equals(property)) {
            this.setMetaClass((MetaClass)newValue);
        } else if ("resolveStrategy".equals(property)) {
            this.setResolveStrategy(((Number)newValue).intValue());
        } else {
            switch (this.resolveStrategy) {
                case 1: {
                    this.setPropertyDelegateFirst(property, newValue);
                    break;
                }
                case 3: {
                    InvokerHelper.setProperty(this.delegate, property, newValue);
                    break;
                }
                case 2: {
                    InvokerHelper.setProperty(this.owner, property, newValue);
                    break;
                }
                case 4: {
                    super.setProperty(property, newValue);
                    break;
                }
                default: {
                    this.setPropertyOwnerFirst(property, newValue);
                }
            }
        }
    }

    private void setPropertyDelegateFirst(String property, Object newValue) {
        if (this.delegate == null) {
            this.setPropertyOwnerFirst(property, newValue);
        } else {
            this.setPropertyTryThese(property, newValue, this.delegate, this.owner);
        }
    }

    private void setPropertyTryThese(String property, Object newValue, Object firstTry, Object secondTry) {
        try {
            InvokerHelper.setProperty(firstTry, property, newValue);
        }
        catch (GroovyRuntimeException e1) {
            if (firstTry != null && firstTry != this && firstTry != secondTry) {
                try {
                    InvokerHelper.setProperty(secondTry, property, newValue);
                    return;
                }
                catch (GroovyRuntimeException e2) {
                    // empty catch block
                }
            }
            throw e1;
        }
    }

    private void setPropertyOwnerFirst(String property, Object newValue) {
        this.setPropertyTryThese(property, newValue, this.owner, this.delegate);
    }

    public boolean isCase(Object candidate) {
        return DefaultTypeTransformation.castToBoolean(this.call(candidate));
    }

    public Object call() {
        Object[] NOARGS = EMPTY_OBJECT_ARRAY;
        return this.call(NOARGS);
    }

    public Object call(Object[] args) {
        try {
            return this.getMetaClass().invokeMethod((Object)this, "doCall", args);
        }
        catch (Exception e2) {
            return Closure.throwRuntimeException(e2);
        }
    }

    public Object call(Object arguments) {
        return this.call(new Object[]{arguments});
    }

    protected static Object throwRuntimeException(Throwable throwable) {
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        throw new GroovyRuntimeException(throwable.getMessage(), throwable);
    }

    public Object getOwner() {
        return this.owner;
    }

    public Object getDelegate() {
        return this.delegate;
    }

    public void setDelegate(Object delegate) {
        this.delegate = delegate;
    }

    public Class[] getParameterTypes() {
        return this.parameterTypes;
    }

    public int getMaximumNumberOfParameters() {
        return this.maximumNumberOfParameters;
    }

    public Closure asWritable() {
        return new WritableClosure();
    }

    public void run() {
        this.call();
    }

    public Closure curry(Object[] arguments) {
        return new CurriedClosure(this, arguments);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e2) {
            return null;
        }
    }

    public int getDirective() {
        return this.directive;
    }

    public void setDirective(int directive) {
        this.directive = directive;
    }

    private class WritableClosure
    extends Closure
    implements Writable {
        public WritableClosure() {
            super(Closure.this);
        }

        public Writer writeTo(Writer out) throws IOException {
            Closure.this.call(new Object[]{out});
            return out;
        }

        public Object invokeMethod(String method, Object arguments) {
            if ("clone".equals(method)) {
                return this.clone();
            }
            if ("curry".equals(method)) {
                return this.curry((Object[])arguments);
            }
            if ("asWritable".equals(method)) {
                return this.asWritable();
            }
            return Closure.this.invokeMethod(method, arguments);
        }

        public Object getProperty(String property) {
            return Closure.this.getProperty(property);
        }

        public void setProperty(String property, Object newValue) {
            Closure.this.setProperty(property, newValue);
        }

        public Object call() {
            return ((Closure)this.getOwner()).call();
        }

        public Object call(Object arguments) {
            return ((Closure)this.getOwner()).call(arguments);
        }

        public Object call(Object[] args) {
            return ((Closure)this.getOwner()).call(args);
        }

        public Object doCall(Object[] args) {
            return this.call(args);
        }

        public Object getDelegate() {
            return Closure.this.getDelegate();
        }

        public void setDelegate(Object delegate) {
            Closure.this.setDelegate(delegate);
        }

        public Class[] getParameterTypes() {
            return Closure.this.getParameterTypes();
        }

        public int getMaximumNumberOfParameters() {
            return Closure.this.getMaximumNumberOfParameters();
        }

        public Closure asWritable() {
            return this;
        }

        public void run() {
            Closure.this.run();
        }

        public Object clone() {
            return ((Closure)Closure.this.clone()).asWritable();
        }

        public int hashCode() {
            return Closure.this.hashCode();
        }

        public boolean equals(Object arg0) {
            return Closure.this.equals(arg0);
        }

        public String toString() {
            StringWriter writer = new StringWriter();
            try {
                this.writeTo(writer);
            }
            catch (IOException e2) {
                return null;
            }
            return writer.toString();
        }

        public Closure curry(Object[] arguments) {
            return new CurriedClosure((Closure)this, arguments).asWritable();
        }

        public void setResolveStrategy(int resolveStrategy) {
            Closure.this.setResolveStrategy(resolveStrategy);
        }

        public int getResolveStrategy() {
            return Closure.this.getResolveStrategy();
        }
    }
}

