/*
 * Decompiled with CFR 0.152.
 */
package groovy.lang;

import groovy.lang.ExpandoMetaClass;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import groovy.lang.MetaClassRegistry;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.runtime.metaclass.ConcurrentReaderHashMap;

public class ExpandoMetaClassCreationHandle
extends MetaClassRegistry.MetaClassCreationHandle {
    public static final ExpandoMetaClassCreationHandle instance = new ExpandoMetaClassCreationHandle();
    private final Map modifiedExpandos = new ConcurrentReaderHashMap();

    protected MetaClass createNormalMetaClass(Class theClass, MetaClassRegistry registry) {
        if (theClass != ExpandoMetaClass.class) {
            ExpandoMetaClass emc = new ExpandoMetaClass(theClass, false, true);
            Set modifiedSuperExpandos = this.retrieveModifiedSuperExpandos(emc);
            emc.refreshInheritedMethods(modifiedSuperExpandos);
            return emc;
        }
        return super.create(theClass, registry);
    }

    private Set retrieveModifiedSuperExpandos(ExpandoMetaClass child) {
        HashSet modifiedSupers = new HashSet();
        LinkedList superClasses = child.getSuperClasses();
        Iterator i2 = superClasses.iterator();
        while (i2.hasNext()) {
            Class c2 = (Class)i2.next();
            Class[] interfaces = c2.getInterfaces();
            this.populateSupersFromInterfaces(modifiedSupers, interfaces);
            if (!this.modifiedExpandos.containsKey(c2)) continue;
            modifiedSupers.add(this.modifiedExpandos.get(c2));
        }
        Class[] interfaces = child.getJavaClass().getInterfaces();
        this.populateSupersFromInterfaces(modifiedSupers, interfaces);
        return modifiedSupers;
    }

    private void populateSupersFromInterfaces(Set modifiedSupers, Class[] interfaces) {
        for (int i2 = 0; i2 < interfaces.length; ++i2) {
            Class anInterface = interfaces[i2];
            Class[] superInterfaces = anInterface.getInterfaces();
            if (this.modifiedExpandos.containsKey(anInterface)) {
                modifiedSupers.add(this.modifiedExpandos.get(anInterface));
            }
            if (superInterfaces.length <= 0) continue;
            this.populateSupersFromInterfaces(modifiedSupers, superInterfaces);
        }
    }

    public void registerModifiedMetaClass(ExpandoMetaClass emc) {
        this.modifiedExpandos.put(emc.getJavaClass(), emc);
    }

    public boolean hasModifiedMetaClass(ExpandoMetaClass emc) {
        return this.modifiedExpandos.containsKey(emc.getJavaClass());
    }

    public static void enable() {
        MetaClassRegistry metaClassRegistry = GroovySystem.getMetaClassRegistry();
        if (metaClassRegistry.getMetaClassCreationHandler() != instance) {
            ExpandoMetaClassCreationHandle.instance.modifiedExpandos.clear();
            metaClassRegistry.setMetaClassCreationHandle(instance);
        }
    }

    public static void disable() {
        MetaClassRegistry metaClassRegistry = GroovySystem.getMetaClassRegistry();
        if (metaClassRegistry.getMetaClassCreationHandler() == instance) {
            ExpandoMetaClassCreationHandle.instance.modifiedExpandos.clear();
            metaClassRegistry.setMetaClassCreationHandle(new MetaClassRegistry.MetaClassCreationHandle());
        }
    }
}

