/*
 * Decompiled with CFR 0.152.
 */
package groovy.ui;

import groovy.ui.text.GroovyFilter;
import groovy.ui.text.StructuredSyntaxResources;
import groovy.ui.text.TextEditor;
import groovy.ui.text.TextUndoManager;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.DefaultStyledDocument;

public class ConsoleTextEditor
extends JScrollPane {
    private static final PrinterJob PRINTER_JOB = PrinterJob.getPrinterJob();
    private TextEditor textEditor = new TextEditor(true, true, true);
    private UndoAction undoAction = new UndoAction();
    private RedoAction redoAction = new RedoAction();
    private PrintAction printAction = new PrintAction();
    private boolean editable = true;
    private File textFile;
    private TextUndoManager undoManager;

    public ConsoleTextEditor() {
        this.textEditor.setFont(StructuredSyntaxResources.EDITOR_FONT);
        this.setWheelScrollingEnabled(true);
        this.setViewportView(this.textEditor);
        this.textEditor.setDragEnabled(this.editable);
        this.initActions();
        DefaultStyledDocument doc = new DefaultStyledDocument();
        doc.setDocumentFilter(new GroovyFilter(doc));
        this.textEditor.setDocument(doc);
        this.undoManager = new TextUndoManager();
        doc.addUndoableEditListener(this.undoManager);
        this.undoManager.addPropertyChangeListener(this.undoAction);
        this.undoManager.addPropertyChangeListener(this.redoAction);
        doc.addDocumentListener(this.undoAction);
        doc.addDocumentListener(this.redoAction);
        InputMap im = this.textEditor.getInputMap(2);
        KeyStroke ks = KeyStroke.getKeyStroke(90, 2, false);
        im.put(ks, "Undo");
        ActionMap am = this.textEditor.getActionMap();
        am.put("Undo", this.undoAction);
        ks = KeyStroke.getKeyStroke(89, 2, false);
        im.put(ks, "Redo");
        am.put("Redo", this.redoAction);
        ks = KeyStroke.getKeyStroke(80, 2, false);
        im.put(ks, "Print");
        am.put("Print", this.printAction);
    }

    public boolean clipBoardAvailable() {
        Transferable t = StructuredSyntaxResources.SYSTEM_CLIPBOARD.getContents(this);
        return t.isDataFlavorSupported(DataFlavor.stringFlavor);
    }

    public TextEditor getTextEditor() {
        return this.textEditor;
    }

    protected void initActions() {
        ActionMap map = this.getActionMap();
        PrintAction printAction = new PrintAction();
        map.put("Print", printAction);
    }

    public Action getUndoAction() {
        return this.undoAction;
    }

    public Action getRedoAction() {
        return this.redoAction;
    }

    public Action getPrintAction() {
        return this.printAction;
    }

    private class UndoAction
    extends UpdateCaretListener
    implements PropertyChangeListener {
        public UndoAction() {
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent ae) {
            ConsoleTextEditor.this.undoManager.undo();
            this.setEnabled(ConsoleTextEditor.this.undoManager.canUndo());
            ConsoleTextEditor.this.redoAction.setEnabled(ConsoleTextEditor.this.undoManager.canRedo());
            super.actionPerformed(ae);
        }

        public void propertyChange(PropertyChangeEvent pce) {
            this.setEnabled(ConsoleTextEditor.this.undoManager.canUndo());
        }
    }

    private abstract class UpdateCaretListener
    extends AbstractAction
    implements DocumentListener {
        protected int lastUpdate;

        private UpdateCaretListener() {
        }

        public void changedUpdate(DocumentEvent de) {
        }

        public void insertUpdate(DocumentEvent de) {
            this.lastUpdate = de.getOffset() + de.getLength();
        }

        public void removeUpdate(DocumentEvent de) {
            this.lastUpdate = de.getOffset();
        }

        public void actionPerformed(ActionEvent ae) {
            ConsoleTextEditor.this.textEditor.setCaretPosition(this.lastUpdate);
        }
    }

    private class RedoAction
    extends UpdateCaretListener
    implements PropertyChangeListener {
        public RedoAction() {
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent ae) {
            ConsoleTextEditor.this.undoManager.redo();
            this.setEnabled(ConsoleTextEditor.this.undoManager.canRedo());
            ConsoleTextEditor.this.undoAction.setEnabled(ConsoleTextEditor.this.undoManager.canUndo());
            super.actionPerformed(ae);
        }

        public void propertyChange(PropertyChangeEvent pce) {
            this.setEnabled(ConsoleTextEditor.this.undoManager.canRedo());
        }
    }

    private class PrintAction
    extends AbstractAction {
        public PrintAction() {
            this.setEnabled(true);
        }

        public void actionPerformed(ActionEvent ae) {
            PRINTER_JOB.setPageable(ConsoleTextEditor.this.textEditor);
            try {
                if (PRINTER_JOB.printDialog()) {
                    PRINTER_JOB.print();
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
    }
}

