/*
 * Decompiled with CFR 0.152.
 */
package groovy.util;

import groovy.lang.GroovyObjectSupport;
import groovy.lang.GroovyRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.management.Attribute;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

public class GroovyMBean
extends GroovyObjectSupport {
    private final MBeanServerConnection server;
    private final ObjectName name;
    private MBeanInfo beanInfo;
    private final boolean ignoreErrors;
    private final Map operations = new HashMap();

    public GroovyMBean(MBeanServerConnection server, String objectName) throws JMException, IOException {
        this(server, objectName, false);
    }

    public GroovyMBean(MBeanServerConnection server, String objectName, boolean ignoreErrors) throws JMException, IOException {
        this(server, new ObjectName(objectName), ignoreErrors);
    }

    public GroovyMBean(MBeanServerConnection server, ObjectName name) throws JMException, IOException {
        this(server, name, false);
    }

    public GroovyMBean(MBeanServerConnection server, ObjectName name, boolean ignoreErrors) throws JMException, IOException {
        this.server = server;
        this.name = name;
        this.ignoreErrors = ignoreErrors;
        this.beanInfo = server.getMBeanInfo(name);
        MBeanOperationInfo[] operationInfos = this.beanInfo.getOperations();
        for (int i2 = 0; i2 < operationInfos.length; ++i2) {
            MBeanOperationInfo info = operationInfos[i2];
            String[] signature = this.createSignature(info);
            String operationKey = this.createOperationKey(info.getName(), signature.length);
            this.operations.put(operationKey, signature);
        }
    }

    public MBeanServerConnection server() {
        return this.server;
    }

    public ObjectName name() {
        return this.name;
    }

    public MBeanInfo info() {
        return this.beanInfo;
    }

    public Object getProperty(String property) {
        block3: {
            try {
                return this.server.getAttribute(this.name, property);
            }
            catch (MBeanException e2) {
                this.throwExceptionWithTarget("Could not access property: " + property + ". Reason: ", e2);
            }
            catch (Exception e3) {
                if (this.ignoreErrors) break block3;
                this.throwException("Could not access property: " + property + ". Reason: ", e3);
            }
        }
        return null;
    }

    public void setProperty(String property, Object value) {
        try {
            this.server.setAttribute(this.name, new Attribute(property, value));
        }
        catch (MBeanException e2) {
            this.throwExceptionWithTarget("Could not set property: " + property + ". Reason: ", e2);
        }
        catch (Exception e3) {
            this.throwException("Could not set property: " + property + ". Reason: ", e3);
        }
    }

    public Object invokeMethod(String method, Object arguments) {
        Object[] argArray = null;
        argArray = arguments instanceof Object[] ? (Object[])arguments : new Object[]{arguments};
        String operationKey = this.createOperationKey(method, argArray.length);
        String[] signature = (String[])this.operations.get(operationKey);
        if (signature != null) {
            try {
                return this.server.invoke(this.name, method, argArray, signature);
            }
            catch (MBeanException e2) {
                this.throwExceptionWithTarget("Could not invoke method: " + method + ". Reason: ", e2);
            }
            catch (Exception e3) {
                this.throwException("Could not invoke method: " + method + ". Reason: ", e3);
            }
            return null;
        }
        return super.invokeMethod(method, arguments);
    }

    protected String[] createSignature(MBeanOperationInfo info) {
        MBeanParameterInfo[] params = info.getSignature();
        String[] answer = new String[params.length];
        for (int i2 = 0; i2 < params.length; ++i2) {
            answer[i2] = params[i2].getType();
        }
        return answer;
    }

    protected String createOperationKey(String operation, int params) {
        return operation + "_" + params;
    }

    public Collection listAttributeNames() {
        ArrayList<String> list = new ArrayList<String>();
        try {
            MBeanAttributeInfo[] attrs = this.beanInfo.getAttributes();
            for (int i2 = 0; i2 < attrs.length; ++i2) {
                MBeanAttributeInfo attr = attrs[i2];
                list.add(attr.getName());
            }
        }
        catch (Exception e2) {
            this.throwException("Could not list attribute names. Reason: ", e2);
        }
        return list;
    }

    public List listAttributeValues() {
        ArrayList<String> list = new ArrayList<String>();
        Collection names = this.listAttributeNames();
        Iterator iterator = names.iterator();
        while (iterator.hasNext()) {
            String name = (String)iterator.next();
            try {
                Object val = this.getProperty(name);
                if (val == null) continue;
                list.add(name + " : " + val.toString());
            }
            catch (Exception e2) {
                this.throwException("Could not list attribute values. Reason: ", e2);
            }
        }
        return list;
    }

    public Collection listAttributeDescriptions() {
        ArrayList<String> list = new ArrayList<String>();
        try {
            MBeanAttributeInfo[] attrs = this.beanInfo.getAttributes();
            for (int i2 = 0; i2 < attrs.length; ++i2) {
                MBeanAttributeInfo attr = attrs[i2];
                list.add(this.describeAttribute(attr));
            }
        }
        catch (Exception e2) {
            this.throwException("Could not list attribute descriptions. Reason: ", e2);
        }
        return list;
    }

    protected String describeAttribute(MBeanAttributeInfo attr) {
        StringBuffer buf = new StringBuffer();
        buf.append("(");
        if (attr.isReadable()) {
            buf.append("r");
        }
        if (attr.isWritable()) {
            buf.append("w");
        }
        buf.append(") ").append(attr.getType()).append(" ").append(attr.getName());
        return buf.toString();
    }

    public String describeAttribute(String attributeName) {
        String ret = "Attribute not found";
        try {
            MBeanAttributeInfo[] attributes = this.beanInfo.getAttributes();
            for (int i2 = 0; i2 < attributes.length; ++i2) {
                MBeanAttributeInfo attribute = attributes[i2];
                if (!attribute.getName().equals(attributeName)) continue;
                return this.describeAttribute(attribute);
            }
        }
        catch (Exception e2) {
            this.throwException("Could not describe attribute '" + attributeName + "'. Reason: ", e2);
        }
        return ret;
    }

    public Collection listOperationNames() {
        ArrayList<String> list = new ArrayList<String>();
        try {
            MBeanOperationInfo[] operations = this.beanInfo.getOperations();
            for (int i2 = 0; i2 < operations.length; ++i2) {
                MBeanOperationInfo operation = operations[i2];
                list.add(operation.getName());
            }
        }
        catch (Exception e2) {
            this.throwException("Could not list operation names. Reason: ", e2);
        }
        return list;
    }

    public Collection listOperationDescriptions() {
        ArrayList<String> list = new ArrayList<String>();
        try {
            MBeanOperationInfo[] operations = this.beanInfo.getOperations();
            for (int i2 = 0; i2 < operations.length; ++i2) {
                MBeanOperationInfo operation = operations[i2];
                list.add(this.describeOperation(operation));
            }
        }
        catch (Exception e2) {
            this.throwException("Could not list operation descriptions. Reason: ", e2);
        }
        return list;
    }

    public List describeOperation(String operationName) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            MBeanOperationInfo[] operations = this.beanInfo.getOperations();
            for (int i2 = 0; i2 < operations.length; ++i2) {
                MBeanOperationInfo operation = operations[i2];
                if (!operation.getName().equals(operationName)) continue;
                list.add(this.describeOperation(operation));
            }
        }
        catch (Exception e2) {
            this.throwException("Could not describe operations matching name '" + operationName + "'. Reason: ", e2);
        }
        return list;
    }

    protected String describeOperation(MBeanOperationInfo operation) {
        StringBuffer buf = new StringBuffer();
        buf.append(operation.getReturnType()).append(" ").append(operation.getName()).append("(");
        MBeanParameterInfo[] params = operation.getSignature();
        for (int j2 = 0; j2 < params.length; ++j2) {
            MBeanParameterInfo param = params[j2];
            if (j2 != 0) {
                buf.append(", ");
            }
            buf.append(param.getType()).append(" ").append(param.getName());
        }
        buf.append(")");
        return buf.toString();
    }

    public String toString() {
        Iterator iterator;
        StringBuffer buf = new StringBuffer();
        buf.append("MBean Name:").append("\n  ").append(this.name.getCanonicalName()).append("\n  ");
        if (!this.listAttributeDescriptions().isEmpty()) {
            buf.append("\nAttributes:");
            iterator = this.listAttributeDescriptions().iterator();
            while (iterator.hasNext()) {
                buf.append("\n  ").append((String)iterator.next());
            }
        }
        if (!this.listOperationDescriptions().isEmpty()) {
            buf.append("\nOperations:");
            iterator = this.listOperationDescriptions().iterator();
            while (iterator.hasNext()) {
                buf.append("\n  ").append((String)iterator.next());
            }
        }
        return buf.toString();
    }

    private void throwException(String m2, Exception e2) {
        if (!this.ignoreErrors) {
            throw new GroovyRuntimeException(m2 + e2, e2);
        }
    }

    private void throwExceptionWithTarget(String m2, MBeanException e2) {
        if (!this.ignoreErrors) {
            throw new GroovyRuntimeException(m2 + e2, e2.getTargetException());
        }
    }
}

