/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cglib.core;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import net.sf.cglib.core.CodeGenerationException;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.util.TraceClassVisitor;

public class DebuggingClassWriter
extends ClassWriter {
    public static final String DEBUG_LOCATION_PROPERTY = "cglib.debugLocation";
    private static String debugLocation = System.getProperty("cglib.debugLocation");
    private static boolean traceEnabled;
    private String className;
    private String superName;

    public DebuggingClassWriter(boolean computeMaxs) {
        super(computeMaxs);
    }

    public DebuggingClassWriter(boolean computeMaxs, int major, int minor) {
        super(computeMaxs);
    }

    public void visit(int version, int access, String name, String superName, String[] interfaces, String sourceFile) {
        this.className = name.replace('/', '.');
        this.superName = superName.replace('/', '.');
        super.visit(version, access, name, superName, interfaces, sourceFile);
    }

    public String getClassName() {
        return this.className;
    }

    public String getSuperName() {
        return this.superName;
    }

    public byte[] toByteArray() {
        return (byte[])AccessController.doPrivileged(new PrivilegedAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() {
                byte[] b2;
                block10: {
                    b2 = DebuggingClassWriter.super.toByteArray();
                    if (debugLocation != null) {
                        String dirs = DebuggingClassWriter.this.className.replace('.', File.separatorChar);
                        try {
                            new File(debugLocation + File.separatorChar + dirs).getParentFile().mkdirs();
                            File file = new File(new File(debugLocation), dirs + ".class");
                            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
                            try {
                                ((OutputStream)out).write(b2);
                            }
                            finally {
                                ((OutputStream)out).close();
                            }
                            if (!traceEnabled) break block10;
                            file = new File(new File(debugLocation), dirs + ".asm");
                            out = new BufferedOutputStream(new FileOutputStream(file));
                            try {
                                ClassReader cr = new ClassReader(b2);
                                PrintWriter pw = new PrintWriter(new OutputStreamWriter(out));
                                TraceClassVisitor tcv = new TraceClassVisitor(null, pw);
                                cr.accept((ClassVisitor)tcv, false);
                                pw.flush();
                            }
                            finally {
                                ((OutputStream)out).close();
                            }
                        }
                        catch (IOException e2) {
                            throw new CodeGenerationException(e2);
                        }
                    }
                }
                return b2;
            }
        });
    }

    static {
        if (debugLocation != null) {
            System.err.println("CGLIB debugging enabled, writing to '" + debugLocation + "'");
            try {
                Class.forName("org.objectweb.asm.util.TraceClassVisitor");
                traceEnabled = true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

