/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cglib.core;

import java.util.HashMap;
import java.util.Map;
import org.objectweb.asm.CodeAdapter;
import org.objectweb.asm.CodeVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;

public class RemappingCodeVisitor
extends CodeAdapter {
    private State state;
    private IntRef check = new IntRef();

    public RemappingCodeVisitor(CodeVisitor v, int access, Type[] args) {
        super(v);
        this.state = new State(access, args);
    }

    public RemappingCodeVisitor(RemappingCodeVisitor wrap) {
        super(wrap.cv);
        this.state = wrap.state;
    }

    protected int nextLocal(int size) {
        int var = this.state.nextLocal;
        this.state.nextLocal += size;
        return var;
    }

    private int remap(int var, int size) {
        if (var < this.state.firstLocal) {
            return var;
        }
        Integer value = this.remapHelper(var, size == 0 ? 1 : size);
        if (value == null) {
            if (size == 0) {
                value = this.remapHelper(var, 2);
                if (value == null) {
                    throw new IllegalStateException("Unknown local variable " + var);
                }
            } else {
                IntRef ref = new IntRef();
                ref.key = this.getKey(var, size);
                value = new Integer(this.nextLocal(size));
                this.state.locals.put(ref, value);
            }
        }
        return value;
    }

    private Integer remapHelper(int var, int size) {
        this.check.key = this.getKey(var, size);
        return (Integer)this.state.locals.get(this.check);
    }

    private int getKey(int var, int size) {
        return size == 2 ? ~var : var;
    }

    public void visitIincInsn(int var, int increment) {
        this.cv.visitIincInsn(this.remap(var, 1), increment);
    }

    public void visitLocalVariable(String name, String desc, Label start, Label end, int index) {
        this.cv.visitLocalVariable(name, desc, start, end, this.remap(index, 0));
    }

    public void visitVarInsn(int opcode, int var) {
        int size;
        switch (opcode) {
            case 22: 
            case 24: 
            case 55: 
            case 57: {
                size = 2;
                break;
            }
            default: {
                size = 1;
            }
        }
        this.cv.visitVarInsn(opcode, this.remap(var, size));
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        this.cv.visitMaxs(0, 0);
    }

    private static class IntRef {
        int key;

        private IntRef() {
        }

        public boolean equals(Object o2) {
            return this.key == ((IntRef)o2).key;
        }

        public int hashCode() {
            return this.key;
        }
    }

    private static class State {
        Map locals = new HashMap();
        int firstLocal;
        int nextLocal;

        State(int access, Type[] args) {
            this.nextLocal = (8 & access) != 0 ? 0 : 1;
            for (int i2 = 0; i2 < args.length; ++i2) {
                this.nextLocal += args[i2].getSize();
            }
            this.firstLocal = this.nextLocal;
        }
    }
}

