/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cglib.util;

import java.util.Comparator;
import net.sf.cglib.core.AbstractClassGenerator;
import net.sf.cglib.core.ClassesKey;
import net.sf.cglib.core.ReflectUtils;
import net.sf.cglib.util.ParallelSorterEmitter;
import net.sf.cglib.util.SorterTemplate;
import org.objectweb.asm.ClassVisitor;

public abstract class ParallelSorter
extends SorterTemplate {
    protected Object[] a;
    private Comparer comparer;
    static /* synthetic */ Class class$net$sf$cglib$util$ParallelSorter;

    protected ParallelSorter() {
    }

    public abstract ParallelSorter newInstance(Object[] var1);

    public static ParallelSorter create(Object[] arrays) {
        Generator gen = new Generator();
        gen.setArrays(arrays);
        return gen.create();
    }

    private int len() {
        return ((Object[])this.a[0]).length;
    }

    public void quickSort(int index) {
        this.quickSort(index, 0, this.len(), null);
    }

    public void quickSort(int index, int lo, int hi) {
        this.quickSort(index, lo, hi, null);
    }

    public void quickSort(int index, Comparator cmp) {
        this.quickSort(index, 0, this.len(), cmp);
    }

    public void quickSort(int index, int lo, int hi, Comparator cmp) {
        this.chooseComparer(index, cmp);
        super.quickSort(lo, hi - 1);
    }

    public void mergeSort(int index) {
        this.mergeSort(index, 0, this.len(), null);
    }

    public void mergeSort(int index, int lo, int hi) {
        this.mergeSort(index, lo, hi, null);
    }

    public void mergeSort(int index, Comparator cmp) {
        this.mergeSort(index, 0, this.len(), cmp);
    }

    public void mergeSort(int index, int lo, int hi, Comparator cmp) {
        this.chooseComparer(index, cmp);
        super.mergeSort(lo, hi - 1);
    }

    private void chooseComparer(int index, Comparator cmp) {
        Object array = this.a[index];
        Class<?> type = array.getClass().getComponentType();
        this.comparer = type.equals(Integer.TYPE) ? new IntComparer((int[])array) : (type.equals(Long.TYPE) ? new LongComparer((long[])array) : (type.equals(Double.TYPE) ? new DoubleComparer((double[])array) : (type.equals(Float.TYPE) ? new FloatComparer((float[])array) : (type.equals(Short.TYPE) ? new ShortComparer((short[])array) : (type.equals(Byte.TYPE) ? new ByteComparer((byte[])array) : (cmp != null ? new ComparatorComparer((Object[])array, cmp) : new ObjectComparer((Object[])array)))))));
    }

    protected int compare(int i2, int j2) {
        return this.comparer.compare(i2, j2);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Generator
    extends AbstractClassGenerator {
        private static final AbstractClassGenerator.Source SOURCE = new AbstractClassGenerator.Source((class$net$sf$cglib$util$ParallelSorter == null ? (class$net$sf$cglib$util$ParallelSorter = ParallelSorter.class$("net.sf.cglib.util.ParallelSorter")) : class$net$sf$cglib$util$ParallelSorter).getName());
        private Object[] arrays;

        public Generator() {
            super(SOURCE);
        }

        protected ClassLoader getDefaultClassLoader() {
            return null;
        }

        public void setArrays(Object[] arrays) {
            this.arrays = arrays;
        }

        public ParallelSorter create() {
            return (ParallelSorter)super.create(ClassesKey.create(this.arrays));
        }

        public void generateClass(ClassVisitor v) throws Exception {
            if (this.arrays.length == 0) {
                throw new IllegalArgumentException("No arrays specified to sort");
            }
            for (int i2 = 0; i2 < this.arrays.length; ++i2) {
                if (this.arrays[i2].getClass().isArray()) continue;
                throw new IllegalArgumentException(this.arrays[i2].getClass() + " is not an array");
            }
            new ParallelSorterEmitter(v, this.getClassName(), this.arrays);
        }

        protected Object firstInstance(Class type) {
            return ((ParallelSorter)ReflectUtils.newInstance(type)).newInstance(this.arrays);
        }

        protected Object nextInstance(Object instance) {
            return ((ParallelSorter)instance).newInstance(this.arrays);
        }
    }

    static class ByteComparer
    implements Comparer {
        private byte[] a;

        public ByteComparer(byte[] a2) {
            this.a = a2;
        }

        public int compare(int i2, int j2) {
            return this.a[i2] - this.a[j2];
        }
    }

    static class ShortComparer
    implements Comparer {
        private short[] a;

        public ShortComparer(short[] a2) {
            this.a = a2;
        }

        public int compare(int i2, int j2) {
            return this.a[i2] - this.a[j2];
        }
    }

    static class DoubleComparer
    implements Comparer {
        private double[] a;

        public DoubleComparer(double[] a2) {
            this.a = a2;
        }

        public int compare(int i2, int j2) {
            double vi = this.a[i2];
            double vj = this.a[j2];
            return vi == vj ? 0 : (vi > vj ? 1 : -1);
        }
    }

    static class FloatComparer
    implements Comparer {
        private float[] a;

        public FloatComparer(float[] a2) {
            this.a = a2;
        }

        public int compare(int i2, int j2) {
            float vi = this.a[i2];
            float vj = this.a[j2];
            return vi == vj ? 0 : (vi > vj ? 1 : -1);
        }
    }

    static class LongComparer
    implements Comparer {
        private long[] a;

        public LongComparer(long[] a2) {
            this.a = a2;
        }

        public int compare(int i2, int j2) {
            long vi = this.a[i2];
            long vj = this.a[j2];
            return vi == vj ? 0 : (vi > vj ? 1 : -1);
        }
    }

    static class IntComparer
    implements Comparer {
        private int[] a;

        public IntComparer(int[] a2) {
            this.a = a2;
        }

        public int compare(int i2, int j2) {
            return this.a[i2] - this.a[j2];
        }
    }

    static class ObjectComparer
    implements Comparer {
        private Object[] a;

        public ObjectComparer(Object[] a2) {
            this.a = a2;
        }

        public int compare(int i2, int j2) {
            return ((Comparable)this.a[i2]).compareTo(this.a[j2]);
        }
    }

    static class ComparatorComparer
    implements Comparer {
        private Object[] a;
        private Comparator cmp;

        public ComparatorComparer(Object[] a2, Comparator cmp) {
            this.a = a2;
            this.cmp = cmp;
        }

        public int compare(int i2, int j2) {
            return this.cmp.compare(this.a[i2], this.a[j2]);
        }
    }

    static interface Comparer {
        public int compare(int var1, int var2);
    }
}

