/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.store.DiskStore;
import net.sf.ehcache.store.MemoryStore;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Cache
implements Cloneable {
    public static final String DEFAULT_CACHE_NAME = "default";
    public static final int STATUS_UNINITIALISED = 1;
    public static final int STATUS_ALIVE = 2;
    public static final int STATUS_DISPOSED = 3;
    private static final Log LOG = LogFactory.getLog((class$net$sf$ehcache$Cache == null ? (class$net$sf$ehcache$Cache = Cache.class$("net.sf.ehcache.Cache")) : class$net$sf$ehcache$Cache).getName());
    private static final long DEFAULT_EXPIRY_THREAD_INTERVAL_SECONDS = 120L;
    private static final int MS_PER_SECOND = 1000;
    private String name;
    private DiskStore diskStore;
    private int status;
    private final int maxElementsInMemory;
    private final boolean overflowToDisk;
    private final long diskExpiryThreadIntervalSeconds;
    private final boolean diskPersistent;
    private final boolean eternal;
    private final long timeToLiveSeconds;
    private final long timeToIdleSeconds;
    private int hitCount;
    private int memoryStoreHitCount;
    private int diskStoreHitCount;
    private int missCountNotFound;
    private int missCountExpired;
    private MemoryStore memoryStore;
    static /* synthetic */ Class class$net$sf$ehcache$Cache;

    public Cache(String name, int maximumSize, boolean overflowToDisk, boolean eternal, long timeToLiveSeconds, long timeToIdleSeconds) {
        this(name, maximumSize, overflowToDisk, eternal, timeToLiveSeconds, timeToIdleSeconds, false, 120L);
    }

    public Cache(String name, int maximumSize, boolean overflowToDisk, boolean eternal, long timeToLiveSeconds, long timeToIdleSeconds, boolean diskPersistent, long diskExpiryThreadIntervalSeconds) {
        this.name = name;
        this.maxElementsInMemory = maximumSize;
        this.overflowToDisk = overflowToDisk;
        this.eternal = eternal;
        this.timeToLiveSeconds = timeToLiveSeconds;
        this.timeToIdleSeconds = timeToIdleSeconds;
        this.diskPersistent = diskPersistent;
        this.diskExpiryThreadIntervalSeconds = diskExpiryThreadIntervalSeconds == 0L ? 120L : diskExpiryThreadIntervalSeconds;
        this.status = 1;
    }

    synchronized void initialise(Configuration configuration) {
        if (this.status != 1) {
            throw new IllegalStateException("Cannot initialise the " + this.name + " cache because its status is not STATUS_UNINITIALISED");
        }
        if (configuration == null) {
            throw new IllegalArgumentException("Cannot intialise caches without a configuration");
        }
        if (this.maxElementsInMemory == 0 && LOG.isWarnEnabled()) {
            LOG.warn("Cache: " + this.name + " has a maxElementsInMemory of 0. It is strongly recommended to " + "have a maximumSize of at least 1. Performance is halved by not using a MemoryStore.");
        }
        if (this.overflowToDisk) {
            this.diskStore = new DiskStore(this, configuration.getDiskCachePath());
        }
        this.memoryStore = new MemoryStore(this, this.diskStore);
        if (this.diskPersistent) {
            this.addShutdownHook();
        }
        this.status = 2;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Initialised cache: " + this.name);
        }
    }

    private void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                1 var1_1 = this;
                synchronized (var1_1) {
                    if (Cache.this.status == 2) {
                        LOG.info("VM shutting down with the disk store for " + Cache.this.name + " still active. The disk store is persistent. Calling dispose...");
                        Cache.this.dispose();
                    }
                }
            }
        });
    }

    public synchronized void put(Element element) throws IllegalArgumentException, IllegalStateException {
        this.checkStatus();
        if (element == null) {
            throw new IllegalArgumentException("Element cannot be null");
        }
        element.resetAccessStatistics();
        this.memoryStore.put(element);
    }

    public synchronized void putQuiet(Element element) throws IllegalArgumentException, IllegalStateException {
        this.checkStatus();
        if (element == null) {
            throw new IllegalArgumentException("Element cannot be null");
        }
        this.memoryStore.put(element);
    }

    public synchronized Element get(Serializable key) throws IllegalStateException, CacheException {
        this.checkStatus();
        Element element = null;
        element = this.searchInMemoryStore(key, true);
        if (element == null && this.overflowToDisk) {
            try {
                element = this.searchInDiskStore(key, true);
            }
            catch (IOException e2) {
                throw new CacheException(e2.getMessage());
            }
        }
        if (element == null) {
            ++this.missCountNotFound;
            if (LOG.isTraceEnabled()) {
                LOG.trace(this.name + " cache - Miss");
            }
            return null;
        }
        ++this.hitCount;
        return element;
    }

    public synchronized Element getQuiet(Serializable key) throws IllegalStateException, CacheException {
        this.checkStatus();
        Element element = null;
        element = this.searchInMemoryStore(key, false);
        if (element == null && this.overflowToDisk) {
            try {
                element = this.searchInDiskStore(key, false);
            }
            catch (IOException e2) {
                throw new CacheException(e2.getMessage());
            }
        }
        if (element == null) {
            ++this.missCountNotFound;
            if (LOG.isTraceEnabled()) {
                LOG.trace(this.name + " cache - Miss");
            }
            return null;
        }
        ++this.hitCount;
        return element;
    }

    public synchronized List getKeys() throws IllegalStateException, CacheException {
        this.checkStatus();
        ArrayList<Object> allKeyList = new ArrayList<Object>();
        List<Object> keyList = Arrays.asList(this.memoryStore.getKeyArray());
        allKeyList.addAll(keyList);
        if (this.overflowToDisk) {
            HashSet<Object> allKeys = new HashSet<Object>();
            allKeys.addAll(keyList);
            Object[] diskKeys = this.diskStore.getKeyArray();
            for (int i2 = 0; i2 < diskKeys.length; ++i2) {
                Object diskKey = diskKeys[i2];
                if (!allKeys.add(diskKey)) continue;
                allKeyList.add(diskKey);
            }
        }
        return allKeyList;
    }

    public List getKeysWithExpiryCheck() throws IllegalStateException, CacheException {
        List allKeyList = this.getKeys();
        ArrayList<Serializable> nonExpiredKeys = new ArrayList<Serializable>(allKeyList.size());
        int allKeyListSize = allKeyList.size();
        for (int i2 = 0; i2 < allKeyListSize; ++i2) {
            Serializable key = (Serializable)allKeyList.get(i2);
            Element element = this.getQuiet(key);
            if (element == null) continue;
            nonExpiredKeys.add(key);
        }
        nonExpiredKeys.trimToSize();
        return nonExpiredKeys;
    }

    public synchronized List getKeysNoDuplicateCheck() throws IllegalStateException {
        this.checkStatus();
        ArrayList<Object> allKeys = new ArrayList<Object>();
        List<Object> memoryKeySet = Arrays.asList(this.memoryStore.getKeyArray());
        allKeys.addAll(memoryKeySet);
        if (this.overflowToDisk) {
            List<Object> diskKeySet = Arrays.asList(this.diskStore.getKeyArray());
            allKeys.addAll(diskKeySet);
        }
        return allKeys;
    }

    private Element searchInMemoryStore(Serializable key, boolean updateStatistics) {
        Element element = null;
        element = updateStatistics ? this.memoryStore.get(key) : this.memoryStore.getQuiet(key);
        if (element != null) {
            if (this.isExpired(element)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(this.name + " Memory cache hit, but element expired");
                }
                ++this.missCountExpired;
                this.remove(key);
                element = null;
            } else {
                ++this.memoryStoreHitCount;
            }
        }
        return element;
    }

    private Element searchInDiskStore(Serializable key, boolean updateStatistics) throws IOException {
        Element element = null;
        element = updateStatistics ? this.diskStore.get(key) : this.diskStore.getQuiet(key);
        if (element != null) {
            if (this.isExpired(element)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(this.name + " cache - Disk Store hit, but element expired");
                }
                ++this.missCountExpired;
                this.remove(key);
                element = null;
            } else {
                ++this.diskStoreHitCount;
                this.memoryStore.put(element);
            }
        }
        return element;
    }

    public synchronized boolean remove(Serializable key) throws IllegalStateException {
        this.checkStatus();
        boolean removedFromMemory = false;
        removedFromMemory = this.memoryStore.remove(key);
        if (LOG.isDebugEnabled() && removedFromMemory) {
            LOG.debug("Removing " + key + " from memoryStore");
        }
        boolean removedFromDisk = false;
        if (this.overflowToDisk) {
            try {
                removedFromDisk = this.diskStore.remove(key);
                if (LOG.isDebugEnabled() && removedFromDisk) {
                    LOG.debug("Removing " + key + " from diskStore");
                }
            }
            catch (IOException e2) {
                LOG.error("Failure removing from Disk Cache", e2);
            }
        }
        return removedFromMemory || removedFromDisk;
    }

    public synchronized void removeAll() throws IllegalStateException, IOException {
        this.checkStatus();
        this.memoryStore.removeAll();
        if (this.overflowToDisk) {
            this.diskStore.removeAll();
        }
    }

    synchronized void dispose() throws IllegalStateException {
        this.checkStatus();
        this.memoryStore.dispose();
        this.memoryStore = null;
        if (this.overflowToDisk) {
            this.diskStore.dispose();
            this.diskStore = null;
        }
        this.status = 3;
    }

    public synchronized int getSize() throws IllegalStateException, CacheException {
        this.checkStatus();
        return this.getKeys().size();
    }

    public synchronized long calculateInMemorySize() throws IllegalStateException, CacheException {
        this.checkStatus();
        return this.memoryStore.getSizeInBytes();
    }

    public long getMemoryStoreSize() throws IllegalStateException {
        this.checkStatus();
        return this.memoryStore.getSize();
    }

    public int getDiskStoreSize() throws IllegalStateException {
        this.checkStatus();
        if (this.overflowToDisk) {
            return this.diskStore.getSize();
        }
        return 0;
    }

    public int getStatus() {
        return this.status;
    }

    private void checkStatus() {
        if (this.status != 2) {
            throw new IllegalStateException("The " + this.name + " Cache is not alive.");
        }
    }

    public int getHitCount() throws IllegalStateException {
        this.checkStatus();
        return this.hitCount;
    }

    public int getMemoryStoreHitCount() throws IllegalStateException {
        this.checkStatus();
        return this.memoryStoreHitCount;
    }

    public int getDiskStoreHitCount() throws IllegalStateException {
        this.checkStatus();
        return this.diskStoreHitCount;
    }

    public int getMissCountNotFound() throws IllegalStateException {
        this.checkStatus();
        return this.missCountNotFound;
    }

    public int getMissCountExpired() throws IllegalStateException {
        this.checkStatus();
        return this.missCountExpired;
    }

    public String getName() {
        return this.name;
    }

    void setName(String name) {
        this.name = name;
    }

    public long getTimeToIdleSeconds() {
        return this.timeToIdleSeconds;
    }

    public long getTimeToLiveSeconds() {
        return this.timeToLiveSeconds;
    }

    public boolean isEternal() {
        return this.eternal;
    }

    public boolean isOverflowToDisk() {
        return this.overflowToDisk;
    }

    public int getMaxElementsInMemory() {
        return this.maxElementsInMemory;
    }

    public String toString() {
        StringBuffer dump = new StringBuffer();
        dump.append("[ ").append(" name = ").append(this.name).append(" status = ").append(this.status).append(" eternal = ").append(this.eternal).append(" overflowToDisk = ").append(this.overflowToDisk).append(" maxElementsInMemory = ").append(this.maxElementsInMemory).append(" timeToLiveSeconds = ").append(this.timeToLiveSeconds).append(" timeToIdleSeconds = ").append(this.timeToIdleSeconds).append(" diskPersistent = ").append(this.diskPersistent).append(" diskExpiryThreadIntervalSeconds = ").append(this.diskExpiryThreadIntervalSeconds).append(" hitCount = ").append(this.hitCount).append(" memoryStoreHitCount = ").append(this.memoryStoreHitCount).append(" diskStoreHitCount = ").append(this.diskStoreHitCount).append(" missCountNotFound = ").append(this.missCountNotFound).append(" missCountExpired = ").append(this.missCountExpired).append(" ]");
        return dump.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isExpired(Element element) throws IllegalStateException, NullPointerException {
        this.checkStatus();
        Element element2 = element;
        synchronized (element2) {
            boolean expired;
            if (element.getValue() == null) {
                expired = true;
            }
            if (!this.eternal) {
                long now = System.currentTimeMillis();
                long creationTime = element.getCreationTime();
                long ageLived = now - creationTime;
                long ageToLive = this.timeToLiveSeconds * 1000L;
                long nextToLastAccessTime = element.getNextToLastAccessTime();
                long mostRecentTime = Math.max(creationTime, nextToLastAccessTime);
                long ageIdled = now - mostRecentTime;
                long ageToIdle = this.timeToIdleSeconds * 1000L;
                if (LOG.isTraceEnabled()) {
                    LOG.trace(element.getKey() + " now: " + now);
                    LOG.trace(element.getKey() + " Creation Time: " + creationTime + " Next To Last Access Time: " + nextToLastAccessTime);
                    LOG.trace(element.getKey() + " mostRecentTime: " + mostRecentTime);
                    LOG.trace(element.getKey() + " Age to Idle: " + ageToIdle + " Age Idled: " + ageIdled);
                }
                if (this.timeToLiveSeconds != 0L && ageLived > ageToLive) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("timeToLiveSeconds exceeded : " + element.getKey());
                    }
                    expired = true;
                } else if (this.timeToIdleSeconds != 0L && ageIdled > ageToIdle) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("timeToIdleSeconds exceeded : " + element.getKey());
                    }
                    expired = true;
                } else {
                    expired = false;
                }
            } else {
                expired = false;
            }
            if (LOG.isDebugEnabled()) {
                Serializable key = null;
                if (element != null) {
                    key = element.getKey();
                }
                LOG.debug(this.getName() + ": Is element with key " + key + " expired?: " + expired);
            }
            return expired;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        if (this.memoryStore != null || this.diskStore != null) {
            throw new CloneNotSupportedException("Cannot clone an initialized cache.");
        }
        return (Cache)super.clone();
    }

    DiskStore getDiskStore() throws IllegalStateException {
        this.checkStatus();
        return this.diskStore;
    }

    MemoryStore getMemoryStore() throws IllegalStateException {
        this.checkStatus();
        return this.memoryStore;
    }

    public boolean isDiskPersistent() {
        return this.diskPersistent;
    }

    public long getDiskExpiryThreadIntervalSeconds() {
        return this.diskExpiryThreadIntervalSeconds;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

