/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store;

import java.io.Externalizable;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Element;
import net.sf.ehcache.store.DiskStore;
import net.sf.ehcache.store.Store;
import org.apache.commons.collections.LRUMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MemoryStore
implements Store {
    private static final Log LOG = LogFactory.getLog((class$net$sf$ehcache$store$MemoryStore == null ? (class$net$sf$ehcache$store$MemoryStore = MemoryStore.class$("net.sf.ehcache.store.MemoryStore")) : class$net$sf$ehcache$store$MemoryStore).getName());
    private Map map;
    private Cache cache;
    private DiskStore diskStore;
    private int status;
    static /* synthetic */ Class class$net$sf$ehcache$store$MemoryStore;

    private MemoryStore() {
    }

    public MemoryStore(Cache cache, DiskStore diskStore) {
        this.status = 1;
        this.cache = cache;
        this.diskStore = diskStore;
        try {
            this.map = this.loadMapInstance();
        }
        catch (CacheException e2) {
            LOG.error(cache.getName() + "Cache: Cannot start MemoryStore", e2);
            return;
        }
        LOG.debug("initialized MemoryStore for " + cache.getName());
        this.status = 2;
    }

    public Map loadMapInstance() throws CacheException {
        try {
            Class.forName("java.util.LinkedHashMap");
            SpoolingLinkedHashMap candidateMap = new SpoolingLinkedHashMap();
            if (LOG.isDebugEnabled()) {
                LOG.debug(this.cache.getName() + " Cache: Using SpoolingLinkedHashMap implementation");
            }
            return candidateMap;
        }
        catch (Exception e2) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(this.cache.getName() + " Cache: Cannot find java.util.LinkedHashMap");
            }
            try {
                Class.forName("org.apache.commons.collections.LRUMap");
                SpoolingLRUMap candidateMap = new SpoolingLRUMap();
                if (LOG.isDebugEnabled()) {
                    LOG.debug(this.cache.getName() + " Cache: Using SpoolingLRUMap implementation");
                }
                return candidateMap;
            }
            catch (Exception e3) {
                throw new CacheException(this.cache.getName() + "Cache: Cannot find org.apache.commons.collections.LRUMap.");
            }
        }
    }

    public synchronized void put(Element element) {
        this.map.put(element.getKey(), element);
    }

    public synchronized void removeAll() {
        this.map.clear();
    }

    public synchronized Element get(Serializable key) {
        Element cacheElement = (Element)this.map.get(key);
        if (cacheElement != null) {
            cacheElement.updateAccessStatistics();
            if (LOG.isTraceEnabled()) {
                LOG.trace(this.cache.getName() + "Cache: MemoryStore hit for " + key);
            }
        } else if (LOG.isTraceEnabled()) {
            LOG.trace(this.cache.getName() + "Cache: MemoryStore miss for " + key);
        }
        return cacheElement;
    }

    public synchronized Element getQuiet(Serializable key) {
        Element cacheElement = (Element)this.map.get(key);
        if (cacheElement != null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace(this.cache.getName() + "Cache: Quiet MemoryStore hit for " + key);
            }
        } else if (LOG.isTraceEnabled()) {
            LOG.trace(this.cache.getName() + "Cache: Quiet MemoryStore miss for " + key);
        }
        return cacheElement;
    }

    public synchronized boolean remove(Serializable key) {
        boolean removed = false;
        if (this.map.remove(key) != null) {
            removed = true;
        } else if (LOG.isDebugEnabled()) {
            LOG.debug(this.cache.getName() + "Cache: Cannot remove entry as key " + key + " was not found");
        }
        return removed;
    }

    public synchronized Object[] getKeyArray() {
        return this.map.keySet().toArray();
    }

    public int getSize() {
        return this.map.size();
    }

    public Cache getCache() {
        return this.cache;
    }

    public int getStatus() {
        return this.status;
    }

    public int getCacheType() {
        return 1;
    }

    public String getName() {
        return this.cache.getName();
    }

    public synchronized void dispose() {
        if (this.status == 3) {
            return;
        }
        this.status = 3;
        if (this.cache.isDiskPersistent()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(this.cache.getName() + " is persistent. Spooling " + this.map.size() + " elements to the disk store.");
            }
            this.spoolAllToDisk();
        }
        this.map.clear();
        this.cache = null;
    }

    public synchronized long getSizeInBytes() throws CacheException {
        long sizeInBytes = 0L;
        Iterator iterator = this.map.values().iterator();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            if (element == null) continue;
            sizeInBytes += element.getSerializedSize();
        }
        return sizeInBytes;
    }

    private boolean removeLeastRecentlyUsedElement(Element element) {
        if (this.cache.isExpired(element)) {
            return true;
        }
        if (this.map.size() <= this.cache.getMaxElementsInMemory()) {
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Memory Store maximum size of " + this.cache.getMaxElementsInMemory() + " reached. About to spool element with key \"" + element.getKey() + "\" to Disk Store");
        }
        if (this.cache.isOverflowToDisk()) {
            this.spoolToDisk(element);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Memory Store size now: " + this.map.size());
        }
        return true;
    }

    private void spoolAllToDisk() {
        Collection values = this.map.values();
        Iterator iterator = values.iterator();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            this.spoolToDisk(element);
        }
    }

    private void spoolToDisk(Element element) {
        try {
            this.diskStore.put(element);
        }
        catch (IOException e2) {
            LOG.error(e2.getMessage(), e2);
            throw new IllegalStateException(e2.getMessage());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.cache.getName() + "Cache: spool to disk done for: " + element.getKey());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class SpoolingLinkedHashMap
    extends LinkedHashMap {
        private static final int INITIAL_CAPACITY = 100;
        private static final float GROWTH_FACTOR = 0.75f;

        public SpoolingLinkedHashMap() {
            super(100, 0.75f, true);
        }

        protected boolean removeEldestEntry(Map.Entry eldest) {
            Element element = (Element)eldest.getValue();
            return MemoryStore.this.removeLeastRecentlyUsedElement(element);
        }
    }

    public class SpoolingLRUMap
    extends LRUMap
    implements Externalizable {
        public SpoolingLRUMap() {
            this.setMaximumSize(MemoryStore.this.cache.getMaxElementsInMemory());
        }

        protected void processRemovedLRU(Object key, Object value) {
            Element element = (Element)value;
            MemoryStore.this.removeLeastRecentlyUsedElement(element);
        }
    }
}

