/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.charts.fill;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.charts.JRTimeSeries;
import net.sf.jasperreports.charts.JRTimeSeriesDataset;
import net.sf.jasperreports.charts.fill.JRFillTimeSeries;
import net.sf.jasperreports.charts.util.TimeSeriesLabelGenerator;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.design.JRVerifier;
import net.sf.jasperreports.engine.fill.JRCalculator;
import net.sf.jasperreports.engine.fill.JRExpressionEvalException;
import net.sf.jasperreports.engine.fill.JRFillChartDataset;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import org.jfree.data.general.Dataset;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;

public class JRFillTimeSeriesDataset
extends JRFillChartDataset
implements JRTimeSeriesDataset {
    protected JRFillTimeSeries[] timeSeries = null;
    private List seriesNames = null;
    private Map seriesMap = null;
    private Map labelsMap = null;
    private Map itemHyperlinks;

    public JRFillTimeSeriesDataset(JRTimeSeriesDataset timeSeriesDataset, JRFillObjectFactory factory) {
        super(timeSeriesDataset, factory);
        JRTimeSeries[] srcTimeSeries = timeSeriesDataset.getSeries();
        if (srcTimeSeries != null && srcTimeSeries.length > 0) {
            this.timeSeries = new JRFillTimeSeries[srcTimeSeries.length];
            for (int i2 = 0; i2 < this.timeSeries.length; ++i2) {
                this.timeSeries[i2] = (JRFillTimeSeries)factory.getTimeSeries(srcTimeSeries[i2]);
            }
        }
    }

    public JRTimeSeries[] getSeries() {
        return this.timeSeries;
    }

    protected void customInitialize() {
        this.seriesNames = null;
        this.seriesMap = null;
        this.labelsMap = null;
        this.itemHyperlinks = null;
    }

    protected void customEvaluate(JRCalculator calculator) throws JRExpressionEvalException {
        if (this.timeSeries != null && this.timeSeries.length > 0) {
            for (int i2 = 0; i2 < this.timeSeries.length; ++i2) {
                this.timeSeries[i2].evaluate(calculator);
            }
        }
    }

    protected void customIncrement() {
        if (this.timeSeries != null && this.timeSeries.length > 0) {
            if (this.seriesNames == null) {
                this.seriesNames = new ArrayList();
                this.seriesMap = new HashMap();
                this.labelsMap = new HashMap();
                this.itemHyperlinks = new HashMap();
            }
            for (int i2 = 0; i2 < this.timeSeries.length; ++i2) {
                JRFillTimeSeries crtTimeSeries = this.timeSeries[i2];
                Comparable seriesName = crtTimeSeries.getSeries();
                if (seriesName == null) {
                    throw new JRRuntimeException("Time series name is null.");
                }
                TimeSeries series = (TimeSeries)this.seriesMap.get(seriesName);
                if (series == null) {
                    series = new TimeSeries(seriesName.toString(), this.getTimePeriod());
                    this.seriesNames.add(seriesName);
                    this.seriesMap.put(seriesName, series);
                }
                RegularTimePeriod tp = RegularTimePeriod.createInstance(this.getTimePeriod(), crtTimeSeries.getTimePeriod(), this.getTimeZone());
                series.addOrUpdate(tp, crtTimeSeries.getValue());
                if (crtTimeSeries.getLabelExpression() != null) {
                    HashMap<RegularTimePeriod, String> seriesLabels = (HashMap<RegularTimePeriod, String>)this.labelsMap.get(seriesName);
                    if (seriesLabels == null) {
                        seriesLabels = new HashMap<RegularTimePeriod, String>();
                        this.labelsMap.put(seriesName, seriesLabels);
                    }
                    seriesLabels.put(tp, crtTimeSeries.getLabel());
                }
                if (!crtTimeSeries.hasItemHyperlink()) continue;
                HashMap<RegularTimePeriod, JRPrintHyperlink> seriesLinks = (HashMap<RegularTimePeriod, JRPrintHyperlink>)this.itemHyperlinks.get(seriesName);
                if (seriesLinks == null) {
                    seriesLinks = new HashMap<RegularTimePeriod, JRPrintHyperlink>();
                    this.itemHyperlinks.put(seriesName, seriesLinks);
                }
                seriesLinks.put(tp, crtTimeSeries.getPrintItemHyperlink());
            }
        }
    }

    public Dataset getCustomDataset() {
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        if (this.seriesNames != null) {
            for (int i2 = 0; i2 < this.seriesNames.size(); ++i2) {
                Comparable seriesName = (Comparable)this.seriesNames.get(i2);
                dataset.addSeries((TimeSeries)this.seriesMap.get(seriesName));
            }
        }
        return dataset;
    }

    public Class getTimePeriod() {
        return ((JRTimeSeriesDataset)this.parent).getTimePeriod();
    }

    public void setTimePeriod(Class timePeriod) {
    }

    public byte getDatasetType() {
        return 6;
    }

    public TimeSeriesLabelGenerator getLabelGenerator() {
        return new TimeSeriesLabelGenerator(this.labelsMap);
    }

    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }

    public Map getItemHyperlinks() {
        return this.itemHyperlinks;
    }

    public boolean hasItemHyperlinks() {
        boolean foundLinks = false;
        if (this.timeSeries != null && this.timeSeries.length > 0) {
            for (int i2 = 0; i2 < this.timeSeries.length && !foundLinks; ++i2) {
                foundLinks = this.timeSeries[i2].hasItemHyperlink();
            }
        }
        return foundLinks;
    }

    public void validate(JRVerifier verifier) {
        verifier.verify(this);
    }
}

