/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.io.Serializable;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRQuery;
import net.sf.jasperreports.engine.JRSortField;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;

public class JRBaseDataset
implements JRDataset,
Serializable {
    private static final long serialVersionUID = 10200L;
    protected final boolean isMain;
    protected String name = null;
    protected String scriptletClass = null;
    protected JRParameter[] parameters = null;
    protected JRQuery query = null;
    protected JRField[] fields = null;
    protected JRSortField[] sortFields = null;
    protected JRVariable[] variables = null;
    protected JRGroup[] groups = null;
    protected String resourceBundle = null;
    protected byte whenResourceMissingType = 1;
    protected JRPropertiesMap propertiesMap;
    protected JRExpression filterExpression;

    protected JRBaseDataset(boolean isMain) {
        this.isMain = isMain;
        this.propertiesMap = new JRPropertiesMap();
    }

    protected JRBaseDataset(JRDataset dataset, JRBaseObjectFactory factory) {
        JRGroup[] jrGroups;
        JRVariable[] jrVariables;
        JRSortField[] jrSortFields;
        JRField[] jrFields;
        factory.put(dataset, this);
        this.name = dataset.getName();
        this.scriptletClass = dataset.getScriptletClass();
        this.resourceBundle = dataset.getResourceBundle();
        this.whenResourceMissingType = dataset.getWhenResourceMissingType();
        this.propertiesMap = dataset.getPropertiesMap().cloneProperties();
        this.query = factory.getQuery(dataset.getQuery());
        this.isMain = dataset.isMainDataset();
        JRParameter[] jrParameters = dataset.getParameters();
        if (jrParameters != null && jrParameters.length > 0) {
            this.parameters = new JRParameter[jrParameters.length];
            for (int i2 = 0; i2 < this.parameters.length; ++i2) {
                this.parameters[i2] = factory.getParameter(jrParameters[i2]);
            }
        }
        if ((jrFields = dataset.getFields()) != null && jrFields.length > 0) {
            this.fields = new JRField[jrFields.length];
            for (int i3 = 0; i3 < this.fields.length; ++i3) {
                this.fields[i3] = factory.getField(jrFields[i3]);
            }
        }
        if ((jrSortFields = dataset.getSortFields()) != null && jrSortFields.length > 0) {
            this.sortFields = new JRSortField[jrSortFields.length];
            for (int i4 = 0; i4 < this.sortFields.length; ++i4) {
                this.sortFields[i4] = factory.getSortField(jrSortFields[i4]);
            }
        }
        if ((jrVariables = dataset.getVariables()) != null && jrVariables.length > 0) {
            this.variables = new JRVariable[jrVariables.length];
            for (int i5 = 0; i5 < this.variables.length; ++i5) {
                this.variables[i5] = factory.getVariable(jrVariables[i5]);
            }
        }
        if ((jrGroups = dataset.getGroups()) != null && jrGroups.length > 0) {
            this.groups = new JRGroup[jrGroups.length];
            for (int i6 = 0; i6 < this.groups.length; ++i6) {
                this.groups[i6] = factory.getGroup(jrGroups[i6]);
            }
        }
        this.filterExpression = factory.getExpression(dataset.getFilterExpression());
    }

    public String getName() {
        return this.name;
    }

    public String getScriptletClass() {
        return this.scriptletClass;
    }

    public JRQuery getQuery() {
        return this.query;
    }

    public JRParameter[] getParameters() {
        return this.parameters;
    }

    public JRField[] getFields() {
        return this.fields;
    }

    public JRSortField[] getSortFields() {
        return this.sortFields;
    }

    public JRVariable[] getVariables() {
        return this.variables;
    }

    public JRGroup[] getGroups() {
        return this.groups;
    }

    public boolean isMainDataset() {
        return this.isMain;
    }

    public String getResourceBundle() {
        return this.resourceBundle;
    }

    public byte getWhenResourceMissingType() {
        return this.whenResourceMissingType;
    }

    public void setWhenResourceMissingType(byte whenResourceMissingType) {
        this.whenResourceMissingType = whenResourceMissingType;
    }

    public JRPropertiesMap getPropertiesMap() {
        return this.propertiesMap;
    }

    public JRExpression getFilterExpression() {
        return this.filterExpression;
    }
}

