/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.io.Serializable;
import java.util.StringTokenizer;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionChunk;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.util.JRClassLoader;

public class JRBaseExpression
implements JRExpression,
Serializable {
    private static final long serialVersionUID = 10200L;
    protected String valueClassName = null;
    protected String valueClassRealName = null;
    protected int id = 0;
    protected transient Class valueClass = null;
    private JRExpressionChunk[] chunks = null;
    private static int lastId = 0;

    protected JRBaseExpression() {
    }

    protected JRBaseExpression(JRExpression expression, JRBaseObjectFactory factory, Integer expressionId) {
        factory.put(expression, this);
        this.valueClassName = expression.getValueClassName();
        this.id = expressionId == null ? expression.getId() : expressionId.intValue();
        JRExpressionChunk[] jrChunks = expression.getChunks();
        if (jrChunks != null && jrChunks.length > 0) {
            this.chunks = new JRExpressionChunk[jrChunks.length];
            for (int i2 = 0; i2 < this.chunks.length; ++i2) {
                this.chunks[i2] = factory.getExpressionChunk(jrChunks[i2]);
            }
        }
    }

    protected JRBaseExpression(JRExpression expression, JRBaseObjectFactory factory) {
        this(expression, factory, null);
    }

    private static synchronized int getNextId() {
        return lastId++;
    }

    public void regenerateId() {
        this.id = JRBaseExpression.getNextId();
    }

    public Class getValueClass() {
        String className;
        if (this.valueClass == null && (className = this.getValueClassRealName()) != null) {
            try {
                this.valueClass = JRClassLoader.loadClassForName(className);
            }
            catch (ClassNotFoundException e2) {
                throw new JRRuntimeException(e2);
            }
        }
        return this.valueClass;
    }

    public String getValueClassName() {
        return this.valueClassName;
    }

    private String getValueClassRealName() {
        if (this.valueClassRealName == null) {
            this.valueClassRealName = JRClassLoader.getClassRealName(this.valueClassName);
        }
        return this.valueClassRealName;
    }

    public int getId() {
        return this.id;
    }

    public JRExpressionChunk[] getChunks() {
        return this.chunks;
    }

    public String getText() {
        String text = "";
        this.chunks = this.getChunks();
        if (this.chunks != null && this.chunks.length > 0) {
            StringBuffer sbuffer = new StringBuffer();
            block6: for (int i2 = 0; i2 < this.chunks.length; ++i2) {
                switch (this.chunks[i2].getType()) {
                    case 2: {
                        sbuffer.append("$P{");
                        sbuffer.append(this.chunks[i2].getText());
                        sbuffer.append("}");
                        continue block6;
                    }
                    case 3: {
                        sbuffer.append("$F{");
                        sbuffer.append(this.chunks[i2].getText());
                        sbuffer.append("}");
                        continue block6;
                    }
                    case 4: {
                        sbuffer.append("$V{");
                        sbuffer.append(this.chunks[i2].getText());
                        sbuffer.append("}");
                        continue block6;
                    }
                    case 5: {
                        sbuffer.append("$R{");
                        sbuffer.append(this.chunks[i2].getText());
                        sbuffer.append("}");
                        continue block6;
                    }
                    default: {
                        String textChunk = this.chunks[i2].getText();
                        String escapedText = this.escapeTextChunk(textChunk);
                        sbuffer.append(escapedText);
                        continue block6;
                    }
                }
            }
            text = sbuffer.toString();
        }
        return text;
    }

    protected String escapeTextChunk(String text) {
        if (text == null || text.indexOf(36) < 0) {
            return text;
        }
        StringBuffer sb = new StringBuffer(text.length() + 4);
        StringTokenizer tkzer = new StringTokenizer(text, "$", true);
        boolean wasDelim = false;
        while (tkzer.hasMoreElements()) {
            String token = tkzer.nextToken();
            if (wasDelim && (token.startsWith("P{") || token.startsWith("F{") || token.startsWith("V{") || token.startsWith("R{")) && token.indexOf(125) > 0) {
                sb.append('$');
            }
            sb.append(token);
            wasDelim = token.equals("$");
        }
        return sb.toString();
    }
}

