/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JRTextExporterParameter;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.JRStyledTextParser;
import org.xml.sax.SAXException;

public class JRTextExporter
extends JRAbstractExporter {
    protected int pageWidth;
    protected int pageHeight;
    protected int characterHeight;
    protected int characterWidth;
    protected JRExportProgressMonitor progressMonitor;
    protected Writer writer;
    char[][] pageData;
    protected String betweenPagesText;
    protected String lineSeparator;
    protected static final String systemLineSeparator = System.getProperty("line.separator");
    protected JRStyledTextParser styledTextParser = new JRStyledTextParser();

    public void exportReport() throws JRException {
        StringBuffer sb;
        Integer characterHeightParam;
        Integer characterWidthParam;
        String encoding;
        this.progressMonitor = (JRExportProgressMonitor)this.parameters.get(JRExporterParameter.PROGRESS_MONITOR);
        this.setOffset();
        this.setInput();
        if (!this.isModeBatch) {
            this.setPageRange();
        }
        if ((encoding = (String)this.parameters.get(JRExporterParameter.CHARACTER_ENCODING)) == null) {
            encoding = "ISO-8859-1";
        }
        if ((characterWidthParam = (Integer)this.parameters.get(JRTextExporterParameter.CHARACTER_WIDTH)) != null) {
            this.characterWidth = characterWidthParam;
            if (this.characterWidth < 0) {
                throw new JRException("Character width must be greater than 0");
            }
        } else {
            Integer pageWidthParam = (Integer)this.parameters.get(JRTextExporterParameter.PAGE_WIDTH);
            if (pageWidthParam != null) {
                this.pageWidth = pageWidthParam;
                if (this.pageWidth <= 0) {
                    throw new JRException("Page width must be greater than 0");
                }
            } else {
                throw new JRException("Character or page width must be specified");
            }
        }
        if ((characterHeightParam = (Integer)this.parameters.get(JRTextExporterParameter.CHARACTER_HEIGHT)) != null) {
            this.characterHeight = characterHeightParam;
            if (this.characterHeight < 0) {
                throw new JRException("Character height must be greater than 0");
            }
        } else {
            Integer pageHeightParam = (Integer)this.parameters.get(JRTextExporterParameter.PAGE_HEIGHT);
            if (pageHeightParam != null) {
                this.pageHeight = pageHeightParam;
                if (this.pageHeight <= 0) {
                    throw new JRException("Page height must be greater than 0");
                }
            } else {
                throw new JRException("Character or page height must be specified");
            }
        }
        this.betweenPagesText = (String)this.parameters.get(JRTextExporterParameter.BETWEEN_PAGES_TEXT);
        if (this.betweenPagesText == null) {
            this.betweenPagesText = systemLineSeparator + systemLineSeparator;
        }
        this.lineSeparator = (String)this.parameters.get(JRTextExporterParameter.LINE_SEPARATOR);
        if (this.lineSeparator == null) {
            this.lineSeparator = systemLineSeparator;
        }
        if ((sb = (StringBuffer)this.parameters.get(JRExporterParameter.OUTPUT_STRING_BUFFER)) != null) {
            try {
                this.writer = new StringWriter();
                this.exportReportToWriter();
                sb.append(this.writer.toString());
            }
            catch (IOException e2) {
                throw new JRException("Error writing to StringBuffer writer : " + this.jasperPrint.getName(), e2);
            }
            finally {
                if (this.writer != null) {
                    try {
                        this.writer.close();
                    }
                    catch (IOException e3) {}
                }
            }
        }
        this.writer = (Writer)this.parameters.get(JRExporterParameter.OUTPUT_WRITER);
        if (this.writer != null) {
            try {
                this.exportReportToWriter();
            }
            catch (IOException e4) {
                throw new JRException("Error writing to writer : " + this.jasperPrint.getName(), e4);
            }
        }
        OutputStream os = (OutputStream)this.parameters.get(JRExporterParameter.OUTPUT_STREAM);
        if (os != null) {
            try {
                this.writer = new OutputStreamWriter(os, encoding);
                this.exportReportToWriter();
            }
            catch (IOException e5) {
                throw new JRException("Error writing to OutputStream writer : " + this.jasperPrint.getName(), e5);
            }
        }
        File destFile = (File)this.parameters.get(JRExporterParameter.OUTPUT_FILE);
        if (destFile == null) {
            String fileName = (String)this.parameters.get(JRExporterParameter.OUTPUT_FILE_NAME);
            if (fileName != null) {
                destFile = new File(fileName);
            } else {
                throw new JRException("No output specified for the exporter.");
            }
        }
        try {
            os = new FileOutputStream(destFile);
            this.writer = new OutputStreamWriter(os, encoding);
            this.exportReportToWriter();
        }
        catch (IOException e6) {
            throw new JRException("Error writing to file writer : " + this.jasperPrint.getName(), e6);
        }
        finally {
            if (this.writer != null) {
                try {
                    this.writer.close();
                }
                catch (IOException e7) {}
            }
        }
    }

    protected void exportReportToWriter() throws JRException, IOException {
        for (int reportIndex = 0; reportIndex < this.jasperPrintList.size(); ++reportIndex) {
            this.jasperPrint = (JasperPrint)this.jasperPrintList.get(reportIndex);
            List pages = this.jasperPrint.getPages();
            if (pages == null || pages.size() <= 0) continue;
            if (this.isModeBatch) {
                this.startPageIndex = 0;
                this.endPageIndex = pages.size() - 1;
            }
            if (this.characterWidth > 0) {
                this.pageWidth = this.jasperPrint.getPageWidth() / this.characterWidth;
            }
            if (this.characterHeight > 0) {
                this.pageHeight = this.jasperPrint.getPageHeight() / this.characterHeight;
            }
            for (int i2 = this.startPageIndex; i2 <= this.endPageIndex; ++i2) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new JRException("Current thread interrupted.");
                }
                JRPrintPage page = (JRPrintPage)pages.get(i2);
                this.exportPage(page);
            }
        }
        this.writer.flush();
    }

    protected void exportPage(JRPrintPage page) throws IOException {
        int i2;
        List elements = page.getElements();
        this.pageData = new char[this.pageHeight][];
        for (i2 = 0; i2 < this.pageHeight; ++i2) {
            this.pageData[i2] = new char[this.pageWidth];
            Arrays.fill(this.pageData[i2], ' ');
        }
        this.exportElements(elements);
        for (i2 = 0; i2 < this.pageHeight; ++i2) {
            this.writer.write(this.pageData[i2]);
            this.writer.write(this.lineSeparator);
        }
        this.writer.write(this.betweenPagesText);
        if (this.progressMonitor != null) {
            this.progressMonitor.afterPageExport();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exportElements(List elements) {
        for (int i2 = 0; i2 < elements.size(); ++i2) {
            Object element = elements.get(i2);
            if (element instanceof JRPrintText) {
                this.exportText((JRPrintText)element);
                continue;
            }
            if (!(element instanceof JRPrintFrame)) continue;
            JRPrintFrame frame = (JRPrintFrame)element;
            this.setFrameElementsOffset(frame, false);
            try {
                this.exportElements(frame.getElements());
                continue;
            }
            finally {
                this.restoreElementOffsets();
            }
        }
    }

    protected void exportText(JRPrintText element) {
        int rowCount = this.calculateYCoord(element.getHeight());
        int columnCount = this.calculateXCoord(element.getWidth());
        int x = this.calculateXCoord(element.getX() + this.getOffsetX());
        int y = this.calculateYCoord(element.getY() + this.getOffsetY());
        JRStyledText styledText = this.getStyledText(element);
        String allText = styledText == null ? "" : styledText.getText();
        if (rowCount <= 0 || columnCount <= 0) {
            return;
        }
        if (allText != null && allText.length() == 0) {
            return;
        }
        StringBuffer[] rows = new StringBuffer[rowCount];
        rows[0] = new StringBuffer();
        int rowIndex = 0;
        int rowPosition = 0;
        StringTokenizer lfTokenizer = new StringTokenizer(allText, "\n");
        block0: while (lfTokenizer.hasMoreTokens()) {
            String line = lfTokenizer.nextToken();
            StringTokenizer spaceTokenizer = new StringTokenizer(line, " ", true);
            while (spaceTokenizer.hasMoreTokens()) {
                String word = spaceTokenizer.nextToken();
                while (word.length() > columnCount) {
                    rows[rowIndex].append(word.substring(0, columnCount - rowPosition));
                    word = word.substring(columnCount - rowPosition, word.length());
                    if (++rowIndex == rowCount) break block0;
                    rowPosition = 0;
                    rows[rowIndex] = new StringBuffer();
                }
                if (rowPosition + word.length() > columnCount) {
                    if (++rowIndex == rowCount) break block0;
                    rowPosition = 0;
                    rows[rowIndex] = new StringBuffer();
                }
                if (rowIndex > 9 && rowPosition == 0 && word.equals(" ")) break;
                rows[rowIndex].append(word);
                rowPosition += word.length();
            }
            if (++rowIndex == rowCount) break;
            rowPosition = 0;
            rows[rowIndex] = new StringBuffer();
        }
        int xOffset = 0;
        int yOffset = 0;
        if (element.getVerticalAlignment() == 3) {
            yOffset = rowCount - rowIndex;
        }
        if (element.getVerticalAlignment() == 2) {
            yOffset = (rowCount - rowIndex) / 2;
        }
        for (int i2 = 0; i2 < rowIndex; ++i2) {
            int pos;
            String line = rows[i2].toString();
            for (pos = line.length() - 1; pos >= 0 && line.charAt(pos) == ' '; --pos) {
            }
            line = line.substring(0, pos + 1);
            if (element.getHorizontalAlignment() == 3) {
                xOffset = columnCount - line.length();
            }
            if (element.getHorizontalAlignment() == 2) {
                xOffset = (columnCount - line.length()) / 2;
            }
            if (element.getHorizontalAlignment() == 4 && i2 < rowIndex - 1) {
                line = this.justifyText(line, columnCount);
            }
            char[] chars = line.toCharArray();
            System.arraycopy(chars, 0, this.pageData[y + yOffset + i2], x + xOffset, chars.length);
        }
    }

    private String justifyText(String s, int width) {
        StringBuffer justified = new StringBuffer();
        StringTokenizer t = new StringTokenizer(s, " ");
        int tokenCount = t.countTokens();
        if (tokenCount <= 1) {
            return s;
        }
        String[] words = new String[tokenCount];
        int i2 = 0;
        while (t.hasMoreTokens()) {
            words[i2++] = t.nextToken();
        }
        int emptySpace = width - s.length() + (words.length - 1);
        int spaceCount = emptySpace / (words.length - 1);
        int remainingSpace = emptySpace % (words.length - 1);
        char[] spaces = new char[spaceCount];
        Arrays.fill(spaces, ' ');
        for (i2 = 0; i2 < words.length - 1; ++i2) {
            justified.append(words[i2]);
            justified.append(spaces);
            if (i2 >= remainingSpace) continue;
            justified.append(' ');
        }
        justified.append(words[words.length - 1]);
        return justified.toString();
    }

    protected int calculateYCoord(int y) {
        return this.pageHeight * y / this.jasperPrint.getPageHeight();
    }

    protected int calculateXCoord(int x) {
        return this.pageWidth * x / this.jasperPrint.getPageWidth();
    }

    protected JRStyledText getStyledText(JRPrintText textElement) {
        JRStyledText styledText = null;
        String text = textElement.getText();
        if (text != null) {
            if (textElement.isStyledText()) {
                try {
                    styledText = this.styledTextParser.parse(null, text);
                }
                catch (SAXException e2) {
                    // empty catch block
                }
            }
            if (styledText == null) {
                styledText = new JRStyledText();
                styledText.append(text);
                styledText.addRun(new JRStyledText.Run(null, 0, text.length()));
            }
        }
        return styledText;
    }
}

