/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.oasis;

import java.awt.Color;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintEllipse;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPrintRectangle;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JRHyperlinkProducerFactory;
import net.sf.jasperreports.engine.export.oasis.ContentBuilder;
import net.sf.jasperreports.engine.export.oasis.StyleBuilder;
import net.sf.jasperreports.engine.export.oasis.StyleCache;
import net.sf.jasperreports.engine.export.oasis.Utility;
import net.sf.jasperreports.engine.export.oasis.zip.FileBufferedOasisZip;
import net.sf.jasperreports.engine.export.oasis.zip.FileBufferedOasisZipEntry;
import net.sf.jasperreports.engine.util.JRStringUtil;
import net.sf.jasperreports.engine.util.JRStyledText;

public class JROdtFrameExporter
extends JRAbstractExporter {
    public static final String VERSION = "1.0";
    protected static final String JR_PAGE_ANCHOR_PREFIX = "JR_PAGE_ANCHOR_";
    public static final String IMAGE_NAME_PREFIX = "img_";
    protected static final int IMAGE_NAME_PREFIX_LEGTH = "img_".length();
    protected Writer tempBodyWriter = null;
    protected Writer tempStyleWriter = null;
    protected JRExportProgressMonitor progressMonitor = null;
    protected Map rendererToImagePathMap = null;
    protected Map imageMaps;
    protected List imagesToProcess = null;
    protected int reportIndex = 0;
    protected int pageIndex = 0;
    protected int tableIndex = 0;
    protected String encoding = null;
    protected boolean isWrapBreakWord = false;
    protected Map fontMap = null;
    private LinkedList backcolorStack = new LinkedList();
    private Color backcolor = null;
    private StyleCache styleCache = null;
    protected JRHyperlinkProducerFactory hyperlinkProducerFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportReport() throws JRException {
        block21: {
            this.progressMonitor = (JRExportProgressMonitor)this.parameters.get(JRExporterParameter.PROGRESS_MONITOR);
            this.setOffset();
            try {
                this.setExportContext();
                this.setInput();
                if (!this.isModeBatch) {
                    this.setPageRange();
                }
                this.encoding = (String)this.parameters.get(JRExporterParameter.CHARACTER_ENCODING);
                if (this.encoding == null) {
                    this.encoding = "UTF-8";
                }
                this.rendererToImagePathMap = new HashMap();
                this.imageMaps = new HashMap();
                this.imagesToProcess = new ArrayList();
                this.fontMap = (Map)this.parameters.get(JRExporterParameter.FONT_MAP);
                this.setHyperlinkProducerFactory();
                OutputStream os = (OutputStream)this.parameters.get(JRExporterParameter.OUTPUT_STREAM);
                if (os != null) {
                    try {
                        this.exportReportToOasisZip(os);
                        break block21;
                    }
                    catch (IOException e2) {
                        throw new JRException("Error trying to export to output stream : " + this.jasperPrint.getName(), e2);
                    }
                }
                File destFile = (File)this.parameters.get(JRExporterParameter.OUTPUT_FILE);
                if (destFile == null) {
                    String fileName = (String)this.parameters.get(JRExporterParameter.OUTPUT_FILE_NAME);
                    if (fileName != null) {
                        destFile = new File(fileName);
                    } else {
                        throw new JRException("No output specified for the exporter.");
                    }
                }
                try {
                    os = new FileOutputStream(destFile);
                    this.exportReportToOasisZip(os);
                }
                catch (IOException e3) {
                    throw new JRException("Error trying to export to file : " + destFile, e3);
                }
                finally {
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (IOException e4) {}
                    }
                }
            }
            finally {
                this.resetExportContext();
            }
        }
    }

    protected void setHyperlinkProducerFactory() {
        this.hyperlinkProducerFactory = (JRHyperlinkProducerFactory)this.parameters.get(JRExporterParameter.HYPERLINK_PRODUCER_FACTORY);
    }

    protected void exportReportToOasisZip(OutputStream os) throws JRException, IOException {
        FileBufferedOasisZip oasisZip = new FileBufferedOasisZip();
        FileBufferedOasisZipEntry tempBodyEntry = new FileBufferedOasisZipEntry(null);
        FileBufferedOasisZipEntry tempStyleEntry = new FileBufferedOasisZipEntry(null);
        this.tempBodyWriter = tempBodyEntry.getWriter();
        this.tempStyleWriter = tempStyleEntry.getWriter();
        this.styleCache = new StyleCache(this.tempStyleWriter, this.fontMap);
        Writer stylesWriter = oasisZip.getStylesEntry().getWriter();
        StyleBuilder styleBuilder = new StyleBuilder(this.jasperPrintList, stylesWriter);
        styleBuilder.build();
        stylesWriter.close();
        this.reportIndex = 0;
        while (this.reportIndex < this.jasperPrintList.size()) {
            this.jasperPrint = (JasperPrint)this.jasperPrintList.get(this.reportIndex);
            List pages = this.jasperPrint.getPages();
            if (pages != null && pages.size() > 0) {
                if (this.isModeBatch) {
                    this.startPageIndex = 0;
                    this.endPageIndex = pages.size() - 1;
                }
                JRPrintPage page = null;
                this.pageIndex = this.startPageIndex;
                while (this.pageIndex <= this.endPageIndex) {
                    if (Thread.currentThread().isInterrupted()) {
                        throw new JRException("Current thread interrupted.");
                    }
                    page = (JRPrintPage)pages.get(this.pageIndex);
                    this.exportPage(page);
                    ++this.pageIndex;
                }
            }
            ++this.reportIndex;
        }
        this.tempBodyWriter.flush();
        this.tempStyleWriter.flush();
        this.tempBodyWriter.close();
        this.tempStyleWriter.close();
        ContentBuilder contentBuilder = new ContentBuilder(oasisZip.getContentEntry(), tempStyleEntry, tempBodyEntry, this.styleCache.getFontFaces());
        contentBuilder.build();
        oasisZip.zipEntries(os);
        oasisZip.dispose();
    }

    protected void exportPage(JRPrintPage page) throws JRException, IOException {
        List elements = page.getElements();
        this.exportElements(elements);
        if (this.progressMonitor != null) {
            this.progressMonitor.afterPageExport();
        }
    }

    protected void exportElements(Collection elements) throws IOException, JRException {
        if (elements != null && elements.size() > 0) {
            Iterator it = elements.iterator();
            while (it.hasNext()) {
                JRPrintElement element = (JRPrintElement)it.next();
                if (element instanceof JRPrintLine) {
                    this.exportLine((JRPrintLine)element);
                    continue;
                }
                if (element instanceof JRPrintRectangle) {
                    this.exportRectangle((JRPrintRectangle)element);
                    continue;
                }
                if (element instanceof JRPrintEllipse) {
                    this.exportEllipse((JRPrintEllipse)element);
                    continue;
                }
                if (element instanceof JRPrintImage) continue;
                if (element instanceof JRPrintText) {
                    this.exportText((JRPrintText)element);
                    continue;
                }
                if (!(element instanceof JRPrintFrame)) continue;
            }
        }
    }

    protected void exportLine(JRPrintLine line) throws IOException {
        this.tempBodyWriter.write("\n<draw:line text:anchor-type=\"page\" text:anchor-page-number=\"" + (this.pageIndex + 1) + "\"" + " svg:x2=\"" + Utility.translatePixelsToInches(line.getX() + line.getWidth()) + "in\"" + " svg:y2=\"" + Utility.translatePixelsToInches(line.getY() + line.getHeight()) + "in\"" + " svg:x1=\"" + Utility.translatePixelsToInches(line.getX()) + "in\"" + " svg:y1=\"" + Utility.translatePixelsToInches(line.getY()) + "in\">" + " draw:style-name=\"" + this.styleCache.getGraphicStyle(line) + "\"" + "</draw:line>");
    }

    protected void exportRectangle(JRPrintRectangle rectangle) throws IOException {
        this.tempBodyWriter.write("<draw:rect text:anchor-type=\"page\" text:anchor-page-number=\"" + (this.pageIndex + 1) + "\"" + " svg:x=\"" + Utility.translatePixelsToInches(rectangle.getX()) + "in\"" + " svg:y=\"" + Utility.translatePixelsToInches(rectangle.getY()) + "in\"" + " svg:width=\"" + Utility.translatePixelsToInches(rectangle.getWidth()) + "in\"" + " svg:height=\"" + Utility.translatePixelsToInches(rectangle.getHeight()) + "in\"" + "></draw:rect>");
    }

    protected void exportEllipse(JRPrintEllipse ellipse) throws IOException {
        this.tempBodyWriter.write("<draw:ellipse text:anchor-type=\"page\" text:anchor-page-number=\"" + (this.pageIndex + 1) + "\"" + " svg:x=\"" + Utility.translatePixelsToInches(ellipse.getX()) + "in\"" + " svg:y=\"" + Utility.translatePixelsToInches(ellipse.getY()) + "in\"" + " svg:width=\"" + Utility.translatePixelsToInches(ellipse.getWidth()) + "in\"" + " svg:height=\"" + Utility.translatePixelsToInches(ellipse.getHeight()) + "in\"" + "></draw:ellipse>");
    }

    protected void exportText(JRPrintText text) throws IOException {
        JRStyledText styledText = this.getStyledText(text);
        int textLength = 0;
        if (styledText != null) {
            textLength = styledText.length();
        }
        this.tempBodyWriter.write("<draw:frame text:anchor-type=\"page\" text:anchor-page-number=\"" + (this.pageIndex + 1) + "\"" + " draw:style-name=\"" + this.styleCache.getFrameStyle(text) + "\"" + " svg:x=\"" + Utility.translatePixelsToInches(text.getX()) + "in\"" + " svg:y=\"" + Utility.translatePixelsToInches(text.getY()) + "in\"" + " svg:width=\"" + Utility.translatePixelsToInches(text.getWidth()) + "in\"" + " svg:height=\"" + Utility.translatePixelsToInches(text.getHeight()) + "in\"" + "><draw:text-box>");
        this.tempBodyWriter.write("<text:p");
        this.tempBodyWriter.write(" text:style-name=\"" + this.styleCache.getParagraphStyle(text) + "\"");
        this.tempBodyWriter.write(">");
        if (textLength > 0) {
            this.exportStyledText(styledText);
        }
        this.tempBodyWriter.write("</text:p>\n");
        this.tempBodyWriter.write("</draw:text-box></draw:frame>");
    }

    protected void exportStyledText(JRStyledText styledText) throws IOException {
        String text = styledText.getText();
        int runLimit = 0;
        AttributedCharacterIterator iterator = styledText.getAttributedString().getIterator();
        while (runLimit < styledText.length() && (runLimit = iterator.getRunLimit()) <= styledText.length()) {
            this.exportStyledTextRun(iterator.getAttributes(), text.substring(iterator.getIndex(), runLimit));
            iterator.setIndex(runLimit);
        }
    }

    protected void exportStyledTextRun(Map attributes, String text) throws IOException {
        String textRunStyleName = this.styleCache.getTextSpanStyle(attributes, text);
        this.tempBodyWriter.write("<text:span");
        this.tempBodyWriter.write(" text:style-name=\"" + textRunStyleName + "\"");
        this.tempBodyWriter.write(">");
        if (text != null) {
            this.tempBodyWriter.write(Utility.replaceNewLineWithLineBreak(JRStringUtil.xmlEncode(text)));
        }
        this.tempBodyWriter.write("</text:span>");
    }
}

