/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.io.Serializable;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.fill.JRFillBand;

public class JREvaluationTime
implements Serializable {
    private static final long serialVersionUID = 10200L;
    public static final JREvaluationTime EVALUATION_TIME_REPORT = new JREvaluationTime(2, null, null);
    public static final JREvaluationTime EVALUATION_TIME_PAGE = new JREvaluationTime(3, null, null);
    public static final JREvaluationTime EVALUATION_TIME_COLUMN = new JREvaluationTime(4, null, null);
    public static final JREvaluationTime EVALUATION_TIME_NOW = new JREvaluationTime(1, null, null);
    private final byte type;
    private final String groupName;
    private final int bandId;
    private final int hash;

    public static JREvaluationTime getGroupEvaluationTime(String groupName) {
        return new JREvaluationTime(5, groupName, null);
    }

    public static JREvaluationTime getBandEvaluationTime(JRFillBand band) {
        return new JREvaluationTime(6, null, band);
    }

    public static JREvaluationTime getEvaluationTime(byte type, JRGroup group, JRFillBand band) {
        JREvaluationTime evaluationTime;
        switch (type) {
            case 2: {
                evaluationTime = EVALUATION_TIME_REPORT;
                break;
            }
            case 3: {
                evaluationTime = EVALUATION_TIME_PAGE;
                break;
            }
            case 4: {
                evaluationTime = EVALUATION_TIME_COLUMN;
                break;
            }
            case 5: {
                evaluationTime = JREvaluationTime.getGroupEvaluationTime(group.getName());
                break;
            }
            case 6: {
                evaluationTime = JREvaluationTime.getBandEvaluationTime(band);
                break;
            }
            default: {
                evaluationTime = null;
            }
        }
        return evaluationTime;
    }

    private JREvaluationTime(byte type, String groupName, JRFillBand band) {
        this.type = type;
        this.groupName = groupName;
        this.bandId = band == null ? 0 : band.getId();
        this.hash = this.computeHash();
    }

    private int computeHash() {
        int hashCode = this.type;
        hashCode = 31 * hashCode + (this.groupName == null ? 0 : this.groupName.hashCode());
        hashCode = 31 * hashCode + this.bandId;
        return hashCode;
    }

    public boolean equals(Object obj) {
        boolean eq;
        if (obj == this) {
            return true;
        }
        JREvaluationTime e2 = (JREvaluationTime)obj;
        boolean bl = eq = e2.type == this.type;
        if (eq) {
            switch (this.type) {
                case 5: {
                    eq = this.groupName.equals(e2.groupName);
                    break;
                }
                case 6: {
                    eq = this.bandId == e2.bandId;
                }
            }
        }
        return eq;
    }

    public int hashCode() {
        return this.hash;
    }
}

