/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.JRConditionalStyle;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRFrame;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintElementContainer;
import net.sf.jasperreports.engine.JRReportFont;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.base.JRBaseStyle;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRFillBreak;
import net.sf.jasperreports.engine.fill.JRFillCloneFactory;
import net.sf.jasperreports.engine.fill.JRFillCrosstab;
import net.sf.jasperreports.engine.fill.JRFillElement;
import net.sf.jasperreports.engine.fill.JRFillElementGroup;
import net.sf.jasperreports.engine.fill.JRFillExpressionEvaluator;
import net.sf.jasperreports.engine.fill.JRFillFrame;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRFillSubreport;
import net.sf.jasperreports.engine.fill.JRYComparator;
import net.sf.jasperreports.engine.util.JRStyleResolver;

public abstract class JRFillElementContainer
extends JRFillElementGroup {
    protected JRBaseFiller filler;
    private JRFillElement[] ySortedElements = null;
    private JRFillElement[] stretchElements = null;
    private JRFillElement[] bandBottomElements = null;
    private JRFillElement[] removableElements = null;
    private boolean willOverflow = false;
    protected boolean isOverflow = false;
    private int stretchHeight = 0;
    private int firstY = 0;
    protected JRFillElement firstYElement = null;
    protected final JRFillExpressionEvaluator expressionEvaluator;
    protected JRFillElement[] deepElements;
    protected Set stylesToEvaluate = new HashSet();
    protected Map evaluatedStyles = new HashMap();
    protected boolean hasPrintWhenOverflowElement;

    protected JRFillElementContainer(JRBaseFiller filler, JRElementGroup container, JRFillObjectFactory factory) {
        super(container, factory);
        this.expressionEvaluator = factory.getExpressionEvaluator();
        this.initDeepElements();
        this.filler = filler;
    }

    protected JRFillElementContainer(JRFillElementContainer container, JRFillCloneFactory factory) {
        super(container, factory);
        this.expressionEvaluator = container.expressionEvaluator;
        this.initDeepElements();
        this.filler = container.filler;
    }

    private void initDeepElements() {
        if (this.elements == null) {
            this.deepElements = new JRFillElement[0];
        } else {
            ArrayList deepElementsList = new ArrayList(this.elements.length);
            JRFillElementContainer.collectDeepElements(this.elements, deepElementsList);
            this.deepElements = new JRFillElement[deepElementsList.size()];
            deepElementsList.toArray(this.deepElements);
        }
    }

    private static void collectDeepElements(JRElement[] elements, List deepElementsList) {
        for (int i2 = 0; i2 < elements.length; ++i2) {
            JRElement element = elements[i2];
            deepElementsList.add(element);
            if (!(element instanceof JRFillFrame)) continue;
            JRFrame frame = (JRFrame)element;
            JRFillElementContainer.collectDeepElements(frame.getElements(), deepElementsList);
        }
    }

    protected final void initElements() {
        this.hasPrintWhenOverflowElement = false;
        if (this.elements != null && this.elements.length > 0) {
            ArrayList<JRFillElement> sortedElemsList = new ArrayList<JRFillElement>();
            ArrayList<JRFillElement> stretchElemsList = new ArrayList<JRFillElement>();
            ArrayList<JRFillElement> bandBottomElemsList = new ArrayList<JRFillElement>();
            ArrayList<JRFillElement> removableElemsList = new ArrayList<JRFillElement>();
            for (int i2 = 0; i2 < this.elements.length; ++i2) {
                JRFillElement element = this.elements[i2];
                sortedElemsList.add(element);
                if (element.getPositionType() == 3) {
                    bandBottomElemsList.add(element);
                }
                if (element.getStretchType() != 0) {
                    stretchElemsList.add(element);
                }
                if (element.isRemoveLineWhenBlank()) {
                    removableElemsList.add(element);
                }
                if (!element.isPrintWhenDetailOverflows()) continue;
                this.hasPrintWhenOverflowElement = true;
            }
            Collections.sort(sortedElemsList, new JRYComparator());
            this.ySortedElements = new JRFillElement[this.elements.length];
            sortedElemsList.toArray(this.ySortedElements);
            this.stretchElements = new JRFillElement[stretchElemsList.size()];
            stretchElemsList.toArray(this.stretchElements);
            this.bandBottomElements = new JRFillElement[bandBottomElemsList.size()];
            bandBottomElemsList.toArray(this.bandBottomElements);
            this.removableElements = new JRFillElement[removableElemsList.size()];
            removableElemsList.toArray(this.removableElements);
        }
        this.setDependentElements();
        this.setElementsBandBottomY();
    }

    protected final void setElementsBandBottomY() {
        if (this.elements != null && this.elements.length > 0) {
            for (int i2 = 0; i2 < this.elements.length; ++i2) {
                this.elements[i2].setBandBottomY(this.getContainerHeight() - this.elements[i2].getY() - this.elements[i2].getHeight());
            }
        }
    }

    private void setDependentElements() {
        if (this.ySortedElements != null && this.ySortedElements.length > 0) {
            for (int i2 = 0; i2 < this.ySortedElements.length - 1; ++i2) {
                JRFillElement iElem = this.ySortedElements[i2];
                boolean isBreakElem = iElem instanceof JRFillBreak;
                for (int j2 = i2 + 1; j2 < this.ySortedElements.length; ++j2) {
                    JRFillElement jElem = this.ySortedElements[j2];
                    int left = Math.min(iElem.getX(), jElem.getX());
                    int right = Math.max(iElem.getX() + iElem.getWidth(), jElem.getX() + jElem.getWidth());
                    if ((!isBreakElem || jElem.getPositionType() != 2) && jElem.getPositionType() != 1 || iElem.getY() + iElem.getHeight() > jElem.getY() || iElem.getWidth() + jElem.getWidth() <= right - left) continue;
                    iElem.addDependantElement(jElem);
                }
            }
        }
    }

    protected void evaluate(byte evaluation) throws JRException {
        JRElement[] allElements = this.getElements();
        if (allElements != null && allElements.length > 0) {
            for (int i2 = 0; i2 < allElements.length; ++i2) {
                JRFillElement element = (JRFillElement)allElements[i2];
                element.setCurrentEvaluation(evaluation);
                element.evaluate(evaluation);
            }
        }
    }

    protected void resetElements() {
        if (this.ySortedElements != null && this.ySortedElements.length > 0) {
            for (int i2 = 0; i2 < this.ySortedElements.length; ++i2) {
                JRFillElement element = this.ySortedElements[i2];
                element.reset();
                if (this.isOverflow) continue;
                element.setAlreadyPrinted(false);
            }
        }
    }

    protected boolean willOverflow() {
        return this.willOverflow;
    }

    protected void initFill() {
        this.isOverflow = this.willOverflow;
        this.firstY = 0;
        this.firstYElement = null;
    }

    protected void prepareElements(int availableStretchHeight, boolean isOverflowAllowed) throws JRException {
        boolean tmpWillOverflow = false;
        int maxBandStretch = 0;
        int bandStretch = 0;
        this.firstY = this.isOverflow ? this.getContainerHeight() : 0;
        this.firstYElement = null;
        boolean isFirstYFound = false;
        if (this.ySortedElements != null && this.ySortedElements.length > 0) {
            for (int i2 = 0; i2 < this.ySortedElements.length; ++i2) {
                JRFillElement element = this.ySortedElements[i2];
                tmpWillOverflow = element.prepare(availableStretchHeight + this.getElementFirstY(element), this.isOverflow) || tmpWillOverflow;
                element.moveDependantElements();
                if (!element.isToPrint()) continue;
                if (this.isOverflow) {
                    if (element.isReprinted()) {
                        this.firstY = 0;
                    } else if (!isFirstYFound) {
                        this.firstY = element.getY();
                    }
                    isFirstYFound = true;
                }
                this.firstYElement = element;
                bandStretch = element.getRelativeY() + element.getStretchHeight() - this.getContainerHeight() + element.getBandBottomY();
                if (bandStretch <= maxBandStretch) continue;
                maxBandStretch = bandStretch;
            }
        }
        if (maxBandStretch > availableStretchHeight + this.firstY) {
            tmpWillOverflow = true;
        }
        this.stretchHeight = tmpWillOverflow ? this.getContainerHeight() + availableStretchHeight : this.getContainerHeight() + maxBandStretch;
        this.willOverflow = tmpWillOverflow && isOverflowAllowed;
    }

    private int getElementFirstY(JRFillElement element) {
        int elemFirstY = !this.isOverflow || this.hasPrintWhenOverflowElement ? 0 : (element.getY() >= this.firstY ? this.firstY : element.getY());
        return elemFirstY;
    }

    protected void setStretchHeight(int stretchHeight) {
        if (stretchHeight > this.stretchHeight) {
            this.stretchHeight = stretchHeight;
        }
    }

    protected void stretchElements() {
        JRFillElement element;
        int i2;
        if (this.stretchElements != null && this.stretchElements.length > 0) {
            for (i2 = 0; i2 < this.stretchElements.length; ++i2) {
                element = this.stretchElements[i2];
                element.stretchElement(this.stretchHeight - this.getContainerHeight());
                element.moveDependantElements();
            }
        }
        if (this.ySortedElements != null && this.ySortedElements.length > 0) {
            for (i2 = 0; i2 < this.ySortedElements.length; ++i2) {
                element = this.ySortedElements[i2];
                element.stretchHeightFinal();
            }
        }
    }

    protected int getStretchHeight() {
        return this.stretchHeight;
    }

    protected void moveBandBottomElements() {
        if (this.bandBottomElements != null && this.bandBottomElements.length > 0) {
            for (int i2 = 0; i2 < this.bandBottomElements.length; ++i2) {
                JRFillElement element = this.bandBottomElements[i2];
                element.setRelativeY(element.getY() + this.stretchHeight - this.getContainerHeight());
                element.setToPrint(element.isToPrint() && !this.willOverflow);
            }
        }
    }

    protected void removeBlankElements() {
        JRFillElement[] remElems = this.removableElements;
        if (remElems != null && remElems.length > 0) {
            JRFillElement[] elems = this.ySortedElements;
            for (int i2 = 0; i2 < remElems.length; ++i2) {
                JRFillElement jElem;
                int j2;
                JRFillElement iElem = remElems[i2];
                int blankHeight = iElem.isToPrint() ? iElem.getHeight() - iElem.getStretchHeight() : iElem.getHeight();
                if (blankHeight <= 0 || iElem.getRelativeY() + iElem.getStretchHeight() > this.stretchHeight || iElem.getRelativeY() < this.firstY) continue;
                int blankY = iElem.getRelativeY() + iElem.getHeight() - blankHeight;
                boolean isToRemove = true;
                for (j2 = 0; j2 < elems.length; ++j2) {
                    jElem = elems[j2];
                    if (iElem == jElem || !jElem.isToPrint()) continue;
                    int top = Math.min(blankY, jElem.getRelativeY());
                    int bottom = Math.max(blankY + blankHeight, jElem.getRelativeY() + jElem.getStretchHeight());
                    if (blankHeight + jElem.getStretchHeight() <= bottom - top) continue;
                    isToRemove = false;
                    break;
                }
                if (!isToRemove) continue;
                for (j2 = 0; j2 < elems.length; ++j2) {
                    jElem = elems[j2];
                    if (jElem.getRelativeY() < blankY + blankHeight) continue;
                    jElem.setRelativeY(jElem.getRelativeY() - blankHeight);
                }
                this.stretchHeight -= blankHeight;
            }
        }
    }

    protected void fillElements(JRPrintElementContainer printContainer) throws JRException {
        JRElement[] allElements = this.getElements();
        if (allElements != null && allElements.length > 0) {
            for (int i2 = 0; i2 < allElements.length; ++i2) {
                JRPrintElement printElement;
                JRFillElement element = (JRFillElement)allElements[i2];
                element.setRelativeY(element.getRelativeY() - this.firstY);
                if (element.getRelativeY() + element.getStretchHeight() > this.stretchHeight) {
                    element.setToPrint(false);
                }
                element.setAlreadyPrinted(element.isToPrint() || element.isAlreadyPrinted());
                if (!element.isToPrint() || (printElement = element.fill()) == null) continue;
                printContainer.addElement(printElement);
                if (element instanceof JRFillSubreport) {
                    List styles;
                    JRFillSubreport subreport = (JRFillSubreport)element;
                    List fonts = subreport.subreportFiller.getJasperPrint().getFontsList();
                    if (fonts != null) {
                        for (int j2 = 0; j2 < fonts.size(); ++j2) {
                            this.filler.getJasperPrint().addFont((JRReportFont)fonts.get(j2), true);
                        }
                    }
                    if ((styles = subreport.subreportFiller.getJasperPrint().getStylesList()) != null) {
                        for (int j3 = 0; j3 < styles.size(); ++j3) {
                            this.filler.getJasperPrint().addStyle((JRStyle)styles.get(j3), true);
                        }
                    }
                    Collection printElements = subreport.getPrintElements();
                    this.addSubElements(printContainer, element, printElements);
                    continue;
                }
                if (!(element instanceof JRFillCrosstab)) continue;
                List printElements = ((JRFillCrosstab)element).getPrintElements();
                this.addSubElements(printContainer, element, printElements);
            }
        }
        printContainer.setHeight(this.stretchHeight - this.firstY);
    }

    protected void addSubElements(JRPrintElementContainer printContainer, JRFillElement element, Collection printElements) {
        if (printElements != null && printElements.size() > 0) {
            Iterator it = printElements.iterator();
            while (it.hasNext()) {
                JRPrintElement printElement = (JRPrintElement)it.next();
                printElement.setX(element.getX() + printElement.getX());
                printElement.setY(element.getRelativeY() + printElement.getY());
                printContainer.addElement(printElement);
            }
        }
    }

    protected void rewind() throws JRException {
        if (this.ySortedElements != null && this.ySortedElements.length > 0) {
            for (int i2 = 0; i2 < this.ySortedElements.length; ++i2) {
                JRFillElement element = this.ySortedElements[i2];
                element.rewind();
                element.setAlreadyPrinted(false);
            }
        }
        this.willOverflow = false;
    }

    protected int getFirstY() {
        return this.firstY;
    }

    protected abstract int getContainerHeight();

    protected void initConditionalStyles() {
        int i2;
        this.collectConditionalStyle(this.filler.getDefaultStyle());
        for (i2 = 0; i2 < this.deepElements.length; ++i2) {
            JRStyle style = this.deepElements[i2].initStyle;
            this.collectConditionalStyle(style);
        }
        if (this.deepElements.length > 0) {
            for (i2 = 0; i2 < this.deepElements.length; ++i2) {
                this.deepElements[i2].setConditionalStylesContainer(this);
            }
        }
    }

    protected void collectConditionalStyle(JRStyle style) {
        if (style != null) {
            this.stylesToEvaluate.add(style);
        }
    }

    protected void evaluateConditionalStyles(byte evaluation) throws JRException {
        Iterator it = this.stylesToEvaluate.iterator();
        while (it.hasNext()) {
            this.evaluateConditionalStyle((JRStyle)it.next(), evaluation);
        }
    }

    protected JRStyle evaluateConditionalStyle(JRStyle initialStyle, byte evaluation) throws JRException {
        JRStyle consolidatedStyle = initialStyle;
        StringBuffer code = new StringBuffer();
        ArrayList condStylesToApply = new ArrayList();
        boolean anyTrue = this.buildConsolidatedStyle(initialStyle, evaluation, code, condStylesToApply);
        if (anyTrue) {
            String consolidatedStyleName = initialStyle.getName() + code.toString();
            consolidatedStyle = (JRStyle)this.filler.getJasperPrint().getStylesMap().get(consolidatedStyleName);
            if (consolidatedStyle == null) {
                consolidatedStyle = new JRBaseStyle(consolidatedStyleName);
                for (int j2 = condStylesToApply.size() - 1; j2 >= 0; --j2) {
                    JRStyleResolver.appendStyle(consolidatedStyle, (JRStyle)condStylesToApply.get(j2));
                }
                this.filler.getJasperPrint().addStyle(consolidatedStyle, true);
            }
        }
        this.evaluatedStyles.put(initialStyle, consolidatedStyle);
        return consolidatedStyle;
    }

    protected boolean buildConsolidatedStyle(JRStyle style, byte evaluation, StringBuffer code, List condStylesToApply) throws JRException {
        boolean anyTrue = false;
        JRConditionalStyle[] conditionalStyles = style.getConditionalStyles();
        if (conditionalStyles != null && conditionalStyles.length > 0) {
            for (int j2 = 0; j2 < conditionalStyles.length; ++j2) {
                JRConditionalStyle conditionalStyle = conditionalStyles[j2];
                Boolean expressionValue = (Boolean)this.expressionEvaluator.evaluate(conditionalStyle.getConditionExpression(), evaluation);
                boolean condition = expressionValue == null ? false : expressionValue;
                code.append(condition ? (char)'1' : '0');
                anyTrue |= condition;
                if (!condition) continue;
                condStylesToApply.add(conditionalStyle);
            }
        }
        condStylesToApply.add(style);
        if (style.getStyle() != null) {
            anyTrue |= this.buildConsolidatedStyle(style.getStyle(), evaluation, code, condStylesToApply);
        }
        return anyTrue;
    }

    public JRStyle getEvaluatedConditionalStyle(JRStyle parentStyle) {
        return (JRStyle)this.evaluatedStyles.get(parentStyle);
    }
}

