/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.util.JRProperties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileBufferedOutputStream
extends OutputStream {
    private static final Log log = LogFactory.getLog(class$net$sf$jasperreports$engine$util$FileBufferedOutputStream == null ? (class$net$sf$jasperreports$engine$util$FileBufferedOutputStream = FileBufferedOutputStream.class$("net.sf.jasperreports.engine.util.FileBufferedOutputStream")) : class$net$sf$jasperreports$engine$util$FileBufferedOutputStream);
    public static final String PROPERTY_MEMORY_THRESHOLD = "net.sf.jasperreports.file.buffer.os.memory.threshold";
    public static final int INFINIT_MEMORY_THRESHOLD = -1;
    public static final int DEFAULT_INITIAL_MEMORY_BUFFER_SIZE = 65536;
    public static final int DEFAULT_INPUT_BUFFER_LENGTH = 16384;
    private final int memoryThreshold;
    private final int initialMemoryBufferSize;
    private final int inputBufferLength;
    private final ByteArrayOutputStream memoryOutput;
    private int size;
    private File file;
    private BufferedOutputStream fileOutput;
    private boolean closed;
    private boolean disposed;
    static /* synthetic */ Class class$net$sf$jasperreports$engine$util$FileBufferedOutputStream;

    public FileBufferedOutputStream() {
        this(JRProperties.getIntegerProperty(PROPERTY_MEMORY_THRESHOLD, -1), 65536, 16384);
    }

    public FileBufferedOutputStream(int memoryThreshold) {
        this(memoryThreshold, 65536, 16384);
    }

    public FileBufferedOutputStream(int memoryThreshold, int initialMemoryBufferSize) {
        this(memoryThreshold, initialMemoryBufferSize, 16384);
    }

    public FileBufferedOutputStream(int memoryThreshold, int initialMemoryBufferSize, int inputBufferLength) {
        this.memoryThreshold = memoryThreshold;
        this.initialMemoryBufferSize = initialMemoryBufferSize;
        this.inputBufferLength = inputBufferLength;
        this.size = 0;
        this.memoryOutput = this.memoryThreshold != 0 ? new ByteArrayOutputStream(this.initialMemoryBufferSize) : null;
    }

    public void write(int b2) throws IOException {
        this.checkClosed();
        if (this.availableMemorySpace() > 0) {
            this.memoryOutput.write(b2);
        } else {
            this.ensureFileOutput().write(b2);
        }
        ++this.size;
    }

    protected int availableMemorySpace() {
        int availableMemorySpace = this.memoryOutput != null && (this.memoryThreshold < 0 || this.memoryOutput.size() < this.memoryThreshold) ? this.memoryThreshold - this.memoryOutput.size() : 0;
        return availableMemorySpace;
    }

    protected BufferedOutputStream ensureFileOutput() throws IOException, FileNotFoundException {
        if (this.fileOutput == null) {
            this.file = File.createTempFile("file.buff.os.", ".tmp");
            FileOutputStream fileOutputStream = new FileOutputStream(this.file);
            this.fileOutput = new BufferedOutputStream(fileOutputStream);
        }
        return this.fileOutput;
    }

    public void write(byte[] b2, int off, int len) throws IOException {
        this.checkClosed();
        int memoryLen = this.availableMemorySpace();
        if (len < memoryLen) {
            memoryLen = len;
        }
        if (memoryLen > 0) {
            this.memoryOutput.write(b2, off, memoryLen);
        }
        if (memoryLen < len) {
            this.ensureFileOutput().write(b2, off + memoryLen, len - memoryLen);
        }
        this.size += len;
    }

    public void checkClosed() {
        if (this.closed) {
            throw new JRRuntimeException("Output stream already closed.");
        }
    }

    public void close() throws IOException {
        if (!this.closed && this.fileOutput != null) {
            this.fileOutput.flush();
            this.fileOutput.close();
        }
        this.closed = true;
    }

    public void flush() throws IOException {
        if (this.fileOutput != null) {
            this.fileOutput.flush();
        }
    }

    public int size() {
        return this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeData(OutputStream out) throws IOException {
        if (!this.closed) {
            this.close();
        }
        if (this.memoryOutput != null) {
            this.memoryOutput.writeTo(out);
        }
        if (this.file != null) {
            FileInputStream fileInput = new FileInputStream(this.file);
            boolean inputClosed = false;
            try {
                int read;
                byte[] buffer = new byte[this.inputBufferLength];
                while ((read = fileInput.read(buffer)) > 0) {
                    out.write(buffer, 0, read);
                }
                fileInput.close();
                inputClosed = true;
            }
            finally {
                if (!inputClosed) {
                    try {
                        fileInput.close();
                    }
                    catch (IOException e2) {
                        log.warn("Could not close file input stream", e2);
                    }
                }
            }
        }
    }

    public void dispose() {
        if (this.disposed) {
            return;
        }
        boolean success = true;
        if (!this.closed && this.fileOutput != null) {
            try {
                this.fileOutput.close();
            }
            catch (IOException e2) {
                log.warn("Error while closing the temporary file output stream", e2);
                success = false;
            }
        }
        if (this.file != null && !this.file.delete()) {
            log.warn("Error while deleting the temporary file");
            success = false;
        }
        this.disposed = success;
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

