/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.util.ArrayList;
import java.util.StringTokenizer;
import net.sf.jasperreports.engine.JRQueryChunk;
import net.sf.jasperreports.engine.util.JRQueryChunkHandler;

public class JRQueryParser {
    protected static final String CLAUSE_TOKEN_SEPARATOR = ",";
    private static final JRQueryParser singleton = new JRQueryParser();

    public static JRQueryParser instance() {
        return singleton;
    }

    public void parse(String text, JRQueryChunkHandler chunkHandler) {
        if (text != null) {
            StringBuffer textChunk = new StringBuffer();
            StringTokenizer tkzer = new StringTokenizer(text, "$", true);
            boolean wasDelim = false;
            while (tkzer.hasMoreTokens()) {
                int end;
                String token = tkzer.nextToken();
                if (token.equals("$")) {
                    if (wasDelim) {
                        textChunk.append("$");
                    }
                    wasDelim = true;
                    continue;
                }
                if (token.startsWith("P{") && wasDelim) {
                    end = token.indexOf(125);
                    if (end > 0) {
                        if (textChunk.length() > 0) {
                            chunkHandler.handleTextChunk(textChunk.toString());
                        }
                        String parameterChunk = token.substring(2, end);
                        chunkHandler.handleParameterChunk(parameterChunk);
                        textChunk = new StringBuffer(token.substring(end + 1));
                    } else {
                        if (wasDelim) {
                            textChunk.append("$");
                        }
                        textChunk.append(token);
                    }
                } else if (token.startsWith("P!{") && wasDelim) {
                    end = token.indexOf(125);
                    if (end > 0) {
                        if (textChunk.length() > 0) {
                            chunkHandler.handleTextChunk(textChunk.toString());
                        }
                        String parameterClauseChunk = token.substring(3, end);
                        chunkHandler.handleParameterClauseChunk(parameterClauseChunk);
                        textChunk = new StringBuffer(token.substring(end + 1));
                    } else {
                        if (wasDelim) {
                            textChunk.append("$");
                        }
                        textChunk.append(token);
                    }
                } else if (token.startsWith("X{") && wasDelim) {
                    end = token.indexOf(125);
                    if (end > 0) {
                        if (textChunk.length() > 0) {
                            chunkHandler.handleTextChunk(textChunk.toString());
                        }
                        String clauseChunk = token.substring(2, end);
                        String[] tokens = this.parseClause(clauseChunk);
                        chunkHandler.handleClauseChunk(tokens);
                        textChunk = new StringBuffer(token.substring(end + 1));
                    } else {
                        if (wasDelim) {
                            textChunk.append("$");
                        }
                        textChunk.append(token);
                    }
                } else {
                    if (wasDelim) {
                        textChunk.append("$");
                    }
                    textChunk.append(token);
                }
                wasDelim = false;
            }
            if (wasDelim) {
                textChunk.append("$");
            }
            if (textChunk.length() > 0) {
                chunkHandler.handleTextChunk(textChunk.toString());
            }
        }
    }

    protected String[] parseClause(String clauseChunk) {
        ArrayList<String> tokens = new ArrayList<String>();
        boolean wasClauseToken = false;
        StringTokenizer tokenizer = new StringTokenizer(clauseChunk, CLAUSE_TOKEN_SEPARATOR, true);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.equals(CLAUSE_TOKEN_SEPARATOR)) {
                if (!wasClauseToken) {
                    tokens.add("");
                }
                wasClauseToken = false;
                continue;
            }
            tokens.add(token);
            wasClauseToken = true;
        }
        if (!wasClauseToken) {
            tokens.add("");
        }
        return tokens.toArray(new String[tokens.size()]);
    }

    public String asText(JRQueryChunk[] chunks) {
        String text = "";
        if (chunks != null && chunks.length > 0) {
            StringBuffer sbuffer = new StringBuffer();
            block5: for (int i2 = 0; i2 < chunks.length; ++i2) {
                JRQueryChunk queryChunk = chunks[i2];
                switch (queryChunk.getType()) {
                    case 2: {
                        sbuffer.append("$P{");
                        sbuffer.append(queryChunk.getText());
                        sbuffer.append("}");
                        continue block5;
                    }
                    case 3: {
                        sbuffer.append("$P!{");
                        sbuffer.append(queryChunk.getText());
                        sbuffer.append("}");
                        continue block5;
                    }
                    case 4: {
                        sbuffer.append("$X{");
                        sbuffer.append(queryChunk.getText());
                        sbuffer.append("}");
                        continue block5;
                    }
                    default: {
                        sbuffer.append(queryChunk.getText());
                    }
                }
            }
            text = sbuffer.toString();
        }
        return text;
    }

    public String asClauseText(String[] tokens) {
        StringBuffer sb = new StringBuffer();
        if (tokens != null && tokens.length > 0) {
            for (int i2 = 0; i2 < tokens.length; ++i2) {
                String token;
                if (i2 > 0) {
                    sb.append(',');
                }
                if ((token = tokens[i2]) == null) continue;
                sb.append(token);
            }
        }
        return sb.toString();
    }
}

