/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import net.sf.jasperreports.engine.util.ThreadLocalStack;

public class JRResourcesUtil {
    private static URLStreamHandlerFactory globalURLHandlerFactory;
    private static ThreadLocalStack localURLHandlerFactoryStack;
    private static ClassLoader globalClassLoader;
    private static ThreadLocalStack localClassLoaderStack;

    public static URL createURL(String spec, URLStreamHandlerFactory urlHandlerFactory) {
        URL url;
        URLStreamHandler handler = JRResourcesUtil.getURLHandler(spec, urlHandlerFactory);
        try {
            url = handler == null ? new URL(spec) : new URL(null, spec, handler);
        }
        catch (MalformedURLException e2) {
            url = null;
        }
        return url;
    }

    public static URLStreamHandler getURLHandler(String spec, URLStreamHandlerFactory urlHandlerFactory) {
        String protocol;
        urlHandlerFactory = JRResourcesUtil.getURLHandlerFactory(urlHandlerFactory);
        URLStreamHandler handler = null;
        if (urlHandlerFactory != null && (protocol = JRResourcesUtil.getURLProtocol(spec)) != null) {
            handler = urlHandlerFactory.createURLStreamHandler(protocol);
        }
        return handler;
    }

    private static String getURLProtocol(String spec) {
        String proto;
        String protocol = null;
        int colon = (spec = spec.trim()).indexOf(58);
        if (colon > 0 && JRResourcesUtil.protocolValid(proto = spec.substring(0, colon))) {
            protocol = proto;
        }
        return protocol;
    }

    private static boolean protocolValid(String protocol) {
        int length = protocol.length();
        if (length < 1) {
            return false;
        }
        if (!Character.isLetter(protocol.charAt(0))) {
            return false;
        }
        for (int i2 = 1; i2 < length; ++i2) {
            char c2 = protocol.charAt(i2);
            if (Character.isLetterOrDigit(c2) || c2 == '+' || c2 == '-' || c2 == '.') continue;
            return false;
        }
        return true;
    }

    public static URLStreamHandlerFactory getURLHandlerFactory(URLStreamHandlerFactory urlHandlerFactory) {
        if (urlHandlerFactory == null && (urlHandlerFactory = JRResourcesUtil.getThreadURLStreamHandlerFactory()) == null) {
            urlHandlerFactory = globalURLHandlerFactory;
        }
        return urlHandlerFactory;
    }

    public static URLStreamHandlerFactory getGlobalURLStreamHandlerFactory() {
        return globalURLHandlerFactory;
    }

    public static URLStreamHandlerFactory getThreadURLStreamHandlerFactory() {
        return (URLStreamHandlerFactory)localURLHandlerFactoryStack.top();
    }

    public static void setThreadURLHandlerFactory(URLStreamHandlerFactory urlHandlerFactory) {
        localURLHandlerFactoryStack.push(urlHandlerFactory);
    }

    public static void resetThreadURLHandlerFactory() {
        localURLHandlerFactoryStack.pop();
    }

    public static void setGlobalURLHandlerFactory(URLStreamHandlerFactory urlHandlerFactory) {
        globalURLHandlerFactory = urlHandlerFactory;
    }

    public static ClassLoader getClassLoader(ClassLoader classLoader) {
        if (classLoader == null && (classLoader = JRResourcesUtil.getThreadClassLoader()) == null) {
            classLoader = globalClassLoader;
        }
        return classLoader;
    }

    public static ClassLoader getGlobalClassLoader() {
        return globalClassLoader;
    }

    public static ClassLoader getThreadClassLoader() {
        return (ClassLoader)localClassLoaderStack.top();
    }

    public static void setThreadClassLoader(ClassLoader classLoader) {
        localClassLoaderStack.push(classLoader);
    }

    public static void resetClassLoader() {
        localClassLoaderStack.pop();
    }

    public static void setGlobalClassLoader(ClassLoader classLoader) {
        globalClassLoader = classLoader;
    }

    public static URL findClassLoaderResource(String location, ClassLoader classLoader, Class clazz) {
        classLoader = JRResourcesUtil.getClassLoader(classLoader);
        URL url = null;
        if (classLoader != null) {
            url = classLoader.getResource(location);
        }
        if (url == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader != null) {
                url = classLoader.getResource(location);
            }
            if (url == null) {
                classLoader = clazz.getClassLoader();
                url = classLoader == null ? clazz.getResource("/" + location) : classLoader.getResource(location);
            }
        }
        return url;
    }

    static {
        localURLHandlerFactoryStack = new ThreadLocalStack();
        localClassLoaderStack = new ThreadLocalStack();
    }
}

