/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.jasperreports.engine.JRException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JRXmlUtils {
    private static final Log log = LogFactory.getLog(class$net$sf$jasperreports$engine$util$JRXmlUtils == null ? (class$net$sf$jasperreports$engine$util$JRXmlUtils = JRXmlUtils.class$("net.sf.jasperreports.engine.util.JRXmlUtils")) : class$net$sf$jasperreports$engine$util$JRXmlUtils);
    static /* synthetic */ Class class$net$sf$jasperreports$engine$util$JRXmlUtils;

    public static Document parse(InputSource is) throws JRException {
        try {
            return JRXmlUtils.createDocumentBuilder().parse(is);
        }
        catch (SAXException e2) {
            throw new JRException("Failed to parse the xml document", e2);
        }
        catch (IOException e3) {
            throw new JRException("Failed to parse the xml document", e3);
        }
    }

    public static Document parse(String uri) throws JRException {
        return JRXmlUtils.parse(new InputSource(uri));
    }

    public static Document parse(File file) throws JRException {
        try {
            return JRXmlUtils.createDocumentBuilder().parse(file);
        }
        catch (SAXException e2) {
            throw new JRException("Failed to parse the xmlf document", e2);
        }
        catch (IOException e3) {
            throw new JRException("Failed to parse the xml document", e3);
        }
    }

    public static Document parse(InputStream is) throws JRException {
        return JRXmlUtils.parse(new InputSource(is));
    }

    public static Document parse(URL url) throws JRException {
        InputStream is = null;
        try {
            is = url.openStream();
            Document document = JRXmlUtils.createDocumentBuilder().parse(is);
            return document;
        }
        catch (SAXException e2) {
            throw new JRException("Failed to parse the xmlf document", e2);
        }
        catch (IOException e3) {
            throw new JRException("Failed to parse the xml document", e3);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e4) {
                    log.warn("Error closing stream of URL " + url, e4);
                }
            }
        }
    }

    public static DocumentBuilder createDocumentBuilder() throws JRException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(false);
        dbf.setIgnoringComments(true);
        try {
            return dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e2) {
            throw new JRException("Failed to create a document builder factory", e2);
        }
    }

    public static Document createDocument(Node sourceNode) throws JRException {
        Document doc = JRXmlUtils.createDocumentBuilder().newDocument();
        Node source = sourceNode.getNodeType() == 9 ? ((Document)sourceNode).getDocumentElement() : sourceNode;
        Node node = doc.importNode(source, true);
        doc.appendChild(node);
        return doc;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

