/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.olap.xmla;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.olap.result.JROlapCell;
import net.sf.jasperreports.olap.result.JROlapResult;
import net.sf.jasperreports.olap.result.JROlapResultAxis;
import net.sf.jasperreports.olap.xmla.JRXmlaCell;
import net.sf.jasperreports.olap.xmla.JRXmlaResultAxis;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRXmlaResult
implements JROlapResult {
    private static final Log log = LogFactory.getLog(class$net$sf$jasperreports$olap$xmla$JRXmlaResult == null ? (class$net$sf$jasperreports$olap$xmla$JRXmlaResult = JRXmlaResult.class$("net.sf.jasperreports.olap.xmla.JRXmlaResult")) : class$net$sf$jasperreports$olap$xmla$JRXmlaResult);
    private List axesList = new ArrayList();
    private JRXmlaResultAxis[] axes;
    private int[] cellOrdinalFactors;
    private final List cells = new ArrayList();
    static /* synthetic */ Class class$net$sf$jasperreports$olap$xmla$JRXmlaResult;

    public JROlapResultAxis[] getAxes() {
        return this.ensureAxisArray();
    }

    public JROlapCell getCell(int[] axisPositions) {
        int cellOrdinal = this.getCellOrdinal(axisPositions);
        return (JROlapCell)this.cells.get(cellOrdinal);
    }

    protected int getCellOrdinal(int[] axisPositions) {
        this.ensureCellOrdinalFactors();
        if (axisPositions.length != this.axes.length) {
            throw new JRRuntimeException("Number of axis positions (" + axisPositions.length + ") doesn't match the number of axes (" + this.axes.length + ")");
        }
        int ordinal = 0;
        for (int i2 = 0; i2 < axisPositions.length; ++i2) {
            ordinal += this.cellOrdinalFactors[i2] * axisPositions[i2];
        }
        return ordinal;
    }

    public void addAxis(JRXmlaResultAxis axis) {
        this.axesList.add(axis);
        this.resetAxisArray();
    }

    public JRXmlaResultAxis getAxisByName(String name) {
        JRXmlaResultAxis axis = null;
        Iterator iter = this.axesList.iterator();
        while (axis == null && iter.hasNext()) {
            JRXmlaResultAxis ax = (JRXmlaResultAxis)iter.next();
            if (!ax.getAxisName().equals(name)) continue;
            axis = ax;
        }
        return axis;
    }

    protected JRXmlaResultAxis[] ensureAxisArray() {
        if (this.axes == null) {
            this.axes = new JRXmlaResultAxis[this.axesList.size()];
            this.axes = this.axesList.toArray(this.axes);
        }
        return this.axes;
    }

    protected void ensureCellOrdinalFactors() {
        this.ensureAxisArray();
        if (this.cellOrdinalFactors == null) {
            int axisCount = this.axes.length;
            this.cellOrdinalFactors = new int[axisCount];
            this.cellOrdinalFactors[0] = 1;
            for (int i2 = 1; i2 < axisCount; ++i2) {
                this.cellOrdinalFactors[i2] = this.cellOrdinalFactors[i2 - 1] * this.axes[i2 - 1].getTupleCount();
            }
        }
    }

    protected void resetAxisArray() {
        this.axes = null;
        this.cellOrdinalFactors = null;
    }

    public void setCell(JRXmlaCell cell, int cellOrdinal) {
        int cellsCount = this.cells.size();
        if (cellOrdinal == -1 || cellOrdinal == cellsCount) {
            this.cells.add(cell);
        } else if (cellOrdinal > cellsCount) {
            for (int i2 = cellsCount; i2 < cellOrdinal; ++i2) {
                this.cells.add(null);
            }
            this.cells.add(cell);
        } else {
            if (log.isWarnEnabled()) {
                log.warn("Overwriting cell at ordinal " + cellOrdinal);
            }
            this.cells.set(cellOrdinal, cell);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

