/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.view;

import java.awt.Color;
import java.awt.Image;
import java.awt.font.TextAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.sf.jasperreports.crosstabs.JRCellContents;
import net.sf.jasperreports.crosstabs.JRCrosstab;
import net.sf.jasperreports.crosstabs.JRCrosstabCell;
import net.sf.jasperreports.crosstabs.JRCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.JRCrosstabRowGroup;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRBox;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JREllipse;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionChunk;
import net.sf.jasperreports.engine.JRFrame;
import net.sf.jasperreports.engine.JRGraphicElement;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRImage;
import net.sf.jasperreports.engine.JRImageRenderer;
import net.sf.jasperreports.engine.JRLine;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRRectangle;
import net.sf.jasperreports.engine.JRRenderable;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JRStaticText;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRTextElement;
import net.sf.jasperreports.engine.JRTextField;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.base.JRBasePrintElement;
import net.sf.jasperreports.engine.base.JRBasePrintEllipse;
import net.sf.jasperreports.engine.base.JRBasePrintFrame;
import net.sf.jasperreports.engine.base.JRBasePrintGraphicElement;
import net.sf.jasperreports.engine.base.JRBasePrintImage;
import net.sf.jasperreports.engine.base.JRBasePrintLine;
import net.sf.jasperreports.engine.base.JRBasePrintPage;
import net.sf.jasperreports.engine.base.JRBasePrintRectangle;
import net.sf.jasperreports.engine.base.JRBasePrintText;
import net.sf.jasperreports.engine.design.JRDesignFrame;
import net.sf.jasperreports.engine.fill.TextMeasurer;
import net.sf.jasperreports.engine.util.JRFontUtil;
import net.sf.jasperreports.engine.util.JRImageLoader;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.JRStyledTextParser;
import org.xml.sax.SAXException;

public class JRPreviewBuilder {
    private JasperPrint jasperPrint;
    private JRPrintPage page;
    int pageWidth;
    private int offsetX;
    private int offsetY;
    private int upColumns;
    private int downColumns;
    private List contourElementsList = new ArrayList();
    private List bandSeparatorList = new ArrayList();
    private List pageElements = new ArrayList();
    private JRDefaultStyleProvider defaultStyleProvider;
    private JRStyledTextParser styledTextParser = new JRStyledTextParser();
    private boolean isFirstBand = true;
    private boolean hasContour;

    public JRPreviewBuilder(JRReport report) throws JRException {
        this.createJasperPrint(report);
    }

    private void createJasperPrint(JRReport report) throws JRException {
        int i2;
        JRBand band;
        this.jasperPrint = new JasperPrint();
        this.defaultStyleProvider = this.jasperPrint.getDefaultStyleProvider();
        this.page = new JRBasePrintPage();
        this.pageWidth = report.getPageWidth();
        this.jasperPrint.setDefaultFont(report.getDefaultFont());
        this.jasperPrint.setDefaultStyle(report.getDefaultStyle());
        this.jasperPrint.setFormatFactoryClass(report.getFormatFactoryClass());
        this.jasperPrint.setName(report.getName());
        this.jasperPrint.setOrientation(report.getOrientation());
        this.jasperPrint.setPageWidth(this.pageWidth);
        this.offsetY = report.getTopMargin();
        this.offsetX = report.getLeftMargin();
        JRStyle[] styles = report.getStyles();
        if (styles != null) {
            for (int i3 = 0; i3 < styles.length; ++i3) {
                this.jasperPrint.addStyle(styles[i3]);
            }
        }
        if ((band = report.getBackground()) != null) {
            this.setElements(band.getChildren(), report.getPageHeight(), 0, 0, 0, 0, false);
        }
        Color color = new Color(170, 170, 255);
        this.addBandElements(report.getTitle(), color);
        this.addBandElements(report.getPageHeader(), color);
        this.upColumns = this.offsetY;
        this.addBandElements(report.getColumnHeader(), color);
        JRGroup[] groups = report.getGroups();
        if (groups != null) {
            for (i2 = 0; i2 < groups.length; ++i2) {
                this.addBandElements(groups[i2].getGroupHeader(), color);
            }
        }
        this.addBandElements(report.getDetail(), color);
        if (groups != null) {
            for (i2 = 0; i2 < groups.length; ++i2) {
                this.addBandElements(groups[i2].getGroupFooter(), color);
            }
        }
        this.addBandElements(report.getColumnFooter(), color);
        this.downColumns = this.offsetY;
        this.addBandElements(report.getPageFooter(), color);
        this.addBandElements(report.getLastPageFooter(), color);
        this.addBandElements(report.getSummary(), color);
        this.jasperPrint.setPageHeight(this.offsetY + report.getBottomMargin());
        for (i2 = 0; i2 < this.contourElementsList.size(); ++i2) {
            this.pageElements.add(this.getContourShape((ContourElement)this.contourElementsList.get(i2)));
        }
        for (i2 = 0; i2 < this.bandSeparatorList.size(); ++i2) {
            this.pageElements.add(0, this.getContourLine((ContourElement)this.bandSeparatorList.get(i2)));
        }
        int leftColumnPos = report.getLeftMargin();
        for (int i4 = 0; i4 < report.getColumnCount(); ++i4) {
            this.pageElements.add(0, this.getContourLine(new ContourElement(leftColumnPos, this.upColumns, 0, this.downColumns - this.upColumns, color, 4)));
            this.pageElements.add(0, this.getContourLine(new ContourElement(leftColumnPos += report.getColumnWidth(), this.upColumns, 0, this.downColumns - this.upColumns, color, 4)));
            leftColumnPos += report.getColumnSpacing();
        }
        this.pageElements.add(0, this.getContourLine(new ContourElement(0, report.getTopMargin(), this.pageWidth, 0, color, 4)));
        this.pageElements.add(0, this.getContourLine(new ContourElement(0, this.offsetY, this.pageWidth, 0, color, 4)));
        this.pageElements.add(0, this.getContourLine(new ContourElement(this.offsetX, 0, 0, this.jasperPrint.getPageHeight(), color, 4)));
        this.pageElements.add(0, this.getContourLine(new ContourElement(this.pageWidth - report.getRightMargin(), 0, 0, this.jasperPrint.getPageHeight(), color, 4)));
        this.page.setElements(this.pageElements);
        this.jasperPrint.addPage(this.page);
    }

    private void setElements(List list, int bandHeight, int parentX, int parentY, int parentWidth, int parentHeight, boolean isFrameChild) {
        Iterator it = list.iterator();
        while (it.hasNext()) {
            Object element = it.next();
            JRBasePrintElement baseElement = null;
            if (element instanceof JRFrame) {
                JRBasePrintFrame basePrintFrameElement;
                JRFrame frameElement = (JRFrame)element;
                baseElement = this.getFrameElement(frameElement);
                this.setBaseElement(baseElement, (JRElement)element, bandHeight, parentX, parentY, parentWidth, parentHeight, isFrameChild);
                if (baseElement.getHeight() > 0) {
                    this.pageElements.add(baseElement);
                }
                if ((basePrintFrameElement = (JRBasePrintFrame)baseElement).getBorder() == 0 && basePrintFrameElement.getTopBorder() == 0 && basePrintFrameElement.getLeftBorder() == 0 && basePrintFrameElement.getRightBorder() == 0 && basePrintFrameElement.getBottomBorder() == 0) {
                    this.addContourElement(baseElement);
                }
                List<JRElement> frameChildren = Arrays.asList(frameElement.getElements());
                ArrayList<JRElement> availableElements = new ArrayList<JRElement>();
                Iterator<JRElement> frameIt = frameChildren.iterator();
                while (frameIt.hasNext()) {
                    JRElement elem = frameIt.next();
                    if (elem.getY() >= frameElement.getHeight() || elem.getX() >= frameElement.getWidth()) continue;
                    availableElements.add(elem);
                }
                this.setElements(availableElements, bandHeight, basePrintFrameElement.getX(), basePrintFrameElement.getY(), basePrintFrameElement.getWidth(), basePrintFrameElement.getHeight(), true);
                continue;
            }
            if (element instanceof JRElementGroup) {
                List children = ((JRElementGroup)element).getChildren();
                this.setElements(children, bandHeight, parentX, parentY, parentWidth, parentHeight, isFrameChild);
                continue;
            }
            this.hasContour = false;
            if (element instanceof JRImage) {
                baseElement = this.getImageElement((JRImage)element);
            } else if (element instanceof JRGraphicElement) {
                baseElement = this.getGraphicElement((JRGraphicElement)element);
            } else if (element instanceof JRTextElement) {
                baseElement = this.getTextElement((JRTextElement)element);
            } else if (element instanceof JRChart) {
                baseElement = this.getChartElement((JRChart)element);
            } else {
                if (element instanceof JRCrosstab) {
                    this.setElements(this.getCrosstabList((JRCrosstab)element), bandHeight, parentX, parentY, parentWidth, parentHeight, isFrameChild);
                    continue;
                }
                baseElement = new JRBasePrintElement(this.defaultStyleProvider);
            }
            this.setBaseElement(baseElement, (JRElement)element, bandHeight, parentX, parentY, parentWidth, parentHeight, isFrameChild);
            if (element instanceof JRTextElement) {
                JRBasePrintText basePrintTextElement = (JRBasePrintText)baseElement;
                this.measureTextElement(basePrintTextElement, (JRTextElement)element);
            }
            this.pageElements.add(baseElement);
            if (!this.hasContour) {
                this.addContourElement(baseElement);
            }
            this.hasContour = false;
        }
    }

    private void addBandElements(JRBand band, Color color) {
        if (band != null) {
            if (this.isFirstBand) {
                this.bandSeparatorList.add(new ContourElement(0, this.offsetY, this.pageWidth, 0, color, 4));
            }
            this.setElements(band.getChildren(), band.getHeight(), 0, 0, 0, 0, false);
            this.offsetY += band.getHeight();
            this.bandSeparatorList.add(new ContourElement(0, this.offsetY, this.pageWidth, 0, color, 4));
            this.isFirstBand = false;
        }
    }

    private String getExpressionText(JRExpression exp) {
        return exp == null ? null : exp.getText();
    }

    private JRStyledText getStyledText(JRTextElement textElement) {
        JRExpression textExpression;
        JRStyledText styledText = null;
        String text = null;
        if (textElement instanceof JRStaticText) {
            text = ((JRStaticText)textElement).getText();
        } else if (textElement instanceof JRTextField && (textExpression = ((JRTextField)textElement).getExpression()) != null) {
            text = textExpression.getText();
        }
        if (text == null) {
            text = "";
        }
        HashMap<TextAttribute, Color> attributes = new HashMap<TextAttribute, Color>();
        JRFontUtil.setAttributes(attributes, textElement);
        attributes.put(TextAttribute.FOREGROUND, textElement.getForecolor());
        if (textElement instanceof JRStaticText && textElement.isStyledText()) {
            try {
                styledText = this.styledTextParser.parse(attributes, text);
            }
            catch (SAXException e2) {
                // empty catch block
            }
        }
        if (styledText == null) {
            styledText = new JRStyledText();
            styledText.append(text);
            styledText.addRun(new JRStyledText.Run(attributes, 0, text.length()));
        }
        return styledText;
    }

    private JRRenderable getRenderer(JRImage imageElement) {
        String location;
        JRExpressionChunk firstChunk;
        JRRenderable imageRenderer = null;
        Image awtImage = null;
        JRExpression expression = imageElement.getExpression();
        if (expression != null && expression.getChunks().length == 1 && (firstChunk = expression.getChunks()[0]).getType() == 1 && (location = firstChunk.getText().trim()).startsWith("\"") && location.endsWith("\"")) {
            location = location.substring(1, location.length() - 1);
            try {
                awtImage = JRImageLoader.loadImage(JRLoader.loadBytesFromLocation(location));
                if (awtImage == null) {
                    awtImage = JRImageLoader.getImage((byte)1);
                    imageElement.setScaleImage((byte)1);
                    imageElement.setStretchType((byte)0);
                }
                imageRenderer = JRImageRenderer.getInstance(awtImage, imageElement.getOnErrorType());
                return imageRenderer;
            }
            catch (JRException e2) {
                e2.printStackTrace();
            }
        }
        try {
            awtImage = JRImageLoader.getImage((byte)1);
            imageRenderer = JRImageRenderer.getInstance(awtImage, imageElement.getOnErrorType());
            imageElement.setScaleImage((byte)1);
            imageElement.setStretchType((byte)0);
        }
        catch (JRException e3) {
            e3.printStackTrace();
        }
        return imageRenderer;
    }

    private JRRenderable getRenderer(JRChart imageElement) {
        JRRenderable imageRenderer = null;
        Image awtImage = null;
        try {
            awtImage = JRImageLoader.getImage((byte)3);
            if (awtImage == null) {
                awtImage = JRImageLoader.getImage((byte)1);
            }
            imageRenderer = JRImageRenderer.getInstance(awtImage, (byte)3);
            imageElement.setStretchType((byte)0);
        }
        catch (JRException e2) {
            e2.printStackTrace();
        }
        return imageRenderer;
    }

    private JRPrintLine getContourLine(ContourElement contour) {
        JRBasePrintLine line = new JRBasePrintLine(this.defaultStyleProvider);
        line.setX(contour.getContourX());
        line.setY(contour.getContourY());
        line.setWidth(contour.getContourWidth());
        line.setHeight(contour.getContourHeight());
        line.setPen(contour.getContourPen());
        line.setForecolor(contour.getContourColor());
        line.setDirection((byte)1);
        return line;
    }

    private JRBasePrintElement getContourShape(ContourElement contour) {
        JRBasePrintRectangle rectangle = new JRBasePrintRectangle(this.defaultStyleProvider);
        rectangle.setX(contour.getContourX());
        rectangle.setY(contour.getContourY());
        rectangle.setWidth(contour.getContourWidth());
        rectangle.setHeight(contour.getContourHeight());
        rectangle.setPen((byte)5);
        rectangle.setForecolor(contour.getContourColor());
        rectangle.setMode((byte)2);
        return rectangle;
    }

    private JRBasePrintElement getImageElement(JRImage imageElement) {
        JRBasePrintImage basePrintImageElement = new JRBasePrintImage(this.defaultStyleProvider);
        basePrintImageElement.setAnchorName(this.getExpressionText(imageElement.getAnchorNameExpression()));
        basePrintImageElement.setBookmarkLevel(imageElement.getBookmarkLevel());
        basePrintImageElement.setBorder(imageElement.getBorder());
        basePrintImageElement.setBorderColor(imageElement.getBorderColor());
        basePrintImageElement.setBottomBorder(imageElement.getBottomBorder());
        basePrintImageElement.setBottomBorderColor(imageElement.getBottomBorderColor());
        basePrintImageElement.setBottomPadding(imageElement.getBottomPadding());
        basePrintImageElement.setFill(imageElement.getFill());
        basePrintImageElement.setHorizontalAlignment(imageElement.getHorizontalAlignment());
        basePrintImageElement.setLazy(imageElement.isLazy());
        basePrintImageElement.setLeftBorder(imageElement.getLeftBorder());
        basePrintImageElement.setLeftBorderColor(imageElement.getLeftBorderColor());
        basePrintImageElement.setLeftPadding(imageElement.getLeftPadding());
        basePrintImageElement.setLinkType(imageElement.getLinkType());
        basePrintImageElement.setOnErrorType(imageElement.getOnErrorType());
        basePrintImageElement.setPadding(imageElement.getPadding());
        basePrintImageElement.setPen(imageElement.getPen());
        basePrintImageElement.setRightBorder(imageElement.getRightBorder());
        basePrintImageElement.setRightBorderColor(imageElement.getRightBorderColor());
        basePrintImageElement.setRightPadding(imageElement.getRightPadding());
        basePrintImageElement.setTopBorder(imageElement.getTopBorder());
        basePrintImageElement.setTopBorderColor(imageElement.getTopBorderColor());
        basePrintImageElement.setTopPadding(imageElement.getTopPadding());
        basePrintImageElement.setVerticalAlignment(imageElement.getVerticalAlignment());
        basePrintImageElement.setRenderer(this.getRenderer(imageElement));
        basePrintImageElement.setScaleImage(imageElement.getScaleImage());
        this.hasContour = basePrintImageElement.getBorder() != 0 || basePrintImageElement.getTopBorder() != 0 && basePrintImageElement.getLeftBorder() != 0 && basePrintImageElement.getRightBorder() != 0 && basePrintImageElement.getBottomBorder() != 0;
        return basePrintImageElement;
    }

    private JRBasePrintElement getChartElement(JRChart imageElement) {
        JRBasePrintImage basePrintImageElement = new JRBasePrintImage(this.defaultStyleProvider);
        basePrintImageElement.setAnchorName(this.getExpressionText(imageElement.getAnchorNameExpression()));
        basePrintImageElement.setBookmarkLevel(imageElement.getBookmarkLevel());
        basePrintImageElement.setBorder(imageElement.getBorder());
        basePrintImageElement.setBorderColor(imageElement.getBorderColor());
        basePrintImageElement.setBottomBorder(imageElement.getBottomBorder());
        basePrintImageElement.setBottomBorderColor(imageElement.getBottomBorderColor());
        basePrintImageElement.setBottomPadding(imageElement.getBottomPadding());
        basePrintImageElement.setLeftBorder(imageElement.getLeftBorder());
        basePrintImageElement.setLeftBorderColor(imageElement.getLeftBorderColor());
        basePrintImageElement.setLeftPadding(imageElement.getLeftPadding());
        basePrintImageElement.setLinkType(imageElement.getLinkType());
        basePrintImageElement.setOnErrorType((byte)3);
        basePrintImageElement.setPadding(imageElement.getPadding());
        basePrintImageElement.setPen((byte)5);
        basePrintImageElement.setRightBorder(imageElement.getRightBorder());
        basePrintImageElement.setRightBorderColor(imageElement.getRightBorderColor());
        basePrintImageElement.setRightPadding(imageElement.getRightPadding());
        basePrintImageElement.setTopBorder(imageElement.getTopBorder());
        basePrintImageElement.setTopBorderColor(imageElement.getTopBorderColor());
        basePrintImageElement.setTopPadding(imageElement.getTopPadding());
        basePrintImageElement.setRenderer(this.getRenderer(imageElement));
        basePrintImageElement.setScaleImage((byte)1);
        this.hasContour = basePrintImageElement.getBorder() != 0 || basePrintImageElement.getTopBorder() != 0 && basePrintImageElement.getLeftBorder() != 0 && basePrintImageElement.getRightBorder() != 0 && basePrintImageElement.getBottomBorder() != 0;
        return basePrintImageElement;
    }

    private JRBasePrintElement getGraphicElement(JRGraphicElement element) {
        JRBasePrintGraphicElement baseElement = null;
        if (element instanceof JREllipse) {
            baseElement = new JRBasePrintEllipse(this.defaultStyleProvider);
        } else if (element instanceof JRRectangle) {
            baseElement = new JRBasePrintRectangle(this.defaultStyleProvider);
            ((JRBasePrintRectangle)baseElement).setRadius(((JRRectangle)element).getRadius());
        } else if (element instanceof JRLine) {
            baseElement = new JRBasePrintLine(this.defaultStyleProvider);
            ((JRBasePrintLine)baseElement).setDirection(((JRLine)element).getDirection());
        }
        JRBasePrintGraphicElement basePrintGraphicElement = baseElement;
        JRGraphicElement graphicElement = element;
        basePrintGraphicElement.setFill(graphicElement.getFill());
        basePrintGraphicElement.setPen(graphicElement.getPen());
        this.hasContour = basePrintGraphicElement.getPen() != 0;
        return basePrintGraphicElement;
    }

    private JRBasePrintElement getFrameElement(JRFrame frameElement) {
        JRBasePrintFrame basePrintFrameElement = new JRBasePrintFrame(this.defaultStyleProvider);
        basePrintFrameElement.setBorder(frameElement.getBorder());
        basePrintFrameElement.setBorderColor(frameElement.getBorderColor());
        basePrintFrameElement.setBottomBorder(frameElement.getBottomBorder());
        basePrintFrameElement.setBottomBorderColor(frameElement.getBottomBorderColor());
        basePrintFrameElement.setBottomPadding(frameElement.getBottomPadding());
        basePrintFrameElement.setLeftBorder(frameElement.getLeftBorder());
        basePrintFrameElement.setLeftBorderColor(frameElement.getLeftBorderColor());
        basePrintFrameElement.setLeftPadding(frameElement.getLeftPadding());
        basePrintFrameElement.setPadding(frameElement.getPadding());
        basePrintFrameElement.setRightBorder(frameElement.getRightBorder());
        basePrintFrameElement.setRightBorderColor(frameElement.getRightBorderColor());
        basePrintFrameElement.setRightPadding(frameElement.getRightPadding());
        basePrintFrameElement.setTopBorder(frameElement.getTopBorder());
        basePrintFrameElement.setTopBorderColor(frameElement.getTopBorderColor());
        basePrintFrameElement.setTopPadding(frameElement.getTopPadding());
        return basePrintFrameElement;
    }

    private JRBasePrintElement getTextElement(JRTextElement textElement) {
        JRBasePrintText basePrintTextElement = new JRBasePrintText(this.defaultStyleProvider);
        basePrintTextElement.setBorder(textElement.getBorder());
        basePrintTextElement.setBorderColor(textElement.getBorderColor());
        basePrintTextElement.setBottomBorder(textElement.getBottomBorder());
        basePrintTextElement.setBottomBorderColor(textElement.getBottomBorderColor());
        basePrintTextElement.setBottomPadding(textElement.getBottomPadding());
        basePrintTextElement.setLeftBorder(textElement.getLeftBorder());
        basePrintTextElement.setLeftBorderColor(textElement.getLeftBorderColor());
        basePrintTextElement.setLeftPadding(textElement.getLeftPadding());
        basePrintTextElement.setPadding(textElement.getPadding());
        basePrintTextElement.setRightBorder(textElement.getRightBorder());
        basePrintTextElement.setRightBorderColor(textElement.getRightBorderColor());
        basePrintTextElement.setRightPadding(textElement.getRightPadding());
        basePrintTextElement.setTopBorder(textElement.getTopBorder());
        basePrintTextElement.setTopBorderColor(textElement.getTopBorderColor());
        basePrintTextElement.setTopPadding(textElement.getTopPadding());
        basePrintTextElement.setBold(textElement.isBold());
        basePrintTextElement.setFontName(textElement.getFontName());
        basePrintTextElement.setFontSize(textElement.getFontSize());
        basePrintTextElement.setHorizontalAlignment(textElement.getHorizontalAlignment());
        basePrintTextElement.setItalic(textElement.isItalic());
        basePrintTextElement.setLineSpacing(textElement.getLineSpacing());
        basePrintTextElement.setPdfEmbedded(textElement.isPdfEmbedded());
        basePrintTextElement.setPdfEncoding(textElement.getPdfEncoding());
        basePrintTextElement.setPdfFontName(textElement.getPdfFontName());
        basePrintTextElement.setReportFont(textElement.getReportFont());
        basePrintTextElement.setRotation(textElement.getRotation());
        basePrintTextElement.setStrikeThrough(textElement.isStrikeThrough());
        basePrintTextElement.setStyledText(textElement.isStyledText());
        basePrintTextElement.setUnderline(textElement.isUnderline());
        basePrintTextElement.setVerticalAlignment(textElement.getVerticalAlignment());
        if (textElement instanceof JRStaticText) {
            basePrintTextElement.setText(((JRStaticText)textElement).getText());
        }
        if (textElement instanceof JRTextField) {
            JRTextField textFieldElement = (JRTextField)textElement;
            basePrintTextElement.setAnchorName(this.getExpressionText(textFieldElement.getAnchorNameExpression()));
            basePrintTextElement.setBookmarkLevel(textFieldElement.getBookmarkLevel());
            basePrintTextElement.setLinkType(textFieldElement.getLinkType());
            basePrintTextElement.setPattern(textFieldElement.getPattern());
            basePrintTextElement.setText(this.getExpressionText(textFieldElement.getExpression()));
        }
        this.hasContour = basePrintTextElement.getBorder() != 0 || basePrintTextElement.getTopBorder() != 0 && basePrintTextElement.getLeftBorder() != 0 && basePrintTextElement.getRightBorder() != 0 && basePrintTextElement.getBottomBorder() != 0;
        return basePrintTextElement;
    }

    private void measureTextElement(JRBasePrintText basePrintTextElement, JRTextElement textElement) {
        TextMeasurer textMeasurer = new TextMeasurer(textElement);
        textMeasurer.measure(this.getStyledText(textElement), this.getStyledText(textElement).getText(), 0, 0);
        basePrintTextElement.setTextHeight(textMeasurer.getTextHeight() < (float)basePrintTextElement.getHeight() ? textMeasurer.getTextHeight() : (float)basePrintTextElement.getHeight());
        basePrintTextElement.setLeadingOffset(textMeasurer.getLeadingOffset());
        basePrintTextElement.setLineSpacingFactor(textMeasurer.getLineSpacingFactor());
    }

    private void setBaseElement(JRBasePrintElement baseElement, JRElement designElement, int bandHeight, int parentX, int parentY, int parentWidth, int parentHeight, boolean isFrameChild) {
        baseElement.setBackcolor(designElement.getBackcolor());
        baseElement.setForecolor(designElement.getForecolor());
        baseElement.setKey(designElement.getKey());
        baseElement.setMode(designElement.getMode());
        baseElement.setStyle(designElement.getStyle());
        if (isFrameChild) {
            this.setBaseElementGeometry(baseElement, designElement, parentX, parentY, parentWidth, parentHeight);
        } else {
            this.setBaseElementGeometry(baseElement, designElement, this.offsetX, this.offsetY, this.pageWidth, bandHeight);
        }
    }

    private void setBaseElementGeometry(JRBasePrintElement baseElement, JRElement element, int parentX, int parentY, int parentWidth, int parentHeight) {
        baseElement.setX(element.getX() + parentX);
        baseElement.setY(element.getY() + parentY);
        baseElement.setWidth(element.getWidth());
        if (element.getY() + element.getHeight() > parentHeight) {
            baseElement.setHeight(parentHeight - element.getY());
        } else {
            baseElement.setHeight(element.getHeight());
        }
        if (parentWidth > 0 && element.getX() + element.getWidth() > parentWidth) {
            baseElement.setWidth(parentWidth - element.getX());
        } else {
            baseElement.setWidth(element.getWidth());
        }
    }

    private void addContourElement(JRBasePrintElement baseElement) {
        Color contourColor = baseElement.getForecolor() == null ? Color.black : baseElement.getForecolor();
        ContourElement contourElement = new ContourElement(baseElement.getX(), baseElement.getY(), baseElement.getWidth(), baseElement.getHeight(), contourColor, 5);
        this.contourElementsList.add(contourElement);
    }

    protected List getCrosstabList(JRCrosstab crosstab) {
        ArrayList<JRFrame> crosstabElements = new ArrayList<JRFrame>();
        JRCrosstabRowGroup[] rowGroups = crosstab.getRowGroups();
        int rowHeadersXOffset = 0;
        for (int i2 = 0; i2 < rowGroups.length; ++i2) {
            rowHeadersXOffset += rowGroups[i2].getWidth();
        }
        JRCrosstabColumnGroup[] columnGroups = crosstab.getColumnGroups();
        int colHeadersYOffset = 0;
        for (int i3 = 0; i3 < columnGroups.length; ++i3) {
            colHeadersYOffset += columnGroups[i3].getHeight();
        }
        JRCellContents headerCell = crosstab.getHeaderCell();
        if (headerCell != null && headerCell.getWidth() != 0 && headerCell.getHeight() != 0) {
            crosstabElements.add(this.getCrosstabCellFrame(headerCell, crosstab.getX(), crosstab.getY(), false, false, false));
        }
        this.addCrosstabColumnHeaders(crosstab, rowHeadersXOffset, crosstabElements);
        this.addCrosstabRows(crosstab, rowHeadersXOffset, colHeadersYOffset, crosstabElements);
        if (crosstab.getRunDirection() == 1) {
            this.mirrorElements(crosstabElements, crosstab.getX(), crosstab.getWidth());
        }
        return crosstabElements;
    }

    protected void mirrorElements(List elements, int x, int width) {
        Iterator it = elements.iterator();
        while (it.hasNext()) {
            JRElement element = (JRElement)it.next();
            int mirrorX = 2 * x + width - element.getX() - element.getWidth();
            element.setX(mirrorX);
        }
    }

    protected JRFrame getCrosstabCellFrame(JRCellContents cell, int x, int y, boolean left, boolean right, boolean top) {
        List children;
        JRDesignFrame frame = new JRDesignFrame(cell.getDefaultStyleProvider());
        frame.setX(x);
        frame.setY(y);
        frame.setWidth(cell.getWidth());
        frame.setHeight(cell.getHeight());
        frame.setMode(cell.getMode());
        frame.setBackcolor(cell.getBackcolor());
        frame.setStyle(cell.getStyle());
        JRBox box = cell.getBox();
        if (box != null) {
            boolean copyTop;
            frame.setBox(box);
            boolean copyLeft = left && box.getLeftBorder() == 0 && box.getRightBorder() != 0;
            boolean copyRight = right && box.getRightBorder() == 0 && box.getLeftBorder() != 0;
            boolean bl = copyTop = top && box.getTopBorder() == 0 && box.getBottomBorder() != 0;
            if (copyLeft) {
                frame.setLeftBorder(box.getRightBorder());
                frame.setLeftBorderColor(box.getRightBorderColor());
            }
            if (copyRight) {
                frame.setRightBorder(box.getLeftBorder());
                frame.setRightBorderColor(box.getLeftBorderColor());
            }
            if (copyTop) {
                frame.setTopBorder(box.getBottomBorder());
                frame.setTopBorderColor(box.getBottomBorderColor());
            }
        }
        if ((children = cell.getChildren()) != null) {
            Iterator it = children.iterator();
            while (it.hasNext()) {
                JRChild child = (JRChild)it.next();
                if (child instanceof JRElement) {
                    frame.addElement((JRElement)child);
                    continue;
                }
                if (!(child instanceof JRElementGroup)) continue;
                frame.addElementGroup((JRElementGroup)child);
            }
        }
        return frame;
    }

    protected void addCrosstabColumnHeaders(JRCrosstab crosstab, int rowHeadersXOffset, List crosstabElements) {
        JRCrosstabColumnGroup[] groups = crosstab.getColumnGroups();
        int crosstabX = crosstab.getX();
        int crosstabY = crosstab.getY();
        int x = 0;
        int y = 0;
        for (int i2 = 0; i2 < groups.length; ++i2) {
            JRCellContents totalHeader;
            JRCellContents header;
            boolean firstOnRow;
            JRCellContents totalHeader2;
            JRCrosstabColumnGroup group = groups[i2];
            if (group.getTotalPosition() == 1 && (totalHeader2 = group.getTotalHeader()).getWidth() != 0 && totalHeader2.getHeight() != 0) {
                firstOnRow = x == 0 && crosstab.getHeaderCell() == null;
                crosstabElements.add(this.getCrosstabCellFrame(totalHeader2, crosstabX + rowHeadersXOffset + x, crosstabY + y, firstOnRow && crosstab.getRunDirection() == 0, firstOnRow && crosstab.getRunDirection() == 1, false));
                x += totalHeader2.getWidth();
            }
            if ((header = group.getHeader()).getWidth() != 0 && header.getHeight() != 0) {
                firstOnRow = x == 0 && crosstab.getHeaderCell() == null;
                crosstabElements.add(this.getCrosstabCellFrame(header, crosstabX + rowHeadersXOffset + x, crosstabY + y, firstOnRow && crosstab.getRunDirection() == 0, firstOnRow && crosstab.getRunDirection() == 1, false));
            }
            if (group.getTotalPosition() == 2 && (totalHeader = group.getTotalHeader()).getWidth() != 0 && totalHeader.getHeight() != 0) {
                crosstabElements.add(this.getCrosstabCellFrame(totalHeader, crosstabX + rowHeadersXOffset + x + header.getWidth(), crosstabY + y, false, false, false));
            }
            y += group.getHeight();
        }
    }

    protected void addCrosstabRows(JRCrosstab crosstab, int rowHeadersXOffset, int colHeadersYOffset, List crosstabElements) {
        JRCrosstabRowGroup[] groups = crosstab.getRowGroups();
        int crosstabX = crosstab.getX();
        int crosstabY = crosstab.getY();
        int x = 0;
        int y = 0;
        for (int i2 = 0; i2 < groups.length; ++i2) {
            JRCellContents totalHeader;
            JRCellContents header;
            JRCellContents totalHeader2;
            JRCrosstabRowGroup group = groups[i2];
            if (group.getTotalPosition() == 1 && (totalHeader2 = group.getTotalHeader()).getWidth() != 0 && totalHeader2.getHeight() != 0) {
                crosstabElements.add(this.getCrosstabCellFrame(totalHeader2, crosstabX + x, crosstabY + colHeadersYOffset + y, false, false, y == 0 && crosstab.getHeaderCell() == null));
                this.addCrosstabDataCellsRow(crosstab, rowHeadersXOffset, colHeadersYOffset + y, i2, crosstabElements);
                y += totalHeader2.getHeight();
            }
            if ((header = group.getHeader()).getWidth() != 0 && header.getHeight() != 0) {
                crosstabElements.add(this.getCrosstabCellFrame(header, crosstabX + x, crosstabY + colHeadersYOffset + y, false, false, y == 0 && crosstab.getHeaderCell() == null));
            }
            if (i2 == groups.length - 1) {
                this.addCrosstabDataCellsRow(crosstab, rowHeadersXOffset, colHeadersYOffset + y, groups.length, crosstabElements);
            }
            if (group.getTotalPosition() == 2 && (totalHeader = group.getTotalHeader()).getWidth() != 0 && totalHeader.getHeight() != 0) {
                crosstabElements.add(this.getCrosstabCellFrame(totalHeader, crosstabX + x, crosstabY + colHeadersYOffset + y + header.getHeight(), false, false, false));
                this.addCrosstabDataCellsRow(crosstab, rowHeadersXOffset, colHeadersYOffset + y + header.getHeight(), i2, crosstabElements);
            }
            x += group.getWidth();
        }
    }

    protected void addCrosstabDataCellsRow(JRCrosstab crosstab, int rowOffsetX, int rowOffsetY, int rowIndex, List crosstabElements) {
        JRCrosstabColumnGroup[] colGroups = crosstab.getColumnGroups();
        JRCrosstabCell[][] cells = crosstab.getCells();
        int crosstabX = crosstab.getX() + rowOffsetX;
        int crosstabY = crosstab.getY() + rowOffsetY;
        int x = 0;
        for (int i2 = 0; i2 < colGroups.length; ++i2) {
            JRCellContents cell;
            JRCrosstabColumnGroup group = colGroups[i2];
            if (group.getTotalPosition() == 1 && (cell = cells[rowIndex][i2].getContents()).getWidth() != 0 && cell.getHeight() != 0) {
                crosstabElements.add(this.getCrosstabCellFrame(cell, crosstabX + x, crosstabY, false, false, false));
                x += cells[rowIndex][i2].getContents().getWidth();
            }
            if (i2 == colGroups.length - 1 && (cell = cells[rowIndex][colGroups.length].getContents()).getWidth() != 0 && cell.getHeight() != 0) {
                crosstabElements.add(this.getCrosstabCellFrame(cell, crosstabX + x, crosstabY, false, false, false));
            }
            if (group.getTotalPosition() != 2 || (cell = cells[rowIndex][i2].getContents()).getWidth() == 0 || cell.getHeight() == 0) continue;
            crosstabElements.add(this.getCrosstabCellFrame(cell, crosstabX + x + group.getHeader().getWidth(), crosstabY, false, false, false));
        }
    }

    public JasperPrint getJasperPrint() {
        return this.jasperPrint;
    }

    protected class ContourElement {
        private int contourX;
        private int contourY;
        private int contourWidth;
        private int contourHeight;
        private byte contourPen;
        private Color contourColor;

        public ContourElement() {
        }

        public ContourElement(int x, int y, int width, int height, Color color, byte pen) {
            this.contourX = x;
            this.contourY = y;
            this.contourWidth = width;
            this.contourHeight = height;
            this.contourColor = color;
            this.contourPen = pen;
        }

        public Color getContourColor() {
            return this.contourColor;
        }

        public void setContourColor(Color contourColor) {
            this.contourColor = contourColor;
        }

        public int getContourHeight() {
            return this.contourHeight;
        }

        public void setContourHeight(int contourHeight) {
            this.contourHeight = contourHeight;
        }

        public byte getContourPen() {
            return this.contourPen;
        }

        public void setContourPen(byte contourPen) {
            this.contourPen = contourPen;
        }

        public int getContourWidth() {
            return this.contourWidth;
        }

        public void setContourWidth(int contourWidth) {
            this.contourWidth = contourWidth;
        }

        public int getContourX() {
            return this.contourX;
        }

        public void setContourX(int contourX) {
            this.contourX = contourX;
        }

        public int getContourY() {
            return this.contourY;
        }

        public void setContourY(int contourY) {
            this.contourY = contourY;
        }
    }
}

