/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.converters;

import java.util.List;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.converters.AbstractArrayConverter;

public final class StringArrayConverter
extends AbstractArrayConverter {
    private static String[] model = new String[0];
    private static int[] ints = new int[0];

    public StringArrayConverter() {
        this.defaultValue = null;
        this.useDefault = false;
    }

    public StringArrayConverter(Object defaultValue) {
        this.defaultValue = defaultValue;
        this.useDefault = true;
    }

    public Object convert(Class type, Object value) {
        if (value == null) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException("No value specified");
        }
        if (model.getClass() == value.getClass()) {
            return value;
        }
        if (ints.getClass() == value.getClass()) {
            int[] values = (int[])value;
            String[] results = new String[values.length];
            int i2 = 0;
            while (i2 < values.length) {
                results[i2] = Integer.toString(values[i2]);
                ++i2;
            }
            return results;
        }
        try {
            List list = this.parseElements(value.toString());
            String[] results = new String[list.size()];
            int i3 = 0;
            while (i3 < results.length) {
                results[i3] = (String)list.get(i3);
                ++i3;
            }
            return results;
        }
        catch (Exception e2) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException(value.toString(), e2);
        }
    }
}

