/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.util.AbstractCollection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.collections.Buffer;
import org.apache.commons.collections.BufferUnderflowException;
import org.apache.commons.collections.PriorityQueue;

public final class BinaryHeap
extends AbstractCollection
implements PriorityQueue,
Buffer {
    private static final int DEFAULT_CAPACITY = 13;
    int m_size;
    Object[] m_elements;
    boolean m_isMinHeap;
    Comparator m_comparator;

    public BinaryHeap() {
        this(13, true);
    }

    public BinaryHeap(Comparator comparator) {
        this();
        this.m_comparator = comparator;
    }

    public BinaryHeap(int n2) {
        this(n2, true);
    }

    public BinaryHeap(int n2, Comparator comparator) {
        this(n2);
        this.m_comparator = comparator;
    }

    public BinaryHeap(boolean bl) {
        this(13, bl);
    }

    public BinaryHeap(boolean bl, Comparator comparator) {
        this(bl);
        this.m_comparator = comparator;
    }

    public BinaryHeap(int n2, boolean bl) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("invalid capacity");
        }
        this.m_isMinHeap = bl;
        this.m_elements = new Object[n2 + 1];
    }

    public BinaryHeap(int n2, boolean bl, Comparator comparator) {
        this(n2, bl);
        this.m_comparator = comparator;
    }

    public void clear() {
        this.m_elements = new Object[this.m_elements.length];
        this.m_size = 0;
    }

    public boolean isEmpty() {
        return this.m_size == 0;
    }

    public boolean isFull() {
        return this.m_elements.length == this.m_size + 1;
    }

    public void insert(Object object) {
        if (this.isFull()) {
            this.grow();
        }
        if (this.m_isMinHeap) {
            this.percolateUpMinHeap(object);
        } else {
            this.percolateUpMaxHeap(object);
        }
    }

    public Object peek() throws NoSuchElementException {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.m_elements[1];
    }

    public Object pop() throws NoSuchElementException {
        Object object = this.peek();
        this.m_elements[1] = this.m_elements[this.m_size--];
        this.m_elements[this.m_size + 1] = null;
        if (this.m_size != 0) {
            if (this.m_isMinHeap) {
                this.percolateDownMinHeap(1);
            } else {
                this.percolateDownMaxHeap(1);
            }
        }
        return object;
    }

    protected void percolateDownMinHeap(int n2) {
        Object object = this.m_elements[n2];
        int n3 = n2;
        while (n3 * 2 <= this.m_size) {
            int n4 = n3 * 2;
            if (n4 != this.m_size && this.compare(this.m_elements[n4 + 1], this.m_elements[n4]) < 0) {
                ++n4;
            }
            if (this.compare(this.m_elements[n4], object) >= 0) break;
            this.m_elements[n3] = this.m_elements[n4];
            n3 = n4;
        }
        this.m_elements[n3] = object;
    }

    protected void percolateDownMaxHeap(int n2) {
        Object object = this.m_elements[n2];
        int n3 = n2;
        while (n3 * 2 <= this.m_size) {
            int n4 = n3 * 2;
            if (n4 != this.m_size && this.compare(this.m_elements[n4 + 1], this.m_elements[n4]) > 0) {
                ++n4;
            }
            if (this.compare(this.m_elements[n4], object) <= 0) break;
            this.m_elements[n3] = this.m_elements[n4];
            n3 = n4;
        }
        this.m_elements[n3] = object;
    }

    protected void percolateUpMinHeap(Object object) {
        int n2 = ++this.m_size;
        this.m_elements[n2] = object;
        while (n2 > 1 && this.compare(object, this.m_elements[n2 / 2]) < 0) {
            int n3 = n2 / 2;
            this.m_elements[n2] = this.m_elements[n3];
            n2 = n3;
        }
        this.m_elements[n2] = object;
    }

    protected void percolateUpMaxHeap(Object object) {
        int n2 = ++this.m_size;
        while (n2 > 1 && this.compare(object, this.m_elements[n2 / 2]) > 0) {
            int n3 = n2 / 2;
            this.m_elements[n2] = this.m_elements[n3];
            n2 = n3;
        }
        this.m_elements[n2] = object;
    }

    private int compare(Object object, Object object2) {
        if (this.m_comparator != null) {
            return this.m_comparator.compare(object, object2);
        }
        return ((Comparable)object).compareTo(object2);
    }

    protected void grow() {
        Object[] objectArray = new Object[this.m_elements.length * 2];
        System.arraycopy(this.m_elements, 0, objectArray, 0, this.m_elements.length);
        this.m_elements = objectArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[ ");
        int n2 = 1;
        while (n2 < this.m_size + 1) {
            if (n2 != 1) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.m_elements[n2]);
            ++n2;
        }
        stringBuffer.append(" ]");
        return stringBuffer.toString();
    }

    public Iterator iterator() {
        return new Iterator(){
            private int index = 1;
            private int lastReturnedIndex = -1;

            public boolean hasNext() {
                return this.index <= BinaryHeap.this.m_size;
            }

            public Object next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.lastReturnedIndex = this.index++;
                return BinaryHeap.this.m_elements[this.lastReturnedIndex];
            }

            public void remove() {
                if (this.lastReturnedIndex == -1) {
                    throw new IllegalStateException();
                }
                BinaryHeap.this.m_elements[this.lastReturnedIndex] = BinaryHeap.this.m_elements[BinaryHeap.this.m_size];
                BinaryHeap.this.m_elements[BinaryHeap.this.m_size] = null;
                --BinaryHeap.this.m_size;
                if (BinaryHeap.this.m_size != 0) {
                    if (BinaryHeap.this.m_isMinHeap) {
                        BinaryHeap.this.percolateDownMinHeap(this.lastReturnedIndex);
                    } else {
                        BinaryHeap.this.percolateDownMaxHeap(this.lastReturnedIndex);
                    }
                }
                --this.index;
                this.lastReturnedIndex = -1;
            }
        };
    }

    public boolean add(Object object) {
        this.insert(object);
        return true;
    }

    public Object get() {
        try {
            return this.peek();
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new BufferUnderflowException();
        }
    }

    public Object remove() {
        try {
            return this.pop();
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new BufferUnderflowException();
        }
    }

    public int size() {
        return this.m_size;
    }
}

