/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class FastArrayList
extends ArrayList {
    protected ArrayList list = null;
    protected boolean fast = false;

    public FastArrayList() {
        this.list = new ArrayList();
    }

    public FastArrayList(int n2) {
        this.list = new ArrayList(n2);
    }

    public FastArrayList(Collection collection) {
        this.list = new ArrayList(collection);
    }

    public boolean getFast() {
        return this.fast;
    }

    public void setFast(boolean bl) {
        this.fast = bl;
    }

    public boolean add(Object object) {
        if (this.fast) {
            FastArrayList fastArrayList = this;
            synchronized (fastArrayList) {
                ArrayList arrayList = (ArrayList)this.list.clone();
                boolean bl = arrayList.add(object);
                this.list = arrayList;
                boolean bl2 = bl;
                return bl2;
            }
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            boolean bl = this.list.add(object);
            return bl;
        }
    }

    public void add(int n2, Object object) {
        if (this.fast) {
            FastArrayList fastArrayList = this;
            synchronized (fastArrayList) {
                ArrayList arrayList = (ArrayList)this.list.clone();
                arrayList.add(n2, object);
                this.list = arrayList;
            }
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            this.list.add(n2, object);
        }
    }

    public boolean addAll(Collection collection) {
        if (this.fast) {
            FastArrayList fastArrayList = this;
            synchronized (fastArrayList) {
                ArrayList arrayList = (ArrayList)this.list.clone();
                boolean bl = arrayList.addAll(collection);
                this.list = arrayList;
                boolean bl2 = bl;
                return bl2;
            }
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            boolean bl = this.list.addAll(collection);
            return bl;
        }
    }

    public boolean addAll(int n2, Collection collection) {
        if (this.fast) {
            FastArrayList fastArrayList = this;
            synchronized (fastArrayList) {
                ArrayList arrayList = (ArrayList)this.list.clone();
                boolean bl = arrayList.addAll(n2, collection);
                this.list = arrayList;
                boolean bl2 = bl;
                return bl2;
            }
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            boolean bl = this.list.addAll(n2, collection);
            return bl;
        }
    }

    public void clear() {
        if (this.fast) {
            FastArrayList fastArrayList = this;
            synchronized (fastArrayList) {
                ArrayList arrayList = (ArrayList)this.list.clone();
                arrayList.clear();
                this.list = arrayList;
            }
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            this.list.clear();
        }
    }

    public Object clone() {
        FastArrayList fastArrayList = null;
        if (this.fast) {
            fastArrayList = new FastArrayList((Collection)this.list);
        } else {
            ArrayList arrayList = this.list;
            synchronized (arrayList) {
                fastArrayList = new FastArrayList((Collection)this.list);
            }
        }
        fastArrayList.setFast(this.getFast());
        return fastArrayList;
    }

    public boolean contains(Object object) {
        if (this.fast) {
            return this.list.contains(object);
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            boolean bl = this.list.contains(object);
            return bl;
        }
    }

    public boolean containsAll(Collection collection) {
        if (this.fast) {
            return this.list.containsAll(collection);
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            boolean bl = this.list.containsAll(collection);
            return bl;
        }
    }

    public void ensureCapacity(int n2) {
        if (this.fast) {
            FastArrayList fastArrayList = this;
            synchronized (fastArrayList) {
                ArrayList arrayList = (ArrayList)this.list.clone();
                arrayList.ensureCapacity(n2);
                this.list = arrayList;
            }
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            this.list.ensureCapacity(n2);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof List)) {
            return false;
        }
        List list = (List)object;
        if (this.fast) {
            ListIterator listIterator = ((AbstractList)this.list).listIterator();
            ListIterator listIterator2 = list.listIterator();
            while (listIterator.hasNext() && listIterator2.hasNext()) {
                Object e2 = listIterator.next();
                Object e3 = listIterator2.next();
                if (e2 == null ? e3 == null : e2.equals(e3)) continue;
                return false;
            }
            return !listIterator.hasNext() && !listIterator2.hasNext();
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            ListIterator listIterator = ((AbstractList)this.list).listIterator();
            ListIterator listIterator3 = list.listIterator();
            while (listIterator.hasNext() && listIterator3.hasNext()) {
                Object e4 = listIterator.next();
                Object e5 = listIterator3.next();
                if (e4 == null ? e5 == null : e4.equals(e5)) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = !listIterator.hasNext() && !listIterator3.hasNext();
            return bl;
        }
    }

    public Object get(int n2) {
        if (this.fast) {
            return this.list.get(n2);
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            Object e2 = this.list.get(n2);
            return e2;
        }
    }

    public int hashCode() {
        if (this.fast) {
            int n2 = 1;
            Iterator iterator = ((AbstractList)this.list).iterator();
            while (iterator.hasNext()) {
                Object e2 = iterator.next();
                n2 = 31 * n2 + (e2 == null ? 0 : e2.hashCode());
            }
            return n2;
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            int n3 = 1;
            Iterator iterator = ((AbstractList)this.list).iterator();
            while (iterator.hasNext()) {
                Object e3 = iterator.next();
                n3 = 31 * n3 + (e3 == null ? 0 : e3.hashCode());
            }
            int n4 = n3;
            return n4;
        }
    }

    public int indexOf(Object object) {
        if (this.fast) {
            return this.list.indexOf(object);
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            int n2 = this.list.indexOf(object);
            return n2;
        }
    }

    public boolean isEmpty() {
        if (this.fast) {
            return this.list.isEmpty();
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            boolean bl = this.list.isEmpty();
            return bl;
        }
    }

    public Iterator iterator() {
        if (this.fast) {
            return new ListIter(0);
        }
        return ((AbstractList)this.list).iterator();
    }

    public int lastIndexOf(Object object) {
        if (this.fast) {
            return this.list.lastIndexOf(object);
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            int n2 = this.list.lastIndexOf(object);
            return n2;
        }
    }

    public ListIterator listIterator() {
        if (this.fast) {
            return new ListIter(0);
        }
        return ((AbstractList)this.list).listIterator();
    }

    public ListIterator listIterator(int n2) {
        if (this.fast) {
            return new ListIter(n2);
        }
        return ((AbstractList)this.list).listIterator(n2);
    }

    public Object remove(int n2) {
        if (this.fast) {
            FastArrayList fastArrayList = this;
            synchronized (fastArrayList) {
                ArrayList arrayList = (ArrayList)this.list.clone();
                Object e2 = arrayList.remove(n2);
                this.list = arrayList;
                Object e3 = e2;
                return e3;
            }
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            Object e4 = this.list.remove(n2);
            return e4;
        }
    }

    public boolean remove(Object object) {
        if (this.fast) {
            FastArrayList fastArrayList = this;
            synchronized (fastArrayList) {
                ArrayList arrayList = (ArrayList)this.list.clone();
                boolean bl = ((AbstractCollection)arrayList).remove(object);
                this.list = arrayList;
                boolean bl2 = bl;
                return bl2;
            }
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            boolean bl = ((AbstractCollection)this.list).remove(object);
            return bl;
        }
    }

    public boolean removeAll(Collection collection) {
        if (this.fast) {
            FastArrayList fastArrayList = this;
            synchronized (fastArrayList) {
                ArrayList arrayList = (ArrayList)this.list.clone();
                boolean bl = ((AbstractCollection)arrayList).removeAll(collection);
                this.list = arrayList;
                boolean bl2 = bl;
                return bl2;
            }
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            boolean bl = ((AbstractCollection)this.list).removeAll(collection);
            return bl;
        }
    }

    public boolean retainAll(Collection collection) {
        if (this.fast) {
            FastArrayList fastArrayList = this;
            synchronized (fastArrayList) {
                ArrayList arrayList = (ArrayList)this.list.clone();
                boolean bl = ((AbstractCollection)arrayList).retainAll(collection);
                this.list = arrayList;
                boolean bl2 = bl;
                return bl2;
            }
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            boolean bl = ((AbstractCollection)this.list).retainAll(collection);
            return bl;
        }
    }

    public Object set(int n2, Object object) {
        if (this.fast) {
            return this.list.set(n2, object);
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            Object object2 = this.list.set(n2, object);
            return object2;
        }
    }

    public int size() {
        if (this.fast) {
            return this.list.size();
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            int n2 = this.list.size();
            return n2;
        }
    }

    public List subList(int n2, int n3) {
        if (this.fast) {
            return new SubList(n2, n3);
        }
        return ((AbstractList)this.list).subList(n2, n3);
    }

    public Object[] toArray() {
        if (this.fast) {
            return this.list.toArray();
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            Object[] objectArray = this.list.toArray();
            return objectArray;
        }
    }

    public Object[] toArray(Object[] objectArray) {
        if (this.fast) {
            return this.list.toArray(objectArray);
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            Object[] objectArray2 = this.list.toArray(objectArray);
            return objectArray2;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("FastArrayList[");
        stringBuffer.append(this.list.toString());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public void trimToSize() {
        if (this.fast) {
            FastArrayList fastArrayList = this;
            synchronized (fastArrayList) {
                ArrayList arrayList = (ArrayList)this.list.clone();
                arrayList.trimToSize();
                this.list = arrayList;
            }
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            this.list.trimToSize();
        }
    }

    private class ListIter
    implements ListIterator {
        private List expected;
        private ListIterator iter;
        private int lastReturnedIndex = -1;

        public ListIter(int n2) {
            this.expected = FastArrayList.this.list;
            this.iter = this.get().listIterator(n2);
        }

        private void checkMod() {
            if (FastArrayList.this.list != this.expected) {
                throw new ConcurrentModificationException();
            }
        }

        List get() {
            return this.expected;
        }

        public boolean hasNext() {
            this.checkMod();
            return this.iter.hasNext();
        }

        public Object next() {
            this.checkMod();
            this.lastReturnedIndex = this.iter.nextIndex();
            return this.iter.next();
        }

        public boolean hasPrevious() {
            this.checkMod();
            return this.iter.hasPrevious();
        }

        public Object previous() {
            this.checkMod();
            this.lastReturnedIndex = this.iter.previousIndex();
            return this.iter.previous();
        }

        public int previousIndex() {
            this.checkMod();
            return this.iter.previousIndex();
        }

        public int nextIndex() {
            this.checkMod();
            return this.iter.nextIndex();
        }

        public void remove() {
            this.checkMod();
            if (this.lastReturnedIndex < 0) {
                throw new IllegalStateException();
            }
            this.get().remove(this.lastReturnedIndex);
            this.expected = FastArrayList.this.list;
            this.iter = this.get().listIterator(this.previousIndex());
            this.lastReturnedIndex = -1;
        }

        public void set(Object object) {
            this.checkMod();
            if (this.lastReturnedIndex < 0) {
                throw new IllegalStateException();
            }
            this.get().set(this.lastReturnedIndex, object);
            this.expected = FastArrayList.this.list;
            this.iter = this.get().listIterator(this.previousIndex() + 1);
        }

        public void add(Object object) {
            this.checkMod();
            int n2 = this.nextIndex();
            this.get().add(n2, object);
            this.iter = this.get().listIterator(n2 + 1);
            this.lastReturnedIndex = 1;
        }
    }

    private class SubList
    implements List {
        private int first;
        private int last;
        private List expected;

        public SubList(int n2, int n3) {
            this.first = n2;
            this.last = n3;
            this.expected = FastArrayList.this.list;
        }

        private List get(List list) {
            if (FastArrayList.this.list != this.expected) {
                throw new ConcurrentModificationException();
            }
            return list.subList(this.first, this.last);
        }

        public void clear() {
            if (FastArrayList.this.fast) {
                FastArrayList fastArrayList = FastArrayList.this;
                synchronized (fastArrayList) {
                    ArrayList arrayList = (ArrayList)FastArrayList.this.list.clone();
                    this.get(arrayList).clear();
                    this.last = this.first;
                    FastArrayList.this.list = arrayList;
                    this.expected = arrayList;
                }
            }
            ArrayList arrayList = FastArrayList.this.list;
            synchronized (arrayList) {
                this.get(this.expected).clear();
            }
        }

        public boolean remove(Object object) {
            if (FastArrayList.this.fast) {
                FastArrayList fastArrayList = FastArrayList.this;
                synchronized (fastArrayList) {
                    ArrayList arrayList = (ArrayList)FastArrayList.this.list.clone();
                    boolean bl = this.get(arrayList).remove(object);
                    if (bl) {
                        --this.last;
                    }
                    FastArrayList.this.list = arrayList;
                    this.expected = arrayList;
                    boolean bl2 = bl;
                    return bl2;
                }
            }
            ArrayList arrayList = FastArrayList.this.list;
            synchronized (arrayList) {
                boolean bl = this.get(this.expected).remove(object);
                return bl;
            }
        }

        public boolean removeAll(Collection collection) {
            if (FastArrayList.this.fast) {
                FastArrayList fastArrayList = FastArrayList.this;
                synchronized (fastArrayList) {
                    ArrayList arrayList = (ArrayList)FastArrayList.this.list.clone();
                    List list = this.get(arrayList);
                    boolean bl = list.removeAll(collection);
                    if (bl) {
                        this.last = this.first + list.size();
                    }
                    FastArrayList.this.list = arrayList;
                    this.expected = arrayList;
                    boolean bl2 = bl;
                    return bl2;
                }
            }
            ArrayList arrayList = FastArrayList.this.list;
            synchronized (arrayList) {
                boolean bl = this.get(this.expected).removeAll(collection);
                return bl;
            }
        }

        public boolean retainAll(Collection collection) {
            if (FastArrayList.this.fast) {
                FastArrayList fastArrayList = FastArrayList.this;
                synchronized (fastArrayList) {
                    ArrayList arrayList = (ArrayList)FastArrayList.this.list.clone();
                    List list = this.get(arrayList);
                    boolean bl = list.retainAll(collection);
                    if (bl) {
                        this.last = this.first + list.size();
                    }
                    FastArrayList.this.list = arrayList;
                    this.expected = arrayList;
                    boolean bl2 = bl;
                    return bl2;
                }
            }
            ArrayList arrayList = FastArrayList.this.list;
            synchronized (arrayList) {
                boolean bl = this.get(this.expected).retainAll(collection);
                return bl;
            }
        }

        public int size() {
            if (FastArrayList.this.fast) {
                return this.get(this.expected).size();
            }
            ArrayList arrayList = FastArrayList.this.list;
            synchronized (arrayList) {
                int n2 = this.get(this.expected).size();
                return n2;
            }
        }

        public boolean isEmpty() {
            if (FastArrayList.this.fast) {
                return this.get(this.expected).isEmpty();
            }
            ArrayList arrayList = FastArrayList.this.list;
            synchronized (arrayList) {
                boolean bl = this.get(this.expected).isEmpty();
                return bl;
            }
        }

        public boolean contains(Object object) {
            if (FastArrayList.this.fast) {
                return this.get(this.expected).contains(object);
            }
            ArrayList arrayList = FastArrayList.this.list;
            synchronized (arrayList) {
                boolean bl = this.get(this.expected).contains(object);
                return bl;
            }
        }

        public boolean containsAll(Collection collection) {
            if (FastArrayList.this.fast) {
                return this.get(this.expected).containsAll(collection);
            }
            ArrayList arrayList = FastArrayList.this.list;
            synchronized (arrayList) {
                boolean bl = this.get(this.expected).containsAll(collection);
                return bl;
            }
        }

        public Object[] toArray(Object[] objectArray) {
            if (FastArrayList.this.fast) {
                return this.get(this.expected).toArray(objectArray);
            }
            ArrayList arrayList = FastArrayList.this.list;
            synchronized (arrayList) {
                Object[] objectArray2 = this.get(this.expected).toArray(objectArray);
                return objectArray2;
            }
        }

        public Object[] toArray() {
            if (FastArrayList.this.fast) {
                return this.get(this.expected).toArray();
            }
            ArrayList arrayList = FastArrayList.this.list;
            synchronized (arrayList) {
                Object[] objectArray = this.get(this.expected).toArray();
                return objectArray;
            }
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (FastArrayList.this.fast) {
                return this.get(this.expected).equals(object);
            }
            ArrayList arrayList = FastArrayList.this.list;
            synchronized (arrayList) {
                boolean bl = this.get(this.expected).equals(object);
                return bl;
            }
        }

        public int hashCode() {
            if (FastArrayList.this.fast) {
                return this.get(this.expected).hashCode();
            }
            ArrayList arrayList = FastArrayList.this.list;
            synchronized (arrayList) {
                int n2 = this.get(this.expected).hashCode();
                return n2;
            }
        }

        public boolean add(Object object) {
            if (FastArrayList.this.fast) {
                FastArrayList fastArrayList = FastArrayList.this;
                synchronized (fastArrayList) {
                    ArrayList arrayList = (ArrayList)FastArrayList.this.list.clone();
                    boolean bl = this.get(arrayList).add(object);
                    if (bl) {
                        ++this.last;
                    }
                    FastArrayList.this.list = arrayList;
                    this.expected = arrayList;
                    boolean bl2 = bl;
                    return bl2;
                }
            }
            ArrayList arrayList = FastArrayList.this.list;
            synchronized (arrayList) {
                boolean bl = this.get(this.expected).add(object);
                return bl;
            }
        }

        public boolean addAll(Collection collection) {
            if (FastArrayList.this.fast) {
                FastArrayList fastArrayList = FastArrayList.this;
                synchronized (fastArrayList) {
                    ArrayList arrayList = (ArrayList)FastArrayList.this.list.clone();
                    boolean bl = this.get(arrayList).addAll(collection);
                    if (bl) {
                        this.last += collection.size();
                    }
                    FastArrayList.this.list = arrayList;
                    this.expected = arrayList;
                    boolean bl2 = bl;
                    return bl2;
                }
            }
            ArrayList arrayList = FastArrayList.this.list;
            synchronized (arrayList) {
                boolean bl = this.get(this.expected).addAll(collection);
                return bl;
            }
        }

        public void add(int n2, Object object) {
            if (FastArrayList.this.fast) {
                FastArrayList fastArrayList = FastArrayList.this;
                synchronized (fastArrayList) {
                    ArrayList arrayList = (ArrayList)FastArrayList.this.list.clone();
                    this.get(arrayList).add(n2, object);
                    ++this.last;
                    FastArrayList.this.list = arrayList;
                    this.expected = arrayList;
                }
            }
            ArrayList arrayList = FastArrayList.this.list;
            synchronized (arrayList) {
                this.get(this.expected).add(n2, object);
            }
        }

        public boolean addAll(int n2, Collection collection) {
            if (FastArrayList.this.fast) {
                FastArrayList fastArrayList = FastArrayList.this;
                synchronized (fastArrayList) {
                    ArrayList arrayList = (ArrayList)FastArrayList.this.list.clone();
                    boolean bl = this.get(arrayList).addAll(n2, collection);
                    FastArrayList.this.list = arrayList;
                    if (bl) {
                        this.last += collection.size();
                    }
                    this.expected = arrayList;
                    boolean bl2 = bl;
                    return bl2;
                }
            }
            ArrayList arrayList = FastArrayList.this.list;
            synchronized (arrayList) {
                boolean bl = this.get(this.expected).addAll(n2, collection);
                return bl;
            }
        }

        public Object remove(int n2) {
            if (FastArrayList.this.fast) {
                FastArrayList fastArrayList = FastArrayList.this;
                synchronized (fastArrayList) {
                    ArrayList arrayList = (ArrayList)FastArrayList.this.list.clone();
                    Object e2 = this.get(arrayList).remove(n2);
                    --this.last;
                    FastArrayList.this.list = arrayList;
                    this.expected = arrayList;
                    Object e3 = e2;
                    return e3;
                }
            }
            ArrayList arrayList = FastArrayList.this.list;
            synchronized (arrayList) {
                Object e4 = this.get(this.expected).remove(n2);
                return e4;
            }
        }

        public Object set(int n2, Object object) {
            if (FastArrayList.this.fast) {
                FastArrayList fastArrayList = FastArrayList.this;
                synchronized (fastArrayList) {
                    ArrayList arrayList = (ArrayList)FastArrayList.this.list.clone();
                    Object object2 = this.get(arrayList).set(n2, object);
                    FastArrayList.this.list = arrayList;
                    this.expected = arrayList;
                    Object object3 = object2;
                    return object3;
                }
            }
            ArrayList arrayList = FastArrayList.this.list;
            synchronized (arrayList) {
                Object object4 = this.get(this.expected).set(n2, object);
                return object4;
            }
        }

        public Iterator iterator() {
            return new SubListIter(0);
        }

        public ListIterator listIterator() {
            return new SubListIter(0);
        }

        public ListIterator listIterator(int n2) {
            return new SubListIter(n2);
        }

        public Object get(int n2) {
            if (FastArrayList.this.fast) {
                return this.get(this.expected).get(n2);
            }
            ArrayList arrayList = FastArrayList.this.list;
            synchronized (arrayList) {
                Object e2 = this.get(this.expected).get(n2);
                return e2;
            }
        }

        public int indexOf(Object object) {
            if (FastArrayList.this.fast) {
                return this.get(this.expected).indexOf(object);
            }
            ArrayList arrayList = FastArrayList.this.list;
            synchronized (arrayList) {
                int n2 = this.get(this.expected).indexOf(object);
                return n2;
            }
        }

        public int lastIndexOf(Object object) {
            if (FastArrayList.this.fast) {
                return this.get(this.expected).lastIndexOf(object);
            }
            ArrayList arrayList = FastArrayList.this.list;
            synchronized (arrayList) {
                int n2 = this.get(this.expected).lastIndexOf(object);
                return n2;
            }
        }

        public List subList(int n2, int n3) {
            if (FastArrayList.this.list != this.expected) {
                throw new ConcurrentModificationException();
            }
            return new SubList(this.first + n2, n2 + n3);
        }

        private class SubListIter
        implements ListIterator {
            private List expected;
            private ListIterator iter;
            private int lastReturnedIndex = -1;

            public SubListIter(int n2) {
                this.expected = ((SubList)SubList.this).FastArrayList.this.list;
                this.iter = SubList.this.get(this.expected).listIterator(n2);
            }

            private void checkMod() {
                if (((SubList)SubList.this).FastArrayList.this.list != this.expected) {
                    throw new ConcurrentModificationException();
                }
            }

            List get() {
                return SubList.this.get(this.expected);
            }

            public boolean hasNext() {
                this.checkMod();
                return this.iter.hasNext();
            }

            public Object next() {
                this.checkMod();
                this.lastReturnedIndex = this.iter.nextIndex();
                return this.iter.next();
            }

            public boolean hasPrevious() {
                this.checkMod();
                return this.iter.hasPrevious();
            }

            public Object previous() {
                this.checkMod();
                this.lastReturnedIndex = this.iter.previousIndex();
                return this.iter.previous();
            }

            public int previousIndex() {
                this.checkMod();
                return this.iter.previousIndex();
            }

            public int nextIndex() {
                this.checkMod();
                return this.iter.nextIndex();
            }

            public void remove() {
                this.checkMod();
                if (this.lastReturnedIndex < 0) {
                    throw new IllegalStateException();
                }
                this.get().remove(this.lastReturnedIndex);
                SubList.this.last--;
                this.expected = ((SubList)SubList.this).FastArrayList.this.list;
                this.iter = this.get().listIterator(this.previousIndex());
                this.lastReturnedIndex = -1;
            }

            public void set(Object object) {
                this.checkMod();
                if (this.lastReturnedIndex < 0) {
                    throw new IllegalStateException();
                }
                this.get().set(this.lastReturnedIndex, object);
                this.expected = ((SubList)SubList.this).FastArrayList.this.list;
                this.iter = this.get().listIterator(this.previousIndex() + 1);
            }

            public void add(Object object) {
                this.checkMod();
                int n2 = this.nextIndex();
                this.get().add(n2, object);
                SubList.this.last++;
                this.iter = this.get().listIterator(n2 + 1);
                this.lastReturnedIndex = 1;
            }
        }
    }
}

