/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public final class StaticBucketMap
implements Map {
    private static final int DEFAULT_BUCKETS = 255;
    private Node[] m_buckets;
    private Lock[] m_locks;

    public StaticBucketMap() {
        this(255);
    }

    public StaticBucketMap(int n2) {
        int n3 = Math.max(17, n2);
        if (n3 % 2 == 0) {
            --n3;
        }
        this.m_buckets = new Node[n3];
        this.m_locks = new Lock[n3];
        int n4 = 0;
        while (n4 < n3) {
            this.m_locks[n4] = new Lock();
            ++n4;
        }
    }

    private final int getHash(Object object) {
        if (object == null) {
            return 0;
        }
        int n2 = object.hashCode();
        n2 += ~(n2 << 15);
        n2 ^= n2 >>> 10;
        n2 += n2 << 3;
        n2 ^= n2 >>> 6;
        n2 += ~(n2 << 11);
        n2 ^= n2 >>> 16;
        return (n2 %= this.m_buckets.length) < 0 ? n2 * -1 : n2;
    }

    public Set keySet() {
        return new KeySet();
    }

    public int size() {
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.m_buckets.length) {
            n2 += this.m_locks[n3].size;
            ++n3;
        }
        return n2;
    }

    public Object put(Object object, Object object2) {
        int n2 = this.getHash(object);
        Lock lock = this.m_locks[n2];
        synchronized (lock) {
            Node node = this.m_buckets[n2];
            if (node == null) {
                node = new Node();
                node.key = object;
                node.value = object2;
                this.m_buckets[n2] = node;
                ++this.m_locks[n2].size;
                Object var6_6 = null;
                return var6_6;
            }
            Node node2 = node;
            while (node2 != null) {
                node = node2;
                if (node.key == object || node.key != null && node.key.equals(object)) {
                    Object object3 = node.value;
                    node.value = object2;
                    Object object4 = object3;
                    return object4;
                }
                node2 = node2.next;
            }
            Node node3 = new Node();
            node3.key = object;
            node3.value = object2;
            node.next = node3;
            ++this.m_locks[n2].size;
        }
        return null;
    }

    public Object get(Object object) {
        int n2 = this.getHash(object);
        Lock lock = this.m_locks[n2];
        synchronized (lock) {
            Node node = this.m_buckets[n2];
            while (node != null) {
                if (node.key == object || node.key != null && node.key.equals(object)) {
                    Object object2 = node.value;
                    return object2;
                }
                node = node.next;
            }
        }
        return null;
    }

    public boolean containsKey(Object object) {
        int n2 = this.getHash(object);
        Lock lock = this.m_locks[n2];
        synchronized (lock) {
            Node node = this.m_buckets[n2];
            while (node != null) {
                if (node.key == null || node.key != null && node.key.equals(object)) {
                    boolean bl = true;
                    return bl;
                }
                node = node.next;
            }
        }
        return false;
    }

    public boolean containsValue(Object object) {
        int n2 = 0;
        while (n2 < this.m_buckets.length) {
            Lock lock = this.m_locks[n2];
            synchronized (lock) {
                Node node = this.m_buckets[n2];
                while (node != null) {
                    if (node.value == object || node.value != null && node.value.equals(object)) {
                        boolean bl = true;
                        return bl;
                    }
                    node = node.next;
                }
            }
            ++n2;
        }
        return false;
    }

    public Collection values() {
        return new Values();
    }

    public Set entrySet() {
        return new EntrySet();
    }

    public void putAll(Map map) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object k2 = iterator.next();
            this.put(k2, map.get(k2));
        }
    }

    public Object remove(Object object) {
        int n2 = this.getHash(object);
        Lock lock = this.m_locks[n2];
        synchronized (lock) {
            Node node = this.m_buckets[n2];
            Node node2 = null;
            while (node != null) {
                if (node.key == null || node.key != null && node.key.equals(object)) {
                    if (null == node2) {
                        this.m_buckets[n2] = node.next;
                    } else {
                        node2.next = node.next;
                    }
                    --this.m_locks[n2].size;
                    Object object2 = node.value;
                    return object2;
                }
                node2 = node;
                node = node.next;
            }
        }
        return null;
    }

    public final boolean isEmpty() {
        return this.size() == 0;
    }

    public final void clear() {
        int n2 = 0;
        while (n2 < this.m_buckets.length) {
            Lock lock;
            Lock lock2 = lock = this.m_locks[n2];
            synchronized (lock2) {
                this.m_buckets[n2] = null;
                lock.size = 0;
            }
            ++n2;
        }
    }

    public final boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof Map)) {
            return false;
        }
        Map map = (Map)object;
        return this.entrySet().equals(map.entrySet());
    }

    public final int hashCode() {
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.m_buckets.length) {
            Lock lock = this.m_locks[n3];
            synchronized (lock) {
                Node node = this.m_buckets[n3];
                while (node != null) {
                    n2 += node.hashCode();
                    node = node.next;
                }
            }
            ++n3;
        }
        return n2;
    }

    public void atomic(Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException();
        }
        this.atomic(runnable, 0);
    }

    private void atomic(Runnable runnable, int n2) {
        if (n2 >= this.m_buckets.length) {
            runnable.run();
            return;
        }
        Lock lock = this.m_locks[n2];
        synchronized (lock) {
            this.atomic(runnable, n2 + 1);
        }
    }

    private class Values
    extends AbstractCollection {
        private Values() {
        }

        public int size() {
            return StaticBucketMap.this.size();
        }

        public void clear() {
            StaticBucketMap.this.clear();
        }

        public Iterator iterator() {
            return new ValueIterator();
        }
    }

    private class KeySet
    extends AbstractSet {
        private KeySet() {
        }

        public int size() {
            return StaticBucketMap.this.size();
        }

        public void clear() {
            StaticBucketMap.this.clear();
        }

        public Iterator iterator() {
            return new KeyIterator();
        }

        public boolean contains(Object object) {
            return StaticBucketMap.this.containsKey(object);
        }

        public boolean remove(Object object) {
            int n2 = StaticBucketMap.this.getHash(object);
            Lock lock = StaticBucketMap.this.m_locks[n2];
            synchronized (lock) {
                Node node = StaticBucketMap.this.m_buckets[n2];
                while (node != null) {
                    Object object2 = node.getKey();
                    if (object2 == object || object2 != null && object2.equals(object)) {
                        StaticBucketMap.this.remove(object2);
                        boolean bl = true;
                        return bl;
                    }
                    node = node.next;
                }
            }
            return false;
        }
    }

    private class EntrySet
    extends AbstractSet {
        private EntrySet() {
        }

        public int size() {
            return StaticBucketMap.this.size();
        }

        public void clear() {
            StaticBucketMap.this.clear();
        }

        public Iterator iterator() {
            return new EntryIterator();
        }

        public boolean contains(Object object) {
            Map.Entry entry = (Map.Entry)object;
            int n2 = StaticBucketMap.this.getHash(entry.getKey());
            Lock lock = StaticBucketMap.this.m_locks[n2];
            synchronized (lock) {
                Node node = StaticBucketMap.this.m_buckets[n2];
                while (node != null) {
                    if (node.equals(entry)) {
                        boolean bl = true;
                        return bl;
                    }
                    node = node.next;
                }
            }
            return false;
        }

        public boolean remove(Object object) {
            Map.Entry entry = (Map.Entry)object;
            int n2 = StaticBucketMap.this.getHash(entry.getKey());
            Lock lock = StaticBucketMap.this.m_locks[n2];
            synchronized (lock) {
                Node node = StaticBucketMap.this.m_buckets[n2];
                while (node != null) {
                    if (node.equals(entry)) {
                        StaticBucketMap.this.remove(node.getKey());
                        boolean bl = true;
                        return bl;
                    }
                    node = node.next;
                }
            }
            return false;
        }
    }

    private class KeyIterator
    extends EntryIterator {
        private KeyIterator() {
        }

        public Object next() {
            return this.nextEntry().getKey();
        }
    }

    private class ValueIterator
    extends EntryIterator {
        private ValueIterator() {
        }

        public Object next() {
            return this.nextEntry().getValue();
        }
    }

    private class EntryIterator
    implements Iterator {
        private ArrayList current = new ArrayList();
        private int bucket;
        private Map.Entry last;

        private EntryIterator() {
        }

        /*
         * Unable to fully structure code
         */
        public boolean hasNext() {
            if (this.current.size() <= 0) ** GOTO lbl19
            return true;
lbl-1000:
            // 1 sources

            {
                var1_1 = StaticBucketMap.access$600(StaticBucketMap.this)[this.bucket];
                synchronized (var1_1) {
                    var2_2 = StaticBucketMap.access$500(StaticBucketMap.this)[this.bucket];
                    while (var2_2 != null) {
                        this.current.add(var2_2);
                        var2_2 = var2_2.next;
                    }
                    ++this.bucket;
                    if (this.current.size() > 0) {
                        var3_3 = true;
                        return var3_3;
                    }
                    continue;
                }
lbl19:
                // 2 sources

                ** while (this.bucket < StaticBucketMap.access$500((StaticBucketMap)StaticBucketMap.this).length)
            }
lbl20:
            // 1 sources

            return false;
        }

        protected Map.Entry nextEntry() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.last = (Map.Entry)this.current.remove(this.current.size() - 1);
            return this.last;
        }

        public Object next() {
            return this.nextEntry();
        }

        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException();
            }
            StaticBucketMap.this.remove(this.last.getKey());
            this.last = null;
        }
    }

    private static final class Lock {
        public int size;

        private Lock() {
        }
    }

    private final class Node
    implements Map.Entry {
        protected Object key;
        protected Object value;
        protected Node next;

        private Node() {
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object object) {
            boolean bl;
            if (object == null) {
                return false;
            }
            if (object == this) {
                return true;
            }
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            if (this.key == null) {
                if (entry.getKey() != null) return false;
                bl = true;
            } else {
                bl = this.key.equals(entry.getKey());
            }
            if (!bl) return false;
            if (this.value == null) {
                if (entry.getValue() != null) return false;
                return true;
            }
            boolean bl2 = this.value.equals(entry.getValue());
            if (!bl2) return false;
            return true;
        }

        public Object setValue(Object object) {
            Object object2 = this.value;
            this.value = object;
            return object2;
        }
    }
}

