/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.util.AbstractCollection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.collections.Buffer;
import org.apache.commons.collections.BufferUnderflowException;

public final class UnboundedFifoBuffer
extends AbstractCollection
implements Buffer {
    protected Object[] m_buffer;
    protected int m_head;
    protected int m_tail;

    public UnboundedFifoBuffer() {
        this(32);
    }

    public UnboundedFifoBuffer(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("The size must be greater than 0");
        }
        this.m_buffer = new Object[n2 + 1];
        this.m_head = 0;
        this.m_tail = 0;
    }

    public int size() {
        int n2 = 0;
        n2 = this.m_tail < this.m_head ? this.m_buffer.length - this.m_head + this.m_tail : this.m_tail - this.m_head;
        return n2;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean add(Object object) {
        if (null == object) {
            throw new NullPointerException("Attempted to add null object to buffer");
        }
        if (this.size() + 1 >= this.m_buffer.length) {
            Object[] objectArray = new Object[(this.m_buffer.length - 1) * 2 + 1];
            int n2 = 0;
            int n3 = this.m_head;
            while (n3 != this.m_tail) {
                objectArray[n2] = this.m_buffer[n3];
                this.m_buffer[n3] = null;
                ++n2;
                if (++n3 != this.m_buffer.length) continue;
                n3 = 0;
            }
            this.m_buffer = objectArray;
            this.m_head = 0;
            this.m_tail = n2;
        }
        this.m_buffer[this.m_tail] = object;
        ++this.m_tail;
        if (this.m_tail >= this.m_buffer.length) {
            this.m_tail = 0;
        }
        return true;
    }

    public Object get() {
        if (this.isEmpty()) {
            throw new BufferUnderflowException("The buffer is already empty");
        }
        return this.m_buffer[this.m_head];
    }

    public Object remove() {
        if (this.isEmpty()) {
            throw new BufferUnderflowException("The buffer is already empty");
        }
        Object object = this.m_buffer[this.m_head];
        if (null != object) {
            this.m_buffer[this.m_head] = null;
            ++this.m_head;
            if (this.m_head >= this.m_buffer.length) {
                this.m_head = 0;
            }
        }
        return object;
    }

    private int increment(int n2) {
        if (++n2 >= this.m_buffer.length) {
            n2 = 0;
        }
        return n2;
    }

    private int decrement(int n2) {
        if (--n2 < 0) {
            n2 = this.m_buffer.length - 1;
        }
        return n2;
    }

    public Iterator iterator() {
        return new Iterator(){
            private int index;
            private int lastReturnedIndex;
            {
                this.index = UnboundedFifoBuffer.this.m_head;
                this.lastReturnedIndex = -1;
            }

            public boolean hasNext() {
                return this.index != UnboundedFifoBuffer.this.m_tail;
            }

            public Object next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.lastReturnedIndex = this.index;
                this.index = UnboundedFifoBuffer.this.increment(this.index);
                return UnboundedFifoBuffer.this.m_buffer[this.lastReturnedIndex];
            }

            public void remove() {
                if (this.lastReturnedIndex == -1) {
                    throw new IllegalStateException();
                }
                if (this.lastReturnedIndex == UnboundedFifoBuffer.this.m_head) {
                    UnboundedFifoBuffer.this.remove();
                    this.lastReturnedIndex = -1;
                    return;
                }
                int n2 = this.lastReturnedIndex + 1;
                while (n2 != UnboundedFifoBuffer.this.m_tail) {
                    if (n2 >= UnboundedFifoBuffer.this.m_buffer.length) {
                        UnboundedFifoBuffer.this.m_buffer[n2 - 1] = UnboundedFifoBuffer.this.m_buffer[0];
                        n2 = 0;
                        continue;
                    }
                    UnboundedFifoBuffer.this.m_buffer[n2 - 1] = UnboundedFifoBuffer.this.m_buffer[n2];
                    ++n2;
                }
                this.lastReturnedIndex = -1;
                UnboundedFifoBuffer.this.m_tail = UnboundedFifoBuffer.this.decrement(UnboundedFifoBuffer.this.m_tail);
                UnboundedFifoBuffer.this.m_buffer[UnboundedFifoBuffer.this.m_tail] = null;
                this.index = UnboundedFifoBuffer.this.decrement(this.index);
            }
        };
    }
}

