/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.javaflow.bytecode.transformation.bcel;

import java.io.OutputStream;
import java.io.PrintWriter;
import org.apache.bcel.Constants;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.ConstantValue;
import org.apache.bcel.classfile.Deprecated;
import org.apache.bcel.classfile.DescendingVisitor;
import org.apache.bcel.classfile.EmptyVisitor;
import org.apache.bcel.classfile.ExceptionTable;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Synthetic;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.classfile.Visitor;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.CodeExceptionGen;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.LocalVariableGen;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.Select;
import org.apache.bcel.generic.TABLESWITCH;

public final class DecompilingVisitor
extends EmptyVisitor {
    private JavaClass clazz;
    private PrintWriter out;
    private String clazzname;
    private ConstantPoolGen cp;
    private Method _method;

    public DecompilingVisitor(JavaClass clazz, OutputStream out) {
        this.clazz = clazz;
        this.out = new PrintWriter(out);
        this.clazzname = clazz.getClassName();
        this.cp = new ConstantPoolGen(clazz.getConstantPool());
    }

    public void start() {
        new DescendingVisitor(this.clazz, (Visitor)this).visit();
        this.out.close();
    }

    public void visitJavaClass(JavaClass clazz) {
        this.out.println("// source " + clazz.getSourceFileName());
        this.out.println(Utility.accessToString((int)clazz.getAccessFlags(), (boolean)true) + " " + Utility.classOrInterface((int)clazz.getAccessFlags()) + " " + clazz.getClassName().replace('.', '/'));
        this.out.println("  extends " + clazz.getSuperclassName().replace('.', '/'));
        String[] interfaces = clazz.getInterfaceNames();
        if (interfaces.length > 0) {
            this.out.print("  implements");
            for (int i2 = 0; i2 < interfaces.length; ++i2) {
                this.out.print(" " + interfaces[i2].replace('.', '/'));
            }
            this.out.println();
        }
        this.out.println();
    }

    public void visitField(Field field) {
        this.out.println("  " + Utility.accessToString((int)field.getAccessFlags()) + " " + field.getType() + " " + field.getName() + ";");
    }

    public void visitConstantValue(ConstantValue cv) {
        this.out.println(" = " + cv);
    }

    public void visitDeprecated(Deprecated attribute) {
    }

    public void visitSynthetic(Synthetic attribute) {
    }

    public void visitMethod(Method method) {
        this._method = method;
        this.out.println("\n  " + Utility.accessToString((int)this._method.getAccessFlags()) + " " + this._method.getReturnType() + " " + this._method.getName());
    }

    public void visitExceptionTable(ExceptionTable e2) {
        String[] names = e2.getExceptionNames();
        for (int i2 = 0; i2 < names.length; ++i2) {
            this.out.println("    throws " + names[i2].replace('.', '/'));
        }
    }

    public void visitCode(Code code) {
        int i2;
        MethodGen mg = new MethodGen(this._method, this.clazzname, this.cp);
        InstructionList il = mg.getInstructionList();
        InstructionHandle[] ihs = il.getInstructionHandles();
        LocalVariableGen[] lvs = mg.getLocalVariables();
        CodeExceptionGen[] ehs = mg.getExceptionHandlers();
        for (i2 = 0; i2 < lvs.length; ++i2) {
            LocalVariableGen l2 = lvs[i2];
            this.out.println("    // local variable " + l2.getIndex() + " is \"" + l2.getName() + "\" " + l2.getType() + " from " + l2.getStart().getPosition() + " to " + l2.getEnd().getPosition());
        }
        this.out.print("\n");
        for (i2 = 0; i2 < ihs.length; ++i2) {
            InstructionHandle ih = ihs[i2];
            Instruction inst = ih.getInstruction();
            this.out.print("    " + ih.getPosition());
            if (inst instanceof BranchInstruction) {
                if (inst instanceof Select) {
                    int j2;
                    Select s = (Select)inst;
                    int[] matchs = s.getMatchs();
                    InstructionHandle[] targets = s.getTargets();
                    if (s instanceof TABLESWITCH) {
                        this.out.println("  tableswitch " + matchs[0] + " " + matchs[matchs.length - 1]);
                        for (j2 = 0; j2 < targets.length; ++j2) {
                            this.out.println("        " + targets[j2].getPosition());
                        }
                    } else {
                        this.out.println("  lookupswitch ");
                        for (j2 = 0; j2 < targets.length; ++j2) {
                            this.out.println("        " + matchs[j2] + " : " + targets[j2].getPosition());
                        }
                    }
                    this.out.println("        default: " + s.getTarget());
                    continue;
                }
                BranchInstruction bi = (BranchInstruction)inst;
                ih = bi.getTarget();
                this.out.println("  " + Constants.OPCODE_NAMES[bi.getOpcode()] + " " + ih);
                continue;
            }
            this.out.println("  " + inst.toString(this.cp.getConstantPool()));
        }
        this.out.print("\n");
        for (i2 = 0; i2 < ehs.length; ++i2) {
            CodeExceptionGen c2 = ehs[i2];
            ObjectType caught = c2.getCatchType();
            String class_name = caught == null ? "all" : caught.getClassName().replace('.', '/');
            this.out.println("    catch " + class_name + " from " + c2.getStartPC().getPosition() + " to " + c2.getEndPC().getPosition() + " using " + c2.getHandlerPC().getPosition());
        }
    }
}

