/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ant;

import groovy.lang.Binding;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyShell;
import groovy.lang.MissingMethodException;
import groovy.lang.Script;
import groovy.util.AntBuilder;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.codehaus.groovy.ant.AntProjectPropertiesDelegate;
import org.codehaus.groovy.ant.LoggingHelper;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.tools.ErrorReporter;

public class Groovy
extends Task {
    private final LoggingHelper log = new LoggingHelper(this);
    private Vector filesets = new Vector();
    private File srcFile = null;
    private String command = "";
    private File output = null;
    private boolean append = false;
    private Path classpath;
    private CompilerConfiguration configuration = new CompilerConfiguration();
    private Commandline cmdline = new Commandline();

    public void setStacktrace(boolean stacktrace) {
        this.configuration.setDebug(stacktrace);
    }

    public void setSrc(File srcFile) {
        this.srcFile = srcFile;
    }

    public void addText(String txt) {
        this.log("addText('" + txt + "')", 3);
        this.command = this.command + txt;
    }

    public void addFileset(FileSet set) {
        this.filesets.addElement(set);
    }

    public void setOutput(File output) {
        this.output = output;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    public void setClasspath(Path classpath) {
        this.classpath = classpath;
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference ref) {
        this.createClasspath().setRefid(ref);
    }

    public Path getClasspath() {
        return this.classpath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        block12: {
            this.log.debug("execute()");
            this.command = this.command.trim();
            if (this.srcFile == null && this.command.length() == 0 && this.filesets.isEmpty()) {
                throw new BuildException("Source file does not exist!", this.getLocation());
            }
            if (this.srcFile != null && !this.srcFile.exists()) {
                throw new BuildException("Source file does not exist!", this.getLocation());
            }
            for (int i2 = 0; i2 < this.filesets.size(); ++i2) {
                FileSet fs = (FileSet)this.filesets.elementAt(i2);
                DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
                File srcDir = fs.getDir(this.getProject());
                String[] srcFiles = ds.getIncludedFiles();
            }
            try {
                PrintStream out = System.out;
                try {
                    if (this.output != null) {
                        this.log.verbose("Opening PrintStream to output file " + this.output);
                        out = new PrintStream(new BufferedOutputStream(new FileOutputStream(this.output.getAbsolutePath(), this.append)));
                    }
                    if (this.command == null || this.command.trim().length() == 0) {
                        this.createClasspath().add(new Path(this.getProject(), this.srcFile.getParentFile().getCanonicalPath()));
                        this.command = Groovy.getText(new BufferedReader(new FileReader(this.srcFile)));
                    }
                    if (this.command != null) {
                        this.execGroovy(this.command, out);
                        break block12;
                    }
                    throw new BuildException("Source file does not exist!", this.getLocation());
                }
                finally {
                    if (out != null && out != System.out) {
                        out.close();
                    }
                }
            }
            catch (IOException e2) {
                throw new BuildException((Throwable)e2, this.getLocation());
            }
        }
        this.log.verbose("statements executed successfully");
    }

    private static String getText(BufferedReader reader) throws IOException {
        StringBuffer answer = new StringBuffer();
        char[] charBuffer = new char[4096];
        int nbCharRead = 0;
        while ((nbCharRead = reader.read(charBuffer)) != -1) {
            answer.append(charBuffer, 0, nbCharRead);
        }
        reader.close();
        return answer.toString();
    }

    public Commandline.Argument createArg() {
        return this.cmdline.createArgument();
    }

    protected void runStatements(Reader reader, PrintStream out) throws IOException {
        this.log.debug("runStatements()");
        StringBuffer txt = new StringBuffer();
        String line = "";
        BufferedReader in = new BufferedReader(reader);
        while ((line = in.readLine()) != null) {
            line = this.getProject().replaceProperties(line);
            if (line.indexOf("--") < 0) continue;
            txt.append("\n");
        }
        if (!txt.toString().equals("")) {
            this.execGroovy(txt.toString(), out);
        }
    }

    protected void execGroovy(String txt, PrintStream out) {
        ClassLoader baseClassLoader;
        this.log.debug("execGroovy()");
        if ("".equals(txt.trim())) {
            return;
        }
        this.log.verbose("Groovy: " + txt);
        Object mavenPom = null;
        Project project = this.getProject();
        if ("org.apache.commons.grant.GrantProject".equals(project.getClass().getName())) {
            try {
                Object propsHandler = project.getClass().getMethod("getPropsHandler", new Class[0]).invoke((Object)project, new Object[0]);
                Field contextField = propsHandler.getClass().getDeclaredField("context");
                contextField.setAccessible(true);
                Object context = contextField.get(propsHandler);
                mavenPom = InvokerHelper.invokeMethod(context, "getProject", new Object[0]);
            }
            catch (Exception e2) {
                throw new BuildException("Impossible to retrieve Maven's Ant project: " + e2.getMessage(), this.getLocation());
            }
            Thread.currentThread().setContextClassLoader(GroovyShell.class.getClassLoader());
            baseClassLoader = mavenPom.getClass().getClassLoader();
        } else {
            baseClassLoader = GroovyShell.class.getClassLoader();
        }
        String scriptName = this.computeScriptName();
        GroovyClassLoader classLoader = new GroovyClassLoader(baseClassLoader);
        this.addClassPathes(classLoader);
        GroovyShell groovy = new GroovyShell(classLoader, new Binding(), this.configuration);
        try {
            Script script = groovy.parse(txt, scriptName);
            script.setProperty("ant", new AntBuilder(this));
            script.setProperty("project", project);
            script.setProperty("properties", new AntProjectPropertiesDelegate(project));
            script.setProperty("target", this.getOwningTarget());
            script.setProperty("task", (Object)this);
            script.setProperty("args", this.cmdline.getCommandline());
            if (mavenPom != null) {
                script.setProperty("pom", mavenPom);
            }
            script.run();
        }
        catch (MissingMethodException e3) {
            groovy.run(txt, scriptName, this.cmdline.getCommandline());
        }
        catch (CompilationFailedException e4) {
            StringWriter writer = new StringWriter();
            new ErrorReporter(e4, false).write(new PrintWriter(writer));
            String message = writer.toString();
            throw new BuildException("Script Failed: " + message, (Throwable)e4, this.getLocation());
        }
    }

    private String computeScriptName() {
        if (this.srcFile != null) {
            return this.srcFile.getAbsolutePath();
        }
        String name = "embedded_script_in_";
        name = this.getLocation().getFileName().length() > 0 ? name + this.getLocation().getFileName().replaceAll("[^\\w_\\.]", "_") : name + "groovy_Ant_task";
        return name;
    }

    protected void addClassPathes(GroovyClassLoader classLoader) {
        if (this.classpath != null) {
            for (int i2 = 0; i2 < this.classpath.list().length; ++i2) {
                classLoader.addClasspath(this.classpath.list()[i2]);
            }
        }
    }

    protected void printResults(PrintStream out) {
        this.log.debug("printResults()");
        StringBuffer line = new StringBuffer();
        out.println(line);
        line = new StringBuffer();
        out.println();
    }
}

