/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.binding;

import groovy.lang.GroovyObjectSupport;
import groovy.lang.ReadOnlyPropertyException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.binding.BindingUpdatable;
import org.codehaus.groovy.binding.FullBinding;
import org.codehaus.groovy.binding.PropertyBinding;
import org.codehaus.groovy.binding.SourceBinding;
import org.codehaus.groovy.binding.TargetBinding;

public class ModelBinding
extends GroovyObjectSupport
implements BindingUpdatable {
    Object model;
    boolean bound;
    final Map propertyBindings = new HashMap();
    final List generatedBindings = new ArrayList();

    public ModelBinding(Object model) {
        this.model = model;
    }

    public Object getModel() {
        return this.model;
    }

    public synchronized void setModel(Object model) {
        this.model = model;
        this.unbind();
        Iterator iter = this.propertyBindings.values().iterator();
        while (iter.hasNext()) {
            ((PropertyBinding)iter.next()).setBean(model);
        }
        this.rebind();
        this.update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getProperty(String property) {
        PropertyBinding pb;
        Map map = this.propertyBindings;
        synchronized (map) {
            Object o2 = this.propertyBindings.get(property);
            if (o2 == null) {
                o2 = new ModelBindingPropertyBinding(this.model, property);
                this.propertyBindings.put(property, o2);
            }
            pb = (PropertyBinding)o2;
        }
        FullBinding fb = pb.createBinding(pb, null);
        if (this.bound) {
            fb.bind();
        }
        return fb;
    }

    public void setProperty(String property, Object value) {
        throw new ReadOnlyPropertyException(property, this.model.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind() {
        List list = this.generatedBindings;
        synchronized (list) {
            if (!this.bound) {
                this.bound = true;
                Iterator iter = this.generatedBindings.iterator();
                while (iter.hasNext()) {
                    ((FullBinding)iter.next()).bind();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind() {
        List list = this.generatedBindings;
        synchronized (list) {
            if (this.bound) {
                this.bound = false;
                Iterator iter = this.generatedBindings.iterator();
                while (iter.hasNext()) {
                    ((FullBinding)iter.next()).unbind();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebind() {
        List list = this.generatedBindings;
        synchronized (list) {
            if (this.bound) {
                Iterator iter = this.generatedBindings.iterator();
                while (iter.hasNext()) {
                    ((FullBinding)iter.next()).rebind();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        List list = this.generatedBindings;
        synchronized (list) {
            Iterator iter = this.generatedBindings.iterator();
            while (iter.hasNext()) {
                ((FullBinding)iter.next()).update();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reverseUpdate() {
        List list = this.generatedBindings;
        synchronized (list) {
            Iterator iter = this.generatedBindings.iterator();
            while (iter.hasNext()) {
                ((FullBinding)iter.next()).reverseUpdate();
            }
        }
    }

    class ModelBindingPropertyBinding
    extends PropertyBinding {
        public ModelBindingPropertyBinding(Object bean, String propertyName) {
            super(bean, propertyName);
        }

        public FullBinding createBinding(SourceBinding source, TargetBinding target) {
            FullBinding fb = super.createBinding(source, target);
            ModelBinding.this.generatedBindings.add(fb);
            return fb;
        }
    }
}

