/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.classgen;

import groovyjarjarasm.asm.Label;
import groovyjarjarasm.asm.MethodVisitor;
import groovyjarjarasm.asm.Opcodes;
import groovyjarjarasm.asm.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.classgen.ClassGeneratorException;
import org.codehaus.groovy.classgen.Variable;
import org.codehaus.groovy.reflection.ReflectionCache;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;

public class BytecodeHelper
implements Opcodes {
    private MethodVisitor mv;

    public MethodVisitor getMethodVisitor() {
        return this.mv;
    }

    public BytecodeHelper(MethodVisitor mv) {
        this.mv = mv;
    }

    public void quickBoxIfNecessary(ClassNode type) {
        String descr = BytecodeHelper.getTypeDescription(type);
        if (type == ClassHelper.boolean_TYPE) {
            this.boxBoolean();
        } else if (ClassHelper.isPrimitiveType(type) && type != ClassHelper.VOID_TYPE) {
            ClassNode wrapper = ClassHelper.getWrapper(type);
            String internName = BytecodeHelper.getClassInternalName(wrapper);
            this.mv.visitTypeInsn(187, internName);
            this.mv.visitInsn(89);
            if (type == ClassHelper.double_TYPE || type == ClassHelper.long_TYPE) {
                this.mv.visitInsn(94);
                this.mv.visitInsn(88);
            } else {
                this.mv.visitInsn(93);
                this.mv.visitInsn(88);
            }
            this.mv.visitMethodInsn(183, internName, "<init>", "(" + descr + ")V");
        }
    }

    public void quickUnboxIfNecessary(ClassNode type) {
        if (ClassHelper.isPrimitiveType(type) && type != ClassHelper.VOID_TYPE) {
            ClassNode wrapper = ClassHelper.getWrapper(type);
            String internName = BytecodeHelper.getClassInternalName(wrapper);
            if (type == ClassHelper.boolean_TYPE) {
                this.mv.visitTypeInsn(192, internName);
                this.mv.visitMethodInsn(182, internName, type.getName() + "Value", "()" + BytecodeHelper.getTypeDescription(type));
            } else {
                this.mv.visitTypeInsn(192, "java/lang/Number");
                this.mv.visitMethodInsn(182, "java/lang/Number", type.getName() + "Value", "()" + BytecodeHelper.getTypeDescription(type));
            }
        }
    }

    public void box(Class type) {
        if (ReflectionCache.getCachedClass((Class)type).isPrimitive && type != Void.TYPE) {
            String returnString = "(" + BytecodeHelper.getTypeDescription(type) + ")Ljava/lang/Object;";
            this.mv.visitMethodInsn(184, BytecodeHelper.getClassInternalName(DefaultTypeTransformation.class.getName()), "box", returnString);
        }
    }

    public void box(ClassNode type) {
        if (type.isPrimaryClassNode()) {
            return;
        }
        this.box(type.getTypeClass());
    }

    public void unbox(Class type) {
        if (type.isPrimitive() && type != Void.TYPE) {
            String returnString = "(Ljava/lang/Object;)" + BytecodeHelper.getTypeDescription(type);
            this.mv.visitMethodInsn(184, BytecodeHelper.getClassInternalName(DefaultTypeTransformation.class.getName()), type.getName() + "Unbox", returnString);
        }
    }

    public void unbox(ClassNode type) {
        if (type.isPrimaryClassNode()) {
            return;
        }
        this.unbox(type.getTypeClass());
    }

    public static String getClassInternalName(ClassNode t) {
        if (t.isPrimaryClassNode()) {
            return BytecodeHelper.getClassInternalName(t.getName());
        }
        return BytecodeHelper.getClassInternalName(t.getTypeClass());
    }

    public static String getClassInternalName(Class t) {
        return Type.getInternalName(t);
    }

    public static String getClassInternalName(String name) {
        return name.replace('.', '/');
    }

    public static String getMethodDescriptor(ClassNode returnType, Parameter[] parameters) {
        StringBuffer buffer = new StringBuffer("(");
        for (int i2 = 0; i2 < parameters.length; ++i2) {
            buffer.append(BytecodeHelper.getTypeDescription(parameters[i2].getType()));
        }
        buffer.append(")");
        buffer.append(BytecodeHelper.getTypeDescription(returnType));
        return buffer.toString();
    }

    public static String getMethodDescriptor(Class returnType, Class[] paramTypes) {
        StringBuffer buffer = new StringBuffer("(");
        for (int i2 = 0; i2 < paramTypes.length; ++i2) {
            buffer.append(BytecodeHelper.getTypeDescription(paramTypes[i2]));
        }
        buffer.append(")");
        buffer.append(BytecodeHelper.getTypeDescription(returnType));
        return buffer.toString();
    }

    public static String getTypeDescription(Class c2) {
        return Type.getDescriptor(c2);
    }

    public static String getClassLoadingTypeDescription(ClassNode c2) {
        StringBuffer buf = new StringBuffer();
        boolean array = false;
        while (c2.isArray()) {
            buf.append('[');
            c2 = c2.getComponentType();
            array = true;
        }
        if (ClassHelper.isPrimitiveType(c2)) {
            buf.append(BytecodeHelper.getTypeDescription(c2));
        } else {
            if (array) {
                buf.append('L');
            }
            buf.append(c2.getName());
            if (array) {
                buf.append(';');
            }
        }
        return buf.toString();
    }

    public static String getTypeDescription(ClassNode c2) {
        return BytecodeHelper.getTypeDescription(c2, true);
    }

    private static String getTypeDescription(ClassNode c2, boolean end) {
        StringBuffer buf = new StringBuffer();
        ClassNode d2 = c2;
        while (true) {
            if (ClassHelper.isPrimitiveType(d2)) {
                int car = d2 == ClassHelper.int_TYPE ? 73 : (d2 == ClassHelper.VOID_TYPE ? 86 : (d2 == ClassHelper.boolean_TYPE ? 90 : (d2 == ClassHelper.byte_TYPE ? 66 : (d2 == ClassHelper.char_TYPE ? 67 : (d2 == ClassHelper.short_TYPE ? 83 : (d2 == ClassHelper.double_TYPE ? 68 : (d2 == ClassHelper.float_TYPE ? 70 : 74)))))));
                buf.append((char)car);
                return buf.toString();
            }
            if (!d2.isArray()) break;
            buf.append('[');
            d2 = d2.getComponentType();
        }
        buf.append('L');
        String name = d2.getName();
        int len = name.length();
        for (int i2 = 0; i2 < len; ++i2) {
            char car = name.charAt(i2);
            buf.append(car == '.' ? (char)'/' : (char)car);
        }
        if (end) {
            buf.append(';');
        }
        return buf.toString();
    }

    public static String[] getClassInternalNames(ClassNode[] names) {
        int size = names.length;
        String[] answer = new String[size];
        for (int i2 = 0; i2 < size; ++i2) {
            answer[i2] = BytecodeHelper.getClassInternalName(names[i2]);
        }
        return answer;
    }

    protected void pushConstant(boolean value) {
        if (value) {
            this.mv.visitInsn(4);
        } else {
            this.mv.visitInsn(3);
        }
    }

    public void pushConstant(int value) {
        switch (value) {
            case 0: {
                this.mv.visitInsn(3);
                break;
            }
            case 1: {
                this.mv.visitInsn(4);
                break;
            }
            case 2: {
                this.mv.visitInsn(5);
                break;
            }
            case 3: {
                this.mv.visitInsn(6);
                break;
            }
            case 4: {
                this.mv.visitInsn(7);
                break;
            }
            case 5: {
                this.mv.visitInsn(8);
                break;
            }
            default: {
                if (value >= -128 && value <= 127) {
                    this.mv.visitIntInsn(16, value);
                    break;
                }
                if (value >= Short.MIN_VALUE && value <= Short.MAX_VALUE) {
                    this.mv.visitIntInsn(17, value);
                    break;
                }
                this.mv.visitLdcInsn(new Integer(value));
            }
        }
    }

    public void doCast(Class type) {
        if (type != Object.class) {
            if (type.isPrimitive() && type != Void.TYPE) {
                this.unbox(type);
            } else {
                this.mv.visitTypeInsn(192, type.isArray() ? BytecodeHelper.getTypeDescription(type) : BytecodeHelper.getClassInternalName(type.getName()));
            }
        }
    }

    public void doCast(ClassNode type) {
        if (type == ClassHelper.OBJECT_TYPE) {
            return;
        }
        if (ClassHelper.isPrimitiveType(type) && type != ClassHelper.VOID_TYPE) {
            this.unbox(type);
        } else {
            this.mv.visitTypeInsn(192, type.isArray() ? BytecodeHelper.getTypeDescription(type) : BytecodeHelper.getClassInternalName(type));
        }
    }

    public void load(ClassNode type, int idx) {
        if (type == ClassHelper.double_TYPE) {
            this.mv.visitVarInsn(24, idx);
        } else if (type == ClassHelper.float_TYPE) {
            this.mv.visitVarInsn(23, idx);
        } else if (type == ClassHelper.long_TYPE) {
            this.mv.visitVarInsn(22, idx);
        } else if (type == ClassHelper.boolean_TYPE || type == ClassHelper.char_TYPE || type == ClassHelper.byte_TYPE || type == ClassHelper.int_TYPE || type == ClassHelper.short_TYPE) {
            this.mv.visitVarInsn(21, idx);
        } else {
            this.mv.visitVarInsn(25, idx);
        }
    }

    public void load(Variable v) {
        this.load(v.getType(), v.getIndex());
    }

    public void store(Variable v, boolean markStart) {
        ClassNode type = v.getType();
        this.unbox(type);
        int idx = v.getIndex();
        if (type == ClassHelper.double_TYPE) {
            this.mv.visitVarInsn(57, idx);
        } else if (type == ClassHelper.float_TYPE) {
            this.mv.visitVarInsn(56, idx);
        } else if (type == ClassHelper.long_TYPE) {
            this.mv.visitVarInsn(55, idx);
        } else if (type == ClassHelper.boolean_TYPE || type == ClassHelper.char_TYPE || type == ClassHelper.byte_TYPE || type == ClassHelper.int_TYPE || type == ClassHelper.short_TYPE) {
            this.mv.visitVarInsn(54, idx);
        } else {
            this.mv.visitVarInsn(58, idx);
        }
    }

    public void store(Variable v) {
        this.store(v, false);
    }

    void loadConstant(Object value) {
        if (value == null) {
            this.mv.visitInsn(1);
        } else if (value instanceof String) {
            this.mv.visitLdcInsn(value);
        } else if (value instanceof Character) {
            String className = "java/lang/Character";
            this.mv.visitTypeInsn(187, className);
            this.mv.visitInsn(89);
            this.mv.visitLdcInsn(value);
            String methodType = "(C)V";
            this.mv.visitMethodInsn(183, className, "<init>", methodType);
        } else if (value instanceof Number) {
            String methodType;
            Number n2 = (Number)value;
            String className = BytecodeHelper.getClassInternalName(value.getClass().getName());
            this.mv.visitTypeInsn(187, className);
            this.mv.visitInsn(89);
            if (n2 instanceof Integer) {
                this.mv.visitLdcInsn(n2);
                methodType = "(I)V";
            } else if (n2 instanceof Double) {
                this.mv.visitLdcInsn(n2);
                methodType = "(D)V";
            } else if (n2 instanceof Float) {
                this.mv.visitLdcInsn(n2);
                methodType = "(F)V";
            } else if (n2 instanceof Long) {
                this.mv.visitLdcInsn(n2);
                methodType = "(J)V";
            } else if (n2 instanceof BigDecimal) {
                this.mv.visitLdcInsn(n2.toString());
                methodType = "(Ljava/lang/String;)V";
            } else if (n2 instanceof BigInteger) {
                this.mv.visitLdcInsn(n2.toString());
                methodType = "(Ljava/lang/String;)V";
            } else if (n2 instanceof Short) {
                this.mv.visitLdcInsn(n2);
                methodType = "(S)V";
            } else if (n2 instanceof Byte) {
                this.mv.visitLdcInsn(n2);
                methodType = "(B)V";
            } else {
                throw new ClassGeneratorException("Cannot generate bytecode for constant: " + value + " of type: " + value.getClass().getName() + ".  Numeric constant type not supported.");
            }
            this.mv.visitMethodInsn(183, className, "<init>", methodType);
        } else if (value instanceof Boolean) {
            Boolean bool = (Boolean)value;
            String text = bool != false ? "TRUE" : "FALSE";
            this.mv.visitFieldInsn(178, "java/lang/Boolean", text, "Ljava/lang/Boolean;");
        } else if (value instanceof Class) {
            Class vc = (Class)value;
            if (!vc.getName().equals("java.lang.Void")) {
                throw new ClassGeneratorException("Cannot generate bytecode for constant: " + value + " of type: " + value.getClass().getName());
            }
        } else {
            throw new ClassGeneratorException("Cannot generate bytecode for constant: " + value + " of type: " + value.getClass().getName());
        }
    }

    public void loadVar(Variable variable) {
        int index = variable.getIndex();
        if (variable.isHolder()) {
            this.mv.visitVarInsn(25, index);
            this.mv.visitMethodInsn(182, "groovy/lang/Reference", "get", "()Ljava/lang/Object;");
        } else {
            this.load(variable);
            if (variable != Variable.THIS_VARIABLE && variable != Variable.SUPER_VARIABLE) {
                this.box(variable.getType());
            }
        }
    }

    public void storeVar(Variable variable) {
        String type = variable.getTypeName();
        int index = variable.getIndex();
        if (variable.isHolder()) {
            this.mv.visitVarInsn(25, index);
            this.mv.visitInsn(95);
            this.mv.visitMethodInsn(182, "groovy/lang/Reference", "set", "(Ljava/lang/Object;)V");
        } else {
            this.store(variable, false);
        }
    }

    public void putField(FieldNode fld) {
        this.putField(fld, BytecodeHelper.getClassInternalName(fld.getOwner()));
    }

    public void putField(FieldNode fld, String ownerName) {
        this.mv.visitFieldInsn(181, ownerName, fld.getName(), BytecodeHelper.getTypeDescription(fld.getType()));
    }

    public void swapObjectWith(ClassNode type) {
        if (type == ClassHelper.long_TYPE || type == ClassHelper.double_TYPE) {
            this.mv.visitInsn(91);
            this.mv.visitInsn(87);
        } else {
            this.mv.visitInsn(95);
        }
    }

    public void swapWithObject(ClassNode type) {
        if (type == ClassHelper.long_TYPE || type == ClassHelper.double_TYPE) {
            this.mv.visitInsn(93);
            this.mv.visitInsn(88);
        } else {
            this.mv.visitInsn(95);
        }
    }

    public static ClassNode boxOnPrimitive(ClassNode type) {
        if (!type.isArray()) {
            return ClassHelper.getWrapper(type);
        }
        return BytecodeHelper.boxOnPrimitive(type.getComponentType()).makeArray();
    }

    public void boxBoolean() {
        Label l0 = new Label();
        this.mv.visitJumpInsn(153, l0);
        this.mv.visitFieldInsn(178, "java/lang/Boolean", "TRUE", "Ljava/lang/Boolean;");
        Label l1 = new Label();
        this.mv.visitJumpInsn(167, l1);
        this.mv.visitLabel(l0);
        this.mv.visitFieldInsn(178, "java/lang/Boolean", "FALSE", "Ljava/lang/Boolean;");
        this.mv.visitLabel(l1);
    }

    public void negateBoolean() {
        Label endLabel = new Label();
        Label falseLabel = new Label();
        this.mv.visitJumpInsn(154, falseLabel);
        this.mv.visitInsn(4);
        this.mv.visitJumpInsn(167, endLabel);
        this.mv.visitLabel(falseLabel);
        this.mv.visitInsn(3);
        this.mv.visitLabel(endLabel);
    }

    public void mark(String msg) {
        this.mv.visitLdcInsn(msg);
        this.mv.visitInsn(87);
    }

    public static String formatNameForClassLoading(String name) {
        if (name.equals("int") || name.equals("long") || name.equals("short") || name.equals("float") || name.equals("double") || name.equals("byte") || name.equals("char") || name.equals("boolean") || name.equals("void")) {
            return name;
        }
        if (name == null) {
            return "java.lang.Object;";
        }
        if (name.startsWith("[")) {
            return name.replace('/', '.');
        }
        if (name.startsWith("L")) {
            if ((name = name.substring(1)).endsWith(";")) {
                name = name.substring(0, name.length() - 1);
            }
            return name.replace('/', '.');
        }
        String prefix = "";
        if (name.endsWith("[]")) {
            prefix = "[";
            if ((name = name.substring(0, name.length() - 2)).equals("int")) {
                return prefix + "I";
            }
            if (name.equals("long")) {
                return prefix + "J";
            }
            if (name.equals("short")) {
                return prefix + "S";
            }
            if (name.equals("float")) {
                return prefix + "F";
            }
            if (name.equals("double")) {
                return prefix + "D";
            }
            if (name.equals("byte")) {
                return prefix + "B";
            }
            if (name.equals("char")) {
                return prefix + "C";
            }
            if (name.equals("boolean")) {
                return prefix + "Z";
            }
            return prefix + "L" + name.replace('/', '.') + ";";
        }
        return name.replace('/', '.');
    }

    public void dup() {
        this.mv.visitInsn(89);
    }

    public void doReturn(ClassNode returnType) {
        if (returnType == ClassHelper.double_TYPE) {
            this.mv.visitInsn(175);
        } else if (returnType == ClassHelper.float_TYPE) {
            this.mv.visitInsn(174);
        } else if (returnType == ClassHelper.long_TYPE) {
            this.mv.visitInsn(173);
        } else if (returnType == ClassHelper.boolean_TYPE || returnType == ClassHelper.char_TYPE || returnType == ClassHelper.byte_TYPE || returnType == ClassHelper.int_TYPE || returnType == ClassHelper.short_TYPE) {
            this.mv.visitInsn(172);
        } else if (returnType == ClassHelper.VOID_TYPE) {
            this.mv.visitInsn(177);
        } else {
            this.mv.visitInsn(176);
        }
    }

    private static boolean hasGenerics(Parameter[] param) {
        if (param.length == 0) {
            return false;
        }
        for (int i2 = 0; i2 < param.length; ++i2) {
            ClassNode type = param[i2].getType();
            if (type.getGenericsTypes() == null) continue;
            return true;
        }
        return false;
    }

    public static String getGenericsMethodSignature(MethodNode node) {
        GenericsType[] generics = node.getGenericsTypes();
        Parameter[] param = node.getParameters();
        ClassNode returnType = node.getReturnType();
        if (generics == null && !BytecodeHelper.hasGenerics(param) && returnType.getGenericsTypes() == null) {
            return null;
        }
        StringBuffer ret = new StringBuffer(100);
        BytecodeHelper.getGenericsTypeSpec(ret, generics);
        GenericsType[] paramTypes = new GenericsType[param.length];
        for (int i2 = 0; i2 < param.length; ++i2) {
            ClassNode pType = param[i2].getType();
            paramTypes[i2] = pType.getGenericsTypes() == null || !pType.isGenericsPlaceHolder() ? new GenericsType(pType) : pType.getGenericsTypes()[0];
        }
        BytecodeHelper.addSubTypes(ret, paramTypes, "(", ")");
        if (returnType.isGenericsPlaceHolder()) {
            BytecodeHelper.addSubTypes(ret, returnType.getGenericsTypes(), "", "");
        } else {
            BytecodeHelper.writeGenericsBounds(ret, new GenericsType(returnType), false);
        }
        return ret.toString();
    }

    private static boolean usesGenericsInClassSignature(ClassNode node) {
        if (!node.isUsingGenerics()) {
            return false;
        }
        if (node.getGenericsTypes() != null) {
            return true;
        }
        ClassNode sclass = node.getUnresolvedSuperClass(false);
        if (sclass.isUsingGenerics()) {
            return true;
        }
        ClassNode[] interfaces = node.getInterfaces();
        if (interfaces != null) {
            for (int i2 = 0; i2 < interfaces.length; ++i2) {
                if (!interfaces[i2].isUsingGenerics()) continue;
                return true;
            }
        }
        return false;
    }

    public static String getGenericsSignature(ClassNode node) {
        if (!BytecodeHelper.usesGenericsInClassSignature(node)) {
            return null;
        }
        GenericsType[] genericsTypes = node.getGenericsTypes();
        StringBuffer ret = new StringBuffer(100);
        BytecodeHelper.getGenericsTypeSpec(ret, genericsTypes);
        GenericsType extendsPart = new GenericsType(node.getUnresolvedSuperClass(false));
        BytecodeHelper.writeGenericsBounds(ret, extendsPart, true);
        ClassNode[] interfaces = node.getInterfaces();
        for (int i2 = 0; i2 < interfaces.length; ++i2) {
            GenericsType interfacePart = new GenericsType(interfaces[i2]);
            BytecodeHelper.writeGenericsBounds(ret, interfacePart, false);
        }
        return ret.toString();
    }

    private static void getGenericsTypeSpec(StringBuffer ret, GenericsType[] genericsTypes) {
        if (genericsTypes == null) {
            return;
        }
        ret.append('<');
        for (int i2 = 0; i2 < genericsTypes.length; ++i2) {
            String name = genericsTypes[i2].getName();
            ret.append(name);
            ret.append(':');
            BytecodeHelper.writeGenericsBounds(ret, genericsTypes[i2], true);
        }
        ret.append('>');
    }

    public static String getGenericsBounds(ClassNode type) {
        GenericsType[] genericsTypes = type.getGenericsTypes();
        if (genericsTypes == null) {
            return null;
        }
        StringBuffer ret = new StringBuffer(100);
        if (type.isGenericsPlaceHolder()) {
            BytecodeHelper.addSubTypes(ret, type.getGenericsTypes(), "", "");
        } else {
            GenericsType gt = new GenericsType(type);
            BytecodeHelper.writeGenericsBounds(ret, gt, false);
        }
        return ret.toString();
    }

    private static void writeGenericsBoundType(StringBuffer ret, ClassNode printType, boolean writeInterfaceMarker) {
        if (writeInterfaceMarker && printType.isInterface()) {
            ret.append(":");
        }
        ret.append(BytecodeHelper.getTypeDescription(printType, false));
        BytecodeHelper.addSubTypes(ret, printType.getGenericsTypes(), "<", ">");
        if (!ClassHelper.isPrimitiveType(printType)) {
            ret.append(";");
        }
    }

    private static void writeGenericsBounds(StringBuffer ret, GenericsType type, boolean writeInterfaceMarker) {
        if (type.getUpperBounds() != null) {
            ClassNode[] bounds = type.getUpperBounds();
            for (int i2 = 0; i2 < bounds.length; ++i2) {
                BytecodeHelper.writeGenericsBoundType(ret, bounds[i2], writeInterfaceMarker);
            }
        } else if (type.getLowerBound() != null) {
            BytecodeHelper.writeGenericsBoundType(ret, type.getLowerBound(), writeInterfaceMarker);
        } else {
            BytecodeHelper.writeGenericsBoundType(ret, type.getType(), writeInterfaceMarker);
        }
    }

    private static void addSubTypes(StringBuffer ret, GenericsType[] types, String start, String end) {
        if (types == null) {
            return;
        }
        ret.append(start);
        for (int i2 = 0; i2 < types.length; ++i2) {
            String name = types[i2].getName();
            if (types[i2].isPlaceholder()) {
                ret.append('T');
                ret.append(name);
                ret.append(';');
                continue;
            }
            if (types[i2].isWildcard()) {
                if (types[i2].getUpperBounds() != null) {
                    ret.append('+');
                    BytecodeHelper.writeGenericsBounds(ret, types[i2], false);
                    continue;
                }
                if (types[i2].getLowerBound() != null) {
                    ret.append('-');
                    BytecodeHelper.writeGenericsBounds(ret, types[i2], false);
                    continue;
                }
                ret.append('*');
                continue;
            }
            BytecodeHelper.writeGenericsBounds(ret, types[i2], false);
        }
        ret.append(end);
    }
}

