/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.control;

import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.control.SourceUnit;

public class GenericsVisitor
extends ClassCodeVisitorSupport {
    private SourceUnit source;

    public GenericsVisitor(SourceUnit source) {
        this.source = source;
    }

    protected SourceUnit getSourceUnit() {
        return this.source;
    }

    public void visitClass(ClassNode node) {
        boolean error = this.checkWildcard(node);
        if (error) {
            return;
        }
        this.checkGenericsUsage(node.getUnresolvedSuperClass(false), node.getSuperClass());
        ClassNode[] interfaces = node.getInterfaces();
        for (int i2 = 0; i2 < interfaces.length; ++i2) {
            this.checkGenericsUsage(interfaces[i2], interfaces[i2].redirect());
        }
    }

    private boolean checkWildcard(ClassNode cn) {
        ClassNode sn = cn.getUnresolvedSuperClass(false);
        if (sn == null) {
            return false;
        }
        GenericsType[] generics = sn.getGenericsTypes();
        if (generics == null) {
            return false;
        }
        boolean error = false;
        for (int i2 = 0; i2 < generics.length; ++i2) {
            if (!generics[i2].isWildcard()) continue;
            this.addError("A supertype may not specifiy a wildcard type", sn);
            error = true;
        }
        return error;
    }

    private void checkGenericsUsage(ClassNode n2, ClassNode cn) {
        GenericsType[] nTypes = n2.getGenericsTypes();
        GenericsType[] cnTypes = cn.getGenericsTypes();
        if (nTypes == null) {
            return;
        }
        if (cnTypes == null) {
            this.addError("The class " + n2.getName() + " refers to the class " + cn.getName() + " and uses " + nTypes.length + " parameters, but the referred class takes no parameters", n2);
            return;
        }
        if (nTypes.length != cnTypes.length) {
            this.addError("The class " + n2.getName() + " refers to the class " + cn.getName() + " and uses " + nTypes.length + " parameters, but the refered class needs " + cnTypes.length, n2);
            return;
        }
        for (int i2 = 0; i2 < nTypes.length; ++i2) {
            ClassNode cnType;
            ClassNode nType = nTypes[i2].getType();
            if (nType.isDerivedFrom(cnType = cnTypes[i2].getType()) || cnType.isInterface() && nType.declaresInterface(cnType.getName())) continue;
            this.addError("The type " + nTypes[i2].getName() + " is not a valid substitute for the bounded parameter <" + this.getPrintName(cnTypes[i2]) + ">", n2);
        }
    }

    private String getPrintName(GenericsType gt) {
        String ret = gt.getName();
        ClassNode[] upperBounds = gt.getUpperBounds();
        ClassNode lowerBound = gt.getLowerBound();
        if (upperBounds != null) {
            ret = ret + " extends ";
            for (int i2 = 0; i2 < upperBounds.length; ++i2) {
                ret = ret + this.getPrintName(upperBounds[i2]);
                if (i2 + 1 >= upperBounds.length) continue;
                ret = ret + " & ";
            }
        } else if (lowerBound != null) {
            ret = ret + " super " + this.getPrintName(lowerBound);
        }
        return ret;
    }

    private String getPrintName(ClassNode cn) {
        String ret = cn.getName();
        GenericsType[] gts = cn.getGenericsTypes();
        if (gts != null) {
            ret = ret + "<";
            for (int i2 = 0; i2 < gts.length; ++i2) {
                if (i2 != 0) {
                    ret = ret + ",";
                }
                ret = ret + this.getPrintName(gts[i2]);
            }
            ret = ret + ">";
        }
        return ret;
    }

    private void checkBounds(ClassNode[] given, ClassNode[] restrictions) {
        if (restrictions == null) {
            return;
        }
        for (int i2 = 0; i2 < given.length; ++i2) {
            for (int j2 = 0; j2 < restrictions.length; ++j2) {
                if (given[i2].isDerivedFrom(restrictions[j2])) continue;
            }
        }
    }
}

