/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.reflection;

import groovy.lang.GroovyRuntimeException;
import groovy.lang.MetaProperty;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.codehaus.groovy.reflection.CachedClass;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;

public class CachedField
extends MetaProperty {
    public final Field field;
    CachedClass cachedClass;
    boolean alreadySetAccessible;

    public CachedField(CachedClass clazz, Field field) {
        super(field.getName(), field.getType());
        this.field = field;
        this.cachedClass = clazz;
        this.alreadySetAccessible = Modifier.isPublic(field.getModifiers()) && Modifier.isPublic(field.getDeclaringClass().getModifiers());
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.getModifiers());
    }

    public int getModifiers() {
        return this.field.getModifiers();
    }

    public Object getProperty(Object object) {
        if (!this.alreadySetAccessible) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    CachedField.this.field.setAccessible(true);
                    return null;
                }
            });
            this.alreadySetAccessible = true;
        }
        try {
            return this.field.get(object);
        }
        catch (IllegalAccessException e2) {
            throw new GroovyRuntimeException("Cannot get the property '" + this.name + "'.", e2);
        }
    }

    public void setProperty(Object object, Object newValue) {
        Object goalValue = DefaultTypeTransformation.castToType(newValue, this.field.getType());
        if (!this.alreadySetAccessible) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    CachedField.this.field.setAccessible(true);
                    return null;
                }
            });
            this.alreadySetAccessible = true;
        }
        try {
            this.field.set(object, goalValue);
        }
        catch (IllegalAccessException ex) {
            throw new GroovyRuntimeException("Cannot set the property '" + this.name + "'.", ex);
        }
    }
}

