/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.reflection;

import groovy.lang.MetaMethod;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Comparator;
import org.codehaus.groovy.classgen.BytecodeHelper;
import org.codehaus.groovy.reflection.CachedClass;
import org.codehaus.groovy.reflection.ParameterTypes;
import org.codehaus.groovy.reflection.ReflectionCache;
import org.codehaus.groovy.runtime.InvokerInvocationException;
import org.codehaus.groovy.runtime.metaclass.MethodHelper;

public class CachedMethod
extends MetaMethod
implements Comparable {
    public final CachedClass cachedClass;
    private final Method cachedMethod;
    private volatile boolean alreadySetAccessible;
    private int methodIndex;
    private int hashCode;
    private static MyComparator comparator = new MyComparator();

    public CachedMethod(CachedClass clazz, Method method) {
        this.cachedMethod = method;
        this.cachedClass = clazz;
        this.alreadySetAccessible = Modifier.isPublic(method.getModifiers()) && Modifier.isPublic(clazz.getModifiers());
    }

    public CachedMethod(Method method) {
        this(ReflectionCache.getCachedClass(method.getDeclaringClass()), method);
    }

    public static CachedMethod find(Method method) {
        CachedMethod[] methods = ReflectionCache.getCachedClass(method.getDeclaringClass()).getMethods();
        int i2 = Arrays.binarySearch(methods, method, comparator);
        if (i2 < 0) {
            return null;
        }
        return methods[i2];
    }

    protected Class[] getPT() {
        return this.cachedMethod.getParameterTypes();
    }

    public String getName() {
        return this.cachedMethod.getName();
    }

    public String getDescriptor() {
        return BytecodeHelper.getMethodDescriptor(this.getReturnType(), this.getNativeParameterTypes());
    }

    public CachedClass getDeclaringClass() {
        return this.cachedClass;
    }

    public Object invoke(Object object, Object[] arguments) {
        try {
            return this.setAccessible().invoke(object, arguments);
        }
        catch (IllegalArgumentException e2) {
            throw new InvokerInvocationException(e2);
        }
        catch (IllegalAccessException e3) {
            throw new InvokerInvocationException(e3);
        }
        catch (InvocationTargetException e4) {
            throw new InvokerInvocationException(e4);
        }
    }

    public ParameterTypes getParamTypes() {
        return null;
    }

    public Class getReturnType() {
        return this.cachedMethod.getReturnType();
    }

    public int getParamsCount() {
        return this.getParameterTypes().length;
    }

    public int getModifiers() {
        return this.cachedMethod.getModifiers();
    }

    public String getSignature() {
        return this.getName() + this.getDescriptor();
    }

    public Method setAccessible() {
        if (!this.alreadySetAccessible) {
            this.setAccessible0();
        }
        return this.cachedMethod;
    }

    private synchronized void setAccessible0() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                CachedMethod.this.cachedMethod.setAccessible(true);
                return null;
            }
        });
        this.alreadySetAccessible = true;
    }

    public boolean isStatic() {
        return MethodHelper.isStatic(this.cachedMethod);
    }

    public void setMethodIndex(int i2) {
        this.methodIndex = i2;
    }

    public int getMethodIndex() {
        return this.methodIndex;
    }

    public boolean canBeCalledByReflector() {
        if (!Modifier.isPublic(this.cachedClass.getModifiers())) {
            return false;
        }
        if (!Modifier.isPublic(this.getModifiers())) {
            return false;
        }
        this.getParameterTypes();
        for (int i2 = 0; i2 != this.parameterTypes.length; ++i2) {
            if (this.parameterTypes[i2].isPrimitive || Modifier.isPublic(this.parameterTypes[i2].getModifiers())) continue;
            return false;
        }
        return true;
    }

    public int compareTo(Object o2) {
        if (o2 instanceof CachedMethod) {
            return this.compareToCachedMethod((CachedMethod)o2);
        }
        return this.compareToMethod((Method)o2);
    }

    private int compareToCachedMethod(CachedMethod m2) {
        CachedClass[] mparams;
        if (m2 == null) {
            return -1;
        }
        int strComp = this.getName().compareTo(m2.getName());
        if (strComp != 0) {
            return strComp;
        }
        int retComp = this.getReturnType().getName().compareTo(m2.getReturnType().getName());
        if (retComp != 0) {
            return retComp;
        }
        CachedClass[] params = this.getParameterTypes();
        int pd = params.length - (mparams = m2.getParameterTypes()).length;
        if (pd != 0) {
            return pd;
        }
        for (int i2 = 0; i2 != params.length; ++i2) {
            int nameComp = params[i2].getName().compareTo(mparams[i2].getName());
            if (nameComp == 0) continue;
            return nameComp;
        }
        throw new RuntimeException("Should never happen");
    }

    private int compareToMethod(Method m2) {
        Class<?>[] mparams;
        if (m2 == null) {
            return -1;
        }
        int strComp = this.getName().compareTo(m2.getName());
        if (strComp != 0) {
            return strComp;
        }
        int retComp = this.getReturnType().getName().compareTo(m2.getReturnType().getName());
        if (retComp != 0) {
            return retComp;
        }
        CachedClass[] params = this.getParameterTypes();
        int pd = params.length - (mparams = m2.getParameterTypes()).length;
        if (pd != 0) {
            return pd;
        }
        for (int i2 = 0; i2 != params.length; ++i2) {
            int nameComp = params[i2].getName().compareTo(mparams[i2].getName());
            if (nameComp == 0) continue;
            return nameComp;
        }
        return 0;
    }

    public boolean equals(Object o2) {
        return o2 instanceof CachedMethod && this.cachedMethod.equals(((CachedMethod)o2).cachedMethod) || o2 instanceof Method && this.cachedMethod.equals(o2);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.cachedMethod.hashCode();
            if (this.hashCode == 0) {
                this.hashCode = -889274690;
            }
        }
        return this.hashCode;
    }

    public String toString() {
        return this.cachedMethod.toString();
    }

    private static class MyComparator
    implements Comparator {
        private MyComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 instanceof CachedMethod) {
                return ((CachedMethod)o1).compareTo(o2);
            }
            if (o2 instanceof CachedMethod) {
                return -((CachedMethod)o2).compareTo(o1);
            }
            throw new ClassCastException("One of the two comperables must be a CachedMethod");
        }
    }
}

