/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.runtime.metaclass;

import java.io.Serializable;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;

public class MemoryAwareConcurrentReadMap {
    protected final BarrierLock barrierLock = new BarrierLock();
    protected transient Object lastWrite;
    public static final int DEFAULT_INITIAL_CAPACITY = 32;
    private static final int MINIMUM_CAPACITY = 4;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;
    protected transient Entry[] table;
    protected transient int count;
    protected int threshold;
    protected float loadFactor;
    private ReferenceQueue queue;
    private static final Reference DUMMY_REF = new DummyRef();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void recordModification(Object x) {
        BarrierLock barrierLock = this.barrierLock;
        synchronized (barrierLock) {
            this.lastWrite = x;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Entry[] getTableForReading() {
        BarrierLock barrierLock = this.barrierLock;
        synchronized (barrierLock) {
            return this.table;
        }
    }

    private int p2capacity(int initialCapacity) {
        int result;
        int cap = initialCapacity;
        if (cap > 0x40000000 || cap < 0) {
            result = 0x40000000;
        } else {
            for (result = 4; result < cap; result <<= 1) {
            }
        }
        return result;
    }

    private static int hash(Object x) {
        int h2 = x.hashCode();
        return (h2 << 7) - h2 + (h2 >>> 9) + (h2 >>> 17);
    }

    protected boolean eq(Object x, Object y) {
        return x == y;
    }

    public MemoryAwareConcurrentReadMap(int initialCapacity, float loadFactor) {
        if (loadFactor <= 0.0f) {
            throw new IllegalArgumentException("Illegal Load factor: " + loadFactor);
        }
        this.loadFactor = loadFactor;
        int cap = this.p2capacity(initialCapacity);
        this.table = new Entry[cap];
        this.threshold = (int)((float)cap * loadFactor);
        this.queue = new ReferenceQueue();
    }

    public MemoryAwareConcurrentReadMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public MemoryAwareConcurrentReadMap() {
        this(32, 0.75f);
    }

    public synchronized int size() {
        return this.count;
    }

    public synchronized boolean isEmpty() {
        return this.count == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object key) {
        Entry first;
        int hash = MemoryAwareConcurrentReadMap.hash(key);
        Entry[] tab = this.table;
        int index = hash & tab.length - 1;
        Entry e2 = first = tab[index];
        while (true) {
            if (e2 == null) {
                Entry[] reread = this.getTableForReading();
                if (tab == reread && first == tab[index]) {
                    return null;
                }
                tab = reread;
                index = hash & tab.length - 1;
                e2 = first = tab[index];
                continue;
            }
            Object eKey = e2.getKey();
            Object eValue = e2.getValue();
            if (e2.hash == hash && this.eq(key, eKey)) {
                if (e2.value != DUMMY_REF) {
                    return eValue;
                }
                MemoryAwareConcurrentReadMap memoryAwareConcurrentReadMap = this;
                synchronized (memoryAwareConcurrentReadMap) {
                    if (eKey == null && eValue == null) {
                        this.expungeStaleEntries();
                    }
                    tab = this.table;
                }
                index = hash & tab.length - 1;
                e2 = first = tab[index];
                continue;
            }
            e2 = e2.next;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object key, Object value) {
        Entry first;
        if (value == null) {
            throw new NullPointerException();
        }
        int hash = MemoryAwareConcurrentReadMap.hash(key);
        Entry[] tab = this.table;
        int index = hash & tab.length - 1;
        Entry e2 = first = tab[index];
        while (!(e2 == null || e2.hash == hash && this.eq(key, e2.getKey()))) {
            e2 = e2.next;
        }
        MemoryAwareConcurrentReadMap memoryAwareConcurrentReadMap = this;
        synchronized (memoryAwareConcurrentReadMap) {
            if (tab == this.table) {
                if (e2 == null) {
                    if (first == tab[index]) {
                        Entry newEntry;
                        tab[index] = newEntry = new Entry(hash, key, value, first, this.queue);
                        if (++this.count >= this.threshold) {
                            this.rehash();
                        } else {
                            this.recordModification(newEntry);
                        }
                        return null;
                    }
                } else {
                    Object oldValue = e2.getValue();
                    if (first == tab[index] && oldValue != null) {
                        e2.setValue(e2.value);
                        return oldValue;
                    }
                }
            }
            return this.sput(key, value, hash);
        }
    }

    protected Object sput(Object key, Object value, int hash) {
        Entry first;
        this.expungeStaleEntries();
        Entry[] tab = this.table;
        int index = hash & tab.length - 1;
        Entry e2 = first = tab[index];
        while (true) {
            if (e2 == null) {
                Entry newEntry;
                tab[index] = newEntry = new Entry(hash, key, value, first, this.queue);
                if (++this.count >= this.threshold) {
                    this.rehash();
                } else {
                    this.recordModification(newEntry);
                }
                return null;
            }
            if (e2.hash == hash && this.eq(key, e2.getKey())) {
                Object oldValue = e2.getValue();
                e2.setValue(e2.value);
                return oldValue;
            }
            e2 = e2.next;
        }
    }

    protected void rehash() {
        Entry[] oldTable = this.table;
        int oldCapacity = oldTable.length;
        if (oldCapacity >= 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        int newCapacity = oldCapacity << 1;
        int mask = newCapacity - 1;
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        Entry[] newTable = new Entry[newCapacity];
        for (int i2 = 0; i2 < oldCapacity; ++i2) {
            int k2;
            Entry e2 = oldTable[i2];
            if (e2 == null) continue;
            int idx = e2.hash & mask;
            Entry next = e2.next;
            if (next == null) {
                newTable[idx] = e2;
                continue;
            }
            Entry lastRun = e2;
            int lastIdx = idx;
            Entry last = next;
            while (last != null) {
                k2 = last.hash & mask;
                if (k2 != lastIdx) {
                    lastIdx = k2;
                    lastRun = last;
                }
                last = last.next;
            }
            newTable[lastIdx] = lastRun;
            Entry p = e2;
            while (p != lastRun) {
                k2 = p.hash & mask;
                newTable[k2] = new Entry(p.hash, p.getKey(), p.getValue(), newTable[k2], this.queue);
                p = p.next;
            }
        }
        this.table = newTable;
        this.recordModification(newTable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Object key) {
        Entry first;
        int hash = MemoryAwareConcurrentReadMap.hash(key);
        Entry[] tab = this.table;
        int index = hash & tab.length - 1;
        Entry e2 = first = tab[index];
        e2 = first;
        while (!(e2 == null || e2.hash == hash && this.eq(key, e2.getKey()))) {
            e2 = e2.next;
        }
        MemoryAwareConcurrentReadMap memoryAwareConcurrentReadMap = this;
        synchronized (memoryAwareConcurrentReadMap) {
            if (tab == this.table) {
                if (e2 == null) {
                    if (first == tab[index]) {
                        return null;
                    }
                } else {
                    Object oldValue = e2.getValue();
                    if (first == tab[index] && oldValue != null) {
                        e2.setValue(null);
                        --this.count;
                        Entry head = e2.next;
                        Entry p = first;
                        while (p != e2) {
                            head = new Entry(p.hash, p.key, p.value, head, this.queue);
                            p = p.next;
                        }
                        tab[index] = head;
                        this.recordModification(head);
                        return oldValue;
                    }
                }
            }
            return this.sremove(key, hash);
        }
    }

    protected Object sremove(Object key, int hash) {
        Entry first;
        this.expungeStaleEntries();
        Entry[] tab = this.table;
        int index = hash & tab.length - 1;
        Entry e2 = first = tab[index];
        while (e2 != null) {
            if (e2.hash == hash && this.eq(key, e2.getKey())) {
                Object oldValue = e2.getValue();
                e2.setValue(null);
                --this.count;
                Entry head = e2.next;
                Entry p = first;
                while (p != e2) {
                    head = new Entry(p.hash, p.getKey(), p.getValue(), head, this.queue);
                    p = p.next;
                }
                tab[index] = head;
                this.recordModification(head);
                return oldValue;
            }
            e2 = e2.next;
        }
        return null;
    }

    public synchronized void clear() {
        Entry[] tab = this.table;
        for (int i2 = 0; i2 < tab.length; ++i2) {
            Entry e2 = tab[i2];
            while (e2 != null) {
                e2.setValue(null);
                e2 = e2.next;
            }
            tab[i2] = null;
        }
        this.count = 0;
        this.recordModification(tab);
    }

    private void expungeStaleEntries() {
        SoftRef ref;
        Entry[] tab = this.table;
        block0: while ((ref = (SoftRef)this.queue.poll()) != null) {
            Entry first;
            Entry entry = ref.entry;
            if (entry == null) continue;
            ref.entry = null;
            if (entry.key != ref && entry.value != ref) continue;
            int hash = entry.hash;
            int index = hash & tab.length - 1;
            Entry e2 = first = tab[index];
            while (e2 != null) {
                if (e2 == entry) {
                    entry.key.clear();
                    entry.setValue(null);
                    --this.count;
                    Entry head = e2.next;
                    Entry p = first;
                    while (p != e2) {
                        head = new Entry(p.hash, p.key, p.value, head);
                        p = p.next;
                    }
                    tab[index] = head;
                    this.recordModification(head);
                    continue block0;
                }
                e2 = e2.next;
            }
        }
    }

    private static class Entry {
        private final int hash;
        private final SoftRef key;
        private final Entry next;
        private volatile Reference value;

        Entry(int hash, Object key, Object value, Entry next, ReferenceQueue queue) {
            this.hash = hash;
            this.key = new SoftRef(this, key, queue);
            this.next = next;
            this.value = new SoftRef(this, value, queue);
        }

        Entry(int hash, SoftRef key, Reference value, Entry next) {
            this.hash = hash;
            this.key = key;
            key.entry = this;
            this.next = next;
            this.value = DUMMY_REF;
            this.setValue(value);
        }

        public Object getKey() {
            return this.key.get();
        }

        public Object getValue() {
            return this.value.get();
        }

        public Object setValue(Reference value) {
            Object oldValue = this.value.get();
            if (value == null || value == DUMMY_REF) {
                this.value = DUMMY_REF;
            } else {
                SoftRef ref = (SoftRef)value;
                ref.entry = this;
                this.value = value;
            }
            return oldValue;
        }
    }

    private static class SoftRef
    extends SoftReference
    implements Reference {
        private volatile Entry entry;

        public SoftRef(Entry e2, Object v, ReferenceQueue q) {
            super(v, q);
            this.entry = e2;
        }

        public void clear() {
            super.clear();
            this.entry = null;
        }
    }

    private static class DummyRef
    implements Reference {
        private DummyRef() {
        }

        public Object get() {
            return null;
        }
    }

    private static interface Reference {
        public Object get();
    }

    protected static class BarrierLock
    implements Serializable {
        protected BarrierLock() {
        }
    }
}

