/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode;

import java.io.InputStream;
import org.hibernate.bytecode.ClassTransformer;
import org.hibernate.bytecode.util.ByteCodeHelper;

public class InstrumentedClassLoader
extends ClassLoader {
    private ClassTransformer classTransformer;

    public InstrumentedClassLoader(ClassLoader parent, ClassTransformer classTransformer) {
        super(parent);
        this.classTransformer = classTransformer;
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        if (name.startsWith("java.") || this.classTransformer == null) {
            return this.getParent().loadClass(name);
        }
        Class<?> c2 = this.findLoadedClass(name);
        if (c2 != null) {
            return c2;
        }
        InputStream is = this.getResourceAsStream(name.replace('.', '/') + ".class");
        if (is == null) {
            throw new ClassNotFoundException(name + " not found");
        }
        try {
            byte[] originalBytecode = ByteCodeHelper.readByteCode(is);
            byte[] transformedBytecode = this.classTransformer.transform(this.getParent(), name, null, null, originalBytecode);
            if (originalBytecode == transformedBytecode) {
                return this.getParent().loadClass(name);
            }
            return this.defineClass(name, transformedBytecode, 0, transformedBytecode.length);
        }
        catch (Throwable t) {
            throw new ClassNotFoundException(name + " not found", t);
        }
    }
}

