/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.javassist;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class FastClass
implements Serializable {
    private static final Class[] EMPTY_CLASS_ARRAY = new Class[0];
    private Class type;

    private FastClass() {
    }

    private FastClass(Class type) {
        this.type = type;
    }

    public Object invoke(String name, Class[] parameterTypes, Object obj, Object[] args) throws InvocationTargetException {
        return this.invoke(this.getIndex(name, parameterTypes), obj, args);
    }

    public Object invoke(int index, Object obj, Object[] args) throws InvocationTargetException {
        Method[] methods = this.type.getMethods();
        try {
            return methods[index].invoke(obj, args);
        }
        catch (ArrayIndexOutOfBoundsException e2) {
            throw new IllegalArgumentException("Cannot find matching method/constructor");
        }
        catch (IllegalAccessException e3) {
            throw new InvocationTargetException(e3);
        }
    }

    public Object newInstance() throws InvocationTargetException {
        return this.newInstance(this.getIndex(EMPTY_CLASS_ARRAY), null);
    }

    public Object newInstance(Class[] parameterTypes, Object[] args) throws InvocationTargetException {
        return this.newInstance(this.getIndex(parameterTypes), args);
    }

    public Object newInstance(int index, Object[] args) throws InvocationTargetException {
        Constructor<?>[] conss = this.type.getConstructors();
        try {
            return conss[index].newInstance(args);
        }
        catch (ArrayIndexOutOfBoundsException e2) {
            throw new IllegalArgumentException("Cannot find matching method/constructor");
        }
        catch (InstantiationException e3) {
            throw new InvocationTargetException(e3);
        }
        catch (IllegalAccessException e4) {
            throw new InvocationTargetException(e4);
        }
    }

    public int getIndex(String name, Class[] parameterTypes) {
        Method[] methods = this.type.getMethods();
        boolean eq = true;
        for (int i2 = 0; i2 < methods.length; ++i2) {
            Class<?>[] params;
            if (!Modifier.isPublic(methods[i2].getModifiers()) || !methods[i2].getName().equals(name) || (params = methods[i2].getParameterTypes()).length != parameterTypes.length) continue;
            eq = true;
            for (int j2 = 0; j2 < params.length; ++j2) {
                if (params[j2].equals(parameterTypes[j2])) continue;
                eq = false;
                break;
            }
            if (!eq) continue;
            return i2;
        }
        return -1;
    }

    public int getIndex(Class[] parameterTypes) {
        Constructor<?>[] conss = this.type.getConstructors();
        boolean eq = true;
        for (int i2 = 0; i2 < conss.length; ++i2) {
            Class<?>[] params;
            if (!Modifier.isPublic(conss[i2].getModifiers()) || (params = conss[i2].getParameterTypes()).length != parameterTypes.length) continue;
            eq = true;
            for (int j2 = 0; j2 < params.length; ++j2) {
                if (params[j2].equals(parameterTypes[j2])) continue;
                eq = false;
                break;
            }
            if (!eq) continue;
            return i2;
        }
        return -1;
    }

    public int getMaxIndex() {
        Method[] methods = this.type.getMethods();
        int count = 0;
        for (int i2 = 0; i2 < methods.length; ++i2) {
            if (!Modifier.isPublic(methods[i2].getModifiers())) continue;
            ++count;
        }
        return count;
    }

    public String getName() {
        return this.type.getName();
    }

    public Class getJavaClass() {
        return this.type;
    }

    public String toString() {
        return this.type.toString();
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public boolean equals(Object o2) {
        if (!(o2 instanceof FastClass)) {
            return false;
        }
        return this.type.equals(((FastClass)o2).type);
    }

    public static FastClass create(Class type) {
        FastClass fc = new FastClass(type);
        return fc;
    }
}

