/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.javassist;

import java.io.IOException;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;
import org.hibernate.HibernateException;

public class TransformingClassLoader
extends ClassLoader {
    private ClassLoader parent;
    private ClassPool classPool;

    TransformingClassLoader(ClassLoader parent, String[] classpath) {
        this.parent = parent;
        this.classPool = new ClassPool(true);
        for (int i2 = 0; i2 < classpath.length; ++i2) {
            try {
                this.classPool.appendClassPath(classpath[i2]);
                continue;
            }
            catch (NotFoundException e2) {
                throw new HibernateException("Unable to resolve requested classpath for transformation [" + classpath[i2] + "] : " + e2.getMessage());
            }
        }
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        try {
            CtClass cc = this.classPool.get(name);
            byte[] b2 = cc.toBytecode();
            return this.defineClass(name, b2, 0, b2.length);
        }
        catch (NotFoundException e2) {
            throw new ClassNotFoundException();
        }
        catch (IOException e3) {
            throw new ClassNotFoundException();
        }
        catch (CannotCompileException e4) {
            throw new ClassNotFoundException();
        }
    }

    public void release() {
        this.classPool = null;
        this.parent = null;
    }
}

