/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.entry;

import java.io.Serializable;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.event.EventSource;
import org.hibernate.event.PreLoadEvent;
import org.hibernate.event.PreLoadEventListener;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.type.TypeFactory;
import org.hibernate.util.ArrayHelper;

public final class CacheEntry
implements Serializable {
    private final Serializable[] disassembledState;
    private final String subclass;
    private final boolean lazyPropertiesAreUnfetched;
    private final Object version;

    public String getSubclass() {
        return this.subclass;
    }

    public boolean areLazyPropertiesUnfetched() {
        return this.lazyPropertiesAreUnfetched;
    }

    public CacheEntry(Object[] state, EntityPersister persister, boolean unfetched, Object version, SessionImplementor session, Object owner) throws HibernateException {
        this.disassembledState = TypeFactory.disassemble(state, persister.getPropertyTypes(), persister.isLazyPropertiesCacheable() ? null : persister.getPropertyLaziness(), session, owner);
        this.subclass = persister.getEntityName();
        this.lazyPropertiesAreUnfetched = unfetched || !persister.isLazyPropertiesCacheable();
        this.version = version;
    }

    public Object getVersion() {
        return this.version;
    }

    CacheEntry(Serializable[] state, String subclass, boolean unfetched, Object version) {
        this.disassembledState = state;
        this.subclass = subclass;
        this.lazyPropertiesAreUnfetched = unfetched;
        this.version = version;
    }

    public Object[] assemble(Object instance, Serializable id, EntityPersister persister, Interceptor interceptor, EventSource session) throws HibernateException {
        if (!persister.getEntityName().equals(this.subclass)) {
            throw new AssertionFailure("Tried to assemble a different subclass instance");
        }
        return CacheEntry.assemble(this.disassembledState, instance, id, persister, interceptor, session);
    }

    private static Object[] assemble(Serializable[] values, Object result, Serializable id, EntityPersister persister, Interceptor interceptor, EventSource session) throws HibernateException {
        Object[] assembledProps = TypeFactory.assemble(values, persister.getPropertyTypes(), session, result);
        PreLoadEvent preLoadEvent = new PreLoadEvent(session).setEntity(result).setState(assembledProps).setId(id).setPersister(persister);
        PreLoadEventListener[] listeners = session.getListeners().getPreLoadEventListeners();
        for (int i2 = 0; i2 < listeners.length; ++i2) {
            listeners[i2].onPreLoad(preLoadEvent);
        }
        persister.setPropertyValues(result, assembledProps, session.getEntityMode());
        return assembledProps;
    }

    public Serializable[] getDisassembledState() {
        return this.disassembledState;
    }

    public String toString() {
        return "CacheEntry(" + this.subclass + ')' + ArrayHelper.toString(this.disassembledState);
    }
}

