/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.dialect.Dialect;
import org.hibernate.util.ReflectHelper;

public class DialectFactory {
    private static final Map MAPPERS = new HashMap();

    public static Dialect buildDialect(Properties props, String databaseName, int databaseMajorVersion) throws HibernateException {
        String dialectName = props.getProperty("hibernate.dialect");
        if (dialectName == null) {
            return DialectFactory.determineDialect(databaseName, databaseMajorVersion);
        }
        return DialectFactory.buildDialect(dialectName);
    }

    public static Dialect determineDialect(String databaseName, int databaseMajorVersion) {
        if (databaseName == null) {
            throw new HibernateException("Hibernate Dialect must be explicitly set");
        }
        DatabaseDialectMapper mapper = (DatabaseDialectMapper)MAPPERS.get(databaseName);
        if (mapper == null) {
            throw new HibernateException("Hibernate Dialect must be explicitly set for database: " + databaseName);
        }
        String dialectName = mapper.getDialectClass(databaseMajorVersion);
        return DialectFactory.buildDialect(dialectName);
    }

    public static Dialect buildDialect(String dialectName) {
        try {
            return (Dialect)ReflectHelper.classForName(dialectName).newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            throw new HibernateException("Dialect class not found: " + dialectName);
        }
        catch (Exception e2) {
            throw new HibernateException("Could not instantiate dialect class", e2);
        }
    }

    static {
        MAPPERS.put("HSQL Database Engine", new VersionInsensitiveMapper("org.hibernate.dialect.HSQLDialect"));
        MAPPERS.put("DB2/NT", new VersionInsensitiveMapper("org.hibernate.dialect.DB2Dialect"));
        MAPPERS.put("MySQL", new VersionInsensitiveMapper("org.hibernate.dialect.MySQLDialect"));
        MAPPERS.put("PostgreSQL", new VersionInsensitiveMapper("org.hibernate.dialect.PostgreSQLDialect"));
        MAPPERS.put("Microsoft SQL Server Database", new VersionInsensitiveMapper("org.hibernate.dialect.SQLServerDialect"));
        MAPPERS.put("Microsoft SQL Server", new VersionInsensitiveMapper("org.hibernate.dialect.SQLServerDialect"));
        MAPPERS.put("Sybase SQL Server", new VersionInsensitiveMapper("org.hibernate.dialect.SybaseDialect"));
        MAPPERS.put("Informix Dynamic Server", new VersionInsensitiveMapper("org.hibernate.dialect.InformixDialect"));
        MAPPERS.put("Apache Derby", new VersionInsensitiveMapper("org.hibernate.dialect.DerbyDialect"));
        MAPPERS.put("Oracle", new DatabaseDialectMapper(){

            public String getDialectClass(int majorVersion) {
                return majorVersion > 8 ? "org.hibernate.dialect.Oracle9Dialect" : "org.hibernate.dialect.OracleDialect";
            }
        });
    }

    public static class VersionInsensitiveMapper
    implements DatabaseDialectMapper {
        private String dialectClassName;

        public VersionInsensitiveMapper(String dialectClassName) {
            this.dialectClassName = dialectClassName;
        }

        public String getDialectClass(int majorVersion) {
            return this.dialectClassName;
        }
    }

    public static interface DatabaseDialectMapper {
        public String getDialectClass(int var1);
    }
}

