/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function;

import java.util.List;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.engine.Mapping;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.type.Type;

public class StandardSQLFunction
implements SQLFunction {
    private final String name;
    private final Type type;

    public StandardSQLFunction(String name) {
        this(name, null);
    }

    public StandardSQLFunction(String name, Type type) {
        this.name = name;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public Type getReturnType(Type columnType, Mapping mapping) {
        return this.type == null ? columnType : this.type;
    }

    public boolean hasArguments() {
        return true;
    }

    public boolean hasParenthesesIfNoArguments() {
        return true;
    }

    public String render(List args, SessionFactoryImplementor factory) {
        StringBuffer buf = new StringBuffer();
        buf.append(this.name).append('(');
        for (int i2 = 0; i2 < args.size(); ++i2) {
            buf.append(args.get(i2));
            if (i2 >= args.size() - 1) continue;
            buf.append(", ");
        }
        return buf.append(')').toString();
    }

    public String toString() {
        return this.name;
    }
}

