/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.collections.SequencedHashMap;
import org.hibernate.EntityMode;
import org.hibernate.cache.CacheKey;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.CollectionEntry;
import org.hibernate.engine.EntityKey;
import org.hibernate.engine.PersistenceContext;
import org.hibernate.engine.SubselectFetch;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.util.MarkerObject;

public class BatchFetchQueue {
    public static final Object MARKER = new MarkerObject("MARKER");
    private final Map batchLoadableEntityKeys = new SequencedHashMap(8);
    private final Map subselectsByEntityKey = new HashMap(8);
    private final PersistenceContext context;

    public BatchFetchQueue(PersistenceContext context) {
        this.context = context;
    }

    public void clear() {
        this.batchLoadableEntityKeys.clear();
        this.subselectsByEntityKey.clear();
    }

    public SubselectFetch getSubselect(EntityKey key) {
        return (SubselectFetch)this.subselectsByEntityKey.get(key);
    }

    public void addSubselect(EntityKey key, SubselectFetch subquery) {
        this.subselectsByEntityKey.put(key, subquery);
    }

    public void removeSubselect(EntityKey key) {
        this.subselectsByEntityKey.remove(key);
    }

    public void clearSubselects() {
        this.subselectsByEntityKey.clear();
    }

    public void addBatchLoadableEntityKey(EntityKey key) {
        if (key.isBatchLoadable()) {
            this.batchLoadableEntityKeys.put(key, MARKER);
        }
    }

    public void removeBatchLoadableEntityKey(EntityKey key) {
        if (key.isBatchLoadable()) {
            this.batchLoadableEntityKeys.remove(key);
        }
    }

    public Serializable[] getCollectionBatch(CollectionPersister collectionPersister, Serializable id, int batchSize, EntityMode entityMode) {
        Serializable[] keys = new Serializable[batchSize];
        keys[0] = id;
        int i2 = 1;
        int end = -1;
        boolean checkForEnd = false;
        Iterator iter = this.context.getCollectionEntries().entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry me = iter.next();
            CollectionEntry ce = (CollectionEntry)me.getValue();
            PersistentCollection collection = (PersistentCollection)me.getKey();
            if (collection.wasInitialized() || ce.getLoadedPersister() != collectionPersister) continue;
            if (checkForEnd && i2 == end) {
                return keys;
            }
            boolean isEqual = collectionPersister.getKeyType().isEqual(id, ce.getLoadedKey(), entityMode, collectionPersister.getFactory());
            if (isEqual) {
                end = i2;
            } else if (!this.isCached(ce.getLoadedKey(), collectionPersister, entityMode)) {
                keys[i2++] = ce.getLoadedKey();
            }
            if (i2 != batchSize) continue;
            i2 = 1;
            if (end == -1) continue;
            checkForEnd = true;
        }
        return keys;
    }

    public Serializable[] getEntityBatch(EntityPersister persister, Serializable id, int batchSize, EntityMode entityMode) {
        Serializable[] ids = new Serializable[batchSize];
        ids[0] = id;
        int i2 = 1;
        int end = -1;
        boolean checkForEnd = false;
        Iterator iter = this.batchLoadableEntityKeys.keySet().iterator();
        while (iter.hasNext()) {
            EntityKey key = (EntityKey)iter.next();
            if (!key.getEntityName().equals(persister.getEntityName())) continue;
            if (checkForEnd && i2 == end) {
                return ids;
            }
            if (persister.getIdentifierType().isEqual(id, key.getIdentifier(), entityMode)) {
                end = i2;
            } else if (!this.isCached(key, persister, entityMode)) {
                ids[i2++] = key.getIdentifier();
            }
            if (i2 != batchSize) continue;
            i2 = 1;
            if (end == -1) continue;
            checkForEnd = true;
        }
        return ids;
    }

    private boolean isCached(EntityKey entityKey, EntityPersister persister, EntityMode entityMode) {
        if (persister.hasCache()) {
            CacheKey key = new CacheKey(entityKey.getIdentifier(), persister.getIdentifierType(), entityKey.getEntityName(), entityMode, this.context.getSession().getFactory());
            return persister.getCache().getCache().get(key) != null;
        }
        return false;
    }

    private boolean isCached(Serializable collectionKey, CollectionPersister persister, EntityMode entityMode) {
        if (persister.hasCache()) {
            CacheKey cacheKey = new CacheKey(collectionKey, persister.getKeyType(), persister.getRole(), entityMode, this.context.getSession().getFactory());
            return persister.getCache().getCache().get(cacheKey) != null;
        }
        return false;
    }
}

